/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeapRandomly;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.WarpedToadAIRandomSwimming;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityWarpedToad
extends TamableAnimal
implements ITargetsDroppedItems,
IFollower,
ISemiAquatic {
    private static final EntityDataAccessor<Float> TONGUE_LENGTH = SynchedEntityData.defineId(EntityWarpedToad.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> TONGUE_OUT = SynchedEntityData.defineId(EntityWarpedToad.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityWarpedToad.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityWarpedToad.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> JUMP_ACTIVE = SynchedEntityData.defineId(EntityWarpedToad.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float blinkProgress;
    public float prevBlinkProgress;
    public float attackProgress;
    public float prevAttackProgress;
    public float sitProgress;
    public float prevSitProgress;
    public float swimProgress;
    public float prevSwimProgress;
    public float jumpProgress;
    public float prevJumpProgress;
    public float reboundProgress;
    public float prevReboundProgress;
    private boolean isLandNavigator;
    private int currentMoveTypeDuration;
    private int swimTimer = -100;

    protected EntityWarpedToad(EntityType entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.switchNavigator(false);
    }

    public boolean isBased() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("pepe");
    }

    public static boolean canWarpedToadSpawn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        BlockPos blockpos = pos.below();
        boolean spawnBlock = worldIn.getFluidState(blockpos).is(FluidTags.LAVA) || worldIn.getBlockState(blockpos).canOcclude();
        return reason == MobSpawnType.SPAWNER || spawnBlock;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.WARPED_TOAD_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.WARPED_TOAD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.WARPED_TOAD_HURT.get();
    }

    public boolean canBreatheUnderwaterAM() {
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.warpedToadSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public int getMaxSpawnClusterSize() {
        return 5;
    }

    public boolean isMaxGroupSizeReached(int sizeIn) {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("ToadSitting", this.isOrderedToSit());
        compound.putInt("Command", this.getCommand());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("ToadSitting"));
        this.setCommand(compound.getInt("Command"));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(1, (Goal)new TongueAttack(this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwner(this, 1.3, 4.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.WARPED_TOAD_FOODSTUFFS), false));
        this.goalSelector.addGoal(5, (Goal)new WarpedToadAIRandomSwimming(this, 1.0, 7));
        this.goalSelector.addGoal(6, (Goal)new AnimalAILeapRandomly((PathfinderMob)this, 50, 7){

            @Override
            public boolean canUse() {
                return super.canUse() && !EntityWarpedToad.this.isOrderedToSit();
            }
        });
        this.goalSelector.addGoal(7, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 60, 1.0, 5, 4));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.WARPED_TOAD_TARGETS)));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void travel(Vec3 travelVector) {
        if (this.isOrderedToSit()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            travelVector = Vec3.ZERO;
            super.travel(travelVector);
        } else if (this.isEffectiveAi() && (this.isInWater() || this.isInLava())) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected float getJumpPower() {
        return 0.5f;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void customServerAiStep() {
        super.customServerAiStep();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.WARPED_TOAD_BREEDABLES) && this.isTame();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isTame() && itemstack.is(AMTagRegistry.WARPED_TOAD_TAMEABLES)) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, itemstack);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.STRIDER_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.getRandom().nextInt(3) == 0) {
                    this.tame(player);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        InteractionResult type = super.mobInteract(player, hand);
        if (this.isTame() && itemstack.is(AMTagRegistry.WARPED_TOAD_FOODSTUFFS)) {
            if (this.getHealth() < this.getMaxHealth()) {
                if (!this.level().isClientSide) {
                    this.usePlayerItem(player, hand, itemstack);
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.playSound(SoundEvents.STRIDER_EAT, this.getSoundVolume(), this.getVoicePitch());
                    this.heal(5.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack)) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 57.2957763671875) - 90.0f);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isBaby() && this.getEyeHeight() > this.getBbHeight()) {
            this.refreshDimensions();
        }
        if (!this.level().isClientSide) {
            if (this.isInWater() || this.isInLava()) {
                if (this.swimTimer < 0) {
                    this.swimTimer = 0;
                }
                ++this.swimTimer;
            } else {
                if (this.swimTimer > 0) {
                    this.swimTimer = 0;
                }
                --this.swimTimer;
            }
        }
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = this.createNavigation(this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.2f);
            this.navigation = new BoneSerpentPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TONGUE_LENGTH, (Object)Float.valueOf(1.0f));
        builder.define(TONGUE_OUT, (Object)false);
        builder.define(COMMAND, (Object)0);
        builder.define(SITTING, (Object)false);
        builder.define(JUMP_ACTIVE, (Object)false);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public void tick() {
        LivingEntity entityIn;
        boolean isTongueOut;
        boolean isTechnicalBlinking;
        super.tick();
        this.prevBlinkProgress = this.blinkProgress;
        this.prevAttackProgress = this.attackProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevSwimProgress = this.swimProgress;
        this.prevJumpProgress = this.jumpProgress;
        this.prevReboundProgress = this.reboundProgress;
        boolean bl = isTechnicalBlinking = this.tickCount % 50 > 42;
        if (isTechnicalBlinking) {
            if (this.blinkProgress < 5.0f) {
                this.blinkProgress += 1.0f;
            }
        } else if (this.blinkProgress > 0.0f) {
            this.blinkProgress -= 1.0f;
        }
        if ((isTongueOut = this.isTongueOut()) && this.attackProgress < 5.0f) {
            this.attackProgress += 1.0f;
        }
        if (!this.level().isClientSide) {
            this.entityData.set(JUMP_ACTIVE, (Object)(!this.onGround() ? 1 : 0));
        }
        if (((Boolean)this.entityData.get(JUMP_ACTIVE)).booleanValue() && !this.isInWaterOrBubble()) {
            this.yBodyRot = this.getYRot();
            this.yHeadRot = this.getYRot();
            if (this.jumpProgress < 5.0f) {
                this.jumpProgress += 0.5f;
                if (this.reboundProgress > 0.0f) {
                    this.reboundProgress -= 1.0f;
                }
            }
            if (this.jumpProgress >= 5.0f && this.reboundProgress < 5.0f) {
                this.reboundProgress += 0.5f;
            }
        } else {
            if (this.reboundProgress > 0.0f) {
                this.reboundProgress = Math.max(this.reboundProgress - 1.0f, 0.0f);
            }
            if (this.jumpProgress > 0.0f) {
                this.jumpProgress = Math.max(this.jumpProgress - 1.0f, 0.0f);
            }
        }
        if ((entityIn = this.getTarget()) != null && this.attackProgress > 0.0f) {
            if (this.isTongueOut()) {
                double d0 = entityIn.getX() - this.getX();
                double d2 = entityIn.getZ() - this.getZ();
                double d1 = entityIn.getEyeY() - this.getEyeY();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
                this.setXRot(f1);
                this.setYRot(f);
                this.yBodyRot = this.getYRot();
                this.yHeadRot = this.getYRot();
            } else {
                if (entityIn instanceof EntityCrimsonMosquito) {
                    ((EntityCrimsonMosquito)entityIn).setShrink(true);
                }
                this.setXRot(0.0f);
                float radius = this.attackProgress * 0.2f * 1.2f * (this.getTongueLength() - this.getTongueLength() * 0.4f);
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
                double extraZ = radius * Mth.cos((float)angle);
                double yHelp = entityIn.getBbHeight();
                Vec3 minus = new Vec3(this.getX() + extraX - this.getTarget().getX(), (double)this.getEyeHeight() - yHelp - this.getTarget().getY(), this.getZ() + extraZ - this.getTarget().getZ());
                this.getTarget().setDeltaMovement(minus);
                if (this.attackProgress == 0.5f) {
                    float damage = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                    if (entityIn instanceof EntityCrimsonMosquito) {
                        damage = Float.MAX_VALUE;
                    }
                    entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
                }
            }
        }
        if (!this.level().isClientSide && this.attackProgress == 5.0f && isTongueOut) {
            this.setTongueOut(false);
            this.attackProgress = 4.0f;
        }
        if (this.attackProgress > 0.0f && !this.isTongueOut()) {
            this.attackProgress -= 0.5f;
        }
        if (this.isOrderedToSit()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.shouldSwim()) {
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (this.swimProgress < 5.0f) {
                this.swimProgress += 1.0f;
            }
        } else {
            if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.swimProgress > 0.0f) {
                this.swimProgress -= 1.0f;
            }
        }
    }

    public boolean shouldSwim() {
        return this.isInWater() || this.isInLava();
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.WARPED_TOAD_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.heal(5.0f);
    }

    public boolean isBlinking() {
        return this.blinkProgress > 1.0f || this.blinkProgress < -1.0f || this.attackProgress > 1.0f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.WARPED_TOAD.get()).create((Level)serverWorld);
    }

    public float getTongueLength() {
        return ((Float)this.entityData.get(TONGUE_LENGTH)).floatValue();
    }

    public void setTongueLength(float length) {
        this.entityData.set(TONGUE_LENGTH, (Object)Float.valueOf(length));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public boolean shouldEnterWater() {
        return this.swimTimer < -200 && !this.isOrderedToSit() && this.getCommand() != 1;
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.swimTimer > 600 && !this.isOrderedToSit() && this.getCommand() != 1;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isOrderedToSit();
    }

    private boolean isTongueOut() {
        return (Boolean)this.entityData.get(TONGUE_OUT);
    }

    private void setTongueOut(boolean out) {
        this.entityData.set(TONGUE_OUT, (Object)out);
    }

    @Override
    public int getWaterSearchRange() {
        return 8;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public static class TongueAttack
    extends Goal {
        private final EntityWarpedToad parentEntity;
        private int spitCooldown = 0;
        private BlockPos shootPos = null;

        public TongueAttack(EntityWarpedToad toad) {
            this.parentEntity = toad;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.parentEntity.getTarget() != null && this.parentEntity.getPassengers().isEmpty();
        }

        public boolean canContinueToUse() {
            return this.parentEntity.getTarget() != null && this.parentEntity.getPassengers().isEmpty();
        }

        public void stop() {
            this.spitCooldown = 20;
            this.parentEntity.getNavigation().stop();
        }

        public void tick() {
            LivingEntity entityIn;
            if (this.spitCooldown > 0) {
                --this.spitCooldown;
            }
            if ((entityIn = this.parentEntity.getTarget()) != null) {
                double dist = this.parentEntity.distanceTo((Entity)entityIn);
                if (dist < 8.0 && this.parentEntity.hasLineOfSight((Entity)entityIn) && !this.parentEntity.isTongueOut() && this.parentEntity.attackProgress == 0.0f && this.spitCooldown == 0) {
                    this.parentEntity.setTongueLength((float)Math.max(1.0, dist + 2.0));
                    this.spitCooldown = 10;
                    this.parentEntity.setTongueOut(true);
                }
                this.parentEntity.getNavigation().moveTo((Entity)entityIn, (double)1.4f);
            }
        }
    }

    public static class FollowOwner
    extends Goal {
        private final EntityWarpedToad tameable;
        private final LevelReader world;
        private final double followSpeed;
        private final float maxDist;
        private final float minDist;
        private final boolean teleportToLeaves;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowOwner(EntityWarpedToad p_i225711_1_, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
            this.tameable = p_i225711_1_;
            this.world = p_i225711_1_.level();
            this.followSpeed = p_i225711_2_;
            this.minDist = p_i225711_4_;
            this.maxDist = p_i225711_5_;
            this.teleportToLeaves = p_i225711_6_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(p_i225711_1_.getNavigation() instanceof GroundPathNavigation) && !(p_i225711_1_.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean canUse() {
            LivingEntity lvt_1_1_ = this.tameable.getOwner();
            if (lvt_1_1_ == null) {
                return false;
            }
            if (lvt_1_1_.isSpectator()) {
                return false;
            }
            if (this.tameable.isOrderedToSit() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.distanceToSqr((Entity)lvt_1_1_) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = lvt_1_1_;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.tameable.getNavigation().isDone()) {
                return false;
            }
            if (this.tameable.isOrderedToSit() || this.tameable.getCommand() != 1) {
                return false;
            }
            return this.tameable.distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tameable.getPathfindingMalus(PathType.WATER);
            this.tameable.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.owner = null;
            this.tameable.getNavigation().stop();
            this.tameable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            this.tameable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tameable.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.tameable.isLeashed() && !this.tameable.isPassenger()) {
                    if (this.tameable.distanceToSqr((Entity)this.owner) >= 144.0) {
                        this.tryToTeleportNearEntity();
                    } else {
                        this.tameable.getNavigation().moveTo((Entity)this.owner, this.followSpeed);
                    }
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos lvt_1_1_ = this.owner.blockPosition();
            for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
                int lvt_3_1_ = this.getRandomNumber(-3, 3);
                int lvt_4_1_ = this.getRandomNumber(-1, 1);
                int lvt_5_1_ = this.getRandomNumber(-3, 3);
                boolean lvt_6_1_ = this.tryToTeleportToLocation(lvt_1_1_.getX() + lvt_3_1_, lvt_1_1_.getY() + lvt_4_1_, lvt_1_1_.getZ() + lvt_5_1_);
                if (!lvt_6_1_) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
            if (Math.abs((double)p_226328_1_ - this.owner.getX()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.getZ()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
                return false;
            }
            this.tameable.moveTo((double)p_226328_1_ + 0.5, p_226328_2_, (double)p_226328_3_ + 0.5, this.tameable.getYRot(), this.tameable.getXRot());
            this.tameable.getNavigation().stop();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos p_226329_1_) {
            PathType lvt_2_1_ = PathType.WALKABLE;
            if (lvt_2_1_ != PathType.WALKABLE) {
                return false;
            }
            BlockState lvt_3_1_ = this.world.getBlockState(p_226329_1_.below());
            if (!this.teleportToLeaves && lvt_3_1_.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos lvt_4_1_ = p_226329_1_.subtract((Vec3i)this.tameable.blockPosition());
            return this.world.noCollision((Entity)this.tameable, this.tameable.getBoundingBox().move(lvt_4_1_));
        }

        private int getRandomNumber(int p_226327_1_, int p_226327_2_) {
            return this.tameable.getRandom().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
        }
    }
}

