/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityHemolymph;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntityWarpedMosco
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_PUNCH_R = Animation.create((int)25);
    public static final Animation ANIMATION_PUNCH_L = Animation.create((int)25);
    public static final Animation ANIMATION_SLAM = Animation.create((int)35);
    public static final Animation ANIMATION_SUCK = Animation.create((int)60);
    public static final Animation ANIMATION_SPIT = Animation.create((int)60);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityWarpedMosco.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAND_SIDE = SynchedEntityData.defineId(EntityWarpedMosco.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float flyLeftProgress;
    public float prevLeftFlyProgress;
    public float flyRightProgress;
    public float prevFlyRightProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    private int timeFlying;
    private int loopSoundTick = 0;

    protected EntityWarpedMosco(EntityType entityType, Level world) {
        super(entityType, world);
        this.xpReward = 30;
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ARMOR, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    private static Animation getRandomAttack(RandomSource rand) {
        return switch (rand.nextInt(4)) {
            case 0 -> ANIMATION_PUNCH_L;
            case 1 -> ANIMATION_PUNCH_R;
            case 2 -> ANIMATION_SLAM;
            case 3 -> ANIMATION_SUCK;
            default -> ANIMATION_SUCK;
        };
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.WARPED_MOSCO_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.WARPED_MOSCO_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.WARPED_MOSCO_HURT.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new AttackGoal());
        this.goalSelector.addGoal(4, (Goal)new AIWalkIdle());
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityCrimsonMosquito.class, EntityWarpedMosco.class}));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.CRIMSON_MOSQUITO_TARGETS)));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 0.7f, false);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(HAND_SIDE, (Object)true);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        this.setDashRight(flying != this.isFlying() ? this.random.nextBoolean() : this.isDashRight());
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean isDashRight() {
        return (Boolean)this.entityData.get(HAND_SIDE);
    }

    public void setDashRight(boolean right) {
        this.entityData.set(HAND_SIDE, (Object)right);
    }

    public void tick() {
        LivingEntity target;
        super.tick();
        this.prevFlyRightProgress = this.flyRightProgress;
        this.prevLeftFlyProgress = this.flyLeftProgress;
        boolean dashRight = this.isDashRight();
        boolean flying = this.isFlying();
        if (flying && dashRight && this.flyRightProgress < 5.0f) {
            this.flyRightProgress += 1.0f;
        }
        if (!(flying && dashRight || !(this.flyRightProgress > 0.0f))) {
            this.flyRightProgress -= 1.0f;
        }
        if (flying && !dashRight && this.flyLeftProgress < 5.0f) {
            this.flyLeftProgress += 1.0f;
        }
        if ((!flying || dashRight) && this.flyLeftProgress > 0.0f) {
            this.flyLeftProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (flying) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (flying) {
            if (this.loopSoundTick == 0) {
                this.playSound((SoundEvent)AMSoundRegistry.MOSQUITO_LOOP.get(), this.getSoundVolume(), this.getVoicePitch() * 0.3f);
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 100) {
                this.loopSoundTick = 0;
            }
            ++this.timeFlying;
            this.setNoGravity(true);
            if (this.isPassenger() || this.isVehicle()) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.setNoGravity(false);
        }
        if (this.horizontalCollision && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            boolean flag = false;
            AABB axisalignedbb = this.getBoundingBox().inflate(0.2);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)axisalignedbb.minX), (int)Mth.floor((double)axisalignedbb.minY), (int)Mth.floor((double)axisalignedbb.minZ), (int)Mth.floor((double)axisalignedbb.maxX), (int)Mth.floor((double)axisalignedbb.maxY), (int)Mth.floor((double)axisalignedbb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!blockstate.is(AMTagRegistry.WARPED_MOSCO_BREAKABLES)) continue;
                flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.onGround()) {
                this.jumpFromGround();
            }
        }
        if ((target = this.getTarget()) != null && this.isAlive()) {
            if (this.getAnimation() == ANIMATION_SUCK && this.getAnimationTick() == 3 && this.distanceTo((Entity)target) < 4.7f) {
                target.startRiding((Entity)this, true);
            }
            if (this.getAnimation() == ANIMATION_SLAM && this.getAnimationTick() == 19) {
                for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(5.0))) {
                    if (this.isAlliedTo(entity) || entity instanceof EntityWarpedMosco || entity == this) continue;
                    entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 10.0f + this.random.nextFloat() * 8.0f);
                    this.launch(entity, true);
                }
            }
            if ((this.getAnimation() == ANIMATION_PUNCH_R || this.getAnimation() == ANIMATION_PUNCH_L) && this.getAnimationTick() == 13 && this.distanceTo((Entity)target) < 4.7f) {
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                this.knockbackRidiculous(target, 0.9f);
            }
        }
        if (this.getAnimation() == ANIMATION_SLAM && this.getAnimationTick() == 19) {
            this.spawnGroundEffects();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void spawnGroundEffects() {
        float radius = 2.3f;
        double extraY = 0.8f;
        for (int i = 0; i < 4; ++i) {
            for (int i1 = 0; i1 < 20 + this.random.nextInt(12); ++i1) {
                double motionX = this.getRandom().nextGaussian() * 0.07;
                double motionY = this.getRandom().nextGaussian() * 0.07;
                double motionZ = this.getRandom().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.yBodyRot + (float)i1;
                double extraX = 2.3f * Mth.sin((float)((float)Math.PI + angle));
                double extraZ = 2.3f * Mth.cos((float)angle);
                BlockPos ground = this.getMoscoGround(new BlockPos(Mth.floor((double)(this.getX() + extraX)), Mth.floor((double)(this.getY() + (double)0.8f)) - 1, Mth.floor((double)(this.getZ() + extraZ))));
                BlockState state = this.level().getBlockState(ground);
                if (!state.isSolid() || !this.level().isClientSide) continue;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), true, this.getX() + extraX, (double)ground.getY() + (double)0.8f, this.getZ() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.onGround()) {
            double d0 = e.getX() - this.getX();
            double d1 = e.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.push(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUNCH_L, ANIMATION_PUNCH_R, ANIMATION_SLAM, ANIMATION_SUCK, ANIMATION_SPIT};
    }

    private BlockPos getMoscoGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() > -62 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getMoscoGround(radialPos);
        if (ground.getY() == -62) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -62 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24) - radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getMoscoGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 4 + this.getRandom().nextInt(10);
        BlockPos newPos = ground.above(distFromGround > 8 ? flightHeight : this.getRandom().nextInt(6) + 1);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    public void knockbackRidiculous(LivingEntity target, float power) {
        target.knockback((double)power, this.getX() - target.getX(), this.getZ() - target.getZ());
        float knockbackResist = (float)Mth.clamp((double)(1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (double)0.0, (double)1.0);
        target.setDeltaMovement(target.getDeltaMovement().add(0.0, (double)(knockbackResist * power * 0.45f), 0.0));
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private boolean isOverLiquid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > 2 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty();
    }

    public void travel(Vec3 travelVector) {
        if ((this.getAnimation() == ANIMATION_SUCK || this.getAnimation() == ANIMATION_SLAM) && this.getAnimationTick() > 8) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            travelVector = Vec3.ZERO;
            super.travel(travelVector);
            return;
        }
        super.travel(travelVector);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        super.positionRider(passenger, moveFunc);
        if (this.hasPassenger(passenger)) {
            int tick = 5;
            if (this.getAnimation() == ANIMATION_SUCK) {
                tick = this.getAnimationTick();
            } else {
                passenger.stopRiding();
            }
            float radius = 2.0f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            double extraY = tick < 10 ? 0.0 : (double)(0.15f * (float)Mth.clamp((int)(tick - 10), (int)0, (int)15));
            passenger.setPos(this.getX() + extraX, this.getY() + extraY + (double)0.1f, this.getZ() + extraZ);
            if ((tick - 10) % 4 == 0) {
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
                passenger.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.warpedMoscoSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    private void spit(LivingEntity target) {
        if (this.getAnimation() != ANIMATION_SPIT) {
            return;
        }
        this.lookAt((Entity)target, 100.0f, 100.0f);
        this.yBodyRot = this.yHeadRot;
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            EntityHemolymph llamaspitentity = new EntityHemolymph(this.level(), this);
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - llamaspitentity.getY();
            double d2 = target.getZ() - this.getZ();
            float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
            llamaspitentity.shoot(d0, d1 + (double)f, d2, 1.5f, 5.0f);
            if (!this.isSilent()) {
                this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            this.level().addFreshEntity((Entity)llamaspitentity);
        }
    }

    private boolean shouldRangeAttack(LivingEntity target) {
        if ((double)this.getHealth() < Math.floor(this.getMaxHealth() * 0.25f)) {
            return true;
        }
        return this.getHealth() < this.getHealth() * 0.5f && this.distanceTo((Entity)target) > 10.0f;
    }

    private class AttackGoal
    extends Goal {
        private int upTicks = 0;
        private int dashCooldown = 0;
        private boolean ranged = false;
        private BlockPos farTarget = null;

        public boolean canUse() {
            return EntityWarpedMosco.this.getTarget() != null;
        }

        public void tick() {
            if (this.dashCooldown > 0) {
                --this.dashCooldown;
            }
            if (EntityWarpedMosco.this.getTarget() != null) {
                LivingEntity target = EntityWarpedMosco.this.getTarget();
                this.ranged = EntityWarpedMosco.this.shouldRangeAttack(target);
                if (EntityWarpedMosco.this.isFlying() || this.ranged || EntityWarpedMosco.this.distanceTo((Entity)target) > 12.0f && !EntityWarpedMosco.this.isTargetBlocked(target.position().add(0.0, (double)(target.getBbHeight() * 0.6f), 0.0))) {
                    float speedRush = 5.0f;
                    ++this.upTicks;
                    EntityWarpedMosco.this.setFlying(true);
                    if (this.ranged) {
                        if (this.farTarget == null || EntityWarpedMosco.this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.farTarget)) < 9.0) {
                            this.farTarget = this.getAvoidTarget(target);
                        }
                        if (this.farTarget != null) {
                            EntityWarpedMosco.this.getMoveControl().setWantedPosition((double)this.farTarget.getX(), (double)((float)this.farTarget.getY() + target.getEyeHeight() * 0.6f), (double)this.farTarget.getZ(), 3.0);
                        }
                        EntityWarpedMosco.this.setAnimation(ANIMATION_SPIT);
                        if (this.upTicks % 30 == 0) {
                            EntityWarpedMosco.this.heal(1.0f);
                        }
                        int tick = EntityWarpedMosco.this.getAnimationTick();
                        switch (tick) {
                            case 10: 
                            case 20: 
                            case 30: 
                            case 40: {
                                EntityWarpedMosco.this.spit(target);
                            }
                        }
                    } else if (this.upTicks > 20 || EntityWarpedMosco.this.distanceTo((Entity)target) < 6.0f) {
                        EntityWarpedMosco.this.getMoveControl().setWantedPosition(target.getX(), target.getY() + (double)(target.getEyeHeight() * 0.6f), target.getZ(), (double)speedRush);
                    } else {
                        EntityWarpedMosco.this.getMoveControl().setWantedPosition(EntityWarpedMosco.this.getX(), EntityWarpedMosco.this.getY() + 3.0, EntityWarpedMosco.this.getZ(), 0.5);
                    }
                } else {
                    EntityWarpedMosco.this.getNavigation().moveTo((Entity)EntityWarpedMosco.this.getTarget(), 1.25);
                }
                if (EntityWarpedMosco.this.isFlying()) {
                    if (EntityWarpedMosco.this.distanceTo((Entity)target) < 4.3f) {
                        if (this.dashCooldown == 0 || target.onGround() || target.isInLava() || target.isInWater()) {
                            target.hurt(EntityWarpedMosco.this.damageSources().mobAttack((LivingEntity)EntityWarpedMosco.this), 5.0f);
                            EntityWarpedMosco.this.knockbackRidiculous(target, 1.0f);
                            this.dashCooldown = 30;
                        }
                        float groundHeight = EntityWarpedMosco.this.getMoscoGround(EntityWarpedMosco.this.blockPosition()).getY();
                        if (Math.abs(EntityWarpedMosco.this.getY() - (double)groundHeight) < 3.0 && !EntityWarpedMosco.this.isOverLiquid()) {
                            EntityWarpedMosco.this.timeFlying += 300;
                            EntityWarpedMosco.this.setFlying(false);
                        }
                    }
                } else if (EntityWarpedMosco.this.distanceTo((Entity)target) < 4.0f && EntityWarpedMosco.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    Animation animation = EntityWarpedMosco.getRandomAttack(EntityWarpedMosco.this.random);
                    if (animation == ANIMATION_SUCK && target.isPassenger()) {
                        animation = ANIMATION_SLAM;
                    }
                    EntityWarpedMosco.this.setAnimation(animation);
                }
            }
        }

        public BlockPos getAvoidTarget(LivingEntity target) {
            float radius = 10 + EntityWarpedMosco.this.getRandom().nextInt(8);
            float angle = (float)Math.PI / 180 * (target.yHeadRot + 90.0f + (float)EntityWarpedMosco.this.getRandom().nextInt(180));
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = AMBlockPos.fromCoords(target.getX() + extraX, target.getY() + 1.0, target.getZ() + extraZ);
            BlockPos ground = radialPos;
            if (EntityWarpedMosco.this.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 30.0 && !EntityWarpedMosco.this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground)) && EntityWarpedMosco.this.distanceToSqr(Vec3.atCenterOf((Vec3i)ground)) > 6.0) {
                return ground;
            }
            return EntityWarpedMosco.this.blockPosition();
        }

        public void stop() {
            this.upTicks = 0;
            this.dashCooldown = 0;
            this.ranged = false;
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityWarpedMosco mosco;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.mosco = EntityWarpedMosco.this;
        }

        public boolean canUse() {
            if (this.mosco.isVehicle() || this.mosco.getTarget() != null && this.mosco.getTarget().isAlive() || this.mosco.isPassenger()) {
                return false;
            }
            if (this.mosco.getRandom().nextInt(30) != 0 && !this.mosco.isFlying()) {
                return false;
            }
            this.flightTarget = this.mosco.onGround() ? EntityWarpedMosco.this.random.nextInt(8) == 0 : EntityWarpedMosco.this.random.nextInt(5) > 0 && this.mosco.timeFlying < 200;
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.mosco.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.mosco.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityWarpedMosco.this.isFlying() && this.mosco.onGround()) {
                this.mosco.setFlying(false);
            }
            if (EntityWarpedMosco.this.isFlying() && this.mosco.onGround() && this.mosco.timeFlying > 10) {
                this.mosco.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.mosco.position();
            if (this.mosco.isOverLiquid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.mosco.timeFlying < 50 || this.mosco.isOverLiquid()) {
                    return this.mosco.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.mosco.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.mosco, (int)20, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.flightTarget) {
                return this.mosco.isFlying() && this.mosco.distanceToSqr(this.x, this.y, this.z) > 20.0 && !this.mosco.horizontalCollision;
            }
            return !this.mosco.getNavigation().isDone() && !this.mosco.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.mosco.setFlying(true);
                this.mosco.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.mosco.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.mosco.getNavigation().stop();
            super.stop();
        }
    }
}

