/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;

public class EntityVoidWormShot
extends Entity {
    private UUID ownerUUID;
    private int ownerNetworkId;
    private boolean leftOwner;
    private static final EntityDataAccessor<Float> STOP_HOMING_PROGRESS = SynchedEntityData.defineId(EntityVoidWormShot.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float prevStopHomingProgress = 0.0f;
    public static final float HOME_FOR = 40.0f;

    public EntityVoidWormShot(EntityType p_i50162_1_, Level p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public EntityVoidWormShot(Level worldIn, EntityVoidWorm p_i47273_2_) {
        this((EntityType)AMEntityRegistry.VOID_WORM_SHOT.get(), worldIn);
        this.setShooter((Entity)p_i47273_2_);
        this.setPos(p_i47273_2_.getX() - (double)(p_i47273_2_.getBbWidth() + 1.0f) * 0.35 * (double)Mth.sin((float)(p_i47273_2_.yBodyRot * ((float)Math.PI / 180))), p_i47273_2_.getY() + 1.0, p_i47273_2_.getZ() + (double)(p_i47273_2_.getBbWidth() + 1.0f) * 0.35 * (double)Mth.cos((float)(p_i47273_2_.yBodyRot * ((float)Math.PI / 180))));
    }

    public EntityVoidWormShot(Level worldIn, LivingEntity p_i47273_2_, boolean right) {
        this((EntityType)AMEntityRegistry.VOID_WORM_SHOT.get(), worldIn);
        this.setShooter((Entity)p_i47273_2_);
        float rot = p_i47273_2_.yHeadRot + (float)(right ? 60 : -60);
        this.setPos(p_i47273_2_.getX() - (double)p_i47273_2_.getBbWidth() * (double)0.9f * (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), p_i47273_2_.getY() + 1.0, p_i47273_2_.getZ() + (double)p_i47273_2_.getBbWidth() * 0.9 * (double)Mth.cos((float)(rot * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityVoidWormShot(Level worldIn, double x, double y, double z, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        this((EntityType)AMEntityRegistry.VOID_WORM_SHOT.get(), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(p_i47274_8_, p_i47274_10_, p_i47274_12_);
    }

    protected static float lerpRotation(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }

    public void tick() {
        this.prevStopHomingProgress = this.getStopHomingProgress();
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (this.tickCount > 400) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount > 40) {
            Entity entity = this.getShooter();
            float stopHomingProgress = this.getStopHomingProgress();
            if (stopHomingProgress < 40.0f) {
                this.setStopHomingProgress(stopHomingProgress += 1.0f);
            }
            float homeScale = 1.0f - stopHomingProgress / 40.0f;
            if (entity instanceof Mob && ((Mob)entity).getTarget() != null && homeScale > 0.0f) {
                LivingEntity target = ((Mob)entity).getTarget();
                if (target == null) {
                    this.kill();
                }
                double d0 = target.getX() - this.getX();
                double d1 = target.getEyeY() - this.getY();
                double d2 = target.getZ() - this.getZ();
                Vec3 vec = new Vec3(d0, d1, d2).normalize().scale((double)(Math.max(homeScale, 0.5f) * 1.2f));
                this.setDeltaMovement(vec);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.09, 0.0));
            }
        }
        super.tick();
        Vec3 vector3d = this.getDeltaMovement();
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
            this.onImpact(raytraceresult);
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        this.setNoGravity(true);
        this.updateRotation();
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (this.isInWaterOrBubble()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.setDeltaMovement(vector3d.scale((double)0.99f));
            this.setPos(d0, d1, d2);
        }
    }

    protected void onEntityHit(EntityHitResult p_213868_1_) {
        Player player;
        boolean b;
        Entity entity = this.getShooter();
        if (entity instanceof LivingEntity && !(p_213868_1_.getEntity() instanceof EntityVoidWorm) && !(p_213868_1_.getEntity() instanceof EntityVoidWormPart) && (b = this.wormAttack(p_213868_1_.getEntity(), this.damageSources().mobProjectile((Entity)this, (LivingEntity)entity), (float)(AMConfig.voidWormDamageModifier * 4.0))) && p_213868_1_.getEntity() instanceof Player && (player = (Player)p_213868_1_.getEntity()).getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            player.disableShield();
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    private boolean wormAttack(Entity entity, DamageSource source, float dmg) {
        return entity.hurt(source, dmg);
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.level().getBlockState(p_230299_1_.getBlockPos());
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STOP_HOMING_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public float getStopHomingProgress() {
        return ((Float)this.entityData.get(STOP_HOMING_PROGRESS)).floatValue();
    }

    public void setStopHomingProgress(float progress) {
        this.entityData.set(STOP_HOMING_PROGRESS, (Object)Float.valueOf(progress));
    }

    public void setShooter(@Nullable Entity entityIn) {
        if (entityIn != null) {
            this.ownerUUID = entityIn.getUUID();
            this.ownerNetworkId = entityIn.getId();
        }
    }

    @Nullable
    public Entity getShooter() {
        if (this.ownerUUID != null && this.level() instanceof ServerLevel) {
            return ((ServerLevel)this.level()).getEntity(this.ownerUUID);
        }
        return this.ownerNetworkId != 0 ? this.level().getEntity(this.ownerNetworkId) : null;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compound.putBoolean("LeftOwner", true);
        }
        compound.putFloat("HomeTime", this.getStopHomingProgress());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        this.setStopHomingProgress(compound.getFloat("HomeTime"));
        this.leftOwner = compound.getBoolean("LeftOwner");
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getShooter();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_234613_0_ -> !p_234613_0_.isSpectator() && p_234613_0_.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(this.getDeltaMovement().add(vector3d));
        float f = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void onImpact(HitResult result) {
        HitResult.Type raytraceresult$type = result.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)result);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
        this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 0.5f);
        Entity entity = this.getShooter();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)(x * x + z * z)));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        if (!p_230298_1_.isSpectator() && p_230298_1_.isAlive() && p_230298_1_.isPickable()) {
            Entity entity = this.getShooter();
            return (entity == null || this.leftOwner || !entity.isPassengerOfSameVehicle(p_230298_1_)) && !(p_230298_1_ instanceof EntityVoidWormShot) && !(p_230298_1_ instanceof EntityVoidWormPart);
        }
        return false;
    }

    protected void updateRotation() {
        Vec3 vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)vector3d.horizontalDistance()));
        this.setXRot(EntityVoidWormShot.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875)));
        this.setYRot(EntityVoidWormShot.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875)));
    }
}

