/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.entity.IHurtableMultipart;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.network.MessageHurtMultipart;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityVoidWormPart
extends LivingEntity
implements IHurtableMultipart {
    protected static final EntityDimensions SIZE_BASE = EntityDimensions.scalable((float)1.2f, (float)1.95f);
    protected static final EntityDimensions TAIL_SIZE = EntityDimensions.scalable((float)1.6f, (float)2.0f);
    private static final EntityDataAccessor<Boolean> TAIL = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BODYINDEX = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> WORM_SCALE = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> WORM_YAW = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> WORM_ANGLE = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> PORTAL_TICKS = SynchedEntityData.defineId(EntityVoidWormPart.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public EntityDimensions multipartSize;
    public float prevWormAngle;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier = 1.0f;
    private float prevWormYaw = 0.0f;
    private Vec3 teleportPos = null;
    private Vec3 enterPos = null;
    private boolean doesParentControlPos = false;

    public EntityVoidWormPart(EntityType t, Level world) {
        super(t, world);
        this.multipartSize = t.getDimensions();
    }

    public EntityVoidWormPart(EntityType t, LivingEntity parent, float radius, float angleYaw, float offsetY) {
        super(t, parent.level());
        this.setParent((Entity)parent);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f);
    }

    public void push(Entity entityIn) {
    }

    public void kill() {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public float getWormScale() {
        return ((Float)this.entityData.get(WORM_SCALE)).floatValue();
    }

    public void setWormScale(float scale) {
        this.entityData.set(WORM_SCALE, (Object)Float.valueOf(scale));
    }

    public float getScale() {
        return this.getWormScale() + 0.5f;
    }

    public boolean startRiding(Entity entityIn) {
        if (!(entityIn instanceof AbstractMinecart) && !(entityIn instanceof Boat)) {
            return super.startRiding(entityIn);
        }
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.FALL) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.FELL_OUT_OF_WORLD) || source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.LAVA) || source.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(source);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getParentId() != null) {
            compound.putUUID("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            compound.putUUID("ChildUUID", this.getChildId());
        }
        compound.putBoolean("TailPart", this.isTail());
        compound.putInt("BodyIndex", this.getBodyIndex());
        compound.putInt("PortalTicks", this.getPortalTicks());
        compound.putFloat("PartAngle", this.angleYaw);
        compound.putFloat("WormScale", this.getWormScale());
        compound.putFloat("PartRadius", this.radius);
        compound.putFloat("PartYOffset", this.offsetY);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("ParentUUID")) {
            this.setParentId(compound.getUUID("ParentUUID"));
        }
        if (compound.hasUUID("ChildUUID")) {
            this.setChildId(compound.getUUID("ChildUUID"));
        }
        this.setTail(compound.getBoolean("TailPart"));
        this.setBodyIndex(compound.getInt("BodyIndex"));
        this.setPortalTicks(compound.getInt("PortalTicks"));
        this.angleYaw = compound.getFloat("PartAngle");
        this.setWormScale(compound.getFloat("WormScale"));
        this.radius = compound.getFloat("PartRadius");
        this.offsetY = compound.getFloat("PartYOffset");
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARENT_UUID, Optional.empty());
        builder.define(CHILD_UUID, Optional.empty());
        builder.define(TAIL, (Object)false);
        builder.define(BODYINDEX, (Object)0);
        builder.define(WORM_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(WORM_YAW, (Object)Float.valueOf(0.0f));
        builder.define(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(PORTAL_TICKS, (Object)0);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.entityData.get(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.entityData.set(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.entityData.get(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.entityData.set(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public void setInitialPartPos(Entity parent) {
        this.setPos(parent.xo + (double)this.radius * Math.cos((double)parent.getYRot() * (Math.PI / 180) + (double)this.angleYaw), parent.yo + (double)this.offsetY, parent.zo + (double)this.radius * Math.sin((double)parent.getYRot() * (Math.PI / 180) + (double)this.angleYaw));
    }

    public float getWormAngle() {
        return ((Float)this.entityData.get(WORM_ANGLE)).floatValue();
    }

    public void setWormAngle(float progress) {
        this.entityData.set(WORM_ANGLE, (Object)Float.valueOf(progress));
    }

    public int getPortalTicks() {
        return (Integer)this.entityData.get(PORTAL_TICKS);
    }

    public void setPortalTicks(int ticks) {
        this.entityData.set(PORTAL_TICKS, (Object)ticks);
    }

    public void tick() {
        this.prevWormAngle = this.getWormAngle();
        this.prevWormYaw = ((Float)this.entityData.get(WORM_YAW)).floatValue();
        this.setDeltaMovement(Vec3.ZERO);
        this.radius = 1.0f + this.getWormScale() * (this.isTail() ? 0.65f : 0.3f) + (this.getBodyIndex() == 0 ? 0.8f : 0.0f);
        if (this.tickCount > 3) {
            Entity parent = this.getParent();
            this.refreshDimensions();
            if (parent != null && !this.level().isClientSide) {
                this.setNoGravity(true);
                Vec3 parentVec = parent.position().subtract(parent.xo, parent.yo, parent.zo);
                double restrictRadius = Mth.clamp((double)((double)this.radius - parentVec.lengthSqr() * 0.25), (double)(this.radius * 0.5f), (double)this.radius);
                if (parent instanceof EntityVoidWorm) {
                    restrictRadius *= (double)(this.isTail() ? 0.8f : 0.4f);
                }
                double x = parent.getX() + restrictRadius * Math.cos((double)parent.getYRot() * (Math.PI / 180) + (double)this.angleYaw);
                double yStretch = Math.abs(parent.getY() - parent.yo) > (double)this.getBbWidth() ? parent.getY() : parent.yo;
                double y = yStretch + (double)(this.offsetY * this.getWormScale());
                double z = parent.getZ() + restrictRadius * Math.sin((double)parent.getYRot() * (Math.PI / 180) + (double)this.angleYaw);
                double d0 = parent.xo - this.getX();
                double d1 = parent.yo - this.getY();
                double d2 = parent.zo - this.getZ();
                float yaw = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float pitch = parent.getXRot();
                if (this.getPortalTicks() <= 1 && !this.doesParentControlPos) {
                    float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                    this.setPos(x, y, z);
                    this.setXRot(this.limitAngle(this.getXRot(), f2, 5.0f));
                    this.setYRot(yaw);
                    this.entityData.set(WORM_YAW, (Object)Float.valueOf(this.getYRot()));
                }
                this.markHurt();
                this.yHeadRot = this.getYRot();
                this.yBodyRot = pitch;
                if (parent instanceof LivingEntity && !this.level().isClientSide && (((LivingEntity)parent).hurtTime > 0 || ((LivingEntity)parent).deathTime > 0)) {
                    AlexsMobs.sendMSGToAll(new MessageHurtMultipart(this.getId(), parent.getId(), 0.0f, ""));
                    this.hurtTime = ((LivingEntity)parent).hurtTime;
                    this.deathTime = ((LivingEntity)parent).deathTime;
                }
                this.pushEntities();
                if (parent.isRemoved() && !this.level().isClientSide) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                if (parent instanceof EntityVoidWorm) {
                    this.setWormAngle(((EntityVoidWorm)parent).prevWormAngle);
                } else if (parent instanceof EntityVoidWormPart) {
                    this.setWormAngle(((EntityVoidWormPart)parent).prevWormAngle);
                }
            } else if (this.tickCount > 20 && !this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.tickCount % 400 == 0) {
            this.heal(1.0f);
        }
        super.tick();
        if (this.doesParentControlPos && this.enterPos != null) {
            this.teleportTo(this.enterPos.x, this.enterPos.y, this.enterPos.z);
        }
        if (this.getPortalTicks() > 0) {
            this.setPortalTicks(this.getPortalTicks() - 1);
            if (this.getPortalTicks() <= 5 && this.teleportPos != null) {
                Vec3 vec = this.teleportPos;
                this.teleportTo(vec.x, vec.y, vec.z);
                this.xOld = vec.x;
                this.yOld = vec.y;
                this.zOld = vec.z;
                if (this.getPortalTicks() == 5 && this.getChild() instanceof EntityVoidWormPart) {
                    ((EntityVoidWormPart)this.getChild()).teleportTo(this.enterPos, this.teleportPos);
                }
                this.teleportPos = null;
            } else if (this.getPortalTicks() > 5 && this.enterPos != null) {
                this.teleportTo(this.enterPos.x, this.enterPos.y, this.enterPos.z);
            }
            if (this.getPortalTicks() == 0) {
                this.doesParentControlPos = false;
            }
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.DISCARDED);
            for (int i = 0; i < 30; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)AMParticleRegistry.WORM_PORTAL.get(), this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
            }
        }
    }

    public void die(DamageSource cause) {
        EntityVoidWorm worm = this.getWorm();
        if (worm != null) {
            int segments = Math.max(worm.getSegmentCount() / 2 - 1, 1);
            worm.setSegmentCount(segments);
            if (this.getChild() instanceof EntityVoidWormPart) {
                EntityVoidWormPart segment = (EntityVoidWormPart)this.getChild();
                EntityVoidWorm worm2 = (EntityVoidWorm)((EntityType)AMEntityRegistry.VOID_WORM.get()).create(this.level());
                worm2.setNoAi(worm.isNoAi());
                worm2.setInvulnerable(worm.isInvulnerable());
                worm2.copyPosition((Entity)this);
                segment.copyPosition((Entity)this);
                worm2.setChildId(segment.getUUID());
                worm2.setSegmentCount(segments);
                segment.setParent((Entity)worm2);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)worm2);
                }
                worm2.setSplitter(true);
                worm2.setBaseMaxHealth(worm.getBaseMaxHealth() / 2.0, true);
                worm2.setSplitFromUuid(worm.getUUID());
                worm2.setWormSpeed((float)Mth.clamp((double)((double)worm.getWormSpeed() * 0.8), (double)0.4f, (double)1.0));
                worm2.resetWormScales();
                if (!this.level().isClientSide && cause != null && cause.getEntity() instanceof ServerPlayer) {
                    ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.VOID_WORM_SPLIT.get())).trigger((ServerPlayer)cause.getEntity());
                }
            }
            worm.resetWormScales();
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        EntityVoidWorm worm = this.getWorm();
        return super.isAlliedTo(entityIn) || worm != null && worm.isAlliedTo(entityIn);
    }

    public EntityVoidWorm getWorm() {
        Entity parent = this.getParent();
        while (parent instanceof EntityVoidWormPart) {
            parent = ((EntityVoidWormPart)parent).getParent();
        }
        if (parent instanceof EntityVoidWorm) {
            return (EntityVoidWorm)parent;
        }
        return null;
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.getUUID());
    }

    public boolean is(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        Entity parent = this.getParent();
        return parent != null ? parent.getPickResult() : ItemStack.EMPTY;
    }

    public HumanoidArm getMainArm() {
        return null;
    }

    public void pushEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards((double)0.2f, 0.0, (double)0.2f));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> !entity.is(parent) && !(entity instanceof EntityVoidWormPart) && entity.isPushable()).forEach(entity -> entity.push(parent));
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Entity parent = this.getParent();
        return parent != null ? parent.interact(player, hand) : InteractionResult.PASS;
    }

    public boolean isHurt() {
        return (double)this.getHealth() <= this.getHealthThreshold();
    }

    public double getHealthThreshold() {
        return 5.0;
    }

    public boolean hurt(DamageSource source, float damage) {
        if (super.hurt(source, damage)) {
            EntityVoidWorm worm = this.getWorm();
            if (worm != null) {
                worm.playHurtSoundWorm(source);
            }
            return true;
        }
        return false;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public boolean isTail() {
        return (Boolean)this.entityData.get(TAIL);
    }

    public void setTail(boolean tail) {
        this.entityData.set(TAIL, (Object)tail);
    }

    public int getBodyIndex() {
        return (Integer)this.entityData.get(BODYINDEX);
    }

    public void setBodyIndex(int index) {
        this.entityData.set(BODYINDEX, (Object)index);
    }

    public boolean shouldNotExist() {
        Entity parent = this.getParent();
        return !parent.isAlive();
    }

    @Override
    public void onAttackedFromServer(LivingEntity parent, float damage, DamageSource damageSource) {
        if (parent.deathTime > 0) {
            this.deathTime = parent.deathTime;
        }
        if (parent.hurtTime > 0) {
            this.hurtTime = parent.hurtTime;
        }
    }

    public boolean shouldContinuePersisting() {
        return true;
    }

    public float getWormYaw(float partialTicks) {
        return partialTicks == 0.0f ? ((Float)this.entityData.get(WORM_YAW)).floatValue() : this.prevWormYaw + (((Float)this.entityData.get(WORM_YAW)).floatValue() - this.prevWormYaw) * partialTicks;
    }

    public void teleportTo(Vec3 enterPos, Vec3 to) {
        this.setPortalTicks(10);
        this.teleportPos = to;
        this.enterPos = enterPos;
        EntityVoidWorm worm = this.getWorm();
        if (worm != null && this.getChild() == null) {
            worm.fullyThrough = true;
        }
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
    }
}

