/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemDimensionalCarver;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.apache.logging.log4j.Logger;

public class EntityVoidPortal
extends Entity {
    protected static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(EntityVoidPortal.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(EntityVoidPortal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> SHATTERED = SynchedEntityData.defineId(EntityVoidPortal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> DESTINATION = SynchedEntityData.defineId(EntityVoidPortal.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Optional<UUID>> SISTER_UUID = SynchedEntityData.defineId(EntityVoidPortal.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public ResourceKey<Level> exitDimension;
    private boolean madeOpenNoise = false;
    private boolean madeCloseNoise = false;
    private boolean isDummy = false;
    private boolean hasClearedObstructions;

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(LIFESPAN, (Object)300);
        builder.define(SHATTERED, (Object)false);
        builder.define(SISTER_UUID, Optional.empty());
        builder.define(DESTINATION, Optional.empty());
    }

    public EntityVoidPortal(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityVoidPortal(Level world, ItemDimensionalCarver item) {
        this((EntityType)AMEntityRegistry.VOID_PORTAL.get(), world);
        if (item == AMItemRegistry.SHATTERED_DIMENSIONAL_CARVER.get()) {
            this.setShattered(true);
            this.setLifespan(2000);
        } else {
            this.setShattered(false);
            this.setLifespan(1200);
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1 && this.getLifespan() == 0) {
            this.setLifespan(2000);
        }
        if (!this.madeOpenNoise) {
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.playSound((SoundEvent)AMSoundRegistry.VOID_PORTAL_OPEN.get(), 1.0f, 1.0f + this.random.nextFloat() * 0.2f);
            this.madeOpenNoise = true;
        }
        Direction direction2 = this.getAttachmentFacing().getOpposite();
        float minX = -0.15f;
        float minY = -0.15f;
        float minZ = -0.15f;
        float maxX = 0.15f;
        float maxY = 0.15f;
        float maxZ = 0.15f;
        switch (direction2) {
            case NORTH: 
            case SOUTH: {
                minX = -1.5f;
                maxX = 1.5f;
                minY = -1.5f;
                maxY = 1.5f;
                break;
            }
            case EAST: 
            case WEST: {
                minZ = -1.5f;
                maxZ = 1.5f;
                minY = -1.5f;
                maxY = 1.5f;
                break;
            }
            case UP: 
            case DOWN: {
                minX = -1.5f;
                maxX = 1.5f;
                minZ = -1.5f;
                maxZ = 1.5f;
            }
        }
        AABB bb = new AABB(this.getX() + (double)minX, this.getY() + (double)minY, this.getZ() + (double)minZ, this.getX() + (double)maxX, this.getY() + (double)maxY, this.getZ() + (double)maxZ);
        this.setBoundingBox(bb);
        if (this.level().isClientSide && this.random.nextFloat() < 0.5f && Math.min(this.tickCount, this.getLifespan()) >= 20) {
            double particleX = this.getBoundingBox().minX + (double)this.random.nextFloat() * (this.getBoundingBox().maxX - this.getBoundingBox().minX);
            double particleY = this.getBoundingBox().minY + (double)this.random.nextFloat() * (this.getBoundingBox().maxY - this.getBoundingBox().minY);
            double particleZ = this.getBoundingBox().minZ + (double)this.random.nextFloat() * (this.getBoundingBox().maxZ - this.getBoundingBox().minZ);
            this.level().addParticle((ParticleOptions)AMParticleRegistry.WORM_PORTAL.get(), particleX, particleY, particleZ, 0.1 * this.random.nextGaussian(), 0.1 * this.random.nextGaussian(), 0.1 * this.random.nextGaussian());
        }
        ArrayList entities = new ArrayList();
        entities.addAll(this.level().getEntities((Entity)this, bb.deflate((double)0.2f)));
        entities.addAll(this.level().getEntitiesOfClass(EntityVoidWorm.class, bb.inflate(1.5)));
        if (!this.level().isClientSide) {
            MinecraftServer server = this.level().getServer();
            if (this.getDestination() != null && this.getLifespan() > 20 && this.tickCount > 20) {
                BlockPos offsetPos = this.getDestination().relative(this.getAttachmentFacing().getOpposite(), 2);
                for (Entity e : entities) {
                    ServerLevel dimWorld;
                    if (e.isOnPortalCooldown() || e.isShiftKeyDown() || e instanceof EntityVoidPortal || e.getParts() != null || e instanceof PartEntity || e.getType().is(AMTagRegistry.VOID_PORTAL_IGNORES)) continue;
                    if (e instanceof EntityVoidWormPart) {
                        if (this.getLifespan() >= 22) continue;
                        this.setLifespan(this.getLifespan() + 1);
                        continue;
                    }
                    if (e instanceof EntityVoidWorm) {
                        ((EntityVoidWorm)e).teleportTo(Vec3.atCenterOf((Vec3i)this.getDestination()));
                        e.setPortalCooldown();
                        ((EntityVoidWorm)e).resetPortalLogic();
                        continue;
                    }
                    boolean flag = true;
                    if (this.exitDimension != null && (dimWorld = server.getLevel(this.exitDimension)) != null && this.level().dimension() != this.exitDimension) {
                        this.teleportEntityFromDimension(e, dimWorld, offsetPos, true);
                        flag = false;
                    }
                    if (!flag) continue;
                    e.teleportTo((double)((float)offsetPos.getX() + 0.5f), (double)((float)offsetPos.getY() + 0.5f), (double)((float)offsetPos.getZ() + 0.5f));
                    e.setPortalCooldown();
                }
            }
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 20 && !this.madeCloseNoise) {
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.playSound((SoundEvent)AMSoundRegistry.VOID_PORTAL_CLOSE.get(), 1.0f, 1.0f + this.random.nextFloat() * 0.2f);
            this.madeCloseNoise = true;
        }
        if (this.getLifespan() <= 0) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount > 1) {
            this.clearObstructions();
        }
    }

    private void teleportEntityFromDimension(Entity entity, ServerLevel endpointWorld, BlockPos endpoint, boolean b) {
        if (entity instanceof ServerPlayer) {
            entity.teleportTo(endpointWorld, (double)endpoint.getX() + 0.5, (double)endpoint.getY(), (double)endpoint.getZ() + 0.5, Set.of(), entity.getYRot(), entity.getXRot());
            if (this.getSisterId() == null) {
                this.createAndSetSister((Level)endpointWorld, Direction.DOWN);
            }
        } else {
            entity.unRide();
            Entity teleportedEntity = entity.getType().create((Level)endpointWorld);
            if (teleportedEntity != null) {
                teleportedEntity.restoreFrom(entity);
                teleportedEntity.moveTo((double)endpoint.getX() + 0.5, (double)endpoint.getY() + 0.5, (double)endpoint.getZ() + 0.5, entity.getYRot(), entity.getXRot());
                teleportedEntity.setYHeadRot(entity.getYHeadRot());
                teleportedEntity.setPortalCooldown();
                endpointWorld.addFreshEntity(teleportedEntity);
            }
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void clearObstructions() {
        if (!this.hasClearedObstructions && this.isShattered() && this.getDestination() != null) {
            this.hasClearedObstructions = true;
            for (int i = -1; i <= -1; ++i) {
                for (int j = -1; j <= -1; ++j) {
                    for (int k = -1; k <= -1; ++k) {
                        BlockPos toAir = this.getDestination().offset(i, j, k);
                        this.level().destroyBlock(toAir, true);
                    }
                }
            }
        }
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    public void setAttachmentFacing(Direction facing) {
        this.entityData.set(ATTACHED_FACE, (Object)facing);
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.entityData.set(LIFESPAN, (Object)i);
    }

    public boolean isShattered() {
        return (Boolean)this.entityData.get(SHATTERED);
    }

    public void setShattered(boolean set) {
        this.entityData.set(SHATTERED, (Object)set);
    }

    public BlockPos getDestination() {
        return ((Optional)this.entityData.get(DESTINATION)).orElse(null);
    }

    public void setDestination(BlockPos destination) {
        this.entityData.set(DESTINATION, Optional.ofNullable(destination));
        if (this.getSisterId() == null && (this.exitDimension == null || this.exitDimension == this.level().dimension())) {
            this.createAndSetSister(this.level(), null);
        }
    }

    public void createAndSetSister(Level world, Direction dir) {
        EntityVoidPortal portal = (EntityVoidPortal)((EntityType)AMEntityRegistry.VOID_PORTAL.get()).create(world);
        portal.setAttachmentFacing(dir != null ? dir : this.getAttachmentFacing().getOpposite());
        BlockPos safeDestination = this.getDestination();
        portal.teleportTo((float)safeDestination.getX() + 0.5f, (float)safeDestination.getY() + 0.5f, (float)safeDestination.getZ() + 0.5f);
        portal.link(this);
        portal.exitDimension = this.level().dimension();
        world.addFreshEntity((Entity)portal);
        portal.setShattered(this.isShattered());
    }

    public void setDestination(BlockPos destination, Direction dir) {
        this.entityData.set(DESTINATION, Optional.ofNullable(destination));
        if (this.getSisterId() == null && (this.exitDimension == null || this.exitDimension == this.level().dimension())) {
            this.createAndSetSister(this.level(), dir);
        }
    }

    public void link(EntityVoidPortal portal) {
        this.setSisterId(portal.getUUID());
        portal.setSisterId(this.getUUID());
        portal.setLifespan(this.getLifespan());
        this.setDestination(portal.blockPosition());
        portal.setDestination(this.blockPosition());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(ATTACHED_FACE, (Object)Direction.from3DDataValue((int)compound.getByte("AttachFace")));
        this.setLifespan(compound.getInt("Lifespan"));
        if (compound.contains("Shattered")) {
            this.setShattered(compound.getBoolean("Shattered"));
        }
        if (compound.contains("DX")) {
            int i = compound.getInt("DX");
            int j = compound.getInt("DY");
            int k = compound.getInt("DZ");
            this.entityData.set(DESTINATION, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.entityData.set(DESTINATION, Optional.empty());
        }
        if (compound.hasUUID("SisterUUID")) {
            this.setSisterId(compound.getUUID("SisterUUID"));
        }
        if (compound.contains("ExitDimension")) {
            this.exitDimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("ExitDimension")).resultOrPartial(arg_0 -> ((Logger)AlexsMobs.LOGGER).error(arg_0)).orElse(Level.OVERWORLD);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putByte("AttachFace", (byte)((Direction)this.entityData.get(ATTACHED_FACE)).get3DDataValue());
        compound.putInt("Lifespan", this.getLifespan());
        compound.putBoolean("Shattered", this.isShattered());
        BlockPos blockpos = this.getDestination();
        if (blockpos != null) {
            compound.putInt("DX", blockpos.getX());
            compound.putInt("DY", blockpos.getY());
            compound.putInt("DZ", blockpos.getZ());
        }
        if (this.getSisterId() != null) {
            compound.putUUID("SisterUUID", this.getSisterId());
        }
        if (this.exitDimension != null) {
            ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.exitDimension.location()).resultOrPartial(arg_0 -> ((Logger)AlexsMobs.LOGGER).error(arg_0)).ifPresent(p_241148_1_ -> compound.put("ExitDimension", p_241148_1_));
        }
    }

    public Entity getSister() {
        UUID id = this.getSisterId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    @Nullable
    public UUID getSisterId() {
        return ((Optional)this.entityData.get(SISTER_UUID)).orElse(null);
    }

    public void setSisterId(@Nullable UUID uniqueId) {
        this.entityData.set(SISTER_UUID, Optional.ofNullable(uniqueId));
    }
}

