/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.EtherealMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.MonsterAIWalkThroughHallsOfStructure;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class EntityUnderminer
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<BlockPos>> TARGETED_BLOCK_POS = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> DWARF = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> MINING_PROGRESS = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> VISUALLY_MINING = SynchedEntityData.defineId(EntityUnderminer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int mineCooldown = 100;
    private int resetStackTime = 0;
    private ItemStack lastGivenStack = null;
    public float hidingProgress = 0.0f;
    public float prevHidingProgress = 0.0f;
    private boolean mineAIFlag = false;
    private BlockPos lastPosition = this.blockPosition();

    public EntityUnderminer(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new EtherealMoveController((Mob)this, 1.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected PathNavigation createNavigation(Level level) {
        return new PathNavigator(this, this, this.level());
    }

    public static <T extends Mob> boolean checkUnderminerSpawnRules(EntityType<EntityUnderminer> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        int j = 3;
        if (pos.getY() >= iServerWorld.getSeaLevel()) {
            return false;
        }
        if (AlexsMobs.isHalloween()) {
            j = 7;
        } else if (random.nextBoolean()) {
            return false;
        }
        int i = iServerWorld.getMaxLocalRawBrightness(pos);
        return i > random.nextInt(j) ? false : EntityUnderminer.checkMobSpawnRules(entityType, (LevelAccessor)iServerWorld, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.requiresCustomPersistence() && !this.hasCustomName();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.lastGivenStack != null;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.underminerSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DWARF, (Object)true);
        builder.define(HIDING, (Object)false);
        builder.define(VISUALLY_MINING, (Object)false);
        builder.define(TARGETED_BLOCK_POS, Optional.empty());
        builder.define(MINING_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Dwarf", this.isDwarf());
        compound.putBoolean("Hiding", this.isHiding());
        compound.putInt("Variant", this.getVariant());
        compound.putInt("ResetItemTime", this.resetStackTime);
        compound.putInt("MineCooldown", this.mineCooldown);
        if (this.lastGivenStack != null) {
            compound.put("MineStack", this.lastGivenStack.saveOptional((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setDwarf(compound.getBoolean("Dwarf"));
        this.setHiding(compound.getBoolean("Hiding"));
        this.setVariant(compound.getInt("Variant"));
        this.resetStackTime = compound.getInt("ResetItemTime");
        this.mineCooldown = compound.getInt("MineCooldown");
        if (compound.contains("MineStack")) {
            this.lastGivenStack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("MineStack"));
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.UNDERMINER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.UNDERMINER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.UNDERMINER_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    public boolean isDwarf() {
        return (Boolean)this.entityData.get(DWARF) != false && !this.isExtraSpooky();
    }

    public void setDwarf(boolean phasing) {
        this.entityData.set(DWARF, (Object)phasing);
    }

    public int getVariant() {
        return this.isExtraSpooky() ? 1 : (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int i) {
        this.entityData.set(VARIANT, (Object)i);
    }

    public boolean isHiding() {
        return (Boolean)this.entityData.get(HIDING);
    }

    public void setHiding(boolean phasing) {
        this.entityData.set(HIDING, (Object)phasing);
    }

    @Nullable
    public BlockPos getMiningPos() {
        return ((Optional)this.getEntityData().get(TARGETED_BLOCK_POS)).orElse(null);
    }

    public void setMiningPos(@Nullable BlockPos beamTarget) {
        this.getEntityData().set(TARGETED_BLOCK_POS, Optional.ofNullable(beamTarget));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(2, (Goal)new MineGoal());
        this.goalSelector.addGoal(3, (Goal)new MonsterAIWalkThroughHallsOfStructure(this, 0.5, 60, (TagKey<Structure>)StructureTags.MINESHAFT, 50.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return !source.is(DamageTypes.MAGIC) && source.is(DamageTypes.FELL_OUT_OF_WORLD) && !source.isCreativePlayer() || super.isInvulnerableTo(source);
    }

    private float calculateDistanceToFloor() {
        BlockPos floor = AMBlockPos.fromCoords(this.getX(), this.getBoundingBox().maxY, this.getZ());
        while (!this.level().getBlockState(floor).isFaceSturdy((BlockGetter)this.level(), floor, Direction.UP) && floor.getY() > this.level().getMinBuildHeight()) {
            floor = floor.below();
        }
        return (float)(this.getBoundingBox().minY - (double)(floor.getY() + 1));
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.6, 0.9));
        } else {
            super.travel(travelVector);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218949_, DifficultyInstance p_218950_) {
        super.populateDefaultEquipmentSlots(p_218949_, p_218950_);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AMItemRegistry.GHOSTLY_PICKAXE.get()));
    }

    protected float getEquipmentDropChance(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return 0.5f;
        }
        return super.getEquipmentDropChance(slot);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficultyInstance, mobSpawnType, spawnData);
        RandomSource randomsource = level.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, difficultyInstance);
        if (this.random.nextFloat() < 0.3f) {
            this.setVariant(this.random.nextInt(2));
            this.setDwarf(false);
        } else {
            this.setDwarf(true);
        }
        return spawnData;
    }

    public boolean isFullyHidden() {
        return this.isHiding() && this.hidingProgress >= 10.0f;
    }

    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.prevHidingProgress = this.hidingProgress;
        this.noPhysics = false;
        if (this.isHiding() && this.hidingProgress < 10.0f) {
            this.hidingProgress += 1.0f;
        }
        if (!this.isHiding() && this.hidingProgress > 0.0f) {
            this.hidingProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            Player player;
            double xzSpeed = this.getDeltaMovement().horizontalDistance();
            double distToFloor = Mth.clamp((float)this.calculateDistanceToFloor(), (float)-1.0f, (float)1.0f);
            if (Math.abs(distToFloor) > 0.01 && xzSpeed < 0.05 && !this.isActuallyInAWall()) {
                if (distToFloor < 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -Math.min(distToFloor * (double)0.1f, 0.0), 0.0));
                } else if (distToFloor > 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -Math.max(distToFloor * (double)0.1f, 0.0), 0.0));
                }
            }
            if (this.lastPosition != null && this.lastPosition.distSqr((Vec3i)this.blockPosition()) > 2.5 && Math.abs(distToFloor) < 0.5) {
                this.playSound((SoundEvent)AMSoundRegistry.UNDERMINER_STEP.get(), 1.0f, 0.75f + this.random.nextFloat() * 0.25f);
                this.lastPosition = this.blockPosition();
                if (this.random.nextFloat() < 0.015f && !this.level().canSeeSky(this.lastPosition)) {
                    this.playSound((SoundEvent)SoundEvents.AMBIENT_CAVE.value(), 3.0f, 0.75f + this.random.nextFloat() * 0.25f);
                }
            }
            if (!((player = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), AMConfig.underminerDisappearDistance, true)) == null || this.lastGivenStack != null || this.getTarget() != null && this.getTarget().isAlive())) {
                this.setHiding(true);
                this.lookAt((Entity)player, 360.0f, 360.0f);
            } else {
                this.setHiding(false);
            }
        }
        this.setYBodyRot(this.getYRot());
        if (this.mineCooldown > 0) {
            --this.mineCooldown;
        }
        if (this.resetStackTime > 0) {
            --this.resetStackTime;
            if (this.resetStackTime == 0) {
                this.lastGivenStack = null;
            }
        }
        if (((Boolean)this.entityData.get(VISUALLY_MINING)).booleanValue()) {
            this.swing(InteractionHand.MAIN_HAND);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean canPickUpLoot() {
        return true;
    }

    public boolean wantsToPickUp(ItemStack stack) {
        return stack.is(AMTagRegistry.UNDERMINER_ORES);
    }

    protected void pickUpItem(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        if (itemstack.is(AMTagRegistry.UNDERMINER_ORES)) {
            this.onItemPickup(itemEntity);
            this.take((Entity)itemEntity, itemstack.getCount());
            itemEntity.discard();
            this.mineAIFlag = this.lastGivenStack == null || !ItemStack.isSameItem((ItemStack)this.lastGivenStack, (ItemStack)itemEntity.getItem());
            this.lastGivenStack = itemEntity.getItem();
            this.resetStackTime = 2000 + this.random.nextInt(1200);
            this.mineCooldown = 0;
        } else {
            super.pickUpItem(itemEntity);
        }
    }

    public void jumpFromGround() {
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isExtraSpooky() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return AlexsMobs.isAprilFools() || AlexsMobs.isHalloween() || s != null && s.toLowerCase().contains("herobrine");
    }

    private boolean isActuallyInAWall() {
        float f = this.getDimensions(this.getPose()).width() * 0.1f;
        AABB aabb = AABB.ofSize((Vec3)this.getEyePosition(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.betweenClosedStream((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.level().getBlockState(p_201942_);
            return !blockstate.isAir() && blockstate.isSuffocating((BlockGetter)this.level(), p_201942_) && Shapes.joinIsNotEmpty((VoxelShape)blockstate.getCollisionShape((BlockGetter)this.level(), p_201942_).move((double)p_201942_.getX(), (double)p_201942_.getY(), (double)p_201942_.getZ()), (VoxelShape)Shapes.create((AABB)aabb), (BooleanOp)BooleanOp.AND);
        });
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getBrightness() {
        return 1.0f;
    }

    public float getMiningProgress() {
        return ((Float)this.entityData.get(MINING_PROGRESS)).floatValue();
    }

    public void setMiningProgress(float f) {
        this.entityData.set(MINING_PROGRESS, (Object)Float.valueOf(f));
    }

    private List<BlockPos> getNearbyObscuredOres(int range, int maxOres) {
        ArrayList<BlockPos> obscuredBlocks = new ArrayList<BlockPos>();
        BlockPos blockpos = this.blockPosition();
        int half = range / 2;
        int i = 0;
        while (i <= half && i >= -half) {
            int j = 0;
            while (j <= range && j >= -range) {
                int k = 0;
                while (k <= range && k >= -range) {
                    BlockPos offset = blockpos.offset(j, i, k);
                    BlockState state = this.level().getBlockState(offset);
                    if (this.isValidMiningBlock(state)) {
                        if (obscuredBlocks.size() >= maxOres) break;
                        BlockPos obscured = this.getObscuringBlockOf(offset);
                        if (obscured != null) {
                            obscuredBlocks.add(obscured);
                        }
                    }
                    k = (k <= 0 ? 1 : 0) - k;
                }
                j = (j <= 0 ? 1 : 0) - j;
            }
            i = (i <= 0 ? 1 : 0) - i;
        }
        return obscuredBlocks;
    }

    private boolean isValidMiningBlock(BlockState state) {
        if (this.lastGivenStack != null) {
            return this.lastGivenStack.getItem() == state.getBlock().asItem();
        }
        return state.is(Tags.Blocks.ORES);
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public boolean isAttackable() {
        return !this.isFullyHidden() && super.isAttackable();
    }

    public boolean skipAttackInteraction(Entity entity) {
        return this.isFullyHidden() || super.skipAttackInteraction(entity);
    }

    private BlockPos getObscuringBlockOf(BlockPos target) {
        Vec3 eyes = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        BlockHitResult hitResult = this.level().clip(new ClipContext(eyes, Vec3.atCenterOf((Vec3i)target), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult instanceof BlockHitResult && !hitResult.getBlockPos().equals((Object)target)) {
            BlockPos pos = hitResult.getBlockPos();
            return pos.distSqr((Vec3i)target) > 4.0 ? null : pos;
        }
        return null;
    }

    private boolean hasPick() {
        return this.getItemInHand(InteractionHand.MAIN_HAND).is((Item)AMItemRegistry.GHOSTLY_PICKAXE.get());
    }

    private class PathNavigator
    extends GroundPathNavigation {
        public PathNavigator(EntityUnderminer entityUnderminer, EntityUnderminer underminer, Level level) {
            super((Mob)underminer, entityUnderminer.level());
        }

        protected boolean canUpdatePath() {
            return !this.mob.isPassenger();
        }

        protected Vec3 getTempMobPos() {
            return this.mob.position();
        }
    }

    private class MineGoal
    extends Goal {
        private BlockPos minePretendPos = null;
        private BlockState minePretendStartState = null;
        private int mineTime = 0;

        public MineGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (EntityUnderminer.this.mineCooldown == 0 && EntityUnderminer.this.hasPick() && !EntityUnderminer.this.isHiding() && !EntityUnderminer.this.isActuallyInAWall() && EntityUnderminer.this.getRandom().nextInt(30) == 0) {
                List<BlockPos> obscuredOres = EntityUnderminer.this.getNearbyObscuredOres(16, 8);
                BlockPos nearest = null;
                double nearestDist = Double.MAX_VALUE;
                if (!obscuredOres.isEmpty()) {
                    for (BlockPos obscuredPos : obscuredOres) {
                        double dist = EntityUnderminer.this.position().distanceTo(Vec3.atCenterOf((Vec3i)obscuredPos));
                        if (!(nearestDist > dist)) continue;
                        nearest = obscuredPos;
                        nearestDist = dist;
                    }
                }
                EntityUnderminer.this.mineAIFlag = false;
                this.minePretendPos = nearest;
                return this.minePretendPos != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.minePretendPos != null && EntityUnderminer.this.hasPick() && !EntityUnderminer.this.isHiding() && !EntityUnderminer.this.mineAIFlag && this.minePretendStartState != null && this.minePretendStartState.equals(EntityUnderminer.this.level().getBlockState(this.minePretendPos)) && this.mineTime < 200;
        }

        public void start() {
            if (this.minePretendPos != null) {
                this.minePretendStartState = EntityUnderminer.this.level().getBlockState(this.minePretendPos);
            }
        }

        public void stop() {
            if (this.minePretendPos != null && this.minePretendStartState != null && !this.minePretendStartState.equals(EntityUnderminer.this.level().getBlockState(this.minePretendPos))) {
                for (ServerPlayer serverplayerentity : EntityUnderminer.this.level().getEntitiesOfClass(ServerPlayer.class, EntityUnderminer.this.getBoundingBox().inflate(12.0, 12.0, 12.0))) {
                    ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.UNDERMINE_UNDERMINER.get())).trigger(serverplayerentity);
                }
            }
            this.minePretendPos = null;
            this.minePretendStartState = null;
            this.mineTime = 0;
            EntityUnderminer.this.entityData.set(VISUALLY_MINING, (Object)false);
            EntityUnderminer.this.setMiningPos(null);
            EntityUnderminer.this.setMiningProgress(0.0f);
            EntityUnderminer.this.mineCooldown = EntityUnderminer.this.resetStackTime > 0 ? 40 : 200 + EntityUnderminer.this.random.nextInt(200);
        }

        public void tick() {
            if (this.minePretendPos != null && this.minePretendStartState != null) {
                ++this.mineTime;
                double distSqr = EntityUnderminer.this.distanceToSqr((float)this.minePretendPos.getX() + 0.5f, (float)this.minePretendPos.getY() + 0.5f, (float)this.minePretendPos.getZ() + 0.5f);
                if (distSqr < 6.5) {
                    EntityUnderminer.this.getNavigation().stop();
                    if (EntityUnderminer.this.getNavigation().isDone()) {
                        EntityUnderminer.this.setMiningPos(this.minePretendPos);
                        EntityUnderminer.this.setMiningProgress((1.0f + (float)Math.cos((double)((float)this.mineTime * 0.1f) + Math.PI)) * 0.5f);
                        double d1 = (double)((float)this.minePretendPos.getZ() + 0.5f) - EntityUnderminer.this.getZ();
                        double d3 = (double)((float)this.minePretendPos.getY() + 0.5f) - EntityUnderminer.this.getY();
                        double d2 = (double)((float)this.minePretendPos.getX() + 0.5f) - EntityUnderminer.this.getX();
                        float f = Mth.sqrt((float)((float)(d2 * d2 + d1 * d1)));
                        EntityUnderminer.this.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        EntityUnderminer.this.setXRot((float)(Mth.atan2((double)d3, (double)f) * 57.2957763671875) + (float)Math.sin((float)EntityUnderminer.this.tickCount * 0.1f));
                        EntityUnderminer.this.entityData.set(VISUALLY_MINING, (Object)true);
                        if (this.mineTime % 10 == 0) {
                            SoundType soundType = this.minePretendStartState.getBlock().getSoundType(this.minePretendStartState, (LevelReader)EntityUnderminer.this.level(), this.minePretendPos, (Entity)EntityUnderminer.this);
                            EntityUnderminer.this.playSound(soundType.getHitSound());
                        }
                    }
                } else {
                    EntityUnderminer.this.entityData.set(VISUALLY_MINING, (Object)false);
                    EntityUnderminer.this.setMiningPos(null);
                    EntityUnderminer.this.getNavigation().moveTo((double)((float)this.minePretendPos.getX() + 0.5f), (double)((float)this.minePretendPos.getY() + 0.5f), (double)((float)this.minePretendPos.getZ() + 0.5f), 1.0);
                }
            }
        }
    }
}

