/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityTriops
extends WaterAnimal
implements ITargetsDroppedItems,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityTriops.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> TRIOPS_SCALE = SynchedEntityData.defineId(EntityTriops.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> BABY_AGE = SynchedEntityData.defineId(EntityTriops.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevOnLandProgress;
    public float onLandProgress;
    public float prevSwimRot;
    public float swimRot;
    public boolean fedCarrot = false;
    public int breedCooldown = 0;
    public float tail1Yaw;
    public float prevTail1Yaw;
    public float tail2Yaw;
    public float prevTail2Yaw;
    public float moveDistance;
    private EntityTriops breedWith;
    private boolean pregnant;

    public EntityTriops(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f, 15.0f);
        this.tail1Yaw = this.getYRot();
        this.prevTail1Yaw = this.getYRot();
        this.tail2Yaw = this.getYRot();
        this.prevTail2Yaw = this.getYRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(TRIOPS_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(BABY_AGE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BreedGoal());
        this.goalSelector.addGoal(1, (Goal)new LayEggGoal());
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AnimalAISwimBottom((PathfinderMob)this, 1.0, 7));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false, 10));
    }

    public int getMaxSpawnClusterSize() {
        return 5;
    }

    public boolean isMaxGroupSizeReached(int sizeIn) {
        return false;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWaterOrBubble()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.8, 0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
            this.moveDistance = (float)((double)this.moveDistance + travelVector.horizontalDistance());
        } else {
            super.travel(travelVector);
        }
    }

    protected void playSwimSound(float f) {
        if (this.random.nextInt(2) == 0) {
            this.playSound(this.getSwimSound(), 0.2f, 1.3f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean sit) {
        this.entityData.set(FROM_BUCKET, (Object)sit);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket() || this.isBaby() || this.fedCarrot;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isBaby() && !this.fromBucket() && !this.fedCarrot;
    }

    protected void handleAirSupply(int i) {
        if (this.isAlive() && !this.isInWaterOrBubble()) {
            this.setAirSupply(i - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().dryOut(), this.random.nextInt(2) == 0 ? 1.0f : 0.0f);
            }
        } else {
            this.setAirSupply(2000);
        }
    }

    public int getBabyAge() {
        return (Integer)this.entityData.get(BABY_AGE);
    }

    public void setBabyAge(int babyAge) {
        this.entityData.set(BABY_AGE, (Object)babyAge);
    }

    public float getTriopsScale() {
        return ((Float)this.entityData.get(TRIOPS_SCALE)).floatValue();
    }

    public void setTriopsScale(float scale) {
        this.entityData.set(TRIOPS_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isBaby() {
        return this.getBabyAge() < 0;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putBoolean("FedCarrot", this.fedCarrot);
        compound.putBoolean("Pregnant", this.pregnant);
        compound.putInt("BreedCooldown", this.breedCooldown);
        compound.putFloat("TriopsScale", this.getTriopsScale());
        compound.putInt("BabyAge", this.getBabyAge());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.fedCarrot = compound.getBoolean("FedCarrot");
        this.pregnant = compound.getBoolean("Pregnant");
        this.breedCooldown = compound.getInt("BreedCooldown");
        this.setTriopsScale(compound.getFloat("TriopsScale"));
        this.setBabyAge(compound.getInt("BabyAge"));
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setTriopsScale(0.9f + this.random.nextFloat() * 0.2f);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public void tick() {
        super.tick();
        this.prevOnLandProgress = this.onLandProgress;
        this.prevSwimRot = this.swimRot;
        this.prevTail1Yaw = this.tail1Yaw;
        this.prevTail2Yaw = this.tail2Yaw;
        boolean onLand = !this.isInWaterOrBubble() && this.onGround();
        this.setXRot(-((float)this.getDeltaMovement().y * 2.2f * 57.295776f));
        if (onLand && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (!onLand && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        this.tail1Yaw = Mth.approachDegrees((float)this.tail1Yaw, (float)this.yBodyRot, (float)7.0f);
        this.tail2Yaw = Mth.approachDegrees((float)this.tail2Yaw, (float)this.tail1Yaw, (float)7.0f);
        if (this.onLandProgress == 0.0f) {
            float f = (float)(20.0 * Math.sin(this.walkAnimation.position()) * (double)this.walkAnimation.speed());
            this.swimRot = Mth.approachDegrees((float)this.swimRot, (float)f, (float)2.0f);
        }
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)(this.getY() - this.yo), (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(0.5), this.getY(0.8f), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        } else if (id == 68) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY(0.8f), this.getZ(), 0.0, 0.0, 0.0);
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return (stack.is(AMTagRegistry.TRIOPS_BREEDABLES) || stack.is((Item)AMItemRegistry.MOSQUITO_LARVA.get())) && !this.fedCarrot;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack stack = e.getItem();
        if (stack.has(DataComponents.FOOD) && stack.getItem().getFoodProperties(stack, null) != null) {
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.CAT_EAT, this.getVoicePitch(), this.getSoundVolume());
            this.heal(5.0f);
            if (!this.level().isClientSide && this.breedCooldown == 0 && !this.fedCarrot) {
                this.fedCarrot = true;
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (!type.consumesAction() && this.canTargetItem(itemstack) && !this.fedCarrot) {
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.CAT_EAT, this.getVoicePitch(), this.getSoundVolume());
            this.heal(5.0f);
            if (itemstack.is(AMTagRegistry.TRIOPS_BREEDABLES)) {
                if (!this.level().isClientSide && this.breedCooldown == 0) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)67);
                }
                this.fedCarrot = true;
            }
            return InteractionResult.SUCCESS;
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(type);
    }

    public boolean isSearchingForMate() {
        return this.isAlive() && this.isInWaterOrBubble() && this.fedCarrot && this.breedCooldown <= 0;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        CompoundTag platTag = new CompoundTag();
        this.addAdditionalSaveData(platTag);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.put("TriopsTag", (Tag)platTag);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        if (compound.contains("TriopsTag")) {
            this.readAdditionalSaveData(compound.getCompound("TriopsTag"));
        }
        this.setAirSupply(2000);
    }

    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.TRIOPS_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.TRIOPS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.TRIOPS_HURT.get();
    }

    private class BreedGoal
    extends Goal {
        private final Predicate<Entity> validBreedPartner;
        private EntityTriops breedPartner;
        private int executionCooldown = 50;

        public BreedGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.validBreedPartner = shrimp -> {
                EntityTriops otherFish;
                return shrimp instanceof EntityTriops && (otherFish = (EntityTriops)shrimp).getId() != EntityTriops.this.getId() && otherFish.isSearchingForMate();
            };
        }

        public boolean canUse() {
            if (!EntityTriops.this.isInWaterOrBubble() || !EntityTriops.this.fedCarrot || EntityTriops.this.breedCooldown > 0 || EntityTriops.this.breedWith != null) {
                return false;
            }
            if (this.executionCooldown > 0) {
                --this.executionCooldown;
            } else {
                EntityTriops closestPupfish;
                this.executionCooldown = 50 + EntityTriops.this.random.nextInt(50);
                List list = EntityTriops.this.level().getEntitiesOfClass(EntityTriops.class, EntityTriops.this.getBoundingBox().inflate(10.0, 8.0, 10.0), EntitySelector.NO_SPECTATORS.and(this.validBreedPartner));
                list.sort(Comparator.comparingDouble(arg_0 -> ((EntityTriops)EntityTriops.this).distanceToSqr(arg_0)));
                if (!list.isEmpty() && (closestPupfish = (EntityTriops)list.get(0)) != null) {
                    this.breedPartner = closestPupfish;
                    this.breedPartner.breedWith = EntityTriops.this;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.breedPartner != null && !EntityTriops.this.pregnant && !this.breedPartner.pregnant && EntityTriops.this.breedWith == null && this.breedPartner.isSearchingForMate() && EntityTriops.this.isSearchingForMate();
        }

        public void start() {
        }

        public void stop() {
            EntityTriops.this.fedCarrot = false;
            EntityTriops.this.breedCooldown = 1200 + EntityTriops.this.random.nextInt(3600);
        }

        public void tick() {
            EntityTriops.this.getNavigation().moveTo((Entity)this.breedPartner, 1.0);
            this.breedPartner.getNavigation().moveTo((Entity)EntityTriops.this, 1.0);
            if (EntityTriops.this.distanceTo((Entity)this.breedPartner) < 1.2f) {
                EntityTriops.this.level().broadcastEntityEvent((Entity)EntityTriops.this, (byte)68);
                EntityTriops.this.pregnant = true;
            }
        }
    }

    class LayEggGoal
    extends Goal {
        private BlockPos eggPos;

        LayEggGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public void stop() {
            this.eggPos = null;
        }

        public boolean canUse() {
            BlockPos egg;
            if (EntityTriops.this.pregnant && EntityTriops.this.getRandom().nextInt(30) == 0 && (egg = this.getEggLayPos()) != null) {
                this.eggPos = egg;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.eggPos != null && EntityTriops.this.pregnant && EntityTriops.this.level().getBlockState(this.eggPos).isAir();
        }

        public boolean isValidPos(BlockPos pos) {
            BlockState state = EntityTriops.this.level().getBlockState(pos);
            FluidState stateBelow = EntityTriops.this.level().getFluidState(pos.below());
            return stateBelow.is(FluidTags.WATER) && state.isAir();
        }

        public BlockPos getEggLayPos() {
            for (int i = 0; i < 10; ++i) {
                BlockPos offset = EntityTriops.this.blockPosition().offset(EntityTriops.this.getRandom().nextInt(10) - 5, 10, EntityTriops.this.getRandom().nextInt(10) - 5);
                while (EntityTriops.this.level().getBlockState(offset.below()).isAir() && offset.getY() > EntityTriops.this.level().getMinBuildHeight()) {
                    offset = offset.below();
                }
                if (!this.isValidPos(offset)) continue;
                return offset;
            }
            return null;
        }

        public void tick() {
            super.tick();
            EntityTriops.this.getNavigation().moveTo((double)this.eggPos.getX(), (double)this.eggPos.getY(), (double)this.eggPos.getZ(), 1.0);
            if (EntityTriops.this.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.eggPos)) < 2.0) {
                EntityTriops.this.pregnant = false;
                EntityTriops.this.level().setBlockAndUpdate(this.eggPos, ((Block)AMBlockRegistry.TRIOPS_EGGS.get()).defaultBlockState());
            }
        }
    }
}

