/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAITargetDroppedItems;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityToucan
extends Animal
implements ITargetsDroppedItems {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PECK_TICK = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GOLDEN_TIME = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockState>> SAPLING_STATE = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    private static final EntityDataAccessor<Integer> SAPLING_TIME = SynchedEntityData.defineId(EntityToucan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final HashMap<String, String> FEEDING_DATA = new HashMap();
    private static final List<ItemStack> FEEDING_STACKS = new ArrayList<ItemStack>();
    private static boolean initFeedingData = false;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevPeckProgress;
    public float peckProgress;
    private boolean isLandNavigator;
    private int timeFlying;
    private int heldItemTime;
    private boolean aiItemFlag;

    protected EntityToucan(EntityType type, Level worldIn) {
        super(type, worldIn);
        EntityToucan.initFeedingData();
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
        this.switchNavigator(true);
    }

    public static boolean canToucanSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return true;
    }

    private static void initFeedingData() {
        if (!initFeedingData || FEEDING_DATA.isEmpty()) {
            initFeedingData = true;
            for (String string : AMConfig.toucanFruitMatches) {
                String[] split = string.split("\\|");
                if (split.length < 2) continue;
                FEEDING_DATA.put(split[0], split[1]);
                FEEDING_STACKS.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)split[0]))));
            }
        }
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.TOUCAN_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.TOUCAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.TOUCAN_HURT.get();
    }

    public boolean checkSpawnObstruction(LevelReader p_29005_) {
        if (p_29005_.isUnobstructed((Entity)this) && !p_29005_.containsAnyLiquid(this.getBoundingBox())) {
            BlockPos blockpos = this.blockPosition();
            if (blockpos.getY() < p_29005_.getSeaLevel()) {
                return false;
            }
            BlockState blockstate2 = p_29005_.getBlockState(blockpos.below());
            return blockstate2.is(Blocks.GRASS_BLOCK) || blockstate2.is(BlockTags.LEAVES);
        }
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.toucanSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    @Nullable
    private BlockState getSaplingFor(ItemStack stack) {
        String str;
        Block block;
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (!stack.isEmpty() && name != null && FEEDING_DATA.containsKey(name.toString()) && (block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)(str = FEEDING_DATA.get(name.toString()))))) != null) {
            return block.defaultBlockState();
        }
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (this.getSaplingFor(itemstack) != null && this.getSaplingTime() <= 0 && this.getMainHandItem().isEmpty()) {
            this.peck();
            ItemStack duplicate = itemstack.copy();
            duplicate.setCount(1);
            this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
            this.usePlayerItem(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    protected void registerGoals() {
        super.registerGoals();
        EntityToucan.initFeedingData();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.goalSelector.addGoal(2, (Goal)new AIPlantTrees());
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(FEEDING_STACKS.stream()), false){

            public boolean canUse() {
                return !EntityToucan.this.aiItemFlag && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AIWanderIdle());
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, PathfinderMob.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new FlyingAITargetDroppedItems((PathfinderMob)this, false, false, 15, 16));
    }

    @Override
    public void setItemFlag(boolean itemAIFlag) {
        this.aiItemFlag = itemAIFlag;
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return stack.is(AMTagRegistry.TOUCAN_BREEDABLES);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SAPLING_STATE, Optional.empty());
        builder.define(FLYING, (Object)false);
        builder.define(PECK_TICK, (Object)0);
        builder.define(VARIANT, (Object)0);
        builder.define(GOLDEN_TIME, (Object)0);
        builder.define(SAPLING_TIME, (Object)0);
        builder.define(ENCHANTED, (Object)false);
    }

    public boolean onClimbable() {
        return false;
    }

    public void tick() {
        boolean flying;
        super.tick();
        this.prevFlyProgress = this.flyProgress;
        this.prevPeckProgress = this.peckProgress;
        if (this.getGoldenTime() > 0 && !this.level().isClientSide) {
            this.setGoldenTime(this.getGoldenTime() - 1);
        }
        if (flying = this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (flying) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (flying) {
                this.setNoGravity(true);
                if (this.isFlying() && !this.onGround() && !this.isInWaterOrBubble()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, (double)0.6f, 1.0));
                }
                ++this.timeFlying;
            } else {
                this.setNoGravity(false);
                this.timeFlying = 0;
            }
        }
        if ((Integer)this.entityData.get(PECK_TICK) > 0) {
            this.entityData.set(PECK_TICK, (Object)((Integer)this.entityData.get(PECK_TICK) - 1));
            if (this.peckProgress < 5.0f) {
                this.peckProgress += 1.0f;
            }
        } else if (this.peckProgress > 0.0f) {
            this.peckProgress -= 1.0f;
        }
        if (this.peckProgress >= 5.0f && this.getMainHandItem().isEmpty() && this.getSaplingState() != null) {
            this.peckBlockEffect();
        }
        if (!this.getMainHandItem().isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 10 && this.canTargetItem(this.getMainHandItem())) {
                ItemStack mainHandItem;
                this.heldItemTime = 0;
                this.heal(4.0f);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                if ((mainHandItem = this.getMainHandItem()).is(AMTagRegistry.TOUCAN_GOLDEN_FOODS)) {
                    this.setGoldenTime(12000);
                } else if (mainHandItem.is(AMTagRegistry.TOUCAN_ENCHANTED_GOLDEN_FOODS)) {
                    this.setGoldenTime(-1);
                    this.setEnchanted(true);
                }
                this.setSaplingState(this.getSaplingFor(this.getMainHandItem()));
                this.eatItemEffect(this.getMainHandItem());
                this.getMainHandItem().shrink(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.isFlying() && this.level().getBlockState(this.blockPosition()).is(Blocks.VINE)) {
            float f = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f) * 0.2f), (double)0.4f, (double)(Mth.cos((float)f) * 0.2f)));
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            return;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    @Override
    public void peck() {
        if (this.peckProgress == 0.0f) {
            this.entityData.set(PECK_TICK, (Object)7);
        }
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = 7.0f + radiusAdd + (float)this.getRandom().nextInt(8);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getToucanGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 8 + this.getRandom().nextInt(4);
        int j = this.getRandom().nextInt(6) + 18;
        BlockPos newPos = ground.above(distFromGround > 9 ? flightHeight : j);
        if (this.level().getBlockState(ground).is(BlockTags.LEAVES)) {
            newPos = ground.above(1 + this.getRandom().nextInt(3));
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    public BlockPos getToucanGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() < 320 && !this.level().getFluidState(position).isEmpty()) {
            position = position.above();
        }
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = 10 + this.getRandom().nextInt(15);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getToucanGround(radialPos);
        if (ground.getY() == -64) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -62 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 0.6f, false, true);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        BlockState blockstate = this.getSaplingState();
        if (blockstate != null) {
            compound.put("SaplingState", (Tag)NbtUtils.writeBlockState((BlockState)blockstate));
        }
        compound.putInt("Variant", this.getVariant());
        compound.putInt("GoldenTime", this.getGoldenTime());
        compound.putBoolean("Enchanted", this.isEnchanted());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        BlockState blockstate = null;
        if (compound.contains("SaplingState", 10) && (blockstate = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("SaplingState"))).isAir()) {
            blockstate = null;
        }
        this.setSaplingState(blockstate);
        this.setVariant(compound.getInt("Variant"));
        this.setGoldenTime(compound.getInt("GoldenTime"));
        this.setEnchanted(compound.getBoolean("Enchanted"));
    }

    public boolean isSam() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("sam");
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getSaplingTime() {
        return (Integer)this.entityData.get(SAPLING_TIME);
    }

    public void setSaplingTime(int time) {
        this.entityData.set(SAPLING_TIME, (Object)time);
    }

    public boolean isGolden() {
        return this.getGoldenTime() > 0 || this.getGoldenTime() == -1 || this.isEnchanted();
    }

    public int getGoldenTime() {
        return (Integer)this.entityData.get(GOLDEN_TIME);
    }

    public void setGoldenTime(int goldenTime) {
        this.entityData.set(GOLDEN_TIME, (Object)goldenTime);
    }

    public boolean isEnchanted() {
        return (Boolean)this.entityData.get(ENCHANTED);
    }

    public void setEnchanted(boolean enchanted) {
        this.entityData.set(ENCHANTED, (Object)enchanted);
    }

    @Nullable
    public BlockState getSaplingState() {
        return ((Optional)this.entityData.get(SAPLING_STATE)).orElse(null);
    }

    public void setSaplingState(@Nullable BlockState state) {
        this.entityData.set(SAPLING_STATE, Optional.ofNullable(state));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setVariant(this.getRandom().nextInt(4));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        EntityToucan toucan = (EntityToucan)((EntityType)AMEntityRegistry.TOUCAN.get()).create(this.level());
        toucan.setVariant(this.getVariant());
        return toucan;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos).is(BlockTags.LEAVES) ? 10.0f : super.getWalkTargetValue(pos, worldIn);
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -62 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || this.level().getBlockState(position).is(Blocks.VINE) || position.getY() <= 0;
    }

    private boolean isOverLeaves() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -62 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return this.level().getBlockState(position).is(BlockTags.LEAVES) || this.level().getBlockState(position).is(Blocks.VINE);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return this.getSaplingTime() <= 0 && this.getSaplingFor(stack) != null;
    }

    private void peckBlockEffect() {
        BlockState beneath = this.getBlockStateOn();
        if (this.level().isClientSide && !beneath.isAir() && beneath.getFluidState().isEmpty()) {
            for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                float radius = this.getBbWidth() * 0.65f;
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
                double extraZ = radius * Mth.cos((float)angle);
                BlockParticleOption data = new BlockParticleOption(ParticleTypes.BLOCK, beneath);
                this.level().addParticle((ParticleOptions)data, this.getX() + extraX, this.getY() + (double)0.1f, this.getZ() + extraZ, d0, d1, d2);
            }
        }
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        for (int i = 0; i < 2 + this.random.nextInt(2); ++i) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            float radius = this.getBbWidth() * 0.65f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, heldItemMainhand);
            if (heldItemMainhand.getItem() instanceof BlockItem) {
                data = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)heldItemMainhand.getItem()).getBlock().defaultBlockState());
            }
            this.level().addParticle((ParticleOptions)data, this.getX() + extraX, this.getY() + (double)(this.getBbHeight() * 0.6f), this.getZ() + extraZ, d0, d1, d2);
        }
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.peck();
        this.setFlying(true);
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
    }

    private boolean hasLineOfSightSapling(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 blockVec = Vec3.atCenterOf((Vec3i)destinationBlock);
        BlockHitResult result = this.level().clip(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.getBlockPos().equals((Object)destinationBlock);
    }

    private class AIPlantTrees
    extends Goal {
        protected final EntityToucan toucan;
        protected BlockPos pos;
        private int runCooldown = 0;
        private int encircleTime = 0;
        private int plantTime = 0;
        private boolean clockwise;

        public AIPlantTrees() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.toucan = EntityToucan.this;
        }

        public boolean canUse() {
            if (this.toucan.getSaplingState() != null && this.runCooldown-- <= 0) {
                BlockPos target = this.getSaplingPlantPos();
                this.runCooldown = this.resetCooldown();
                if (target != null) {
                    this.pos = target;
                    this.clockwise = EntityToucan.this.random.nextBoolean();
                    this.encircleTime = (this.toucan.isGolden() ? 20 : 100) + EntityToucan.this.random.nextInt(100);
                    return true;
                }
            }
            return false;
        }

        private int resetCooldown() {
            return this.toucan.isGolden() && !this.toucan.isEnchanted() ? 50 + EntityToucan.this.random.nextInt(40) : 200 + EntityToucan.this.random.nextInt(200);
        }

        public void tick() {
            this.toucan.aiItemFlag = true;
            double up = 3.0;
            if (this.encircleTime > 0) {
                --this.encircleTime;
            }
            if (this.isWithinXZDist(this.pos, this.toucan.position(), 5.0) && this.encircleTime <= 0) {
                up = 0.0;
            }
            if (this.toucan.distanceToSqr(Vec3.atCenterOf((Vec3i)this.pos)) < 3.0) {
                this.toucan.setFlying(false);
                this.toucan.peck();
                ++this.plantTime;
                if (this.plantTime > 60) {
                    BlockState state = this.toucan.getSaplingState();
                    if (state != null && state.canSurvive((LevelReader)this.toucan.level(), this.pos) && this.toucan.level().getBlockState(this.pos).canBeReplaced()) {
                        this.toucan.level().setBlockAndUpdate(this.pos, state);
                        if (!this.toucan.isEnchanted()) {
                            this.toucan.setSaplingState(null);
                        }
                    }
                    this.stop();
                }
            } else {
                BlockPos moveTo = this.pos;
                if (this.encircleTime > 0) {
                    moveTo = this.getVultureCirclePos(this.pos, 3.0f, up);
                }
                if (moveTo != null) {
                    if (this.encircleTime <= 0 && !this.toucan.hasLineOfSightSapling(this.pos)) {
                        this.toucan.setFlying(false);
                        this.toucan.getNavigation().moveTo((double)((float)moveTo.getX() + 0.5f), (double)moveTo.getY() + up + 0.5, (double)((float)moveTo.getZ() + 0.5f), 1.0);
                    } else {
                        this.toucan.setFlying(true);
                        this.toucan.getMoveControl().setWantedPosition((double)((float)moveTo.getX() + 0.5f), (double)moveTo.getY() + up + 0.5, (double)((float)moveTo.getZ() + 0.5f), 1.0);
                    }
                }
            }
        }

        public BlockPos getVultureCirclePos(BlockPos target, float circleDistance, double yLevel) {
            float angle = 0.13962634f * (float)(this.clockwise ? -this.encircleTime : this.encircleTime);
            double extraX = circleDistance * Mth.sin((float)angle);
            double extraZ = circleDistance * Mth.cos((float)angle);
            BlockPos pos = new BlockPos((int)((double)((float)target.getX() + 0.5f) + extraX), (int)((double)(target.getY() + 1) + yLevel), (int)((double)((float)target.getZ() + 0.5f) + extraZ));
            if (this.toucan.level().isEmptyBlock(pos)) {
                return pos;
            }
            return null;
        }

        public void stop() {
            this.toucan.aiItemFlag = false;
            this.pos = null;
            this.plantTime = 0;
            this.encircleTime = 0;
        }

        public boolean canContinueToUse() {
            return this.pos != null && this.toucan.getSaplingState() != null;
        }

        private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
            return blockpos.distSqr((Vec3i)new BlockPos((int)positionVec.x(), blockpos.getY(), (int)positionVec.z())) < distance * distance;
        }

        private BlockPos getSaplingPlantPos() {
            BlockState state = this.toucan.getSaplingState();
            if (state != null) {
                for (int i = 0; i < 15; ++i) {
                    BlockPos pos = this.toucan.blockPosition().offset(EntityToucan.this.random.nextInt(10) - 8, EntityToucan.this.random.nextInt(8) - 4, EntityToucan.this.random.nextInt(16) - 8);
                    if (!state.canSurvive((LevelReader)this.toucan.level(), pos) || !this.toucan.level().isEmptyBlock(pos.above()) || !this.toucan.hasLineOfSightSapling(pos)) continue;
                    return pos;
                }
            }
            return null;
        }
    }

    private class AIWanderIdle
    extends Goal {
        protected final EntityToucan toucan;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWanderIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.toucan = EntityToucan.this;
        }

        public boolean canUse() {
            if (this.toucan.isVehicle() || this.toucan.getSaplingState() != null || EntityToucan.this.aiItemFlag || this.toucan.getTarget() != null && this.toucan.getTarget().isAlive() || this.toucan.isPassenger()) {
                return false;
            }
            if (this.toucan.getRandom().nextInt(45) != 0 && !this.toucan.isFlying()) {
                return false;
            }
            this.flightTarget = this.toucan.onGround() ? EntityToucan.this.random.nextInt(6) == 0 : EntityToucan.this.random.nextInt(5) != 0 && this.toucan.timeFlying < 200;
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.toucan.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.toucan.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityToucan.this.isFlying() && this.toucan.onGround()) {
                this.toucan.setFlying(false);
            }
            if (EntityToucan.this.isFlying() && this.toucan.onGround() && this.toucan.timeFlying > 10) {
                this.toucan.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.toucan.position();
            if (this.toucan.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.toucan.timeFlying > 50 && this.toucan.isOverLeaves() && !this.toucan.onGround()) {
                    return this.toucan.getBlockGrounding(vector3d);
                }
                if (this.toucan.timeFlying < 200 || this.toucan.isOverWaterOrVoid()) {
                    return this.toucan.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.toucan.getBlockGrounding(vector3d);
            }
            if (!this.toucan.onGround()) {
                return this.toucan.getBlockGrounding(vector3d);
            }
            if (this.toucan.isOverLeaves()) {
                for (int i = 0; i < 15; ++i) {
                    BlockPos pos = this.toucan.blockPosition().offset(EntityToucan.this.random.nextInt(16) - 8, EntityToucan.this.random.nextInt(8) - 4, EntityToucan.this.random.nextInt(16) - 8);
                    if (this.toucan.level().getBlockState(pos.above()).isSolid() || !this.toucan.level().getBlockState(pos).isSolid() || !(this.toucan.getWalkTargetValue(pos) >= 0.0f)) continue;
                    return Vec3.atBottomCenterOf((Vec3i)pos);
                }
            }
            return LandRandomPos.getPos((PathfinderMob)this.toucan, (int)16, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.toucan.aiItemFlag) {
                return false;
            }
            if (this.flightTarget) {
                return this.toucan.isFlying() && this.toucan.distanceToSqr(this.x, this.y, this.z) > 2.0;
            }
            return !this.toucan.getNavigation().isDone() && !this.toucan.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.toucan.setFlying(true);
                this.toucan.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.toucan.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.toucan.getNavigation().stop();
            super.stop();
        }
    }
}

