/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityTossedItem
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> DART = SynchedEntityData.defineId(EntityTossedItem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public EntityTossedItem(EntityType p_i50154_1_, Level p_i50154_2_) {
        super(p_i50154_1_, p_i50154_2_);
    }

    public EntityTossedItem(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)AMEntityRegistry.TOSSED_ITEM.get(), worldIn);
        this.setOwner((Entity)throwerIn);
        this.setPos(throwerIn.getX(), throwerIn.getEyeY() - 0.1, throwerIn.getZ());
    }

    public EntityTossedItem(Level worldIn, double x, double y, double z) {
        super((EntityType)AMEntityRegistry.TOSSED_ITEM.get(), worldIn);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DART, (Object)false);
    }

    public boolean isDart() {
        return (Boolean)this.entityData.get(DART);
    }

    public void setDart(boolean dart) {
        this.entityData.set(DART, (Object)dart);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)(x * x + z * z)));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public void tick() {
        super.tick();
        Vec3 vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
        this.setXRot(EntityTossedItem.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875)));
        this.setYRot(EntityTossedItem.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        EntityCapuchinMonkey boss;
        super.onHitEntity(p_213868_1_);
        if (this.getOwner() instanceof EntityCapuchinMonkey && (!(boss = (EntityCapuchinMonkey)this.getOwner()).isAlliedTo(p_213868_1_.getEntity()) || !boss.isTame() && !(p_213868_1_.getEntity() instanceof EntityCapuchinMonkey))) {
            p_213868_1_.getEntity().hurt(this.damageSources().thrown((Entity)this, (Entity)boss), this.isDart() ? 8.0f : 4.0f);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("Dart", this.isDart());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setDart(compound.getBoolean("Dart"));
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!(this.level().isClientSide || this.isDart() && result.getType() != HitResult.Type.BLOCK)) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected Item getDefaultItem() {
        if (this.entityData != null && this.isDart()) {
            return (Item)AMItemRegistry.ANCIENT_DART.get();
        }
        return Items.COBBLESTONE;
    }
}

