/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockTerrapinEgg;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.entity.util.TerrapinTypes;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityTerrapinEgg;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityTerrapin
extends Animal
implements ISemiAquatic,
Bucketable {
    private static final EntityDataAccessor<Integer> TURTLE_TYPE = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHELL_TYPE = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SKIN_TYPE = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TURTLE_COLOR = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHELL_COLOR = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SKIN_COLOR = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> RETREATED = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityTerrapin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float clientSpin = 0.0f;
    public int spinCounter = 0;
    public float prevSwimProgress;
    public float swimProgress;
    public float prevRetreatProgress;
    public float retreatProgress;
    public float prevSpinProgress;
    public float spinProgress;
    private int maxRollTime = 50;
    private boolean isLandNavigator;
    private int swimTimer = -1000;
    private int hideInShellTimer = 0;
    private Vec3 spinDelta;
    private float spinYRot;
    private int changeSpinAngleCooldown = 0;
    private LivingEntity lastLauncher = null;
    private TileEntityTerrapinEgg.ParentData partnerData;

    protected EntityTerrapin(EntityType animal, Level level) {
        super(animal, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.switchNavigator(true);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ARMOR, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.TERRAPIN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.TERRAPIN_HURT.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.terrapinSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canTerrapinSpawn(EntityType<EntityTerrapin> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.getBlockState(pos).getFluidState().is((Fluid)Fluids.WATER);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new MateGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new LayEggGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.TERRAPIN_BREEDABLES), false));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new SemiAquaticAIRandomSwimming(this, 1.0, 30));
        this.goalSelector.addGoal(6, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 60));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public void tick() {
        super.tick();
        this.prevSwimProgress = this.swimProgress;
        this.prevRetreatProgress = this.retreatProgress;
        this.prevSpinProgress = this.spinProgress;
        boolean inWaterOrBubble = this.isInWaterOrBubble();
        boolean spinning = this.isSpinning();
        boolean retreated = this.hasRetreated();
        if (inWaterOrBubble) {
            if (this.swimProgress < 5.0f) {
                this.swimProgress += 1.0f;
            }
        } else if (this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (spinning) {
            if (this.spinProgress < 5.0f) {
                this.spinProgress += 1.0f;
            }
        } else if (this.spinProgress > 0.0f) {
            this.spinProgress -= 1.0f;
        }
        if (retreated) {
            if (this.retreatProgress < 5.0f) {
                this.retreatProgress += 1.0f;
            }
        } else if (this.retreatProgress > 0.0f) {
            this.retreatProgress -= 1.0f;
        }
        if (spinning) {
            this.handleSpin();
            if (this.isAlive() && this.spinCounter > 5 && !this.isBaby()) {
                for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)0.3f))) {
                    if (this.isAlliedTo(entity) || entity instanceof EntityTerrapin) continue;
                    entity.hurt(this.damageSources().mobAttack((LivingEntity)(this.lastLauncher == null ? this : this.lastLauncher)), 4.0f + this.random.nextFloat() * 4.0f);
                }
            }
            if (!this.isAlive()) {
                this.setSpinning(false);
            }
            if (this.horizontalCollision) {
                if (this.changeSpinAngleCooldown == 0) {
                    this.changeSpinAngleCooldown = 10;
                    float f = this.collideDirectionAndSound().getAxis() == Direction.Axis.X ? this.spinYRot - 180.0f : 180.0f - this.spinYRot;
                    this.setYRot(f += (float)(this.random.nextInt(40) - 20));
                    this.copySpinDelta(f, Vec3.ZERO);
                } else {
                    this.maxRollTime -= 30;
                }
            }
            if (this.changeSpinAngleCooldown > 0) {
                --this.changeSpinAngleCooldown;
            }
        }
        if (!this.level().isClientSide) {
            if (this.isInWaterOrBubble() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isInWaterOrBubble() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isInWater()) {
                this.swimTimer = Math.max(0, this.swimTimer + 1);
            } else {
                this.swimTimer = Math.min(0, this.swimTimer - 1);
                List list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(0.0, (double)0.15f, 0.0));
                for (Player player : list) {
                    int spin;
                    if (!(player.getDeltaMovement().y > 0.0) && player.onGround() || !(player.getY() > this.getEyeY())) continue;
                    if (!this.hasRetreated()) {
                        this.hideInShellTimer += 40 + this.random.nextInt(40);
                        continue;
                    }
                    if (this.isSpinning()) continue;
                    this.lastLauncher = player;
                    this.hideInShellTimer = spin = 100 + this.random.nextInt(100);
                    this.setYRot(player.getYHeadRot());
                    this.spinFor(spin);
                }
            }
            if (this.swimProgress > 0.0f) {
                // empty if block
            }
            if (this.hideInShellTimer > 0) {
                --this.hideInShellTimer;
            }
            this.setRetreated(this.hideInShellTimer > 0 && !this.isSpinning());
        }
    }

    private Direction collideDirectionAndSound() {
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> false);
        if (raytraceresult instanceof BlockHitResult) {
            BlockState state = this.level().getBlockState(((BlockHitResult)raytraceresult).getBlockPos());
            if (state == null || !this.isSilent()) {
                // empty if block
            }
            return ((BlockHitResult)raytraceresult).getDirection();
        }
        return Direction.DOWN;
    }

    private boolean isMoving() {
        return this.getDeltaMovement().lengthSqr() > 0.02;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new AnimalSwimMoveControllerSink((PathfinderMob)this, 2.5f, 1.15f);
            this.navigation = new SemiAquaticPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TURTLE_TYPE, (Object)0);
        builder.define(SHELL_TYPE, (Object)0);
        builder.define(SKIN_TYPE, (Object)0);
        builder.define(SHELL_COLOR, (Object)0);
        builder.define(SKIN_COLOR, (Object)0);
        builder.define(TURTLE_COLOR, (Object)0);
        builder.define(RETREATED, (Object)false);
        builder.define(SPINNING, (Object)false);
        builder.define(HAS_EGG, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("TurtleType", this.getTurtleTypeOrdinal());
        compound.putInt("ShellType", this.getShellType());
        compound.putInt("SkinType", this.getSkinType());
        compound.putInt("TurtleColor", this.getTurtleColor());
        compound.putInt("ShellColor", this.getShellColor());
        compound.putInt("SkinColor", this.getSkinColor());
        compound.putBoolean("HasEgg", this.hasEgg());
        compound.putBoolean("Bucketed", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTurtleTypeOrdinal(compound.getInt("TurtleType"));
        this.setShellType(compound.getInt("ShellType"));
        this.setSkinType(compound.getInt("SkinType"));
        this.setTurtleColor(compound.getInt("TurtleColor"));
        this.setShellColor(compound.getInt("ShellColor"));
        this.setSkinColor(compound.getInt("SkinColor"));
        this.setHasEgg(compound.getBoolean("HasEgg"));
        this.setFromBucket(compound.getBoolean("Bucketed"));
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!this.isSpinning()) {
            super.playStepSound(pos, state);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.TERRAPIN_BREEDABLES);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.entityData.set(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket() || this.hasCustomName();
    }

    public boolean removeWhenFarAway(double d) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    private int getTurtleTypeOrdinal() {
        return Mth.clamp((int)((Integer)this.entityData.get(TURTLE_TYPE)), (int)0, (int)(TerrapinTypes.values().length - 1));
    }

    private void setTurtleTypeOrdinal(int i) {
        this.entityData.set(TURTLE_TYPE, (Object)i);
    }

    public int getShellType() {
        return (Integer)this.entityData.get(SHELL_TYPE);
    }

    public void setShellType(int i) {
        this.entityData.set(SHELL_TYPE, (Object)i);
    }

    public int getSkinType() {
        return (Integer)this.entityData.get(SKIN_TYPE);
    }

    public void setSkinType(int i) {
        this.entityData.set(SKIN_TYPE, (Object)i);
    }

    public int getShellColor() {
        return (Integer)this.entityData.get(SHELL_COLOR);
    }

    public void setShellColor(int i) {
        this.entityData.set(SHELL_COLOR, (Object)i);
    }

    public int getSkinColor() {
        return (Integer)this.entityData.get(SKIN_COLOR);
    }

    public void setSkinColor(int i) {
        this.entityData.set(SKIN_COLOR, (Object)i);
    }

    public int getTurtleColor() {
        return (Integer)this.entityData.get(TURTLE_COLOR);
    }

    public void setTurtleColor(int i) {
        this.entityData.set(TURTLE_COLOR, (Object)i);
    }

    public TerrapinTypes getTurtleType() {
        return TerrapinTypes.values()[this.getTurtleTypeOrdinal()];
    }

    public void setTurtleType(TerrapinTypes type) {
        this.setTurtleTypeOrdinal(type.ordinal());
    }

    public boolean isSpinning() {
        return (Boolean)this.entityData.get(SPINNING);
    }

    public void setSpinning(boolean b) {
        this.entityData.set(SPINNING, (Object)b);
    }

    public boolean hasRetreated() {
        return (Boolean)this.entityData.get(RETREATED);
    }

    public void setRetreated(boolean b) {
        this.entityData.set(RETREATED, (Object)b);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    public void push(Entity entity) {
        if (this.isInWaterOrBubble() || entity instanceof EntityTerrapin) {
            super.push(entity);
        } else {
            entity.setDeltaMovement(entity.getDeltaMovement().add(this.getDeltaMovement()));
        }
    }

    public boolean canBeCollidedWith() {
        return this.isInWaterOrBubble() ? super.canBeCollidedWith() : this.isAlive();
    }

    private void spinFor(int time) {
        this.maxRollTime = time;
        this.setSpinning(true);
    }

    private void copySpinDelta(float spinRot, Vec3 motionIn) {
        float f = spinRot * ((float)Math.PI / 180);
        float f1 = this.isBaby() ? 0.3f : 0.5f;
        this.spinYRot = spinRot;
        this.spinDelta = new Vec3(motionIn.x + (double)(-Mth.sin((float)f) * f1), 0.0, motionIn.z + (double)(Mth.cos((float)f) * f1));
        this.setDeltaMovement(this.spinDelta.add(0.0, 0.0, 0.0));
    }

    private void handleSpin() {
        this.setRetreated(true);
        ++this.spinCounter;
        if (!this.level().isClientSide) {
            if (this.spinCounter > this.maxRollTime) {
                this.setSpinning(false);
                this.hideInShellTimer = 10 + this.random.nextInt(30);
                this.spinCounter = 0;
            } else {
                Vec3 vec3 = this.getDeltaMovement();
                if (this.spinCounter == 1) {
                    this.copySpinDelta(this.getYRot(), vec3);
                } else {
                    this.setYRot(this.spinYRot);
                    this.setYHeadRot(this.spinYRot);
                    this.setYBodyRot(this.spinYRot);
                    this.setDeltaMovement(this.spinDelta.x, vec3.y, this.spinDelta.z);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setAirSupply(this.getMaxAirSupply());
        this.setTurtleType(TerrapinTypes.getRandomType(this.random));
        this.setShellType(this.random.nextInt(7));
        this.setSkinType(this.random.nextInt(4));
        this.setTurtleColor(TerrapinTypes.generateRandomColor(this.random));
        this.setShellColor(TerrapinTypes.generateRandomColor(this.random));
        this.setSkinColor(TerrapinTypes.generateRandomColor(this.random));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.TERRAPIN.get()).create((Level)p_146743_);
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isSpinning() || this.hasRetreated();
    }

    @Override
    public boolean shouldEnterWater() {
        return this.getTarget() == null && !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.swimTimer > 600 || this.hasEgg();
    }

    @Override
    public int getWaterSearchRange() {
        return 10;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 travelVector) {
        if (this.shouldStopMoving()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            travelVector = Vec3.ZERO;
            super.travel(travelVector);
            return;
        }
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.TERRAPIN_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        CompoundTag platTag = new CompoundTag();
        this.addAdditionalSaveData(platTag);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.put("TerrapinData", (Tag)platTag);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        if (compound.contains("TerrapinData")) {
            this.readAdditionalSaveData(compound.getCompound("TerrapinData"));
        }
    }

    @Nonnull
    public InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(AMTagRegistry.TERRAPIN_BREEDABLES)) {
            this.setPersistenceRequired();
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)0.0, (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * (this.isSpinning() ? 4.0f : 32.0f), 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    public boolean isKoopa() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("koopa");
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    static class MateGoal
    extends BreedGoal {
        private final EntityTerrapin turtle;

        MateGoal(EntityTerrapin turtle, double speedIn) {
            super((Animal)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean canUse() {
            return super.canUse() && !this.turtle.hasEgg();
        }

        protected void breed() {
            Animal animal;
            ServerPlayer serverplayerentity = this.animal.getLoveCause();
            if (serverplayerentity == null && this.partner.getLoveCause() != null) {
                serverplayerentity = this.partner.getLoveCause();
            }
            if (serverplayerentity != null) {
                serverplayerentity.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, this.animal, this.partner, (AgeableMob)this.animal);
            }
            if ((animal = this.partner) instanceof EntityTerrapin) {
                EntityTerrapin terrapin = (EntityTerrapin)animal;
                this.turtle.partnerData = new TileEntityTerrapinEgg.ParentData(terrapin.getTurtleType(), terrapin.getShellType(), terrapin.getSkinType(), terrapin.getTurtleColor(), terrapin.getShellColor(), terrapin.getSkinColor());
            }
            this.turtle.setHasEgg(true);
            this.animal.resetLove();
            this.partner.resetLove();
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            RandomSource random = this.animal.getRandom();
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.level.addFreshEntity((Entity)new ExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final EntityTerrapin turtle;
        private int digTime;

        LayEggGoal(EntityTerrapin turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public void stop() {
            this.digTime = 0;
        }

        public boolean canUse() {
            return this.turtle.hasEgg() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.hasEgg();
        }

        public double acceptedDistance() {
            return (double)this.turtle.getBbWidth() + 0.5;
        }

        public void tick() {
            super.tick();
            BlockPos blockpos = this.turtle.blockPosition();
            this.turtle.swimTimer = 1000;
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                Level world = this.turtle.level();
                this.turtle.gameEvent((Holder)GameEvent.BLOCK_PLACE);
                world.playSound(null, blockpos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
                world.setBlock(this.blockPos.above(), (BlockState)((Block)AMBlockRegistry.TERRAPIN_EGG.get()).defaultBlockState().setValue((Property)BlockTerrapinEgg.EGGS, (Comparable)Integer.valueOf(this.turtle.random.nextInt(1) + 3)), 3);
                BlockEntity blockEntity = world.getBlockEntity(this.blockPos.above());
                if (blockEntity instanceof TileEntityTerrapinEgg) {
                    TileEntityTerrapinEgg eggTe = (TileEntityTerrapinEgg)blockEntity;
                    eggTe.parent1 = new TileEntityTerrapinEgg.ParentData(this.turtle.getTurtleType(), this.turtle.getShellType(), this.turtle.getSkinType(), this.turtle.getTurtleColor(), this.turtle.getShellColor(), this.turtle.getSkinColor());
                    eggTe.parent2 = this.turtle.partnerData == null ? eggTe.parent1 : this.turtle.partnerData;
                }
                this.turtle.setHasEgg(false);
                this.turtle.setInLoveTime(600);
            }
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            return worldIn.isEmptyBlock(pos.above()) && BlockTerrapinEgg.isProperHabitat((BlockGetter)worldIn, pos);
        }
    }
}

