/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.util.TendonWhipUtil;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityTendonSegment
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_ID = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> FROM_ID = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_COUNT = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CURRENT_TARGET_ID = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> PROGRESS = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> RETRACTING = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_CLAW = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_GLINT = SynchedEntityData.defineId(EntityTendonSegment.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private List<Entity> previouslyTouched = new ArrayList<Entity>();
    private boolean hasTouched = false;
    private boolean hasChained = false;
    public float prevProgress = 0.0f;
    public static final float MAX_EXTEND_TIME = 3.0f;

    public EntityTendonSegment(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CREATOR_ID, Optional.empty());
        builder.define(FROM_ID, (Object)-1);
        builder.define(TARGET_COUNT, (Object)0);
        builder.define(CURRENT_TARGET_ID, (Object)-1);
        builder.define(PROGRESS, (Object)Float.valueOf(0.0f));
        builder.define(DAMAGE, (Object)Float.valueOf(5.0f));
        builder.define(RETRACTING, (Object)false);
        builder.define(HAS_CLAW, (Object)true);
        builder.define(HAS_GLINT, (Object)false);
    }

    public void tick() {
        float progress;
        this.prevProgress = progress = this.getProgress();
        if (this.tickCount < 1) {
            this.onJoinWorld();
        } else if (this.tickCount == 1 && !this.level().isClientSide) {
            this.playSound((SoundEvent)AMSoundRegistry.TENDON_WHIP.get(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
        super.tick();
        Entity creator = this.getCreatorEntity();
        Entity current = this.getToEntity();
        if (progress < 3.0f && !this.isRetracting()) {
            this.setProgress(progress + 1.0f);
        }
        if (progress > 0.0f && this.isRetracting()) {
            this.setProgress(progress - 1.0f);
        }
        if (progress == 0.0f && this.isRetracting()) {
            Entity from = this.getFromEntity();
            if (from instanceof EntityTendonSegment) {
                EntityTendonSegment tendonSegment = (EntityTendonSegment)from;
                tendonSegment.setRetracting(true);
                this.updateLastTendon(tendonSegment);
            } else {
                this.updateLastTendon(null);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (creator instanceof LivingEntity && current != null) {
            Vec3 target = new Vec3(current.getX(), current.getY((double)0.4f), current.getZ());
            Vec3 lerp = target.subtract(this.position());
            this.setDeltaMovement(lerp.scale(0.5));
            if (!this.level().isClientSide && !this.hasTouched && progress >= 3.0f) {
                this.hasTouched = true;
                Entity entity = this.getCreatorEntity();
                if (!(entity instanceof LivingEntity) || current == creator || current.hurt(this.damageSources().mobProjectile((Entity)this, (LivingEntity)entity), (float)this.getDamageFor((LivingEntity)creator, (LivingEntity)entity))) {
                    // empty if block
                }
            }
        }
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.level().isClientSide && !this.hasChained) {
            if (this.getTargetsHit() > 3) {
                this.setRetracting(true);
            } else if (creator instanceof LivingEntity && this.getProgress() >= 3.0f) {
                Entity closestValid = null;
                for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(8.0))) {
                    if (entity.equals((Object)creator) || this.previouslyTouched.contains(entity) || !this.isValidTarget((LivingEntity)creator, entity) || !this.hasLineOfSight(entity) || closestValid != null && !(this.distanceTo(entity) < this.distanceTo(closestValid))) continue;
                    closestValid = entity;
                }
                if (closestValid != null) {
                    this.createChain(closestValid);
                    this.hasChained = true;
                } else {
                    this.setRetracting(true);
                }
            }
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        this.setDeltaMovement(vector3d.scale((double)0.99f));
        this.setPos(d0, d1, d2);
    }

    private boolean isValidTarget(LivingEntity creator, Entity entity) {
        if (!creator.isAlliedTo(entity) && !entity.isAlliedTo((Entity)creator) && entity instanceof Mob) {
            return true;
        }
        return creator.getLastHurtMob() != null && creator.getLastHurtMob().getUUID().equals(entity.getUUID()) || creator.getLastHurtByMob() != null && creator.getLastHurtByMob().getUUID().equals(entity.getUUID());
    }

    private double getDamageFor(LivingEntity creator, LivingEntity entity) {
        ItemStack stack = creator.getItemInHand(InteractionHand.MAIN_HAND).is((Item)AMItemRegistry.TENDON_WHIP.get()) ? creator.getItemInHand(InteractionHand.MAIN_HAND) : creator.getItemInHand(InteractionHand.OFF_HAND);
        double dmg = this.getBaseDamage();
        if (stack.is((Item)AMItemRegistry.TENDON_WHIP.get())) {
            // empty if block
        }
        return dmg;
    }

    private double getDamageForItem(ItemStack itemStack) {
        ItemAttributeModifiers modifiers = itemStack.getAttributeModifiers();
        if (modifiers != null && !modifiers.modifiers().isEmpty()) {
            double d = 0.0;
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                if (entry.attribute().value() != Attributes.ATTACK_DAMAGE) continue;
                d += entry.modifier().amount();
            }
            return d;
        }
        return 0.0;
    }

    private boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    private void updateLastTendon(EntityTendonSegment lastTendon) {
        Entity creator = this.getCreatorEntity();
        if (creator == null) {
            creator = this.level().getPlayerByUUID(this.getCreatorEntityUUID());
        }
        if (creator instanceof LivingEntity) {
            TendonWhipUtil.setLastTendon((LivingEntity)creator, lastTendon);
        }
    }

    private void createChain(Entity closestValid) {
        this.entityData.set(HAS_CLAW, (Object)false);
        EntityTendonSegment child = (EntityTendonSegment)((EntityType)AMEntityRegistry.TENDON_SEGMENT.get()).create(this.level());
        child.previouslyTouched = new ArrayList<Entity>(this.previouslyTouched);
        child.previouslyTouched.add(closestValid);
        child.setCreatorEntityUUID(this.getCreatorEntityUUID());
        child.setFromEntityID(this.getId());
        child.setToEntityID(closestValid.getId());
        child.setPos(closestValid.getX(), closestValid.getY((double)0.4f), closestValid.getZ());
        child.setTargetsHit(this.getTargetsHit() + 1);
        this.updateLastTendon(child);
        child.setHasGlint(this.hasGlint());
        this.level().addFreshEntity((Entity)child);
    }

    private void onJoinWorld() {
        Entity creator = this.getCreatorEntity();
        if (creator == null) {
            creator = this.level().getPlayerByUUID(this.getCreatorEntityUUID());
        }
        Entity prior = this.getFromEntity();
        if (creator instanceof Player) {
            ItemStack stack;
            Player player = (Player)creator;
            ItemStack itemStack = stack = player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)AMItemRegistry.TENDON_WHIP.get()) ? player.getItemInHand(InteractionHand.MAIN_HAND) : player.getItemInHand(InteractionHand.OFF_HAND);
            if (stack.is((Item)AMItemRegistry.TENDON_WHIP.get())) {
                this.setHasGlint(stack.hasFoil());
            }
            float dmg = 2.0f;
            dmg = prior instanceof EntityTendonSegment ? Math.max(((EntityTendonSegment)prior).getBaseDamage() - 1.0f, 2.0f) : (float)this.getDamageForItem(stack);
            this.entityData.set(DAMAGE, (Object)Float.valueOf(dmg));
        }
    }

    private float getBaseDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public UUID getCreatorEntityUUID() {
        return ((Optional)this.entityData.get(CREATOR_ID)).orElse(null);
    }

    public void setCreatorEntityUUID(UUID id) {
        this.entityData.set(CREATOR_ID, Optional.ofNullable(id));
    }

    public Entity getCreatorEntity() {
        UUID uuid = this.getCreatorEntityUUID();
        if (uuid != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(uuid);
        }
        return null;
    }

    public int getFromEntityID() {
        return (Integer)this.entityData.get(FROM_ID);
    }

    public void setFromEntityID(int id) {
        this.entityData.set(FROM_ID, (Object)id);
    }

    public Entity getFromEntity() {
        return this.getFromEntityID() == -1 ? null : this.level().getEntity(this.getFromEntityID());
    }

    public int getToEntityID() {
        return (Integer)this.entityData.get(CURRENT_TARGET_ID);
    }

    public void setToEntityID(int id) {
        this.entityData.set(CURRENT_TARGET_ID, (Object)id);
    }

    public Entity getToEntity() {
        return this.getToEntityID() == -1 ? null : this.level().getEntity(this.getToEntityID());
    }

    public int getTargetsHit() {
        return (Integer)this.entityData.get(TARGET_COUNT);
    }

    public void setTargetsHit(int i) {
        this.entityData.set(TARGET_COUNT, (Object)i);
    }

    public float getProgress() {
        return ((Float)this.entityData.get(PROGRESS)).floatValue();
    }

    public void setProgress(float progress) {
        this.entityData.set(PROGRESS, (Object)Float.valueOf(progress));
    }

    public boolean isRetracting() {
        return (Boolean)this.entityData.get(RETRACTING);
    }

    public void setRetracting(boolean retract) {
        this.entityData.set(RETRACTING, (Object)retract);
    }

    public boolean hasGlint() {
        return (Boolean)this.entityData.get(HAS_GLINT);
    }

    public void setHasGlint(boolean glint) {
        this.entityData.set(HAS_GLINT, (Object)glint);
    }

    public boolean hasClaw() {
        return (Boolean)this.entityData.get(HAS_CLAW);
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
    }

    public boolean isCreator(Entity mob) {
        return this.getCreatorEntityUUID() != null && mob.getUUID().equals(this.getCreatorEntityUUID());
    }
}

