/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EntityTasmanianDevil
extends Animal
implements IAnimatedEntity,
ITargetsDroppedItems {
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_HOWL = Animation.create((int)40);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)8);
    private static final EntityDataAccessor<Boolean> BASKING = SynchedEntityData.defineId(EntityTasmanianDevil.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityTasmanianDevil.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevBaskProgress;
    public float prevSitProgress;
    public float baskProgress;
    public float sitProgress;
    private int sittingTime;
    private int maxSitTime;
    private int scareMobsTime = 0;

    protected EntityTasmanianDevil(EntityType type, Level world) {
        super(type, world);
    }

    public boolean shouldMove() {
        return !this.isSitting() && !this.isBasking();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.TASMANIAN_DEVIL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.TASMANIAN_DEVIL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.TASMANIAN_DEVIL_HURT.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.TASMANIAN_DEVIL_HOWLING_FOODS), false){

            public void tick() {
                super.tick();
                if (EntityTasmanianDevil.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    EntityTasmanianDevil.this.setBasking(false);
                    EntityTasmanianDevil.this.setSitting(false);
                }
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 60));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityTasmanianDevil.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 120, false, false, p_213487_0_ -> p_213487_0_ instanceof Chicken || p_213487_0_ instanceof Rabbit));
        this.targetSelector.addGoal(3, new CreatureAITargetItems((PathfinderMob)this, false, 30));
    }

    public void killed(ServerLevel world, LivingEntity entity) {
        if (this.getRandom().nextBoolean() && (entity instanceof Animal || entity.getType().is(EntityTypeTags.ARTHROPOD))) {
            entity.spawnAtLocation(new ItemStack((ItemLike)Items.BONE));
        }
    }

    public void travel(Vec3 vec3d) {
        if (!this.shouldMove()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public void setSitting(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BASKING, (Object)false);
        builder.define(SITTING, (Object)false);
    }

    public boolean isBasking() {
        return (Boolean)this.entityData.get(BASKING);
    }

    public void setBasking(boolean basking) {
        this.entityData.set(BASKING, (Object)basking);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public boolean isFood(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && stack.getItem().getFoodProperties(stack, null) != null && !stack.is(AMTagRegistry.TASMANIAN_DEVIL_HOWLING_FOODS);
    }

    public void tick() {
        super.tick();
        this.prevBaskProgress = this.baskProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isBasking()) {
            if (this.baskProgress < 5.0f) {
                this.baskProgress += 1.0f;
            }
        } else if (this.baskProgress > 0.0f) {
            this.baskProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            if (this.getTarget() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 5 && this.hasLineOfSight((Entity)this.getTarget())) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.02f), 0.0, (double)(Mth.cos((float)f1) * 0.02f)));
                this.getTarget().knockback(1.0, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
                this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
            }
            if ((this.isSitting() || this.isBasking()) && ++this.sittingTime > this.maxSitTime) {
                this.setSitting(false);
                this.setBasking(false);
                this.sittingTime = 0;
                this.maxSitTime = 75 + this.random.nextInt(50);
            }
            if (this.getDeltaMovement().lengthSqr() < 0.03 && this.getAnimation() == NO_ANIMATION && !this.isBasking() && !this.isSitting() && this.random.nextInt(100) == 0) {
                this.sittingTime = 0;
                this.maxSitTime = 100 + this.random.nextInt(550);
                if (this.getRandom().nextBoolean()) {
                    this.setSitting(true);
                    this.setBasking(false);
                } else {
                    this.setSitting(false);
                    this.setBasking(true);
                }
            }
        }
        if (this.getAnimation() == ANIMATION_HOWL && this.getAnimationTick() == 1) {
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.playSound((SoundEvent)AMSoundRegistry.TASMANIAN_DEVIL_ROAR.get(), this.getSoundVolume() * 2.0f, this.getVoicePitch());
        }
        if (this.getAnimation() == ANIMATION_HOWL && this.getAnimationTick() > 3) {
            this.scareMobsTime = 40;
        }
        if (this.scareMobsTime > 0) {
            List list = this.level().getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate(16.0, 8.0, 16.0));
            for (Monster e : list) {
                Vec3 vec;
                e.setTarget(null);
                e.setLastHurtByMob(null);
                if (this.scareMobsTime % 5 != 0 || (vec = LandRandomPos.getPosAway((PathfinderMob)e, (int)20, (int)7, (Vec3)this.position())) == null) continue;
                e.getNavigation().moveTo(vec.x, vec.y, vec.z, 1.5);
            }
            --this.scareMobsTime;
        }
        if (this.getTarget() != null && this.getTarget().isAlive() && (this.getLastHurtByMob() == null || !this.getLastHurtByMob().isAlive())) {
            this.setLastHurtByMob(this.getTarget());
        }
        if ((this.isSitting() || this.isBasking()) && (this.getTarget() != null || this.isInLove())) {
            this.setSitting(false);
            this.setBasking(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (itemstack.is(AMTagRegistry.TASMANIAN_DEVIL_HOWLING_FOODS) && this.getAnimation() != ANIMATION_HOWL) {
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.FOX_EAT, this.getSoundVolume(), this.getVoicePitch());
            this.spawnAtLocation(item.getCraftingRemainingItem(itemstack));
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setAnimation(ANIMATION_HOWL);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_HOWL) {
            this.setSitting(true);
            this.setBasking(false);
            this.maxSitTime = Math.max(25, this.maxSitTime);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK, ANIMATION_HOWL};
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.TASMANIAN_DEVIL.get()).create((Level)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && stack.getItem().getFoodProperties(stack, null) != null || stack.getItem() == Items.BONE;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.gameEvent((Holder)GameEvent.EAT);
        if (e.getItem().getItem() == Items.BONE) {
            this.dropBonemeal();
            this.playSound(SoundEvents.SKELETON_STEP, this.getSoundVolume(), this.getVoicePitch());
        } else {
            this.playSound(SoundEvents.FOX_EAT, this.getSoundVolume(), this.getVoicePitch());
            this.heal(5.0f);
        }
    }

    public void dropBonemeal() {
        ItemStack stack = new ItemStack((ItemLike)Items.BONE_MEAL);
        for (int i = 0; i < 3 + this.random.nextInt(1); ++i) {
            this.spawnAtLocation(stack);
        }
    }
}

