/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySunbird
extends Animal
implements FlyingAnimal {
    public static final Predicate<? super Entity> SCORCH_PRED = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity e) {
            return e.isAlive() && e.getType().is(AMTagRegistry.SUNBIRD_SCORCH_TARGETS);
        }
    };
    private static final EntityDataAccessor<Boolean> SCORCHING = SynchedEntityData.defineId(EntitySunbird.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    private int beaconSearchCooldown = 50;
    private BlockPos beaconPos = null;
    private boolean orbitClockwise = false;
    private float prevScorchProgress;
    private float scorchProgress;
    private int fullScorchTime;

    protected EntitySunbird(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new MoveHelperController(this);
        this.orbitClockwise = new Random().nextBoolean();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SCORCHING, (Object)false);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    public static boolean canSunbirdSpawn(EntityType<? extends Mob> typeIn, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.sunbirdSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.SUNBIRD_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SUNBIRD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SUNBIRD_HURT.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float getBrightness() {
        return 1.0f;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev) {
            if (source.getEntity() != null && source.getEntity() instanceof LivingEntity) {
                LivingEntity hurter = (LivingEntity)source.getEntity();
                if (hurter.hasEffect(AMEffectRegistry.SUNBIRD_BLESSING)) {
                    hurter.removeEffect(AMEffectRegistry.SUNBIRD_BLESSING);
                }
                hurter.addEffect(new MobEffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 600, 0));
            }
            return prev;
        }
        return prev;
    }

    public void travel(Vec3 travelVector) {
        if (this.isInWater()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(0.02f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            BlockPos ground = AMBlockPos.fromCoords(this.getX(), this.getY() - 1.0, this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            f = 0.91f;
            if (this.onGround()) {
                f = this.level().getBlockState(ground).getFriction((LevelReader)this.level(), ground, (Entity)this) * 0.91f;
            }
            this.calculateEntityAnimation(true);
            this.moveRelative(0.2f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        this.calculateEntityAnimation(false);
    }

    public void tick() {
        float f2;
        super.tick();
        this.prevBirdPitch = this.birdPitch;
        this.prevScorchProgress = this.scorchProgress;
        this.birdPitch = f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
        if (this.level().isClientSide) {
            float radius = 0.35f + this.random.nextFloat() * 3.5f;
            float angle = (float)Math.PI / 180 * ((this.random.nextBoolean() ? -85.0f : 85.0f) + this.yBodyRot);
            float f = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            double extraXMotion = -0.2f * Mth.sin((float)((float)(Math.PI + (double)f)));
            double extraZMotion = -0.2f * Mth.cos((float)f);
            double yRandom = 0.2f + this.random.nextFloat() * 0.3f;
            this.level().addParticle((ParticleOptions)AMParticleRegistry.SUNBIRD_FEATHER.get(), this.getX() + extraX, this.getY() + yRandom, this.getZ() + extraZ, extraXMotion, 0.0, extraZMotion);
        } else {
            if (this.tickCount % 100 == 0) {
                if (!this.isScorching() && !this.getScorchingMobs().isEmpty()) {
                    this.setScorching(true);
                }
                List playerList = this.level().getEntitiesOfClass(Player.class, this.getScorchArea(), (Predicate)Predicates.alwaysTrue());
                for (Player player : playerList) {
                    if (player.hasEffect(AMEffectRegistry.SUNBIRD_BLESSING) || player.hasEffect(AMEffectRegistry.SUNBIRD_CURSE)) continue;
                    player.addEffect(new MobEffectInstance(AMEffectRegistry.SUNBIRD_BLESSING, 600, 0));
                }
            }
            if (this.beaconSearchCooldown > 0) {
                --this.beaconSearchCooldown;
            }
            if (this.beaconSearchCooldown <= 0) {
                this.beaconSearchCooldown = 100 + this.random.nextInt(200);
                if (this.level() instanceof ServerLevel) {
                    List<BlockPos> beacons = this.getNearbyBeacons(this.blockPosition(), (ServerLevel)this.level(), 64);
                    BlockPos closest = null;
                    for (BlockPos pos : beacons) {
                        if (closest != null && !(this.distanceToSqr(closest.getX(), closest.getY(), closest.getZ()) > this.distanceToSqr(pos.getX(), pos.getY(), pos.getZ())) || !this.isValidBeacon(pos)) continue;
                        closest = pos;
                    }
                    if (closest != null && this.isValidBeacon(closest)) {
                        this.beaconPos = closest;
                    }
                }
                if (this.beaconPos != null && !this.isValidBeacon(this.beaconPos) && this.tickCount > 40) {
                    this.beaconPos = null;
                }
            }
        }
        boolean scorching = this.isScorching();
        if (scorching) {
            if (this.scorchProgress < 20.0f) {
                this.scorchProgress += 1.0f;
            }
        } else if (this.scorchProgress > 0.0f) {
            this.scorchProgress -= 1.0f;
        }
        if (scorching && this.scorchProgress == 20.0f && !this.level().isClientSide) {
            if (this.fullScorchTime > 30) {
                this.setScorching(false);
            } else if (this.fullScorchTime % 5 == 0) {
                for (Entity entity : this.getScorchingMobs()) {
                    entity.igniteForSeconds(4.0f);
                    if (!(entity instanceof Phantom)) continue;
                    ((Phantom)entity).addEffect(new MobEffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 200, 0));
                }
            }
            ++this.fullScorchTime;
        } else {
            this.fullScorchTime = 0;
        }
    }

    private List<LivingEntity> getScorchingMobs() {
        return this.level().getEntitiesOfClass(LivingEntity.class, this.getScorchArea(), SCORCH_PRED);
    }

    public boolean isScorching() {
        return (Boolean)this.entityData.get(SCORCHING);
    }

    public void setScorching(boolean scorching) {
        this.entityData.set(SCORCHING, (Object)scorching);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("BeaconPosX")) {
            int i = compound.getInt("BeaconPosX");
            int j = compound.getInt("BeaconPosY");
            int k = compound.getInt("BeaconPosZ");
            this.beaconPos = new BlockPos(i, j, k);
        } else {
            this.beaconPos = null;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        BlockPos blockpos = this.beaconPos;
        if (blockpos != null) {
            compound.putInt("BeaconPosX", blockpos.getX());
            compound.putInt("BeaconPosY", blockpos.getY());
            compound.putInt("BeaconPosZ", blockpos.getZ());
        }
    }

    private AABB getScorchArea() {
        return this.getBoundingBox().inflate(15.0, 32.0, 15.0);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private List<BlockPos> getNearbyBeacons(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.getPoiManager();
        Stream stream = pointofinterestmanager.findAll(poiTypeHolder -> poiTypeHolder.is(AMPointOfInterestRegistry.BEACON.getKey()), (Predicate)Predicates.alwaysTrue(), blockpos, range, PoiManager.Occupancy.ANY);
        return stream.collect(Collectors.toList());
    }

    private boolean isValidBeacon(BlockPos pos) {
        BlockEntity te = this.level().getBlockEntity(pos);
        return te instanceof BeaconBlockEntity && !((BeaconBlockEntity)te).getBeamSections().isEmpty();
    }

    public boolean isFlying() {
        return true;
    }

    public float getScorchProgress(float partialTick) {
        return (this.prevScorchProgress + (this.scorchProgress - this.prevScorchProgress) * partialTick) / 20.0f;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntitySunbird parentEntity;

        public MoveHelperController(EntitySunbird sunbird) {
            super((Mob)sunbird);
            this.parentEntity = sunbird;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d0 = vector3d.length();
                if (d0 < this.parentEntity.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                } else {
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * 0.05 / d0)));
                    if (this.parentEntity.getTarget() == null) {
                        Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                        this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                        this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                    } else {
                        double d2 = this.parentEntity.getTarget().getX() - this.parentEntity.getX();
                        double d1 = this.parentEntity.getTarget().getZ() - this.parentEntity.getZ();
                        this.parentEntity.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                        this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                    }
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntitySunbird parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntitySunbird sunbird) {
            this.parentEntity = sunbird;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            MoveControl movementcontroller = this.parentEntity.getMoveControl();
            if (!movementcontroller.hasWanted() || this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.random.nextInt(1)) : this.getBlockInViewSunbird();
                if (this.target != null) {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) > 2.4 && this.parentEntity.getMoveControl().hasWanted() && !this.parentEntity.horizontalCollision;
        }

        public void stop() {
            this.target = null;
        }

        public void tick() {
            if (this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.random.nextInt(1)) : this.getBlockInViewSunbird();
            }
            if (this.parentEntity.beaconPos != null && this.parentEntity.random.nextInt(100) == 0) {
                this.parentEntity.orbitClockwise = this.parentEntity.random.nextBoolean();
            }
            if (this.target != null) {
                this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        private BlockPos getBlockInViewBeacon(BlockPos orbitPos, float gatheringCircleDist) {
            float angle = 0.15707964f * (float)(this.parentEntity.orbitClockwise ? -this.parentEntity.tickCount : this.parentEntity.tickCount);
            double extraX = gatheringCircleDist * Mth.sin((float)angle);
            double extraZ = gatheringCircleDist * Mth.cos((float)angle);
            if (orbitPos != null) {
                BlockPos pos = AMBlockPos.fromCoords((double)orbitPos.getX() + extraX, orbitPos.getY() + this.parentEntity.random.nextInt(2) + 2, (double)orbitPos.getZ() + extraZ);
                if (this.parentEntity.level().isEmptyBlock(new BlockPos((Vec3i)pos))) {
                    return pos;
                }
            }
            return null;
        }

        public BlockPos getBlockInViewSunbird() {
            float radius = -9.45f - (float)this.parentEntity.getRandom().nextInt(24);
            float neg = this.parentEntity.getRandom().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.yBodyRot;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.getRandom().nextFloat() * neg;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = AMBlockPos.fromCoords(this.parentEntity.getX() + extraX, 0.0, this.parentEntity.getZ() + extraZ);
            BlockPos ground = this.parentEntity.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
            int distFromGround = (int)this.parentEntity.getY() - ground.getY();
            int flightHeight = Math.max(ground.getY(), 230 + this.parentEntity.getRandom().nextInt(40)) - ground.getY();
            BlockPos newPos = radialPos.above(distFromGround > 16 ? flightHeight : (int)this.parentEntity.getY() + this.parentEntity.getRandom().nextInt(16) + 1);
            if (!this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }
}

