/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityStraddler;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;

public class EntityStradpole
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DESPAWN_SOON = SynchedEntityData.defineId(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LAUNCHED = SynchedEntityData.defineId(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.defineId(EntityStradpole.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public float swimPitch = 0.0f;
    public float prevSwimPitch = 0.0f;
    private int despawnTimer = 0;
    private int ricochetCount = 0;

    protected EntityStradpole(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.4f);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COD_HURT;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.STRADPOLE_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucket);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compound);
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(AMTagRegistry.STRADPOLE_GROWABLES)) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            if (this.random.nextFloat() < 0.45f) {
                EntityStraddler straddler = (EntityStraddler)((EntityType)AMEntityRegistry.STRADDLER.get()).create(this.level());
                straddler.copyPosition((Entity)this);
                if (!this.level().isClientSide && this.level().addFreshEntity((Entity)straddler)) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (itemstack.getItem() == Items.LAVA_BUCKET && this.isAlive()) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(this.getPickupSound(), 1.0f, 1.0f);
            ItemStack itemstack1 = this.getBucketItemStack();
            this.saveToBucketTag(itemstack1);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.setItemInHand(hand, itemstack2);
            Level level = this.level();
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack1);
            }
            this.discard();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARENT_UUID, Optional.empty());
        builder.define(DESPAWN_SOON, (Object)false);
        builder.define(LAUNCHED, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.entityData.set(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.entityData.get(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.entityData.set(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getParentId() != null) {
            compound.putUUID("ParentUUID", this.getParentId());
        }
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putBoolean("DespawnSoon", this.isDespawnSoon());
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double p_27492_) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.stradpoleSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canStradpoleSpawn(EntityType<EntityStradpole> p_234314_0_, LevelAccessor p_234314_1_, MobSpawnType p_234314_2_, BlockPos p_234314_3_, RandomSource p_234314_4_) {
        if (p_234314_1_.getFluidState(p_234314_3_).is(FluidTags.LAVA) && !p_234314_1_.getFluidState(p_234314_3_.below()).is(FluidTags.LAVA)) {
            return p_234314_1_.isEmptyBlock(p_234314_3_.above());
        }
        return false;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("ParentUUID")) {
            this.setParentId(compound.getUUID("ParentUUID"));
        }
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.setDespawnSoon(compound.getBoolean("DespawnSoon"));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new StradpoleAISwim(this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        if (!worldIn.getBlockState(pos).getFluidState().isEmpty()) {
            return 15.0f;
        }
        return Float.NEGATIVE_INFINITY;
    }

    public boolean isDespawnSoon() {
        return (Boolean)this.entityData.get(DESPAWN_SOON);
    }

    public void setDespawnSoon(boolean despawnSoon) {
        this.entityData.set(DESPAWN_SOON, (Object)despawnSoon);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new BoneSerpentPathNavigator((Mob)this, worldIn);
    }

    public void tick() {
        float f = 1.0f;
        if (((Boolean)this.entityData.get(LAUNCHED)).booleanValue()) {
            this.yBodyRot = this.getYRot();
            HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
                this.onImpact(raytraceresult);
            }
            f = 0.1f;
        }
        super.tick();
        boolean liquid = this.isInWater() || this.isInLava();
        this.prevSwimPitch = this.swimPitch;
        this.swimPitch = (float)(-((double)((float)this.getDeltaMovement().y * (liquid ? 2.5f : f)) * 57.2957763671875));
        if (this.onGround() && !this.isInWater() && !this.isInLava()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        this.setNoGravity(false);
        if (liquid) {
            this.setNoGravity(true);
        }
        if (this.isDespawnSoon()) {
            ++this.despawnTimer;
            if (this.despawnTimer > 100) {
                this.despawnTimer = 0;
                this.spawnAnim();
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void onImpact(HitResult raytraceresult) {
        HitResult.Type raytraceresult$type = raytraceresult.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)raytraceresult);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult traceResult = (BlockHitResult)raytraceresult;
            BlockState blockstate = this.level().getBlockState(traceResult.getBlockPos());
            if (!blockstate.getBlockSupportShape((BlockGetter)this.level(), traceResult.getBlockPos()).isEmpty()) {
                Direction face = traceResult.getDirection();
                Vec3 prevMotion = this.getDeltaMovement();
                double motionX = prevMotion.x();
                double motionY = prevMotion.y();
                double motionZ = prevMotion.z();
                switch (face) {
                    case EAST: 
                    case WEST: {
                        motionX = -motionX;
                        break;
                    }
                    case SOUTH: 
                    case NORTH: {
                        motionZ = -motionZ;
                        break;
                    }
                    default: {
                        motionY = -motionY;
                    }
                }
                this.setDeltaMovement(motionX, motionY, motionZ);
                if (this.tickCount > 200 || this.ricochetCount > 20) {
                    this.entityData.set(LAUNCHED, (Object)false);
                } else {
                    ++this.ricochetCount;
                }
            }
        }
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    private void onEntityHit(EntityHitResult raytraceresult) {
        Entity entity;
        Entity entity2 = this.getParent();
        if (entity2 instanceof LivingEntity && !this.level().isClientSide && (entity = raytraceresult.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (!target.isBlocking()) {
                target.hurt(this.damageSources().mobProjectile((Entity)this, (LivingEntity)entity2), 3.0f);
                target.knockback((double)0.7f, entity2.getX() - this.getX(), entity2.getZ() - this.getZ());
            } else if (this.getTarget() instanceof Player) {
                this.damageShieldFor((Player)this.getTarget(), 3.0f);
            }
            this.entityData.set(LAUNCHED, (Object)false);
        }
    }

    protected void damageShieldFor(Player holder, float damage) {
        if (holder.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            if (!this.level().isClientSide) {
                holder.awardStat(Stats.ITEM_USED.get((Object)holder.getUseItem().getItem()));
            }
            if (damage >= 3.0f) {
                int i = 1 + Mth.floor((float)damage);
                InteractionHand hand = holder.getUsedItemHand();
                holder.getUseItem().hurtAndBreak(i, (LivingEntity)holder, EquipmentSlot.MAINHAND);
                if (holder.getUseItem().isEmpty()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        // empty if block
                    }
                    holder.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        return !p_230298_1_.isSpectator() && !(p_230298_1_ instanceof EntityStraddler) && !(p_230298_1_ instanceof EntityStradpole);
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean canStandOnFluid(Fluid p_230285_1_) {
        return p_230285_1_.is(FluidTags.LAVA);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && (this.isInWater() || this.isInLava())) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected void handleAirSupply(int p_209207_1_) {
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3 lvt_9_1_ = new Vec3(p_70186_1_, p_70186_3_, p_70186_5_).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_).scale((double)p_70186_7_);
        this.setDeltaMovement(lvt_9_1_);
        float lvt_10_1_ = (float)lvt_9_1_.horizontalDistanceSqr();
        this.setYRot((float)(Mth.atan2((double)lvt_9_1_.x, (double)lvt_9_1_.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)lvt_9_1_.y, (double)lvt_10_1_) * 57.2957763671875));
        this.xRotO = this.getXRot();
        this.yBodyRot = this.getYRot();
        this.yHeadRot = this.getYRot();
        this.yHeadRotO = this.getYRot();
        this.yRotO = this.getYRot();
        this.setDespawnSoon(true);
        this.entityData.set(LAUNCHED, (Object)true);
    }

    static class StradpoleAISwim
    extends RandomStrollGoal {
        public StradpoleAISwim(EntityStradpole creature, double speed, int chance) {
            super((PathfinderMob)creature, speed, chance, false);
        }

        public boolean canUse() {
            if (!this.mob.isInLava() && !this.mob.isInWater() || this.mob.isPassenger() || this.mob.getTarget() != null || !this.mob.isInWater() && !this.mob.isInLava() && this.mob instanceof ISemiAquatic && !((ISemiAquatic)this.mob).shouldEnterWater()) {
                return false;
            }
            if (!this.forceTrigger && this.mob.getRandom().nextInt(this.interval) != 0) {
                return false;
            }
            Vec3 vector3d = this.getPosition();
            if (vector3d == null) {
                return false;
            }
            this.wantedX = vector3d.x;
            this.wantedY = vector3d.y;
            this.wantedZ = vector3d.z;
            this.forceTrigger = false;
            return true;
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d;
            if (this.mob.getRandom().nextFloat() < 0.3f && (vector3d = this.findSurfaceTarget(this.mob, 15, 7)) != null) {
                return vector3d;
            }
            vector3d = LandRandomPos.getPos((PathfinderMob)this.mob, (int)7, (int)3);
            int i = 0;
            while (vector3d != null && !this.mob.level().getFluidState(AMBlockPos.fromVec3(vector3d)).is(FluidTags.LAVA) && !this.mob.level().getBlockState(AMBlockPos.fromVec3(vector3d)).isPathfindable(PathComputationType.WATER) && i++ < 15) {
                vector3d = LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
            }
            return vector3d;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.offset(dx * scale, 0, dz * scale);
            return this.mob.level().getFluidState(blockpos).is(FluidTags.LAVA) || this.mob.level().getFluidState(blockpos).is(FluidTags.WATER) && !this.mob.level().getBlockState(blockpos).blocksMotion();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.mob.level().getBlockState(pos.offset(dx * scale, 1, dz * scale)).isAir() && this.mob.level().getBlockState(pos.offset(dx * scale, 2, dz * scale)).isAir();
        }

        private Vec3 findSurfaceTarget(PathfinderMob creature, int i, int i1) {
            BlockPos upPos = creature.blockPosition();
            while (creature.level().getFluidState(upPos).is(FluidTags.WATER) || creature.level().getFluidState(upPos).is(FluidTags.LAVA)) {
                upPos = upPos.above();
            }
            if (this.isAirAbove(upPos.below(), 0, 0, 0) && this.canJumpTo(upPos.below(), 0, 0, 0)) {
                return new Vec3((double)((float)upPos.getX() + 0.5f), (double)((float)upPos.getY() - 1.0f), (double)((float)upPos.getZ() + 0.5f));
            }
            return null;
        }
    }
}

