/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySquidGrapple
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(EntitySquidGrapple.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(EntitySquidGrapple.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Boolean> WITHDRAWING = SynchedEntityData.defineId(EntitySquidGrapple.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> ATTACHED_POS = SynchedEntityData.defineId(EntitySquidGrapple.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private int ticksWithdrawing = 0;

    public EntitySquidGrapple(EntityType type, Level level) {
        super(type, level);
    }

    public EntitySquidGrapple(Level worldIn, LivingEntity player, boolean rightHand) {
        this((EntityType)AMEntityRegistry.SQUID_GRAPPLE.get(), worldIn);
        this.setOwnerId(player.getUUID());
        float rot = player.yHeadRot + (float)(rightHand ? 60 : -60);
        this.setPos(player.getX() - (double)player.getBbWidth() * 0.5 * (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), player.getEyeY() - (double)0.2f, player.getZ() + (double)player.getBbWidth() * 0.5 * (double)Mth.cos((float)(rot * ((float)Math.PI / 180))));
    }

    protected static float lerpRotation(float f2, float f3) {
        while (f3 - f2 < -180.0f) {
            f2 -= 360.0f;
        }
        while (f3 - f2 >= 180.0f) {
            f2 += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)f2, (float)f3);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        float f = Mth.sqrt((float)((float)(vector3d.x * vector3d.x + vector3d.z * vector3d.z)));
        this.setYRot(Mth.wrapDegrees((float)((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875) + 180.0f)));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    public void setAttachmentFacing(Direction direction) {
        this.entityData.set(ATTACHED_FACE, (Object)direction);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uniqueId) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uniqueId));
    }

    public BlockPos getStuckToPos() {
        return ((Optional)this.entityData.get(ATTACHED_POS)).orElse(null);
    }

    public void setStuckToPos(BlockPos harvestedPos) {
        this.entityData.set(ATTACHED_POS, Optional.ofNullable(harvestedPos));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(ATTACHED_POS, Optional.empty());
        builder.define(WITHDRAWING, (Object)false);
    }

    public Entity getOwner() {
        UUID id = this.getOwnerId();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return this.getOwnerId() == null ? null : this.level().getPlayerByUUID(this.getOwnerId());
    }

    public boolean isWithdrawing() {
        return (Boolean)this.entityData.get(WITHDRAWING);
    }

    public void setWithdrawing(boolean withdrawing) {
        this.entityData.set(WITHDRAWING, (Object)withdrawing);
    }

    public void tick() {
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        Entity entity = this.getOwner();
        if (!this.level().isClientSide) {
            if (entity == null || !entity.isAlive()) {
                this.discard();
            } else if (entity.isShiftKeyDown()) {
                this.setWithdrawing(true);
            }
        }
        if (this.isWithdrawing() && entity != null) {
            super.tick();
            ++this.ticksWithdrawing;
            this.setStuckToPos(null);
            Vec3 withDrawTo = entity.getEyePosition().add(0.0, (double)-0.2f, 0.0);
            if (withDrawTo.distanceTo(this.position()) > (double)1.2f && this.ticksWithdrawing < 200) {
                Vec3 move = new Vec3(withDrawTo.x - this.getX(), withDrawTo.y - this.getY(), withDrawTo.z - this.getZ());
                Vec3 vector3d = move.normalize().scale(1.2);
                this.setDeltaMovement(vector3d.scale(0.99));
                double d0 = this.getX() + vector3d.x;
                double d1 = this.getY() + vector3d.y;
                double d2 = this.getZ() + vector3d.z;
                float f = Mth.sqrt((float)((float)(move.x * move.x + move.z * move.z)));
                if (!this.level().isClientSide) {
                    this.setYRot(Mth.wrapDegrees((float)((float)(-Mth.atan2((double)move.x, (double)move.z) * 57.2957763671875))) - 180.0f);
                    this.setXRot((float)(Mth.atan2((double)move.y, (double)f) * 57.2957763671875));
                    this.yRotO = this.getYRot();
                    this.xRotO = this.getXRot();
                }
                this.setPos(d0, d1, d2);
            } else {
                this.discard();
            }
        } else if (this.level().isClientSide || this.level().hasChunkAt(this.blockPosition())) {
            if (this.getStuckToPos() == null) {
                super.tick();
                Vec3 vector3d = this.getDeltaMovement();
                HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, newentity -> false);
                if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
                    this.onImpact(raytraceresult);
                }
                this.checkInsideBlocks();
                double d0 = this.getX() + vector3d.x;
                double d1 = this.getY() + vector3d.y;
                double d2 = this.getZ() + vector3d.z;
                this.updateRotation();
                this.setDeltaMovement(vector3d.scale(0.99));
                if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir) && !this.isInWater()) {
                    this.setDeltaMovement(Vec3.ZERO);
                } else {
                    this.setPos(d0, d1, d2);
                }
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.1f, 0.0));
                }
            } else {
                BlockState state = this.level().getBlockState(this.getStuckToPos());
                Vec3 vec3 = new Vec3((double)((float)this.getStuckToPos().getX() + 0.5f), (double)((float)this.getStuckToPos().getY() + 0.5f), (double)((float)this.getStuckToPos().getZ() + 0.5f));
                Vec3 offset = new Vec3((double)((float)this.getAttachmentFacing().getStepX() * 0.55f), (double)((float)this.getAttachmentFacing().getStepY() * 0.55f), (double)((float)this.getAttachmentFacing().getStepZ() * 0.55f));
                this.setPos(vec3.add(offset));
                float targetX = this.getXRot();
                float targetY = this.getYRot();
                switch (this.getAttachmentFacing()) {
                    case UP: {
                        targetX = 0.0f;
                        break;
                    }
                    case DOWN: {
                        targetX = 180.0f;
                        break;
                    }
                    case NORTH: {
                        targetX = -90.0f;
                        targetY = 0.0f;
                        break;
                    }
                    case EAST: {
                        targetX = -90.0f;
                        targetY = 90.0f;
                        break;
                    }
                    case SOUTH: {
                        targetX = -90.0f;
                        targetY = 180.0f;
                        break;
                    }
                    case WEST: {
                        targetX = -90.0f;
                        targetY = -90.0f;
                    }
                }
                this.setXRot(targetX);
                this.setYRot(targetY);
                if (entity != null && entity.distanceTo((Entity)this) > 2.0f) {
                    float entitySwing = 1.0f;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        float detract = living.xxa * living.xxa + living.yya * living.yya + living.zza * living.zza;
                        entitySwing = (float)((double)entitySwing - Math.min(1.0, Math.sqrt(detract) * (double)0.333f));
                    }
                    Vec3 move = new Vec3(this.getX() - entity.getX(), this.getY() - (double)entity.getEyeHeight() / 2.0 - entity.getY(), this.getZ() - entity.getZ());
                    entity.setDeltaMovement(entity.getDeltaMovement().add(move.normalize().scale(0.2 * (double)entitySwing)));
                    if (!entity.onGround()) {
                        entity.fallDistance = 0.0f;
                    }
                }
                if (state.isAir()) {
                    this.setWithdrawing(true);
                }
            }
        } else {
            this.discard();
        }
    }

    protected float rotlerp(float in, float target, float maxShift) {
        float f1;
        float f = Mth.wrapDegrees((float)(target - in));
        if (f > maxShift) {
            f = maxShift;
        }
        if (f < -maxShift) {
            f = -maxShift;
        }
        if ((f1 = in + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    private void updateRotation() {
    }

    protected void onImpact(HitResult result) {
        HitResult.Type raytraceresult$type = result.getType();
        if (!this.level().isClientSide && raytraceresult$type == HitResult.Type.BLOCK && this.getStuckToPos() == null) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setStuckToPos(((BlockHitResult)result).getBlockPos());
            this.setAttachmentFacing(((BlockHitResult)result).getDirection());
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (this.getOwnerId() != null) {
            compound.putUUID("OwnerUUID", this.getOwnerId());
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("OwnerUUID")) {
            this.setOwnerId(compound.getUUID("OwnerUUID"));
        }
    }
}

