/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntitySkreecher
extends Monster {
    public static final float MAX_DIST_TO_CEILING = 4.0f;
    private static final EntityDataAccessor<Boolean> CLINGING = SynchedEntityData.defineId(EntitySkreecher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> JUMPING_UP = SynchedEntityData.defineId(EntitySkreecher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CLAPPING = SynchedEntityData.defineId(EntitySkreecher.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DIST_TO_CEILING = SynchedEntityData.defineId(EntitySkreecher.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDimensions GROUND_SIZE = EntityDimensions.scalable((float)0.99f, (float)1.35f);
    public float prevClingProgress;
    public float clingProgress;
    public float prevClapProgress;
    public float clapProgress;
    public float prevDistanceToCeiling;
    private int clapTick = 0;
    private int clingCooldown = 0;
    private boolean isUpsideDownNavigator;
    private boolean hasAttemptedWardenSpawning;
    private boolean hasGroundSize = false;

    protected EntitySkreecher(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.switchNavigator(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Warden.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new FollowTargetGoal());
        this.goalSelector.addGoal(3, (Goal)new WanderUpsideDownGoal());
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 30.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new EntityAINearestTarget3D(this, (Mob)this, Player.class, true){

            @Override
            protected AABB getTargetSearchArea(double targetDistance) {
                AABB bb = this.mob.getBoundingBox().inflate(16.0, 1.0, 16.0);
                return new AABB(bb.minX, -64.0, bb.minZ, bb.maxX, 320.0, bb.maxZ);
            }
        });
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.skreecherSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean checkSkreecherSpawnRules(EntityType<? extends Monster> animal, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean isOnSculk = worldIn.getBlockState(pos.below()).is(Blocks.SCULK);
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && EntitySkreecher.isDarkEnoughToSpawn((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)random) && isOnSculk;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    private void switchNavigator(boolean clinging) {
        if (clinging) {
            this.moveControl = new MoveController(this);
            this.navigation = this.createScreecherNavigation(this.level());
            this.isUpsideDownNavigator = true;
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isUpsideDownNavigator = false;
        }
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIST_TO_CEILING, (Object)Float.valueOf(0.0f));
        builder.define(CLINGING, (Object)false);
        builder.define(JUMPING_UP, (Object)false);
        builder.define(CLAPPING, (Object)false);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SKREECHER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SKREECHER_HURT.get();
    }

    public boolean hurt(DamageSource source, float value) {
        this.setClinging(false);
        this.setClapping(false);
        this.clingCooldown = 200 + this.random.nextInt(200);
        return super.hurt(source, value);
    }

    public void tick() {
        boolean clapping;
        boolean clingVisually;
        super.tick();
        this.prevClapProgress = this.clapProgress;
        this.prevClingProgress = this.clingProgress;
        this.prevDistanceToCeiling = this.getDistanceToCeiling();
        boolean bl = clingVisually = this.isClinging() || this.isJumpingUp() || this.jumping;
        if (clingVisually && this.clingProgress < 5.0f) {
            this.clingProgress += 1.0f;
        }
        if (!clingVisually && this.clingProgress > 0.0f && this.getDistanceToCeiling() == 0.0f) {
            this.clingProgress -= 1.0f;
        }
        if (clapping = this.isClapping()) {
            if (this.clapProgress < 5.0f) {
                this.clapProgress += 1.0f;
            }
        } else if (this.clapProgress > 0.0f) {
            this.clapProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            float technicalDistToCeiling = this.calculateDistanceToCeiling();
            float gap = Math.max(technicalDistToCeiling - this.getDistanceToCeiling(), 0.0f);
            if (this.isClinging()) {
                this.setNoGravity(true);
                if (technicalDistToCeiling > 4.0f || !this.isAlive() || this.clingCooldown > 0 || this.isInFluidType()) {
                    this.setClinging(false);
                }
                float goal = Math.min(technicalDistToCeiling, 4.0f);
                if (this.getDistanceToCeiling() < goal) {
                    this.setDistanceToCeiling(Math.min(goal, this.prevDistanceToCeiling + 0.15f));
                }
                if (this.getDistanceToCeiling() > goal) {
                    this.setDistanceToCeiling(Math.max(goal, this.prevDistanceToCeiling - 0.15f));
                }
                if (this.getDistanceToCeiling() < 1.0f) {
                    gap = -0.03f;
                }
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(gap * 0.5f), 0.0));
            } else {
                this.setNoGravity(false);
                if (technicalDistToCeiling < 4.0f && this.clingCooldown <= 0) {
                    this.setClinging(true);
                }
                this.setDistanceToCeiling(Math.max(0.0f, this.prevDistanceToCeiling - 0.5f));
                if (this.onGround() && this.clingCooldown <= 0 && !this.isJumpingUp() && this.isAlive() && this.random.nextFloat() < 0.0085f && technicalDistToCeiling > 4.0f && !this.level().canSeeSky(this.blockPosition())) {
                    this.setJumpingUp(true);
                }
            }
        }
        if (this.isJumpingUp()) {
            if (this.isAlive() && !this.level().canSeeSky(this.blockPosition()) && (!this.verticalCollision || this.onGround())) {
                this.setDistanceToCeiling(1.5f);
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.2f, 0.0));
                for (int i = 0; i < 3; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, this.getRandomX(0.5), this.getY() - (double)0.2f, this.getRandomZ(0.5), 0.0, (double)-0.2f, 0.0);
                }
            } else {
                this.setJumpingUp(false);
            }
        }
        if (this.clingCooldown > 0) {
            --this.clingCooldown;
        }
        if (!this.isAlive() || this.clingCooldown > 0 && this.isClinging()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.25, 0.0));
        }
        if (this.isClinging() && !this.isUpsideDownNavigator) {
            this.switchNavigator(true);
        }
        if (!this.isClinging() && this.isUpsideDownNavigator) {
            this.switchNavigator(false);
        }
        if (this.isClapping() && this.isAlive() && this.clingCooldown <= 0) {
            float dir;
            float f = dir = this.isClinging() ? -0.5f : 0.1f;
            if (this.clapTick % 8 == 0) {
                this.playSound((SoundEvent)AMSoundRegistry.SKREECHER_CLAP.get(), this.getSoundVolume() * 3.0f, this.getVoicePitch());
                this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                this.angerAllNearbyWardens();
                this.level().addParticle((ParticleOptions)AMParticleRegistry.SKULK_BOOM.get(), this.getX(), this.getEyeY(), this.getZ(), 0.0, (double)dir, 0.0);
            } else if (this.clapTick % 15 == 0) {
                this.playSound((SoundEvent)AMSoundRegistry.SKREECHER_CALL.get(), this.getSoundVolume() * 4.0f, this.getVoicePitch());
            }
            if (this.clapTick >= 100 && !this.hasAttemptedWardenSpawning && AMConfig.skreechersSummonWarden) {
                this.hasAttemptedWardenSpawning = true;
                BlockPos spawnAt = this.blockPosition().below();
                while (spawnAt.getY() > -64 && !this.level().getBlockState(spawnAt).isFaceSturdy((BlockGetter)this.level(), spawnAt, Direction.UP)) {
                    spawnAt = spawnAt.below();
                }
                Holder holder = this.level().getBiome(spawnAt);
                if (!this.level().isClientSide && this.getNearbyWardens().isEmpty() && holder.is(AMTagRegistry.SKREECHERS_CAN_SPAWN_WARDENS)) {
                    Warden warden = (Warden)EntityType.WARDEN.create(this.level());
                    warden.moveTo(this.getX(), (double)(spawnAt.getY() + 1), this.getZ(), this.getYRot(), 0.0f);
                    warden.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.TRIGGERED, (SpawnGroupData)null);
                    warden.setAttackTarget((LivingEntity)this);
                    warden.increaseAngerAt((Entity)this, 79, false);
                    this.level().addFreshEntity((Entity)warden);
                }
            }
            ++this.clapTick;
            if (!this.level().isClientSide) {
                if (this.getTarget() != null && this.getTarget().isAlive() && this.hasLineOfSight((Entity)this.getTarget()) && !this.getTarget().hasEffect(MobEffects.INVISIBILITY) && !this.hasEffect(MobEffects.BLINDNESS)) {
                    double horizDist = this.getTarget().position().subtract(this.position()).horizontalDistance();
                    if (horizDist > 20.0) {
                        this.setClapping(false);
                    }
                } else {
                    this.setClapping(false);
                }
            }
        }
        if (!this.isClinging() && !this.hasGroundSize) {
            this.refreshDimensions();
            this.hasGroundSize = true;
        }
        if (this.isClinging() && this.hasGroundSize) {
            this.refreshDimensions();
            this.hasGroundSize = false;
        }
    }

    public boolean dampensVibrations() {
        return true;
    }

    public void angerAllNearbyWardens() {
        for (Warden warden : this.getNearbyWardens()) {
            if (!warden.hasLineOfSight((Entity)this)) continue;
            warden.increaseAngerAt((Entity)this, 100, false);
        }
    }

    private List<Warden> getNearbyWardens() {
        AABB angerBox = new AABB(this.getX() - 35.0, this.getY() + (double)(this.isClinging() ? 5.0f : 25.0f), this.getZ() - 35.0, this.getX() + 35.0, -64.0, this.getZ() + 35.0);
        return this.level().getEntitiesOfClass(Warden.class, angerBox);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Clinging", this.isClinging());
        compound.putDouble("CeilDist", (double)this.getDistanceToCeiling());
        compound.putBoolean("SummonedWarden", this.hasAttemptedWardenSpawning);
        compound.putInt("ClingCooldown", this.clingCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setClinging(compound.getBoolean("Clinging"));
        this.setDistanceToCeiling((float)compound.getDouble("CeilDist"));
        this.hasAttemptedWardenSpawning = compound.getBoolean("SummonedWarden");
        this.clingCooldown = compound.getInt("ClingCooldown");
    }

    public boolean isClinging() {
        return (Boolean)this.entityData.get(CLINGING);
    }

    public void setClinging(boolean upsideDown) {
        this.entityData.set(CLINGING, (Object)upsideDown);
    }

    public boolean isClapping() {
        return (Boolean)this.entityData.get(CLAPPING);
    }

    public void setClapping(boolean clapping) {
        this.entityData.set(CLAPPING, (Object)clapping);
        if (!clapping) {
            this.clapTick = 0;
        }
    }

    public boolean isJumpingUp() {
        return (Boolean)this.entityData.get(JUMPING_UP);
    }

    public void setJumpingUp(boolean jumping) {
        this.entityData.set(JUMPING_UP, (Object)jumping);
    }

    protected BlockPos getPositionAbove(float height) {
        return AMBlockPos.fromCoords(this.position().x, this.getBoundingBox().maxY + (double)height + 0.5000001, this.position().z);
    }

    protected PathNavigation createScreecherNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                int airAbove = 0;
                while (EntitySkreecher.this.level().getBlockState(pos).isAir() && (float)airAbove < 6.0f) {
                    pos = pos.above();
                    ++airAbove;
                }
                return (float)airAbove < Math.min(4.0f, (float)EntitySkreecher.this.random.nextInt(4));
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        return flyingpathnavigation;
    }

    private float calculateDistanceToCeiling() {
        BlockPos ceiling = this.getCeilingOf(this.blockPosition());
        return (float)((double)ceiling.getY() - this.getBoundingBox().maxY);
    }

    private boolean isOpaqueBlockAt(double x, double y, double z) {
        if (this.noPhysics) {
            return false;
        }
        double d = 0.3f;
        Vec3 vec3 = new Vec3(x, y, z);
        AABB axisAlignedBB = AABB.ofSize((Vec3)vec3, (double)0.3f, (double)1.0E-6, (double)0.3f);
        return this.level().getBlockStates(axisAlignedBB).filter(Predicate.not(BlockBehaviour.BlockStateBase::isAir)).anyMatch(p_185969_ -> {
            BlockPos blockpos = AMBlockPos.fromVec3(vec3);
            return p_185969_.isSuffocating((BlockGetter)this.level(), blockpos) && Shapes.joinIsNotEmpty((VoxelShape)p_185969_.getCollisionShape((BlockGetter)this.level(), blockpos).move(vec3.x, vec3.y, vec3.z), (VoxelShape)Shapes.create((AABB)axisAlignedBB), (BooleanOp)BooleanOp.AND);
        });
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getDistanceToCeiling() {
        return ((Float)this.entityData.get(DIST_TO_CEILING)).floatValue();
    }

    public void setDistanceToCeiling(float dist) {
        this.entityData.set(DIST_TO_CEILING, (Object)Float.valueOf(dist));
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isClinging() && !this.isInFluidType()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.75));
        } else {
            super.travel(travelVector);
        }
    }

    public BlockPos getCeilingOf(BlockPos usPos) {
        while (!this.level().getBlockState(usPos).isFaceSturdy((BlockGetter)this.level(), usPos, Direction.DOWN) && usPos.getY() < this.level().getMaxBuildHeight()) {
            usPos = usPos.above();
        }
        return usPos;
    }

    private class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntitySkreecher.this.getTarget() != null && EntitySkreecher.this.getTarget().isAlive() && EntitySkreecher.this.clingCooldown <= 0;
        }

        public void start() {
            EntitySkreecher.this.playSound((SoundEvent)AMSoundRegistry.SKREECHER_DETECT.get(), EntitySkreecher.this.getSoundVolume() * 6.0f, EntitySkreecher.this.getVoicePitch());
        }

        public void tick() {
            LivingEntity target = EntitySkreecher.this.getTarget();
            if (target != null) {
                if (EntitySkreecher.this.isClinging()) {
                    BlockPos ceilAbove = EntitySkreecher.this.getCeilingOf(target.blockPosition().above());
                    EntitySkreecher.this.getNavigation().moveTo(target.getX(), (double)((float)ceilAbove.getY() - EntitySkreecher.this.random.nextFloat() * 4.0f), target.getZ(), (double)1.2f);
                } else {
                    EntitySkreecher.this.getNavigation().moveTo(target.getX(), target.getY(), target.getZ(), 1.0);
                }
                Vec3 vec = target.position().subtract(EntitySkreecher.this.position());
                EntitySkreecher.this.getLookControl().setLookAt((Entity)target, 360.0f, 180.0f);
                if (vec.horizontalDistance() < 2.5 && EntitySkreecher.this.clingCooldown == 0) {
                    EntitySkreecher.this.setClapping(true);
                }
            }
        }
    }

    class WanderUpsideDownGoal
    extends RandomStrollGoal {
        private int stillTicks;

        public WanderUpsideDownGoal() {
            super((PathfinderMob)EntitySkreecher.this, 1.0, 25);
            this.stillTicks = 0;
        }

        @Nullable
        protected Vec3 getPosition() {
            if (EntitySkreecher.this.isClinging()) {
                int distance = 16;
                int i = 0;
                if (i < 15) {
                    Random rand = new Random();
                    BlockPos randPos = EntitySkreecher.this.blockPosition().offset(rand.nextInt(distance * 2) - distance, -4, rand.nextInt(distance * 2) - distance);
                    BlockPos lowestPos = EntitySkreecher.this.getCeilingOf(randPos).below(rand.nextInt(4));
                    return Vec3.atCenterOf((Vec3i)lowestPos);
                }
                return null;
            }
            return super.getPosition();
        }

        public boolean canUse() {
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }

        public void stop() {
            super.stop();
            this.wantedX = 0.0;
            this.wantedY = 0.0;
            this.wantedZ = 0.0;
        }

        public void start() {
            this.stillTicks = 0;
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController(EntitySkreecher this$0) {
            super((Mob)this$0);
            this.parentEntity = this$0;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d0 = vector3d.length();
                double width = this.parentEntity.getBoundingBox().getSize();
                Vec3 vector3d1 = vector3d.scale(this.speedModifier * 0.035 / d0);
                float verticalSpeed = 0.15f;
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d1.multiply(1.0, (double)verticalSpeed, 1.0)));
                if (this.parentEntity.getTarget() != null) {
                    double d1 = this.parentEntity.getTarget().getZ() - this.parentEntity.getZ();
                    double d3 = this.parentEntity.getTarget().getY() - this.parentEntity.getY();
                    double d2 = this.parentEntity.getTarget().getX() - this.parentEntity.getX();
                    float f = Mth.sqrt((float)((float)(d2 * d2 + d1 * d1)));
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                    this.parentEntity.setXRot((float)(Mth.atan2((double)d3, (double)f) * 57.2957763671875));
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                } else if (d0 >= width) {
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                }
            }
        }
    }
}

