/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class EntitySkelewag
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_STAB = Animation.create((int)10);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntitySkelewag.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int animationTick;
    private Animation currentAnimation;
    public float prevOnLandProgress;
    public float onLandProgress;

    protected EntitySkelewag(EntityType<? extends Monster> monster, Level level) {
        super(monster, level);
        this.xpReward = 10;
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f, 15.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new SemiAquaticPathNavigator((Mob)this, worldIn);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.skelewagSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canSkelewagSpawn(EntityType<EntitySkelewag> type, ServerLevelAccessor levelAccessor, MobSpawnType p_32352_, BlockPos below, RandomSource random) {
        if (!levelAccessor.getFluidState(below.below()).is(FluidTags.WATER)) {
            return false;
        }
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL && EntitySkelewag.isDarkEnoughToSpawn((ServerLevelAccessor)levelAccessor, (BlockPos)below, (RandomSource)random) && (p_32352_ == MobSpawnType.SPAWNER || random.nextInt(40) == 0 && levelAccessor.getFluidState(below).is(FluidTags.WATER));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.SKELEWAG_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SKELEWAG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SKELEWAG_HURT.get();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return this.level().getFluidState(pos).is(FluidTags.WATER) ? 10.0f + level.getLightLevelDependentMagicValue(pos) - 0.5f : super.getWalkTargetValue(pos, (LevelReader)this.level());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIRandomSwimming((PathfinderMob)this, 1.0, 12, 5));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Drowned.class, EntitySkelewag.class}));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<Dolphin>((Mob)this, Dolphin.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, 0.45).add(Attributes.MAX_HEALTH, 20.0);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public void tick() {
        boolean onLand;
        super.tick();
        this.prevOnLandProgress = this.onLandProgress;
        boolean bl = onLand = !this.isInWaterOrBubble() && this.onGround();
        if (onLand && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (!onLand && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        float targetXRot = 0.0f;
        if (this.getDeltaMovement().length() > 0.09) {
            targetXRot = -((float)(Mth.atan2((double)this.getDeltaMovement().y, (double)this.getDeltaMovement().horizontalDistance()) * 57.2957763671875));
        }
        if (targetXRot < this.getXRot() - 5.0f) {
            targetXRot = this.getXRot() - 5.0f;
        }
        if (targetXRot > this.getXRot() + 5.0f) {
            targetXRot = this.getXRot() + 5.0f;
        }
        this.setXRot(targetXRot);
        if (!this.level().isClientSide && this.getTarget() != null && this.distanceTo((Entity)this.getTarget()) < 2.0f + this.getTarget().getBbWidth()) {
            this.lookAt((Entity)this.getTarget(), 350.0f, 200.0f);
            if (this.getAnimation() == ANIMATION_STAB && this.getAnimationTick() == 7 && this.hasLineOfSight((Entity)this.getTarget())) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.02f), 0.0, (double)(Mth.cos((float)f1) * 0.02f)));
                this.getTarget().knockback(1.0, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
                this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
            }
            if (this.getAnimation() == ANIMATION_SLASH && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() > 0 && this.getAnimationTick() < 25 && this.hasLineOfSight((Entity)this.getTarget())) {
                for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getTarget().getBoundingBox().inflate(2.0))) {
                    if (entity.isPassengerOfSameVehicle((Entity)this) || entity == this || entity.isAlliedTo((Entity)this)) continue;
                    entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() * 0.5f);
                }
            }
        }
        if (this.onLandProgress >= 5.0f && this.isVehicle()) {
            this.ejectPassengers();
        }
        if (!this.isInWaterOrBubble() && this.onGround() && this.random.nextFloat() < 0.2f) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.playSound((SoundEvent)AMSoundRegistry.SKELEWAG_HURT.get(), this.getSoundVolume(), this.getVoicePitch());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int command) {
        this.entityData.set(VARIANT, (Object)command);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getInt("Variant"));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            passenger.setYBodyRot(this.yBodyRot);
            Vec3 vec = new Vec3(0.0, (double)(this.getBbHeight() * 0.4f), (double)(this.getBbWidth() * -0.2f)).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
            passenger.setPos(this.getX() + vec.x, this.getY() + vec.y + (double)passenger.getBbHeight() * 0.5, this.getZ() + vec.z);
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setVariant(this.getRandom().nextFloat() < 0.3f ? 1 : 0);
        if (this.random.nextFloat() < 0.2f) {
            Drowned drowned = (Drowned)EntityType.DROWNED.create(this.level());
            drowned.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
            drowned.copyPosition((Entity)this);
            drowned.startRiding((Entity)this);
            worldIn.addFreshEntityWithPassengers((Entity)drowned);
        }
        if (reason == MobSpawnType.STRUCTURE) {
            this.restrictTo(this.blockPosition(), 15);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean canBreatheUnderwaterAM() {
        return true;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SLASH, ANIMATION_STAB};
    }

    private class AttackGoal
    extends Goal {
        private final EntitySkelewag fish;
        private boolean isCharging = false;

        public AttackGoal(EntitySkelewag skelewag) {
            this.fish = skelewag;
        }

        public boolean canUse() {
            return this.fish.getTarget() != null;
        }

        public void tick() {
            LivingEntity target = this.fish.getTarget();
            if (target != null) {
                double dist = this.fish.distanceTo((Entity)target);
                if (dist > 5.0) {
                    this.isCharging = true;
                }
                this.fish.getNavigation().moveTo((Entity)target, this.isCharging ? (double)1.3f : (double)0.8f);
                if (dist < (double)(5.0f + target.getBbWidth() / 2.0f)) {
                    this.fish.setAnimation(this.isCharging ? ANIMATION_STAB : (EntitySkelewag.this.random.nextBoolean() ? ANIMATION_SLASH : ANIMATION_STAB));
                    this.isCharging = false;
                }
            }
        }

        public void stop() {
            this.isCharging = false;
        }
    }
}

