/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAlligatorSnappingTurtle;
import com.github.alexthe666.alexsmobs.entity.EntityCaiman;
import com.github.alexthe666.alexsmobs.entity.EntityCrocodile;
import com.github.alexthe666.alexsmobs.entity.EntityTerrapin;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWadeSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.ShoebillAIFish;
import com.github.alexthe666.alexsmobs.entity.ai.ShoebillAIFlightFlee;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityShoebill
extends Animal
implements IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_FISH = Animation.create((int)40);
    public static final Animation ANIMATION_BEAKSHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityShoebill.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevFlyProgress;
    public float flyProgress;
    public int revengeCooldown = 0;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    public int fishingCooldown = 1200 + this.random.nextInt(1200);
    public int lureLevel = 0;
    public int luckLevel = 0;
    public static final Predicate<LivingEntity> TARGET_BABY = animal -> animal.isBaby();

    protected EntityShoebill(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.shoebillSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.SHOEBILL_HURT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.SHOEBILL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.SHOEBILL_HURT.get();
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev && source.getEntity() != null && !(source.getEntity() instanceof AbstractFish)) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.getRandom().nextInt(150);
            List list = this.level().getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(range, range / 2.0, range));
            for (EntityShoebill gaz : list) {
                gaz.revengeCooldown = fleeTime;
            }
        }
        return prev;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 0.7f, false);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AnimalAIWadeSwimming((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ShoebillAIFish(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(4, (Goal)new ShoebillAIFlightFlee(this));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.SHOEBILL_FOODSTUFFS), false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 1400));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, new EntityAINearestTarget3D<AbstractFish>((Mob)this, AbstractFish.class, 30, false, true, null));
        this.targetSelector.addGoal(2, new CreatureAITargetItems((PathfinderMob)this, false, 10));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityAlligatorSnappingTurtle.class, 40, false, false, TARGET_BABY));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 40, false, false, TARGET_BABY));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityCrocodile.class, 40, false, false, TARGET_BABY));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityCaiman.class, 40, false, false, TARGET_BABY));
        this.targetSelector.addGoal(8, new EntityAINearestTarget3D<EntityTerrapin>((Mob)this, EntityTerrapin.class, 100, false, true, null));
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void tick() {
        super.tick();
        if (this.isInWater()) {
            // empty if block
        }
        this.prevFlyProgress = this.flyProgress;
        boolean flying = this.isFlying();
        if (flying) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.revengeCooldown > 0) {
            --this.revengeCooldown;
        }
        if (this.revengeCooldown == 0 && this.getLastHurtByMob() != null) {
            this.setLastHurtByMob(null);
        }
        if (!this.level().isClientSide) {
            if (this.fishingCooldown > 0) {
                --this.fishingCooldown;
            }
            if (this.getAnimation() == NO_ANIMATION && this.getRandom().nextInt(700) == 0) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            if (flying) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.revengeCooldown > 0 && !this.isFlying() && (this.onGround() || this.isInWater())) {
                this.setFlying(false);
            }
            if (this.isFlying()) {
                this.setNoGravity(true);
            } else {
                this.setNoGravity(false);
            }
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 9 && this.hasLineOfSight((Entity)this.getTarget())) {
            this.getTarget().knockback((double)0.3f, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
            this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putInt("FishingTimer", this.fishingCooldown);
        compound.putInt("FishingLuck", this.luckLevel);
        compound.putInt("FishingLure", this.lureLevel);
        compound.putInt("RevengeCooldownTimer", this.revengeCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.fishingCooldown = compound.getInt("FishingTimer");
        this.luckLevel = compound.getInt("FishingLuck");
        this.lureLevel = compound.getInt("FishingLure");
        this.revengeCooldown = compound.getInt("RevengeCooldownTimer");
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_FISH, ANIMATION_BEAKSHAKE, ANIMATION_ATTACK};
    }

    public InteractionResult mobInteract(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.getItemInHand(p_230254_2_);
        if (lvt_3_1_.is(AMTagRegistry.SHOEBILL_LUCK_FOODS) && this.isAlive()) {
            if (this.luckLevel < 10) {
                this.luckLevel = Mth.clamp((int)(this.luckLevel + 1), (int)0, (int)10);
                for (int i = 0; i < 6 + this.random.nextInt(3); ++i) {
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, lvt_3_1_), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
                lvt_3_1_.shrink(1);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            return InteractionResult.SUCCESS;
        }
        if (lvt_3_1_.is(AMTagRegistry.SHOEBILL_LURE_FOODS) && this.isAlive()) {
            if (this.lureLevel < 10) {
                this.lureLevel = Mth.clamp((int)(this.lureLevel + 1), (int)0, (int)10);
                this.fishingCooldown = Mth.clamp((int)(this.fishingCooldown - 200), (int)200, (int)2400);
                for (int i = 0; i < 6 + this.random.nextInt(3); ++i) {
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, lvt_3_1_), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
                lvt_3_1_.shrink(1);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_BEAKSHAKE);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_230254_1_, p_230254_2_);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.SHOEBILL.get()).create((Level)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.SHOEBILL_FOODSTUFFS) || stack.is(AMTagRegistry.SHOEBILL_LUCK_FOODS) && this.luckLevel < 10 || stack.is(AMTagRegistry.SHOEBILL_LURE_FOODS) && this.lureLevel < 10;
    }

    public void resetFishingCooldown() {
        this.fishingCooldown = Math.max(1200 + this.random.nextInt(1200) - this.lureLevel * 120, 200);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.gameEvent((Holder)GameEvent.EAT);
        this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
        if (e.getItem().is(AMTagRegistry.SHOEBILL_LUCK_FOODS)) {
            this.luckLevel = Mth.clamp((int)(this.luckLevel + 1), (int)0, (int)10);
        } else if (e.getItem().is(AMTagRegistry.SHOEBILL_LURE_FOODS)) {
            this.lureLevel = Mth.clamp((int)(this.lureLevel + 1), (int)0, (int)10);
        }
        this.heal(5.0f);
    }
}

