/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.EventHooks;

public class EntitySharkToothArrow
extends Arrow {
    public EntitySharkToothArrow(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public EntitySharkToothArrow(EntityType type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.setPos(x, y, z);
    }

    public EntitySharkToothArrow(Level worldIn, LivingEntity shooter) {
        this((EntityType)AMEntityRegistry.SHARK_TOOTH_ARROW.get(), shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ(), worldIn);
        this.setOwner((Entity)shooter);
        if (shooter instanceof Player) {
            this.pickup = AbstractArrow.Pickup.ALLOWED;
        }
    }

    protected void damageShield(Player player, float damage) {
        if (damage >= 3.0f && player.getUseItem().getItem().canPerformAction(player.getUseItem(), ItemAbilities.SHIELD_BLOCK)) {
            ItemStack copyBeforeUse = player.getUseItem().copy();
            int i = 1 + Mth.floor((float)damage);
            player.getUseItem().hurtAndBreak(i, (LivingEntity)player, EquipmentSlot.MAINHAND);
            if (player.getUseItem().isEmpty()) {
                InteractionHand Hand = player.getUsedItemHand();
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copyBeforeUse, (InteractionHand)Hand);
                if (Hand == InteractionHand.MAIN_HAND) {
                    // empty if block
                }
                player.stopUsingItem();
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        if (living instanceof Player) {
            this.damageShield((Player)living, (float)this.getBaseDamage());
        }
        Entity entity1 = this.getOwner();
        if (living.getType().is(EntityTypeTags.ARTHROPOD) || living instanceof Drowned || !living.getType().is(EntityTypeTags.UNDEAD) && living.canBreatheUnderwater()) {
            DamageSource damagesource = entity1 == null ? this.damageSources().arrow((AbstractArrow)this, (Entity)this) : this.damageSources().arrow((AbstractArrow)this, entity1);
            living.hurt(damagesource, 7.0f);
        }
    }

    public boolean isInWater() {
        return false;
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)AMItemRegistry.SHARK_TOOTH_ARROW.get());
    }
}

