/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntitySeaBear
extends WaterAnimal
implements IAnimatedEntity {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)17);
    public static final Animation ANIMATION_POINT = Animation.create((int)25);
    public float prevOnLandProgress;
    public float onLandProgress;
    public int circleCooldown = 0;
    private int animationTick;
    private Animation currentAnimation;
    private BlockPos lastCircle = null;
    public static final Predicate<LivingEntity> SOMBRERO = player -> player.getItemBySlot(EquipmentSlot.HEAD).is((Item)AMItemRegistry.SOMBRERO.get());

    protected EntitySeaBear(EntityType entityType, Level level) {
        super(entityType, level);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f, 10.0f);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.requiresCustomPersistence();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.325f);
    }

    public static boolean isMobSafe(Entity entity) {
        if (entity instanceof Player && ((Player)entity).isCreative()) {
            return true;
        }
        BlockState state = entity.level().getBlockState(entity.blockPosition().below());
        return state.is((Block)AMBlockRegistry.SAND_CIRCLE.get()) || state.is((Block)AMBlockRegistry.RED_SAND_CIRCLE.get());
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.GRIZZLY_BEAR_DIE.get();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AttackAI());
        this.goalSelector.addGoal(3, (Goal)new AvoidCircleAI());
        this.goalSelector.addGoal(4, (Goal)new AnimalAISwimBottom((PathfinderMob)this, 1.0, 7){

            public boolean canUse() {
                return super.canUse() && EntitySeaBear.this.getAnimation() == IAnimatedEntity.NO_ANIMATION;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && EntitySeaBear.this.getAnimation() == IAnimatedEntity.NO_ANIMATION;
            }
        });
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, SOMBRERO));
    }

    public void tick() {
        super.tick();
        this.prevOnLandProgress = this.onLandProgress;
        if (this.isInWater()) {
            if (this.onLandProgress > 0.0f) {
                this.onLandProgress -= 1.0f;
            }
        } else if (this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (this.onGround() && !this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (this.circleCooldown > 0) {
            --this.circleCooldown;
            this.setTarget(null);
            this.setLastHurtByMob(null);
        }
        if (this.getAnimation() == ANIMATION_POINT) {
            this.yBodyRot = this.getYHeadRot();
            this.rotOffs = this.getYHeadRot();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new SemiAquaticPathNavigator((Mob)this, worldIn);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canCollideWith(Entity e) {
        return !EntitySeaBear.isMobSafe(e);
    }

    public void travel(Vec3 travelVector) {
        if (this.getAnimation() == ANIMATION_POINT) {
            super.travel(Vec3.ZERO);
        } else if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_POINT, ANIMATION_ATTACK};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void setTarget(@Nullable LivingEntity entity) {
        if (entity == null || !EntitySeaBear.isMobSafe((Entity)entity)) {
            super.setTarget(entity);
        }
    }

    public void push(Entity entity) {
        if (!EntitySeaBear.isMobSafe(entity)) {
            super.push(entity);
        }
    }

    private class AttackAI
    extends Goal {
        public AttackAI() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntitySeaBear.this.getTarget() != null && EntitySeaBear.this.getTarget().isInWaterOrBubble() && EntitySeaBear.this.getTarget().isAlive() && (EntitySeaBear.this.circleCooldown == 0 || EntitySeaBear.this.getAnimation() == ANIMATION_POINT);
        }

        public void tick() {
            LivingEntity enemy = EntitySeaBear.this.getTarget();
            if (EntitySeaBear.this.getAnimation() == ANIMATION_POINT) {
                EntitySeaBear.this.getNavigation().stop();
                EntitySeaBear.this.setDeltaMovement(EntitySeaBear.this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
                EntitySeaBear.this.lookAt((Entity)enemy, 360.0f, 50.0f);
            } else if (EntitySeaBear.isMobSafe((Entity)enemy) && EntitySeaBear.this.distanceTo((Entity)enemy) < 6.0f) {
                EntitySeaBear.this.circleCooldown = 100 + EntitySeaBear.this.random.nextInt(100);
                EntitySeaBear.this.setAnimation(ANIMATION_POINT);
                EntitySeaBear.this.lookAt((Entity)enemy, 360.0f, 50.0f);
                EntitySeaBear.this.lastCircle = enemy.blockPosition();
            } else {
                EntitySeaBear.this.getNavigation().moveTo(enemy.getX(), enemy.getY(0.5), enemy.getZ(), 1.6);
                if (EntitySeaBear.this.hasLineOfSight((Entity)enemy) && EntitySeaBear.this.distanceTo((Entity)enemy) < 3.5f) {
                    EntitySeaBear.this.setAnimation(ANIMATION_ATTACK);
                    if (EntitySeaBear.this.getAnimationTick() % 5 == 0) {
                        enemy.hurt(EntitySeaBear.this.damageSources().mobAttack((LivingEntity)EntitySeaBear.this), 6.0f);
                    }
                }
            }
        }
    }

    private class AvoidCircleAI
    extends Goal {
        private Vec3 target = null;

        public AvoidCircleAI() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntitySeaBear.this.circleCooldown > 0 && EntitySeaBear.this.lastCircle != null && EntitySeaBear.this.getAnimation() != ANIMATION_POINT;
        }

        public void tick() {
            BlockPos pos = EntitySeaBear.this.lastCircle;
            if (this.target == null || EntitySeaBear.this.distanceToSqr(this.target) < 2.0 || !EntitySeaBear.this.level().getFluidState(AMBlockPos.fromVec3(this.target).above()).is(FluidTags.WATER)) {
                this.target = DefaultRandomPos.getPosAway((PathfinderMob)EntitySeaBear.this, (int)20, (int)7, (Vec3)Vec3.atCenterOf((Vec3i)pos));
            }
            if (this.target != null && EntitySeaBear.this.level().getFluidState(AMBlockPos.fromVec3(this.target).above()).is(FluidTags.WATER)) {
                EntitySeaBear.this.getNavigation().moveTo(this.target.x, this.target.y, this.target.z, 1.0);
            }
        }
    }
}

