/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.MovementControllerCustomCollisions;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityRockyRoller
extends Monster
implements ICustomCollisions {
    private static final EntityDataAccessor<Boolean> ROLLING = SynchedEntityData.defineId(EntityRockyRoller.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityRockyRoller.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float rollProgress;
    public float prevRollProgress;
    public int rollCounter = 0;
    public float clientRoll = 0.0f;
    private int maxRollTime = 50;
    private Vec3 rollDelta;
    private float rollYRot;
    private int rollCooldown = 0;
    private int earthquakeCooldown = 0;

    protected EntityRockyRoller(EntityType<? extends Monster> monster, Level level) {
        super(monster, level);
        this.xpReward = 8;
        this.moveControl = new MovementControllerCustomCollisions((Mob)this);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.rockyRollerSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean checkRockyRollerSpawnRules(EntityType<? extends Monster> animal, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && EntityRockyRoller.isDarkEnoughToSpawn((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)random) && (worldIn.getBlockState(pos.below()).is(AMTagRegistry.ROCKY_ROLLER_SPAWNS) || worldIn.getBlockState(pos.below()).isSolid());
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ARMOR, 20.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.7f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new Navigator((Mob)this, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AIMelee());
        this.goalSelector.addGoal(2, (Goal)new AIRollIdle(this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANGRY, (Object)false);
        builder.define(ROLLING, (Object)false);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.ROCKY_ROLLER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.ROCKY_ROLLER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.ROCKY_ROLLER_HURT.get();
    }

    public void tick() {
        super.tick();
        this.prevRollProgress = this.rollProgress;
        if (this.isRolling()) {
            if (this.rollProgress < 5.0f) {
                this.rollProgress += 1.0f;
            }
        } else if (this.rollProgress > 0.0f) {
            this.rollProgress -= 1.0f;
        }
        if (!this.level().isClientSide) {
            this.setAngry(this.getTarget() != null && this.getTarget().isAlive() && this.distanceToSqr((Entity)this.getTarget()) < 400.0);
        }
        if (this.isRolling() && this.rollCooldown <= 0) {
            this.handleRoll();
            if (this.isAngry() && this.isAlive()) {
                for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)0.3f))) {
                    if (this.isAlliedTo(entity) || entity == this) continue;
                    entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (this.isTarget(entity) ? 5.0f : 2.0f) + this.random.nextFloat() * 2.0f);
                    this.launch(entity, this.isTarget(entity));
                    if (!this.isTarget(entity)) continue;
                    this.maxRollTime = this.rollCounter + 10;
                }
            }
            if (this.rollCounter > 2 && !this.isMoving() || !this.isAlive()) {
                this.setRolling(false);
            }
        } else {
            this.rollCounter = 0;
        }
        if (this.rollCooldown > 0) {
            --this.rollCooldown;
        }
        if (this.earthquakeCooldown > 0) {
            --this.earthquakeCooldown;
        }
    }

    private boolean isMoving() {
        return this.getDeltaMovement().lengthSqr() > 0.02;
    }

    private void earthquake() {
        boolean flag = false;
        List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(6.0, 8.0, 6.0));
        for (LivingEntity e : list) {
            if (e instanceof EntityRockyRoller || !e.isAlive()) continue;
            e.addEffect(new MobEffectInstance(AMEffectRegistry.EARTHQUAKE, 20, 0, false, false, true));
            flag = true;
        }
        if (!this.level().canSeeSky(this.blockPosition()) && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            BlockPos ceil = this.blockPosition().offset(0, 2, 0);
            while (!(this.level().getBlockState(ceil).isSolid() && this.level().getBlockState(ceil).getBlock() != Blocks.POINTED_DRIPSTONE || ceil.getY() >= this.level().getMaxBuildHeight())) {
                ceil = ceil.above();
            }
            int i = 2 + this.random.nextInt(2);
            int j = 2 + this.random.nextInt(2);
            int k = 2 + this.random.nextInt(2);
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            double fTimesF = f * f;
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)ceil.offset(-i, -j, -k), (BlockPos)ceil.offset(i, j, k))) {
                if (!(blockpos1.distSqr((Vec3i)ceil) <= fTimesF) || !(this.level().getBlockState(blockpos1).getBlock() instanceof Fallable)) continue;
                if (this.isHangingDripstone(blockpos1)) {
                    while (this.isHangingDripstone(blockpos1.above()) && blockpos1.getY() < this.level().getMaxBuildHeight()) {
                        blockpos1 = blockpos1.above();
                    }
                    if (this.isHangingDripstone(blockpos1)) {
                        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos1);
                        FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)this.level(), (BlockPos)new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z), (BlockState)this.level().getBlockState(blockpos1));
                        this.level().destroyBlock(blockpos1, false);
                        this.level().addFreshEntity((Entity)fallingblockentity);
                    }
                } else {
                    this.level().scheduleTick(blockpos1, this.level().getBlockState(blockpos1).getBlock(), 2);
                }
                flag = true;
            }
        }
        if (flag) {
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.playSound((SoundEvent)AMSoundRegistry.ROCKY_ROLLER_EARTHQUAKE.get(), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    private boolean isHangingDripstone(BlockPos pos) {
        return this.level().getBlockState(pos).getBlock() instanceof PointedDripstoneBlock && this.level().getBlockState(pos).getValue((Property)PointedDripstoneBlock.TIP_DIRECTION) == Direction.DOWN;
    }

    private boolean isTarget(Entity entity) {
        return this.getTarget() != null && this.getTarget().is(entity);
    }

    public boolean isRolling() {
        return (Boolean)this.entityData.get(ROLLING);
    }

    public void setRolling(boolean rolling) {
        this.entityData.set(ROLLING, (Object)rolling);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
    }

    private void handleRoll() {
        ++this.rollCounter;
        if (!this.level().isClientSide) {
            if (this.horizontalCollision && this.earthquakeCooldown == 0 & this.isAngry()) {
                this.earthquakeCooldown = this.maxRollTime;
                this.earthquake();
            }
            if (this.rollCounter > this.maxRollTime) {
                this.setRolling(false);
                this.rollCooldown = 10 + this.random.nextInt(10);
                this.rollCounter = 0;
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                Vec3 vec3 = this.getDeltaMovement();
                if (this.rollCounter == 1) {
                    float f = this.getYRot() * ((float)Math.PI / 180);
                    float f1 = this.isBaby() ? 0.2f : 0.35f;
                    this.rollYRot = this.getYRot();
                    this.rollDelta = new Vec3(vec3.x + (double)(-Mth.sin((float)f) * f1), 0.0, vec3.z + (double)(Mth.cos((float)f) * f1));
                    this.setDeltaMovement(this.rollDelta.add(0.0, 0.27, 0.0));
                } else {
                    this.setYRot(this.rollYRot);
                    this.setYHeadRot(this.rollYRot);
                    this.setYBodyRot(this.rollYRot);
                    this.setDeltaMovement(this.rollDelta.x, vec3.y, this.rollDelta.z);
                }
            }
        }
    }

    private void rollFor(int time) {
        if (this.rollCooldown == 0) {
            this.maxRollTime = time;
            this.earthquakeCooldown = 0;
            this.setRolling(true);
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.onGround()) {
            double d0 = e.getX() - this.getX();
            double d1 = e.getZ() - this.getZ();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 1.0f : 0.35f;
            e.push(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.equals("fallingStalactite") || super.isInvulnerableTo(source);
    }

    public int getMaxFallDistance() {
        return super.getMaxFallDistance() * 2;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public void push(Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().add(this.getDeltaMovement()));
    }

    public boolean canPassThrough(BlockPos blockPos, BlockState blockstate, VoxelShape voxelShape) {
        return blockstate.getBlock() instanceof PointedDripstoneBlock;
    }

    public boolean isColliding(BlockPos pos, BlockState blockstate) {
        return !(blockstate.getBlock() instanceof PointedDripstoneBlock) && super.isColliding(pos, blockstate);
    }

    public Vec3 collide(Vec3 vec3) {
        return ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vec3)vec3);
    }

    public boolean hurt(DamageSource dmg, float amount) {
        LivingEntity livingentity;
        Entity entity;
        if (!(this.isMoving() || dmg.is(DamageTypes.MAGIC) || !((entity = dmg.getDirectEntity()) instanceof LivingEntity) || (livingentity = (LivingEntity)entity) instanceof EntityRockyRoller || dmg.is(DamageTypes.EXPLOSION) || livingentity.hurtMarked)) {
            livingentity.hurt(this.damageSources().thorns((Entity)this), 2.0f);
        }
        return super.hurt(dmg, amount);
    }

    static class Navigator
    extends AdvancedPathNavigateNoTeleport {
        public Navigator(Mob mob, Level world) {
            super(mob, world, true);
        }

        protected PathFinder createPathFinder(int i) {
            this.nodeEvaluator = new RockyRollerNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, i);
        }
    }

    private class AIMelee
    extends Goal {
        private BlockPos rollFromPos = null;
        private int rollTimeout = 0;

        public AIMelee() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityRockyRoller.this.getTarget() != null && EntityRockyRoller.this.getTarget().isAlive() && !EntityRockyRoller.this.isRolling();
        }

        public void tick() {
            LivingEntity enemy = EntityRockyRoller.this.getTarget();
            double d0 = this.validRollDistance(enemy);
            double distToEnemySqr = EntityRockyRoller.this.distanceTo((Entity)enemy);
            if (this.rollFromPos == null || enemy.distanceToSqr((double)((float)this.rollFromPos.getX() + 0.5f), (double)((float)this.rollFromPos.getY() + 0.5f), (double)this.rollFromPos.getZ() + 0.5) > 60.0 || !this.canEntitySeePosition(enemy, this.rollFromPos)) {
                this.rollFromPos = this.getRollAtPosition((Entity)enemy);
            }
            EntityRockyRoller.this.lookAt((Entity)enemy, 100.0f, 5.0f);
            if (this.rollTimeout < 40 && this.rollFromPos != null && distToEnemySqr <= d0 && EntityRockyRoller.this.distanceToSqr((float)this.rollFromPos.getX() + 0.5f, (float)this.rollFromPos.getY() + 0.5f, (double)this.rollFromPos.getZ() + 0.5) > 2.25) {
                EntityRockyRoller.this.getNavigation().moveTo((double)((float)this.rollFromPos.getX() + 0.5f), (double)((float)this.rollFromPos.getY() + 0.5f), (double)((float)this.rollFromPos.getZ() + 0.5f), 1.6);
                ++this.rollTimeout;
            } else {
                double d1 = enemy.getX() - EntityRockyRoller.this.getX();
                double d2 = enemy.getZ() - EntityRockyRoller.this.getZ();
                float f = (float)(Mth.atan2((double)d2, (double)d1) * 57.2957763671875) - 90.0f;
                EntityRockyRoller.this.setYRot(f);
                EntityRockyRoller.this.yBodyRot = f;
                EntityRockyRoller.this.rollFor(30 + EntityRockyRoller.this.random.nextInt(40));
            }
        }

        public void stop() {
            super.stop();
            this.rollTimeout = 0;
        }

        protected double validRollDistance(LivingEntity attackTarget) {
            return 3.0f + attackTarget.getBbWidth();
        }

        private boolean canEntitySeePosition(LivingEntity entity, BlockPos destinationBlock) {
            Vec3 Vector3d = new Vec3(entity.getX(), entity.getY() + 0.5, entity.getZ());
            Vec3 blockVec = Vec3.atCenterOf((Vec3i)destinationBlock);
            BlockHitResult result = entity.level().clip(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
            return result != null && (result.getBlockPos().equals((Object)destinationBlock) || entity.level().getBlockState(result.getBlockPos()).getBlock() == Blocks.POINTED_DRIPSTONE);
        }

        public BlockPos getRollAtPosition(Entity target) {
            float radius = (float)(EntityRockyRoller.this.getRandom().nextInt(2) + 6) + target.getBbWidth();
            int orbit = EntityRockyRoller.this.getRandom().nextInt(360);
            float angle = (float)Math.PI / 180 * (float)orbit;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos circlePos = new BlockPos((int)(target.getX() + extraX), (int)target.getEyeY(), (int)(target.getZ() + extraZ));
            while (!EntityRockyRoller.this.level().getBlockState(circlePos).isAir() && circlePos.getY() < EntityRockyRoller.this.level().getMaxBuildHeight()) {
                circlePos = circlePos.above();
            }
            while (!EntityRockyRoller.this.level().getBlockState(circlePos.below()).entityCanStandOn((BlockGetter)EntityRockyRoller.this.level(), circlePos.below(), (Entity)EntityRockyRoller.this) && circlePos.getY() > 1) {
                circlePos = circlePos.below();
            }
            if (EntityRockyRoller.this.getWalkTargetValue(circlePos) > -1.0f) {
                return circlePos;
            }
            return null;
        }
    }

    class AIRollIdle
    extends Goal {
        EntityRockyRoller rockyRoller;

        public AIRollIdle(EntityRockyRoller p_29328_) {
            this.rockyRoller = p_29328_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (this.rockyRoller.onGround()) {
                if (this.rockyRoller.isRolling() || this.rockyRoller.rollCooldown > 0 || this.rockyRoller.getTarget() != null && this.rockyRoller.getTarget().isAlive()) {
                    return false;
                }
                float f = this.rockyRoller.getYRot() * ((float)Math.PI / 180);
                int i = 0;
                int j = 0;
                float f1 = -Mth.sin((float)f);
                float f2 = Mth.cos((float)f);
                if ((double)Math.abs(f1) > 0.5) {
                    i = (int)((float)i + f1 / Math.abs(f1));
                }
                if ((double)Math.abs(f2) > 0.5) {
                    j = (int)((float)j + f2 / Math.abs(f2));
                }
                return this.rockyRoller.level().getBlockState(this.rockyRoller.blockPosition().offset(i, -1, j)).isAir();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.rockyRoller.rollFor(30 + EntityRockyRoller.this.random.nextInt(30));
        }

        public boolean isInterruptable() {
            return false;
        }
    }

    static class RockyRollerNodeEvaluator
    extends WalkNodeEvaluator {
        RockyRollerNodeEvaluator() {
        }

        protected PathType getPathTypeOfMob(BlockGetter level, BlockPos pos, PathType typeIn) {
            return level.getBlockState(pos).getBlock() instanceof PointedDripstoneBlock ? PathType.OPEN : typeIn;
        }
    }
}

