/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityRhinoceros
extends Animal
implements IAnimatedEntity {
    public static final Animation ANIMATION_FLICK_EARS = Animation.create((int)20);
    public static final Animation ANIMATION_EAT_GRASS = Animation.create((int)35);
    public static final Animation ANIMATION_FLING = Animation.create((int)15);
    public static final Animation ANIMATION_SLASH = Animation.create((int)30);
    private static final EntityDataAccessor<String> APPLIED_POTION = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> POTION_LEVEL = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> INFLICTED_COUNT = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> POTION_DURATION = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityRhinoceros.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Object2IntMap<String> potionToColor = new Object2IntOpenHashMap();
    private int animationTick;
    private Animation currentAnimation;

    protected EntityRhinoceros(EntityType type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 12.0).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.ATTACK_KNOCKBACK, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TRUSTED_ID_0, Optional.empty());
        builder.define(DATA_TRUSTED_ID_1, Optional.empty());
        builder.define(APPLIED_POTION, (Object)"");
        builder.define(POTION_LEVEL, (Object)0);
        builder.define(INFLICTED_COUNT, (Object)0);
        builder.define(POTION_DURATION, (Object)0);
        builder.define(ANGRY, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.goalSelector.addGoal(2, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.RHINOCEROS_FOODSTUFFS), new Ingredient.TagValue(AMTagRegistry.RHINOCEROS_BREEDABLES))), false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 90, 1.0, 18, 7));
        this.goalSelector.addGoal(7, (Goal)new StrollGoal(200));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new DefendTrustedTargetGoal(LivingEntity.class, false, false, entity -> !this.trusts(entity.getUUID())));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal<Raider>((Mob)this, Raider.class, 50, true, true, null){

            public boolean canUse() {
                return super.canUse() && !EntityRhinoceros.this.isBaby();
            }
        });
        this.targetSelector.addGoal(3, (Goal)new AIAttackNearPlayers());
        this.targetSelector.addGoal(4, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, worldIn, true);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.rhinocerosSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public void tick() {
        super.tick();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.level().isClientSide) {
            LivingEntity target;
            if (!(this.getAnimation() != NO_ANIMATION || this.getTarget() != null && this.getTarget().isAlive())) {
                if (this.getDeltaMovement().lengthSqr() < 0.03 && this.getRandom().nextInt(500) == 0 && this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                    this.setAnimation(ANIMATION_EAT_GRASS);
                } else if (this.getRandom().nextInt(200) == 0) {
                    this.setAnimation(ANIMATION_FLICK_EARS);
                }
            }
            if (this.getAnimation() == ANIMATION_EAT_GRASS && this.getAnimationTick() == 30 && this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK)) {
                BlockPos down = this.blockPosition().below();
                this.level().levelEvent(2001, down, Block.getId((BlockState)Blocks.GRASS_BLOCK.defaultBlockState()));
                this.level().setBlock(down, Blocks.DIRT.defaultBlockState(), 2);
                this.heal(10.0f);
            }
            if ((target = this.getTarget()) != null && target.isAlive()) {
                this.setAngry(this.distanceTo((Entity)target) < 20.0f);
                double dist = this.distanceTo((Entity)target);
                if (this.hasLineOfSight((Entity)target)) {
                    this.lookAt((Entity)target, 30.0f, 30.0f);
                    this.yBodyRot = this.getYRot();
                }
                if (dist < (double)(this.getBbWidth() + 3.0f)) {
                    if (this.getAnimation() == NO_ANIMATION) {
                        this.setAnimation(this.random.nextBoolean() ? ANIMATION_SLASH : ANIMATION_FLING);
                    }
                    if (dist < (double)(this.getBbWidth() + 1.5f) && this.hasLineOfSight((Entity)target)) {
                        float dmg;
                        if (this.getAnimation() == ANIMATION_FLING && this.getAnimationTick() >= 5 && this.getAnimationTick() <= 8) {
                            dmg = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
                            if (target instanceof Raider) {
                                dmg = 10.0f;
                            }
                            this.attackWithPotion(target, dmg);
                            this.launch((Entity)target, 0.0f, 1.0f);
                            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0))) {
                                if (entity instanceof Animal || this.trusts(entity.getUUID()) || entity == target) continue;
                                this.attackWithPotion(entity, Math.max(dmg - 5.0f, 1.0f));
                                this.launch((Entity)entity, 0.0f, 0.5f);
                            }
                        }
                        if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() >= 9 && this.getAnimationTick() <= 11 || this.getAnimationTick() >= 19 && this.getAnimationTick() <= 21)) {
                            dmg = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
                            if (target instanceof Raider) {
                                dmg = 10.0f;
                            }
                            this.attackWithPotion(target, dmg);
                            this.launch((Entity)target, this.getAnimationTick() <= 15 ? -90.0f : 90.0f, 1.0f);
                            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0))) {
                                if (entity instanceof Animal || this.trusts(entity.getUUID()) || entity == target) continue;
                                this.attackWithPotion(entity, Math.max(dmg - 5.0f, 1.0f));
                                this.launch((Entity)entity, this.getAnimationTick() <= 15 ? -90.0f : 90.0f, 0.5f);
                            }
                        }
                    }
                }
            } else {
                this.setAngry(false);
            }
        }
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!this.isBaby()) {
            this.playSound((SoundEvent)AMSoundRegistry.ELEPHANT_WALK.get(), 0.2f, 1.2f);
        } else {
            super.playStepSound(pos, state);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.RHINOCEROS_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.RHINOCEROS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.RHINOCEROS_HURT.get();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.RHINOCEROS_BREEDABLES);
    }

    public String getAppliedPotionId() {
        return (String)this.entityData.get(APPLIED_POTION);
    }

    public void setAppliedPotionId(String potionId) {
        this.entityData.set(APPLIED_POTION, (Object)potionId);
    }

    public int getPotionColor() {
        String s = this.getAppliedPotionId();
        if (s.isEmpty()) {
            return -1;
        }
        if (!potionToColor.containsKey((Object)s)) {
            MobEffect effect;
            Holder<MobEffect> effectHolder = this.getPotionEffect();
            MobEffect mobEffect = effect = effectHolder != null ? (MobEffect)effectHolder.value() : null;
            if (effect != null) {
                int color = effect.getColor();
                potionToColor.put((Object)s, color);
                return color;
            }
            return -1;
        }
        return potionToColor.getInt((Object)s);
    }

    public Holder<MobEffect> getPotionEffect() {
        ResourceLocation loc = ResourceLocation.parse((String)this.getAppliedPotionId());
        return BuiltInRegistries.MOB_EFFECT.getHolder(loc).orElse(null);
    }

    public int getPotionDuration() {
        return (Integer)this.entityData.get(POTION_DURATION);
    }

    public void setPotionDuration(int time) {
        this.entityData.set(POTION_DURATION, (Object)time);
    }

    public int getPotionLevel() {
        return (Integer)this.entityData.get(POTION_LEVEL);
    }

    public void setPotionLevel(int time) {
        this.entityData.set(POTION_LEVEL, (Object)time);
    }

    public int getInflictedCount() {
        return (Integer)this.entityData.get(INFLICTED_COUNT);
    }

    public void setInflictedCount(int count) {
        this.entityData.set(INFLICTED_COUNT, (Object)count);
    }

    public void resetPotion() {
        this.setAppliedPotionId("");
        this.setPotionDuration(0);
        this.setPotionLevel(0);
        this.setInflictedCount(0);
    }

    private List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.entityData.get(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    private void addTrustedUUID(@javax.annotation.Nullable UUID p_28516_) {
        if (((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    private void launch(Entity launch, float angle, float scale) {
        float rot = 180.0f + angle + this.getYRot();
        float hugeScale = 1.0f + this.random.nextFloat() * 0.5f * scale;
        float strength = (float)((double)hugeScale * (1.0 - ((LivingEntity)launch).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)));
        float rotRad = rot * ((float)Math.PI / 180);
        float x = Mth.sin((float)rotRad);
        float z = -Mth.cos((float)rotRad);
        launch.hasImpulse = true;
        Vec3 vec3 = this.getDeltaMovement();
        Vec3 vec31 = vec3.add(new Vec3((double)x, 0.0, (double)z).normalize().scale((double)strength));
        launch.setDeltaMovement(vec31.x, (double)(hugeScale * 0.3f), vec31.z);
        launch.setOnGround(false);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    private boolean trusts(UUID uuid) {
        return this.getTrustedUUIDs().contains(uuid);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_FLICK_EARS, ANIMATION_EAT_GRASS, ANIMATION_FLING, ANIMATION_SLASH};
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)AMEntityRegistry.RHINOCEROS.get()).create((Level)serverLevel);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
    }

    private void attackWithPotion(LivingEntity target, float dmg) {
        Holder<MobEffect> potion = this.getPotionEffect();
        target.hurt(this.damageSources().mobAttack((LivingEntity)this), dmg);
        if (potion != null) {
            MobEffectInstance instance = new MobEffectInstance(potion, this.getPotionDuration(), this.getPotionLevel());
            if (!target.hasEffect(potion) && target.addEffect(instance)) {
                this.setInflictedCount(this.getInflictedCount() + 1);
            }
        }
        if (this.getInflictedCount() > 15 && this.random.nextInt(3) == 0 || this.getInflictedCount() > 20) {
            this.resetPotion();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.random.nextBoolean() ? ANIMATION_SLASH : ANIMATION_FLING);
        }
        return false;
    }

    public boolean isAlliedTo(Entity entityIn) {
        TamableAnimal tamableAnimal;
        if (entityIn instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entityIn).getOwnerUUID() != null && this.trusts(tamableAnimal.getOwnerUUID())) {
            return true;
        }
        return super.isAlliedTo(entityIn) || this.trusts(entityIn.getUUID());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        tag.put("Trusted", (Tag)listtag);
        tag.putBoolean("Sleeping", this.isSleeping());
        tag.putString("PotionName", this.getAppliedPotionId());
        tag.putInt("PotionLevel", this.getPotionLevel());
        tag.putInt("PotionDuration", this.getPotionDuration());
        tag.putInt("InflictedCount", this.getInflictedCount());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag listtag = tag.getList("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.loadUUID((Tag)listtag.get(i)));
        }
        this.setAppliedPotionId(tag.getString("PotionName"));
        this.setPotionLevel(tag.getInt("PotionLevel"));
        this.setPotionDuration(tag.getInt("PotionDuration"));
        this.setInflictedCount(tag.getInt("InflictedCount"));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (!(this.isBaby() || itemstack.getItem() != Items.POTION && itemstack.getItem() != Items.SPLASH_POTION && itemstack.getItem() != Items.LINGERING_POTION)) {
            Potion contained = null;
            if (this.applyPotion(contained)) {
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                this.playSound(SoundEvents.DYE_USE);
                this.usePlayerItem(player, hand, itemstack);
                ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.addItem(bottle)) {
                    player.drop(bottle, false);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.is(AMTagRegistry.RHINOCEROS_FOODSTUFFS) && !this.trusts(player.getUUID())) {
            this.addTrustedUUID(player.getUUID());
            this.usePlayerItem(player, hand, itemstack);
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.HORSE_EAT);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean applyPotion(Potion potion) {
        MobEffectInstance first;
        ResourceLocation loc;
        if (potion == null || potion == Potions.WATER) {
            this.resetPotion();
            return true;
        }
        if (potion.getEffects().size() >= 1 && (loc = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)(first = (MobEffectInstance)potion.getEffects().get(0)).getEffect().value()))) != null) {
            this.setAppliedPotionId(loc.toString());
            this.setPotionLevel(first.getAmplifier());
            this.setPotionDuration(first.getDuration());
            this.setInflictedCount(0);
            return true;
        }
        return false;
    }

    private boolean trustsAny() {
        return ((Optional)this.entityData.get(DATA_TRUSTED_ID_0)).isPresent() || ((Optional)this.entityData.get(DATA_TRUSTED_ID_1)).isPresent();
    }

    class StrollGoal
    extends MoveThroughVillageGoal {
        public StrollGoal(int timr) {
            super((PathfinderMob)EntityRhinoceros.this, 1.0, true, timr, () -> false);
        }

        public void start() {
            super.start();
        }

        public boolean canUse() {
            return super.canUse() && this.canRhinoWander();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canRhinoWander();
        }

        private boolean canRhinoWander() {
            return !EntityRhinoceros.this.getTrustedUUIDs().isEmpty();
        }
    }

    class DefendTrustedTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        private LivingEntity trustedLastHurtBy;
        private LivingEntity trustedLastHurt;
        private LivingEntity trusted;
        private int timestamp;

        public DefendTrustedTargetGoal(Class<LivingEntity> entities, @javax.annotation.Nullable boolean b, boolean b2, Predicate<LivingEntity> pred) {
            super((Mob)EntityRhinoceros.this, entities, 10, b, b2, pred);
        }

        public boolean canUse() {
            if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0 || this.mob.isBaby()) {
                return false;
            }
            for (UUID uuid : EntityRhinoceros.this.getTrustedUUIDs()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(EntityRhinoceros.this.level() instanceof ServerLevel) || !((entity = ((ServerLevel)EntityRhinoceros.this.level()).getEntity(uuid)) instanceof LivingEntity)) continue;
                this.trusted = livingentity = (LivingEntity)entity;
                this.trustedLastHurtBy = livingentity.getLastHurtByMob();
                this.trustedLastHurt = livingentity.getLastHurtMob();
                int i = livingentity.getLastHurtByMobTimestamp();
                int j = livingentity.getLastHurtMobTimestamp();
                if (i != this.timestamp && this.canAttack(this.trustedLastHurtBy, this.targetConditions)) {
                    return true;
                }
                if (j == this.timestamp || !this.canAttack(this.trustedLastHurt, this.targetConditions)) continue;
                return true;
            }
            return false;
        }

        public void start() {
            if (this.trustedLastHurtBy != null) {
                this.setTarget(this.trustedLastHurtBy);
                this.target = this.trustedLastHurtBy;
                if (this.trusted != null) {
                    this.timestamp = this.trusted.getLastHurtByMobTimestamp();
                }
            } else {
                this.setTarget(this.trustedLastHurt);
                this.target = this.trustedLastHurt;
                if (this.trusted != null) {
                    this.timestamp = this.trusted.getLastHurtMobTimestamp();
                }
            }
            super.start();
        }
    }

    class AIAttackNearPlayers
    extends NearestAttackableTargetGoal<Player> {
        public AIAttackNearPlayers() {
            super((Mob)EntityRhinoceros.this, Player.class, 80, true, true, null);
        }

        public boolean canUse() {
            if (EntityRhinoceros.this.isBaby() || EntityRhinoceros.this.isInLove() || EntityRhinoceros.this.trustsAny()) {
                return false;
            }
            return super.canUse();
        }

        protected double getFollowDistance() {
            return 3.0;
        }
    }
}

