/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityJerboa;
import com.github.alexthe666.alexsmobs.entity.EntityRoadrunner;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EntityRattlesnake
extends Animal
implements IAnimatedEntity {
    public float prevCurlProgress;
    public float curlProgress;
    public int randomToungeTick = 0;
    public int maxCurlTime = 75;
    private int curlTime = 0;
    private static final EntityDataAccessor<Boolean> RATTLING = SynchedEntityData.defineId(EntityRattlesnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CURLED = SynchedEntityData.defineId(EntityRattlesnake.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Predicate<LivingEntity> WARNABLE_PREDICATE = mob -> mob instanceof Player && !((Player)mob).isCreative() && !mob.isSpectator() || mob instanceof EntityRoadrunner;
    private static final Predicate<LivingEntity> TARGETABLE_PREDICATE = mob -> mob instanceof Player && !((Player)mob).isCreative() && !mob.isSpectator() || mob instanceof EntityRoadrunner;
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_BITE = Animation.create((int)20);
    private int loopSoundTick = 0;

    protected EntityRattlesnake(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(2, (Goal)new WarnPredatorsGoal());
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 60, 1.0, 7, 7));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, 15, true, true, null));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityJerboa.class, 15, true, true, null));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new ShortDistanceTarget());
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.RATTLESNAKE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.RATTLESNAKE_HURT.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.rattlesnakeSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean doHurtTarget(Entity entityIn) {
        this.setAnimation(ANIMATION_BITE);
        return true;
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(potioneffectIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CURLED, (Object)false);
        builder.define(RATTLING, (Object)false);
    }

    public boolean isCurled() {
        return (Boolean)this.entityData.get(CURLED);
    }

    public void setCurled(boolean curled) {
        this.entityData.set(CURLED, (Object)curled);
    }

    public boolean isRattling() {
        return (Boolean)this.entityData.get(RATTLING);
    }

    public void setRattling(boolean rattling) {
        this.entityData.set(RATTLING, (Object)rattling);
    }

    public void tick() {
        super.tick();
        this.prevCurlProgress = this.curlProgress;
        if (this.isCurled()) {
            if (this.curlProgress < 5.0f) {
                this.curlProgress += 0.5f;
            }
        } else if (this.curlProgress > 0.0f) {
            this.curlProgress -= 1.0f;
        }
        if (this.randomToungeTick == 0 && this.random.nextInt(15) == 0) {
            this.randomToungeTick = 10 + this.random.nextInt(20);
        }
        if (this.randomToungeTick > 0) {
            --this.randomToungeTick;
        }
        if (this.isCurled() && !this.isRattling() && ++this.curlTime > this.maxCurlTime) {
            this.setCurled(false);
            this.curlTime = 0;
            this.maxCurlTime = 75 + this.random.nextInt(50);
        }
        LivingEntity target = this.getTarget();
        if (!this.level().isClientSide) {
            if (this.isCurled() && target != null && target.isAlive()) {
                this.setCurled(false);
            }
            if (this.isRattling() && target == null) {
                this.setCurled(true);
            }
            if (!this.isCurled() && this.getTarget() == null && this.random.nextInt(500) == 0) {
                this.maxCurlTime = 300 + this.random.nextInt(250);
                this.setCurled(true);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE) {
            if (this.getAnimationTick() == 4) {
                this.playSound((SoundEvent)AMSoundRegistry.RATTLESNAKE_ATTACK.get(), this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.getAnimationTick() == 8 && target != null && (double)this.distanceTo((Entity)target) < 2.0) {
                boolean meepMeep = target instanceof EntityRoadrunner;
                int f = this.isBaby() ? 2 : 1;
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), meepMeep ? 1.0f : (float)f * (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                if (!meepMeep) {
                    target.addEffect(new MobEffectInstance(MobEffects.POISON, 300, f * 2));
                }
            }
        }
        if (this.isRattling()) {
            if (this.loopSoundTick == 0) {
                this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                this.playSound((SoundEvent)AMSoundRegistry.RATTLESNAKE_LOOP.get(), this.getSoundVolume() * 0.5f, this.getVoicePitch());
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 50) {
                this.loopSoundTick = 0;
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void travel(Vec3 vec3d) {
        if (this.onGround() && this.isCurled()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.28f);
    }

    public boolean isFood(ItemStack stack) {
        return stack.has(DataComponents.FOOD) && stack.getItem().getFoodProperties(stack, null) != null;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.RATTLESNAKE.get()).create((Level)p_241840_1_);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public static boolean canRattlesnakeSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.RATTLESNAKE_SPAWNS);
        return spawnBlock && worldIn.getRawBrightness(pos, 0) > 8;
    }

    class WarnPredatorsGoal
    extends Goal {
        int executionChance = 20;
        Entity target = null;

        WarnPredatorsGoal() {
        }

        public boolean canUse() {
            if (EntityRattlesnake.this.getRandom().nextInt(this.executionChance) == 0) {
                double dist = 5.0;
                List list = EntityRattlesnake.this.level().getEntitiesOfClass(LivingEntity.class, EntityRattlesnake.this.getBoundingBox().inflate(5.0, 5.0, 5.0), WARNABLE_PREDICATE);
                double d0 = Double.MAX_VALUE;
                Entity possibleTarget = null;
                for (Entity entity : list) {
                    double d1 = EntityRattlesnake.this.distanceToSqr(entity);
                    if (d1 > d0) continue;
                    d0 = d1;
                    possibleTarget = entity;
                }
                this.target = possibleTarget;
                return !list.isEmpty();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && (double)EntityRattlesnake.this.distanceTo(this.target) < 5.0 && EntityRattlesnake.this.getTarget() == null;
        }

        public void stop() {
            this.target = null;
            EntityRattlesnake.this.setRattling(false);
        }

        public void tick() {
            EntityRattlesnake.this.setRattling(true);
            EntityRattlesnake.this.setCurled(true);
            EntityRattlesnake.this.curlTime = 0;
            EntityRattlesnake.this.getLookControl().setLookAt(this.target, 30.0f, 30.0f);
        }
    }

    class ShortDistanceTarget
    extends NearestAttackableTargetGoal<Player> {
        public ShortDistanceTarget() {
            super((Mob)EntityRattlesnake.this, Player.class, 3, true, true, TARGETABLE_PREDICATE);
        }

        public boolean canUse() {
            if (EntityRattlesnake.this.isBaby()) {
                return false;
            }
            return super.canUse();
        }

        public void start() {
            super.start();
            EntityRattlesnake.this.setCurled(false);
            EntityRattlesnake.this.setRattling(true);
        }

        protected double getFollowDistance() {
            return 2.0;
        }
    }
}

