/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBlueJay;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILootChests;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.ILootsChests;
import com.github.alexthe666.alexsmobs.entity.ai.RaccoonAIBeg;
import com.github.alexthe666.alexsmobs.entity.ai.RaccoonAIWash;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIDestroyTurtleEggs;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidType;

public class EntityRaccoon
extends TamableAnimal
implements IAnimatedEntity,
IFollower,
ITargetsDroppedItems,
ILootsChests {
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BEGGING = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WASHING = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<BlockPos>> WASH_POS = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CARPET_COLOR = SynchedEntityData.defineId(EntityRaccoon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevStandProgress;
    public float standProgress;
    public float prevBegProgress;
    public float begProgress;
    public float prevWashProgress;
    public float washProgress;
    public float prevSitProgress;
    public float sitProgress;
    public int maxStandTime = 75;
    private int standingTime = 0;
    private int stealCooldown = 0;
    public int lookForWaterBeforeEatingTimer = 0;
    private int animationTick;
    private Animation currentAnimation;
    private int pickupItemCooldown = 0;
    @Nullable
    private UUID eggThrowerUUID = null;
    public boolean forcedSit = false;
    public static final Animation ANIMATION_ATTACK = Animation.create((int)12);
    private static final TargetingConditions VILLAGER_STEAL_PREDICATE = TargetingConditions.forCombat().range(20.0).ignoreLineOfSight();
    private static final TargetingConditions IRON_GOLEM_PREDICATE = TargetingConditions.forCombat().range(20.0).ignoreLineOfSight();

    protected EntityRaccoon(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.RACCOON_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.RACCOON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.RACCOON_HURT.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.raccoonSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RaccoonAIWash(this));
        this.goalSelector.addGoal(3, (Goal)new TameableAIFollowOwner(this, 1.3, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.goalSelector.addGoal(7, (Goal)new AnimalAILootChests((Animal)this, 16));
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new RaccoonAIBeg(this, 0.65));
        this.goalSelector.addGoal(10, (Goal)new AnimalAIPanicBaby((Animal)this, 1.25));
        this.goalSelector.addGoal(11, (Goal)new AIStealFromVillagers(this));
        this.goalSelector.addGoal(12, (Goal)new StrollGoal(200));
        this.goalSelector.addGoal(13, (Goal)new TameableAIDestroyTurtleEggs(this, 1.0, 3));
        this.goalSelector.addGoal(14, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 120, 1.0, 14, 7));
        this.goalSelector.addGoal(15, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AnimalAIHurtByTargetNotBaby((Animal)this, new Class[0]));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (entityIn instanceof EntityBlueJay) {
            EntityBlueJay jay = (EntityBlueJay)entityIn;
            return jay.getRaccoonUUID() != null && jay.getRaccoonUUID().equals(this.getUUID());
        }
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.getColor() != null) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
        }
    }

    @Nullable
    public DyeColor getColor() {
        int lvt_1_1_ = (Integer)this.entityData.get(CARPET_COLOR);
        return lvt_1_1_ == -1 ? null : DyeColor.byId((int)lvt_1_1_);
    }

    public void setColor(@Nullable DyeColor color) {
        this.entityData.set(CARPET_COLOR, (Object)(color == null ? -1 : color.getId()));
    }

    public Item getCarpetItemBeingWorn() {
        if (this.getColor() != null) {
            return EntityElephant.DYE_COLOR_ITEM_MAP.get(this.getColor());
        }
        return Items.AIR;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.RACCOON_BREEDABLES);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean owner;
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        boolean bl = owner = this.isTame() && this.isOwnedBy((LivingEntity)player);
        if (itemstack.is(AMTagRegistry.RACCOON_TEAMING_FOODS) && this.bondWithBlueJays(player.getUUID())) {
            this.usePlayerItem(player, hand, itemstack);
            this.level().broadcastEntityEvent((Entity)this, (byte)93);
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.getMainHandItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation(this.getMainHandItem().copy());
            }
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            this.pickupItemCooldown = 60;
            return InteractionResult.SUCCESS;
        }
        if (owner && itemstack.is(ItemTags.WOOL_CARPETS)) {
            DyeColor color = EntityElephant.getCarpetColor(itemstack);
            if (color != this.getColor()) {
                if (this.getColor() != null) {
                    this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
                }
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                this.playSound((SoundEvent)SoundEvents.LLAMA_SWAG.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                itemstack.shrink(1);
                this.setColor(color);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (owner && this.getColor() != null && itemstack.is(Tags.Items.TOOLS_SHEAR)) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            if (this.getColor() != null) {
                this.spawnAtLocation((ItemLike)this.getCarpetItemBeingWorn());
            }
            this.setColor(null);
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && EntityRaccoon.isRaccoonFood(itemstack) && !this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
            if (this.getMainHandItem().isEmpty()) {
                ItemStack copy = itemstack.copy();
                copy.setCount(1);
                this.setItemInHand(InteractionHand.MAIN_HAND, copy);
                this.onEatItem();
                if (itemstack.hasCraftingRemainingItem()) {
                    this.spawnAtLocation(itemstack.getCraftingRemainingItem());
                }
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            } else {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                this.heal(5.0f);
            }
            this.usePlayerItem(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !EntityRaccoon.isRaccoonFood(itemstack) && !player.isShiftKeyDown()) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl2 = sit = this.getCommand() == 2;
            if (sit) {
                this.forcedSit = true;
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.forcedSit = false;
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("RacSitting", this.isSitting());
        compound.putBoolean("ForcedToSit", this.forcedSit);
        compound.putInt("RacCommand", this.getCommand());
        compound.putInt("Carpet", ((Integer)this.entityData.get(CARPET_COLOR)).intValue());
        compound.putInt("StealCooldown", this.stealCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("RacSitting"));
        this.forcedSit = compound.getBoolean("ForcedToSit");
        this.setCommand(compound.getInt("RacCommand"));
        this.entityData.set(CARPET_COLOR, (Object)compound.getInt("Carpet"));
        this.stealCooldown = compound.getInt("StealCooldown");
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public static boolean isRaccoonFood(ItemStack stack) {
        return stack.has(DataComponents.FOOD) || stack.is(AMTagRegistry.RACCOON_FOODSTUFFS);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 9.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 4.0f;
        }
        return super.hurt(source, amount);
    }

    protected void updateControlFlags() {
        boolean flag = !(this.getControllingPassenger() instanceof Mob);
        boolean flag1 = !(this.getVehicle() instanceof Boat);
        boolean flag2 = this.getFirstPassenger() instanceof EntityBlueJay;
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, flag || flag2);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, flag && flag1 || flag2);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, flag || flag2);
    }

    public void tick() {
        super.tick();
        this.prevStandProgress = this.standProgress;
        this.prevBegProgress = this.begProgress;
        this.prevWashProgress = this.washProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isStanding()) {
            if (this.standProgress < 5.0f) {
                this.standProgress += 1.0f;
            }
        } else if (this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (this.isBegging()) {
            if (this.begProgress < 5.0f) {
                this.begProgress += 1.0f;
            }
        } else if (this.begProgress > 0.0f) {
            this.begProgress -= 1.0f;
        }
        if (this.isWashing()) {
            if (this.washProgress < 5.0f) {
                this.washProgress += 1.0f;
            }
        } else if (this.washProgress > 0.0f) {
            this.washProgress -= 1.0f;
        }
        if (this.isSitting()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.random.nextInt(50);
        }
        if (!this.level().isClientSide) {
            if (this.lookForWaterBeforeEatingTimer > 0) {
                --this.lookForWaterBeforeEatingTimer;
            } else if (!this.isWashing() && this.canTargetItem(this.getMainHandItem())) {
                this.onEatItem();
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                this.getMainHandItem().shrink(1);
            }
        }
        if (this.isWashing() && this.getWashPos() != null) {
            BlockPos washingPos = this.getWashPos();
            if (this.distanceToSqr((double)washingPos.getX() + 0.5, (double)washingPos.getY() + 0.5, (double)washingPos.getZ() + 0.5) < 3.0) {
                int j = 0;
                while ((float)j < 4.0f) {
                    double d2 = this.random.nextDouble();
                    double d3 = this.random.nextDouble();
                    Vec3 vector3d = this.getDeltaMovement();
                    this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)washingPos.getX() + d2, (double)((float)washingPos.getY() + 0.8f), (double)washingPos.getZ() + d3, vector3d.x, vector3d.y, vector3d.z);
                    ++j;
                }
            } else {
                this.setWashing(false);
            }
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.hasLineOfSight((Entity)this.getTarget()) && this.distanceTo((Entity)this.getTarget()) < 4.0f && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 5) {
            float f1 = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * -0.06f), 0.0, (double)(Mth.cos((float)f1) * -0.06f)));
            this.getTarget().knockback((double)0.35f, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
            this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        if (this.pickupItemCooldown > 0) {
            --this.pickupItemCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void onEatItem() {
        this.heal(10.0f);
        this.level().broadcastEntityEvent((Entity)this, (byte)92);
        this.gameEvent((Holder)GameEvent.EAT);
        this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
    }

    public void postWashItem(ItemStack stack) {
        if (stack.is(AMTagRegistry.RACCOON_TAMEABLES) && this.eggThrowerUUID != null && !this.isTame()) {
            if (this.getRandom().nextFloat() < 0.3f) {
                this.setTame(true, true);
                this.setOwnerUUID(this.eggThrowerUUID);
                Player player = this.level().getPlayerByUUID(this.eggThrowerUUID);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 92) {
            for (int i = 0; i < 6 + this.random.nextInt(3); ++i) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.MAIN_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
            }
        } else if (id == 93) {
            for (int i = 0; i < 6 + this.random.nextInt(3); ++i) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.GLOW_BERRIES)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
    }

    public boolean isBegging() {
        return (Boolean)this.entityData.get(BEGGING);
    }

    public void setBegging(boolean begging) {
        this.entityData.set(BEGGING, (Object)begging);
    }

    public boolean isWashing() {
        return (Boolean)this.entityData.get(WASHING);
    }

    public void setWashing(boolean washing) {
        this.entityData.set(WASHING, (Object)washing);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STANDING, (Object)false);
        builder.define(SITTING, (Object)false);
        builder.define(BEGGING, (Object)false);
        builder.define(WASHING, (Object)false);
        builder.define(CARPET_COLOR, (Object)-1);
        builder.define(COMMAND, (Object)0);
        builder.define(WASH_POS, Optional.empty());
    }

    public BlockPos getWashPos() {
        return ((Optional)this.entityData.get(WASH_POS)).orElse(null);
    }

    public void setWashPos(BlockPos washingPos) {
        this.entityData.set(WASH_POS, Optional.ofNullable(washingPos));
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_ATTACK) {
            this.maxStandTime = 15;
            this.setStanding(true);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.RACCOON.get()).create((Level)serverWorld);
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting() || this.isWashing()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        super.travel(vec3d);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return EntityRaccoon.isRaccoonFood(stack) && this.pickupItemCooldown == 0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.lookForWaterBeforeEatingTimer = 100;
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        Entity thrower = e.getOwner();
        if (e.getItem().is(AMTagRegistry.RACCOON_TEAMING_FOODS) && thrower != null && this.bondWithBlueJays(thrower.getUUID())) {
            this.level().broadcastEntityEvent((Entity)this, (byte)93);
        } else {
            this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        }
        this.eggThrowerUUID = e.getItem().is(AMTagRegistry.RACCOON_TAMEABLES) && thrower != null ? thrower.getUUID() : null;
    }

    public double getPassengersRidingOffset() {
        return (double)this.getBbHeight() * 0.45;
    }

    private boolean bondWithBlueJays(UUID uuid) {
        AABB allyBox = this.getBoundingBox().inflate(48.0);
        boolean any = false;
        for (EntityBlueJay entity : this.level().getEntitiesOfClass(EntityBlueJay.class, allyBox)) {
            if (entity.getFeedTime() <= 0 || entity.getLastFeederUUID() == null || !entity.getLastFeederUUID().equals(uuid)) continue;
            entity.setRaccoon((Entity)this);
            entity.setFeedTime(0);
            any = true;
        }
        return any;
    }

    @Override
    public boolean isLootable(Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!this.shouldLootItem(inventory.getItem(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLootItem(ItemStack stack) {
        return EntityRaccoon.isRaccoonFood(stack);
    }

    public boolean isHoldingSugar() {
        return this.getMainHandItem().is(AMTagRegistry.RACOON_DISSOLVES);
    }

    public BlockPos getLightPosition() {
        BlockPos pos = AMBlockPos.fromVec3(this.position());
        if (!this.level().getBlockState(pos).canOcclude()) {
            return pos.above();
        }
        return pos;
    }

    public boolean isRigby() {
        String name = ChatFormatting.stripFormatting((String)this.getName().getString());
        if (name == null) {
            return false;
        }
        String lowercaseName = name.toLowerCase(Locale.ROOT);
        return lowercaseName.contains("rigby");
    }

    private class AIStealFromVillagers
    extends Goal {
        EntityRaccoon raccoon;
        AbstractVillager target;
        int golemCheckTime = 0;
        int cooldown = 0;
        int fleeTime = 0;

        private AIStealFromVillagers(EntityRaccoon raccoon) {
            this.raccoon = raccoon;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (this.raccoon != null && this.raccoon.stealCooldown == 0 && this.raccoon.getMainHandItem() != null && this.raccoon.getMainHandItem().isEmpty()) {
                AbstractVillager villager = this.getNearbyVillagers();
                if (!this.isGolemNearby() && villager != null) {
                    this.target = villager;
                }
                this.cooldown = 150;
                return this.target != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.raccoon != null;
        }

        public void stop() {
            this.target = null;
            this.cooldown = 200 + EntityRaccoon.this.random.nextInt(200);
            this.golemCheckTime = 0;
            this.fleeTime = 0;
        }

        public void tick() {
            if (this.target != null) {
                ++this.golemCheckTime;
                if (this.fleeTime > 0) {
                    Vec3 fleevec;
                    --this.fleeTime;
                    if (this.raccoon.getNavigation().isDone() && (fleevec = DefaultRandomPos.getPosAway((PathfinderMob)this.raccoon, (int)16, (int)7, (Vec3)this.raccoon.position())) != null) {
                        this.raccoon.getNavigation().moveTo(fleevec.x, fleevec.y, fleevec.z, (double)1.3f);
                    }
                    if (this.fleeTime == 0) {
                        this.stop();
                    }
                } else {
                    this.raccoon.getNavigation().moveTo((Entity)this.target, 1.0);
                    if (this.raccoon.distanceTo((Entity)this.target) < 1.7f) {
                        this.raccoon.setStanding(true);
                        this.raccoon.maxStandTime = 15;
                        MerchantOffers offers = this.target.getOffers();
                        if (offers == null || offers.isEmpty() || offers.size() < 1) {
                            this.stop();
                        } else {
                            MerchantOffer offer = (MerchantOffer)offers.get(offers.size() <= 1 ? 0 : this.raccoon.getRandom().nextInt(offers.size() - 1));
                            if (offer != null) {
                                ItemStack stealStack;
                                ItemStack itemStack = stealStack = offer.getResult().getItem() == Items.EMERALD ? offer.getBaseCostA() : offer.getResult();
                                if (stealStack.isEmpty()) {
                                    this.stop();
                                } else {
                                    offer.increaseUses();
                                    ItemStack copy = stealStack.copy();
                                    copy.setCount(1);
                                    this.raccoon.setItemInHand(InteractionHand.MAIN_HAND, copy);
                                    this.fleeTime = 60 + EntityRaccoon.this.random.nextInt(60);
                                    this.raccoon.getNavigation().stop();
                                    EntityRaccoon.this.lookForWaterBeforeEatingTimer = 120 + EntityRaccoon.this.random.nextInt(60);
                                    this.target.hurt(EntityRaccoon.this.damageSources().generic(), 0.0f);
                                    this.raccoon.stealCooldown = 24000 + EntityRaccoon.this.random.nextInt(48000);
                                }
                            }
                        }
                    }
                    if (this.golemCheckTime % 30 == 0 && EntityRaccoon.this.random.nextBoolean() && this.isGolemNearby()) {
                        this.stop();
                    }
                }
            }
        }

        @Nullable
        private boolean isGolemNearby() {
            List lvt_1_1_ = this.raccoon.level().getNearbyEntities(IronGolem.class, IRON_GOLEM_PREDICATE, (LivingEntity)this.raccoon, this.raccoon.getBoundingBox().inflate(25.0));
            return !lvt_1_1_.isEmpty();
        }

        @Nullable
        private AbstractVillager getNearbyVillagers() {
            List lvt_1_1_ = this.raccoon.level().getNearbyEntities(AbstractVillager.class, VILLAGER_STEAL_PREDICATE, (LivingEntity)this.raccoon, this.raccoon.getBoundingBox().inflate(20.0));
            double lvt_2_1_ = 10000.0;
            AbstractVillager lvt_4_1_ = null;
            for (AbstractVillager lvt_6_1_ : lvt_1_1_) {
                if (!(lvt_6_1_.getHealth() > 2.0f) || lvt_6_1_.getOffers().isEmpty() || !(this.raccoon.distanceToSqr((Entity)lvt_6_1_) < lvt_2_1_)) continue;
                lvt_4_1_ = lvt_6_1_;
                lvt_2_1_ = this.raccoon.distanceToSqr((Entity)lvt_6_1_);
            }
            return lvt_4_1_;
        }
    }

    class StrollGoal
    extends MoveThroughVillageGoal {
        public StrollGoal(int p_i50726_3_) {
            super((PathfinderMob)EntityRaccoon.this, 1.0, true, p_i50726_3_, () -> false);
        }

        public void start() {
            super.start();
        }

        public boolean canUse() {
            return super.canUse() && this.canFoxMove();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !EntityRaccoon.this.isWashing() && !EntityRaccoon.this.isSitting() && EntityRaccoon.this.getTarget() == null;
        }
    }
}

