/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityFlutter;
import com.github.alexthe666.alexsmobs.entity.EntityMobProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityPollenBall
extends EntityMobProjectile {
    public EntityPollenBall(EntityType type, Level level) {
        super(type, level);
    }

    public EntityPollenBall(Level worldIn, EntityFlutter flutter) {
        super((EntityType)AMEntityRegistry.POLLEN_BALL.get(), worldIn, (Mob)flutter);
        Vec3 vec3 = flutter.position().add(this.calcOffsetVec(new Vec3(0.0, (double)(0.4f * flutter.getScale()), 0.0), flutter.getFlutterPitch(), flutter.getYRot()));
        this.setPos(vec3.x, vec3.y, vec3.z);
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    public void doBehavior() {
        Entity entity = this.getShooter();
        if (entity instanceof Mob && ((Mob)entity).getTarget() != null) {
            LivingEntity target = ((Mob)entity).getTarget();
            if (target == null) {
                this.kill();
            }
            double d0 = target.getX() - this.getX();
            double d1 = target.getY() + (double)(target.getBbHeight() * 0.5f) - this.getY();
            double d2 = target.getZ() - this.getZ();
            float speed = 0.35f;
            this.shoot(d0, d1, d2, 0.35f, 0.0f);
            this.setYRot(-((float)Mth.atan2((double)d0, (double)d2)) * 57.295776f);
        }
        if (this.level().isClientSide && this.random.nextInt(2) == 0) {
            float r1 = (this.random.nextFloat() - 0.5f) * 0.5f;
            float r2 = (this.random.nextFloat() - 0.5f) * 0.5f;
            float r3 = (this.random.nextFloat() - 0.5f) * 0.5f;
            this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_NECTAR, this.getX() + (double)r1, this.getY() + (double)r2, this.getZ() + (double)r3, (double)(r1 * 0.1f), (double)(r2 * 0.1f), (double)(r3 * 0.1f));
        }
    }

    @Override
    protected float getDamage() {
        return 3.0f;
    }
}

