/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockReptileEgg;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.PlatypusAIDigForItems;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityPlatypus
extends Animal
implements ISemiAquatic,
ITargetsDroppedItems,
Bucketable {
    private static final EntityDataAccessor<Boolean> SENSING = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SENSING_VISUAL = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FEDORA = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(EntityPlatypus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevInWaterProgress;
    public float inWaterProgress;
    public float prevDigProgress;
    public float digProgress;
    public boolean superCharged = false;
    private boolean isLandNavigator;
    private int swimTimer = -1000;

    protected EntityPlatypus(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public static boolean canPlatypusSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getBlockState(pos.below()).is(AMTagRegistry.PLATYPUS_SPAWNS) && pos.getY() < worldIn.getSeaLevel() + 4;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.platypusSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.PLATYPUS_BREEDABLES);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.PLATYPUS_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.PLATYPUS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.PLATYPUS_HURT.get();
    }

    @Nonnull
    public ItemStack getBucketItemStack() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.PLATYPUS_BUCKET.get());
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    public void saveToBucketTag(@Nonnull ItemStack bucket) {
        if (this.hasCustomName()) {
            bucket.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        CompoundTag platTag = new CompoundTag();
        this.addAdditionalSaveData(platTag);
        CompoundTag compound = ((CustomData)bucket.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        compound.put("PlatypusData", (Tag)platTag);
    }

    public void loadFromBucketTag(@Nonnull CompoundTag compound) {
        if (compound.contains("PlatypusData")) {
            this.readAdditionalSaveData(compound.getCompound("PlatypusData"));
        }
    }

    @Nonnull
    public InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() == AMItemRegistry.FEDORA.get() && !this.hasFedora()) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setFedora(true);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (itemstack.is(AMTagRegistry.PLATYPUS_CHARGEABLES) && !this.isSensing()) {
            this.superCharged = itemstack.is(AMTagRegistry.PLATYPUS_SUPER_CHARGEABLES);
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setSensing(true);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.mobInteract(player, hand));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new MateGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LayEggGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.PLATYPUS_CHARGEABLES), false){

            public void start() {
                super.start();
                EntityPlatypus.this.setSensingVisual(true);
            }

            public boolean canUse() {
                return super.canUse() && !EntityPlatypus.this.isSensing();
            }

            public void stop() {
                super.stop();
                EntityPlatypus.this.setSensingVisual(false);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.PLATYPUS_FOODSTUFFS), false){

            public boolean canUse() {
                return super.canUse() && !EntityPlatypus.this.isSensing();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new PlatypusAIDigForItems(this));
        this.goalSelector.addGoal(6, (Goal)new SemiAquaticAIRandomSwimming(this, 1.0, 30));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 60));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new CreatureAITargetItems((PathfinderMob)this, false, false, 40, 15){

            @Override
            public boolean canUse() {
                return super.canUse() && !EntityPlatypus.this.isSensing();
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && !EntityPlatypus.this.isSensing();
            }
        });
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev && source.getDirectEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)source.getDirectEntity();
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 100));
        }
        return prev;
    }

    public boolean isPerry() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && s.toLowerCase().contains("perry");
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    public void spawnGroundEffects() {
        float radius = 0.3f;
        for (int i1 = 0; i1 < 3; ++i1) {
            double motionX = this.getRandom().nextGaussian() * 0.07;
            double motionY = this.getRandom().nextGaussian() * 0.07;
            double motionZ = this.getRandom().nextGaussian() * 0.07;
            float angle = (float)Math.PI / 180 * this.yBodyRot + (float)i1;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraY = 0.8f;
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos ground = this.getBlockPosBelowThatAffectsMyMovement();
            BlockState state = this.level().getBlockState(ground);
            if (!state.isSolid() || !this.level().isClientSide) continue;
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), true, this.getX() + extraX, (double)ground.getY() + extraY, this.getZ() + extraZ, motionX, motionY, motionZ);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setAirSupply(this.getMaxAirSupply());
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIGGING, (Object)false);
        builder.define(SENSING, (Object)false);
        builder.define(SENSING_VISUAL, (Object)false);
        builder.define(FEDORA, (Object)false);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(HAS_EGG, (Object)false);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.hasFedora()) {
            this.spawnAtLocation((ItemLike)AMItemRegistry.FEDORA.get());
        }
    }

    public boolean isSensing() {
        return (Boolean)this.entityData.get(SENSING);
    }

    public void setSensing(boolean sensing) {
        this.entityData.set(SENSING, (Object)sensing);
    }

    public boolean isSensingVisual() {
        return (Boolean)this.entityData.get(SENSING_VISUAL);
    }

    public void setSensingVisual(boolean sensing) {
        this.entityData.set(SENSING_VISUAL, (Object)sensing);
    }

    public boolean hasFedora() {
        return (Boolean)this.entityData.get(FEDORA);
    }

    public void setFedora(boolean sensing) {
        this.entityData.set(FEDORA, (Object)sensing);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Fedora", this.hasFedora());
        compound.putBoolean("Sensing", this.isSensing());
        compound.putBoolean("FromBucket", this.fromBucket());
        compound.putBoolean("HasEgg", this.hasEgg());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFedora(compound.getBoolean("Fedora"));
        this.setSensing(compound.getBoolean("Sensing"));
        this.setFromBucket(compound.getBoolean("FromBucket"));
        this.setHasEgg(compound.getBoolean("HasEgg"));
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.entityData.set(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nonnull
    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket() || this.hasCustomName();
    }

    public boolean removeWhenFarAway(double dist) {
        return !this.fromBucket() && !this.requiresCustomPersistence();
    }

    public void tick() {
        boolean dig;
        super.tick();
        this.prevInWaterProgress = this.inWaterProgress;
        this.prevDigProgress = this.digProgress;
        boolean bl = dig = this.isDigging() && this.isInWaterOrBubble();
        if (dig && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!dig && this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (this.isInWaterOrBubble()) {
            if (this.inWaterProgress < 5.0f) {
                this.inWaterProgress += 1.0f;
            }
            if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
        } else {
            if (this.inWaterProgress > 0.0f) {
                this.inWaterProgress -= 1.0f;
            }
            if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (this.onGround() && this.isDigging()) {
            this.spawnGroundEffects();
        }
        if (this.inWaterProgress > 0.0f) {
            // empty if block
        }
        if (!this.level().isClientSide) {
            this.swimTimer = this.isInWater() ? ++this.swimTimer : --this.swimTimer;
        }
        if (this.isAlive() && (this.isSensing() || this.isSensingVisual())) {
            for (int j = 0; j < 2; ++j) {
                float radius = this.getBbWidth() * 0.65f;
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double extraX = (double)(radius * (1.5f + this.random.nextFloat() * 0.3f) * Mth.sin((float)((float)Math.PI + angle)) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().x * 2.0;
                double extraZ = (double)(radius * (1.5f + this.random.nextFloat() * 0.3f) * Mth.cos((float)angle) + (this.random.nextFloat() - 0.5f)) + this.getDeltaMovement().z * 2.0;
                double actualX = radius * Mth.sin((float)((float)Math.PI + angle));
                double actualZ = radius * Mth.cos((float)angle);
                double motX = actualX - extraX;
                double motZ = actualZ - extraZ;
                this.level().addParticle((ParticleOptions)AMParticleRegistry.PLATYPUS_SENSE.get(), this.getX() + extraX, (double)(this.getBbHeight() * 0.3f) + this.getY(), this.getZ() + extraZ, motX * (double)0.1f, 0.0, motZ * (double)0.1f);
            }
        }
    }

    public boolean isDigging() {
        return (Boolean)this.entityData.get(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.entityData.set(DIGGING, (Object)digging);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new AnimalSwimMoveControllerSink((PathfinderMob)this, 1.2f, 1.6f);
            this.navigation = new SemiAquaticPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    @Override
    public boolean shouldEnterWater() {
        return (this.getLastHurtByMob() != null || this.swimTimer <= -1000 || this.isSensing()) && !this.hasEgg();
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.swimTimer > 600 && !this.isSensing() || this.hasEgg();
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isDigging();
    }

    @Override
    public int getWaterSearchRange() {
        return 10;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.PLATYPUS.get()).create((Level)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return !this.isSensing() && stack.is(AMTagRegistry.PLATYPUS_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.gameEvent((Holder)GameEvent.EAT);
        this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
        if (e.getItem().is(AMTagRegistry.PLATYPUS_CHARGEABLES)) {
            this.superCharged = e.getItem().is(AMTagRegistry.PLATYPUS_SUPER_CHARGEABLES);
            this.setSensing(true);
        }
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    static class MateGoal
    extends BreedGoal {
        private final EntityPlatypus platypus;

        MateGoal(EntityPlatypus platypus, double speedIn) {
            super((Animal)platypus, speedIn);
            this.platypus = platypus;
        }

        public boolean canUse() {
            return super.canUse() && !this.platypus.hasEgg();
        }

        protected void breed() {
            ServerPlayer serverplayerentity = this.animal.getLoveCause();
            if (serverplayerentity == null && this.partner.getLoveCause() != null) {
                serverplayerentity = this.partner.getLoveCause();
            }
            if (serverplayerentity != null) {
                serverplayerentity.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, this.animal, this.partner, (AgeableMob)this.animal);
            }
            this.platypus.setHasEgg(true);
            this.animal.resetLove();
            this.partner.resetLove();
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                RandomSource random = this.animal.getRandom();
                this.level.addFreshEntity((Entity)new ExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final EntityPlatypus turtle;
        private int digTime;

        LayEggGoal(EntityPlatypus turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public void stop() {
            this.digTime = 0;
        }

        public boolean canUse() {
            return this.turtle.hasEgg() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.hasEgg();
        }

        public double acceptedDistance() {
            return (double)this.turtle.getBbWidth() + 0.5;
        }

        public void tick() {
            super.tick();
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                BlockPos blockpos = this.turtle.blockPosition();
                Level world = this.turtle.level();
                this.turtle.gameEvent((Holder)GameEvent.BLOCK_PLACE);
                world.playSound(null, blockpos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
                world.setBlock(this.blockPos.above(), (BlockState)((Block)AMBlockRegistry.PLATYPUS_EGG.get()).defaultBlockState().setValue((Property)BlockReptileEgg.EGGS, (Comparable)Integer.valueOf(this.turtle.random.nextInt(3) + 1)), 3);
                this.turtle.setHasEgg(false);
                this.turtle.setDigging(false);
                this.turtle.setInLoveTime(600);
            }
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            return worldIn.isEmptyBlock(pos.above()) && BlockReptileEgg.isProperHabitat((BlockGetter)worldIn, pos);
        }
    }
}

