/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.entity.OrcaAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.OrcaAIJump;
import com.github.alexthe666.alexsmobs.entity.ai.OrcaAIMeleeJump;
import com.github.alexthe666.alexsmobs.entity.ai.SwimmerJumpPathNavigator;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class EntityOrca
extends TamableAnimal
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)8);
    public static final Animation ANIMATION_TAILSWING = Animation.create((int)20);
    private static final EntityDataAccessor<Integer> MOISTNESS = SynchedEntityData.defineId(EntityOrca.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.forNonCombat().range(24.0).ignoreLineOfSight();
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityOrca.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int jumpCooldown;
    private int animationTick;
    private Animation currentAnimation;
    private int blockBreakCounter;
    public static final Predicate<LivingEntity> TARGET_BABY = animal -> animal.isBaby();

    protected EntityOrca(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveHelperController(this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.orcaSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.7f).add(Attributes.MOVEMENT_SPEED, (double)1.35f);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new SwimmerJumpPathNavigator((Mob)this, worldIn);
    }

    public int getMoistness() {
        return (Integer)this.entityData.get(MOISTNESS);
    }

    public void setMoistness(int p_211137_1_) {
        this.entityData.set(MOISTNESS, (Object)p_211137_1_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)2400);
        builder.define(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int determineVariant(BlockPos coords) {
        if (coords == null) {
            return 0;
        }
        if (coords.getZ() < 0) {
            return coords.getX() < 0 ? 1 : 0;
        }
        return coords.getX() < 0 ? 3 : 2;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.ORCA_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.ORCA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.ORCA_DIE.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new SwimWithPlayerGoal(this, 4.0));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new OrcaAIJump(this, 10));
        this.goalSelector.addGoal(6, (Goal)new OrcaAIMeleeJump(this));
        this.goalSelector.addGoal(6, (Goal)new OrcaAIMelee(this, 1.2f, true));
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<EntityCachalotWhale>((Mob)this, EntityCachalotWhale.class, 25, false, false, TARGET_BABY));
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 200, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.ORCA_TARGETS)));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_TAILSWING};
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.breakBlock();
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.level().isClientSide && this.blockBreakCounter == 0) {
            for (int a = (int)Math.round(this.getBoundingBox().minX); a <= (int)Math.round(this.getBoundingBox().maxX); ++a) {
                for (int b = (int)Math.round(this.getBoundingBox().minY) - 1; b <= (int)Math.round(this.getBoundingBox().maxY) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.getBoundingBox().minZ); c <= (int)Math.round(this.getBoundingBox().maxZ); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.level().getBlockState(pos);
                        FluidState fluidState = this.level().getFluidState(pos);
                        Block block = state.getBlock();
                        if (state.isAir() || state.getShape((BlockGetter)this.level(), pos).isEmpty() || !state.is(AMTagRegistry.ORCA_BREAKABLES) || !fluidState.isEmpty() || block == Blocks.AIR) continue;
                        this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        if (state.is(BlockTags.ICE)) {
                            this.level().destroyBlock(pos, false);
                            this.level().setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
                            continue;
                        }
                        this.level().destroyBlock(pos, true);
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = 20;
        }
    }

    public void tick() {
        super.tick();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
            float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
            this.setXRot(f2);
        }
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
        } else {
            if (this.isInWaterRainOrBubble()) {
                this.setMoistness(2400);
            } else {
                this.setMoistness(this.getMoistness() - 1);
                if (this.getMoistness() <= 0) {
                    this.hurt(this.damageSources().dryOut(), 1.0f);
                }
                if (this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
                    this.setYRot(this.random.nextFloat() * 360.0f);
                    this.setOnGround(false);
                    this.hasImpulse = true;
                }
            }
            if (this.level().isClientSide && this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.03) {
                Vec3 vector3d = this.getViewVector(0.0f);
                float yRotRad = this.getYRot() * ((float)Math.PI / 180);
                float f = Mth.cos((float)yRotRad) * 0.9f;
                float f1 = Mth.sin((float)yRotRad) * 0.9f;
                float f2 = 1.2f - this.random.nextFloat() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null && this.distanceTo((Entity)attackTarget) < attackTarget.getBbWidth() + this.getBbWidth() + 2.0f) {
            float damage;
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 4) {
                boolean flag;
                damage = (int)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
                if (attackTarget instanceof Drowned || attackTarget instanceof Guardian) {
                    damage *= 2.0f;
                }
                if (flag = attackTarget.hurt(this.damageSources().mobAttack((LivingEntity)this), damage)) {
                    this.playSound(SoundEvents.DOLPHIN_ATTACK, 1.0f, 1.0f);
                }
            }
            if (this.getAnimation() == ANIMATION_TAILSWING && this.getAnimationTick() == 6) {
                boolean flag;
                damage = (int)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
                if (attackTarget instanceof Drowned || attackTarget instanceof Guardian) {
                    damage *= 2.0f;
                }
                if (flag = attackTarget.hurt(this.damageSources().mobAttack((LivingEntity)this), damage)) {
                    this.playSound(SoundEvents.DOLPHIN_ATTACK, 1.0f, 1.0f);
                }
                float yRotRad = this.getYRot() * ((float)Math.PI / 180);
                attackTarget.knockback(1.0, (double)Mth.sin((float)yRotRad), (double)(-Mth.cos((float)yRotRad)));
                float knockbackResist = (float)Mth.clamp((double)(1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)), (double)0.0, (double)1.0);
                this.getTarget().setDeltaMovement(this.getTarget().getDeltaMovement().add(0.0, (double)(knockbackResist * 0.4f), 0.0));
            }
        }
        if (attackTarget != null && attackTarget instanceof Player && attackTarget.hasEffect(AMEffectRegistry.ORCAS_MIGHT)) {
            attackTarget.removeEffect(AMEffectRegistry.ORCAS_MIGHT);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.isInWaterOrBubble() && this.random.nextBoolean()) {
            this.setAnimation(ANIMATION_TAILSWING);
        } else {
            this.setAnimation(ANIMATION_BITE);
        }
        return true;
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int currentAir) {
        return this.getMaxAirSupply();
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == Items.SALMON;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.ORCA.get()).create((Level)serverWorld);
    }

    public boolean shouldUseJumpAttack(LivingEntity attackTarget) {
        if (attackTarget.isInWater()) {
            BlockPos up = attackTarget.blockPosition().above();
            return this.level().getFluidState(up.above()).isEmpty() && this.level().getFluidState(up.above(2)).isEmpty() && this.jumpCooldown == 0;
        }
        return this.jumpCooldown == 0;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setAirSupply(this.getMaxAirSupply());
        this.setVariant(this.determineVariant(this.blockPosition()));
        this.setXRot(0.0f);
        this.setMoistness(2400);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean canBreatheUnderwaterAM() {
        return false;
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        this.updateAir(i);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    protected void updateAir(int p_209207_1_) {
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Moistness", this.getMoistness());
        compound.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMoistness(compound.getInt("Moistness"));
        this.setVariant(compound.getInt("Variant"));
    }

    public void onJumpHit(LivingEntity entityIn) {
        boolean flag = entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (flag) {
            this.playSound(SoundEvents.DOLPHIN_ATTACK, 1.0f, 1.0f);
        }
    }

    public static boolean canOrcaSpawn(EntityType<EntityOrca> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        if (p_223364_3_.getY() > 45 && p_223364_3_.getY() < p_223364_1_.getSeaLevel()) {
            return p_223364_1_.getFluidState(p_223364_3_).is(FluidTags.WATER);
        }
        return false;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityOrca dolphin;

        public MoveHelperController(EntityOrca dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void tick() {
            if (this.dolphin.isInWater()) {
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.dolphin.getNavigation().isDone()) {
                double d2;
                double d1;
                double d0 = this.wantedX - this.dolphin.getX();
                double d3 = d0 * d0 + (d1 = this.wantedY - this.dolphin.getY()) * d1 + (d2 = this.wantedZ - this.dolphin.getZ()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.setYRot(this.rotlerp(this.dolphin.getYRot(), f, 10.0f));
                    this.dolphin.yBodyRot = this.dolphin.getYRot();
                    this.dolphin.yHeadRot = this.dolphin.getYRot();
                    float f1 = (float)(this.speedModifier * this.dolphin.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    if (this.dolphin.isInWater()) {
                        this.dolphin.setSpeed(f1 * 0.02f);
                        float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.setXRot(this.rotlerp(this.dolphin.getXRot(), f2, 5.0f));
                        float xRotRad = this.dolphin.getXRot() * ((float)Math.PI / 180);
                        float f3 = Mth.cos((float)xRotRad);
                        float f4 = Mth.sin((float)xRotRad);
                        this.dolphin.zza = f3 * f1;
                        this.dolphin.yya = -f4 * f1;
                    } else {
                        this.dolphin.setSpeed(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.setSpeed(0.0f);
                this.dolphin.setXxa(0.0f);
                this.dolphin.setYya(0.0f);
                this.dolphin.setZza(0.0f);
            }
        }
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final EntityOrca dolphin;
        private final double speed;
        private Player targetPlayer;

        SwimWithPlayerGoal(EntityOrca dolphinIn, double speedIn) {
            this.dolphin = dolphinIn;
            this.speed = speedIn;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            this.targetPlayer = this.dolphin.level().getNearestPlayer(PLAYER_PREDICATE, (LivingEntity)this.dolphin);
            if (this.targetPlayer == null) {
                return false;
            }
            return this.targetPlayer.isSwimming() && this.dolphin.getTarget() != this.targetPlayer;
        }

        public boolean canContinueToUse() {
            return this.targetPlayer != null && this.dolphin.getTarget() != this.targetPlayer && this.targetPlayer.isSwimming() && this.dolphin.distanceToSqr((Entity)this.targetPlayer) < 256.0;
        }

        public void start() {
        }

        public void stop() {
            this.targetPlayer = null;
            this.dolphin.getNavigation().stop();
        }

        public void tick() {
            this.dolphin.getLookControl().setLookAt((Entity)this.targetPlayer, (float)(this.dolphin.getMaxHeadYRot() + 20), (float)this.dolphin.getMaxHeadXRot());
            if (this.dolphin.distanceToSqr((Entity)this.targetPlayer) < 10.0) {
                this.dolphin.getNavigation().stop();
            } else {
                this.dolphin.getNavigation().moveTo((Entity)this.targetPlayer, this.speed);
            }
            if (this.targetPlayer.isSwimming() && this.targetPlayer.level().random.nextInt(6) == 0) {
                this.targetPlayer.addEffect(new MobEffectInstance(AMEffectRegistry.ORCAS_MIGHT, 1000));
            }
        }
    }
}

