/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMurmur;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class EntityMurmurHead
extends Monster
implements FlyingAnimal {
    private static final EntityDataAccessor<Optional<UUID>> BODY_UUID = SynchedEntityData.defineId(EntityMurmurHead.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> BODY_ID = SynchedEntityData.defineId(EntityMurmurHead.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> PULLED_IN = SynchedEntityData.defineId(EntityMurmurHead.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityMurmurHead.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public double prevXHair;
    public double prevYHair;
    public double prevZHair;
    public double xHair;
    public double yHair;
    public double zHair;
    public float angerProgress;
    public float prevAngerProgress;
    private boolean prevLaunched = false;

    protected EntityMurmurHead(EntityType type, Level level) {
        super(type, level);
        this.moveControl = new MoveController();
    }

    protected EntityMurmurHead(EntityMurmur parent) {
        this((EntityType)AMEntityRegistry.MURMUR_HEAD.get(), parent.level());
        this.setBodyId(parent.getUUID());
        this.doSpawnPositioning(parent);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, this.level());
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public int getExperienceReward() {
        return 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AttackGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, 10, false, true, null));
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<AbstractVillager>((Mob)this, AbstractVillager.class, 30, false, true, null));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BODY_UUID, Optional.empty());
        builder.define(BODY_ID, (Object)-1);
        builder.define(PULLED_IN, (Object)true);
        builder.define(ANGRY, (Object)false);
    }

    private void doSpawnPositioning(EntityMurmur parent) {
        this.setPos(parent.getNeckBottom(1.0f).add(0.0, 0.5, 0.0));
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPulledIn() {
        return (Boolean)this.entityData.get(PULLED_IN);
    }

    public void setPulledIn(boolean pulledIn) {
        this.entityData.set(PULLED_IN, (Object)pulledIn);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY) != false || !this.isAlive();
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
    }

    public Vec3 getNeckTop(float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)this.xo, (double)this.getX());
        double d1 = Mth.lerp((double)partialTick, (double)this.yo, (double)this.getY());
        double d2 = Mth.lerp((double)partialTick, (double)this.zo, (double)this.getZ());
        double bounce = 0.0;
        Entity body = this.getBody();
        if (body instanceof EntityMurmur) {
            bounce = ((EntityMurmur)body).calculateWalkBounce(partialTick);
        }
        return new Vec3(d0, d1 + bounce, d2);
    }

    public Vec3 getNeckBottom(float partialTick) {
        Entity body = this.getBody();
        Vec3 top = this.getNeckTop(partialTick);
        if (body instanceof EntityMurmur) {
            EntityMurmur murmur = (EntityMurmur)body;
            Vec3 bodyBase = murmur.getNeckBottom(partialTick);
            double sub = top.subtract(bodyBase).horizontalDistance();
            return sub <= 0.06 ? new Vec3(top.x, bodyBase.y, top.z) : bodyBase;
        }
        return top.add(0.0, -0.5, 0.0);
    }

    public boolean hasNeckBottom() {
        return true;
    }

    @Nullable
    public UUID getBodyId() {
        return ((Optional)this.entityData.get(BODY_UUID)).orElse(null);
    }

    public void setBodyId(@Nullable UUID uniqueId) {
        this.entityData.set(BODY_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getBody() {
        if (!this.level().isClientSide) {
            UUID id = this.getBodyId();
            return id == null ? null : ((ServerLevel)this.level()).getEntity(id);
        }
        int id = (Integer)this.entityData.get(BODY_ID);
        return id == -1 ? null : this.level().getEntity(id);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("BodyUUID")) {
            this.setBodyId(compound.getUUID("BodyUUID"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getBodyId() != null) {
            compound.putUUID("BodyUUID", this.getBodyId());
        }
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return dimensions.height() * 0.35f;
    }

    public void tick() {
        super.tick();
        this.yHeadRot = Mth.clamp((float)this.yHeadRot, (float)(this.yBodyRot - 70.0f), (float)(this.yBodyRot + 70.0f));
        this.prevAngerProgress = this.angerProgress;
        if (this.isAngry() && this.angerProgress < 5.0f) {
            this.angerProgress += 1.0f;
        }
        if (!this.isAngry() && this.angerProgress > 0.0f) {
            this.angerProgress -= 1.0f;
        }
        this.moveHair();
        Entity body = this.getBody();
        if (!this.level().isClientSide) {
            if (body instanceof EntityMurmur) {
                EntityMurmur murmur = (EntityMurmur)body;
                this.entityData.set(BODY_ID, (Object)body.getId());
                if (this.isPulledIn() && murmur.isAlive()) {
                    Vec3 base = murmur.getNeckBottom(1.0f).add(0.0, (double)0.55f, 0.0);
                    Vec3 vec3 = base.subtract(this.position());
                    if (vec3.length() < 1.0) {
                        this.setPos(base.x, base.y, base.z);
                        this.noPhysics = false;
                    } else {
                        this.noPhysics = true;
                        vec3 = base.subtract(this.position()).normalize();
                        float f = this.getTarget() != null && this.getTarget().isAlive() ? 0.3f : 0.15f;
                        this.setDeltaMovement(vec3.scale((double)f));
                    }
                    this.setYRot(murmur.getYRot());
                    this.yBodyRot = murmur.getYRot();
                } else {
                    this.noPhysics = false;
                }
                LivingEntity headTarget = this.getTarget();
                LivingEntity bodyTarget = murmur.getTarget();
                if (headTarget != null && headTarget.isAlive()) {
                    if (murmur.canAttack(headTarget)) {
                        murmur.setTarget(headTarget);
                    } else {
                        this.setTarget(null);
                        murmur.setTarget(null);
                    }
                } else if (bodyTarget != null && bodyTarget.isAlive() && this.canAttack(bodyTarget)) {
                    this.setTarget(bodyTarget);
                }
                if (body.isRemoved()) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            if (body == null && this.tickCount > 20) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else if (body instanceof EntityMurmur) {
            EntityMurmur murmur = (EntityMurmur)body;
            if (murmur.hurtTime > 0 || murmur.deathTime > 0) {
                this.hurtTime = murmur.hurtTime;
                this.deathTime = murmur.deathTime;
            }
        }
        if (this.prevLaunched && !this.isPulledIn()) {
            this.playSound((SoundEvent)AMSoundRegistry.MURMUR_NECK.get(), 3.0f * this.getSoundVolume(), this.getVoicePitch());
        }
        this.prevLaunched = this.isPulledIn();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean hurt(DamageSource source, float damage) {
        Entity body = this.getBody();
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (body != null && body.hurt(source, 0.5f * damage)) {
            return true;
        }
        return super.hurt(source, damage);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return super.isInvulnerableTo(damageSource) || damageSource.is(DamageTypes.IN_WALL);
    }

    private void moveHair() {
        this.prevXHair = this.xHair;
        this.prevYHair = this.yHair;
        this.prevZHair = this.zHair;
        double d0 = this.getX() - this.xHair;
        double d1 = this.getY() - this.yHair;
        double d2 = this.getZ() - this.zHair;
        if (d0 > 10.0) {
            this.prevXHair = this.xHair = this.getX();
        }
        if (d2 > 10.0) {
            this.prevZHair = this.zHair = this.getZ();
        }
        if (d1 > 10.0) {
            this.prevYHair = this.yHair = this.getY();
        }
        if (d0 < -10.0) {
            this.prevXHair = this.xHair = this.getX();
        }
        if (d2 < -10.0) {
            this.prevZHair = this.zHair = this.getZ();
        }
        if (d1 < -10.0) {
            this.prevYHair = this.yHair = this.getY();
        }
        this.xHair += d0 * 0.25;
        this.zHair += d2 * 0.25;
        this.yHair += d1 * 0.25;
    }

    public boolean isAlliedTo(Entity entity) {
        return this.getBodyId() != null && entity.getUUID().equals(this.getBodyId()) || super.isAlliedTo(entity);
    }

    public void playAmbientSound() {
        if (this.isPulledIn() && !this.isAngry()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.MURMUR_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.getBody() == null ? (SoundEvent)AMSoundRegistry.MURMUR_HURT.get() : null;
    }

    protected SoundEvent getDeathSound() {
        return this.getBody() == null ? (SoundEvent)AMSoundRegistry.MURMUR_HURT.get() : null;
    }

    public boolean isFlying() {
        return true;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)EntityMurmurHead.this);
            this.parentEntity = EntityMurmurHead.this;
        }

        public void tick() {
            if (EntityMurmurHead.this.isPulledIn()) {
                return;
            }
            float angle = (float)Math.PI / 180 * (this.parentEntity.yBodyRot + 90.0f);
            float radius = (float)Math.sin((float)this.parentEntity.tickCount * 0.2f) * 2.0f;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraY = (double)radius * -Math.cos((double)angle - 1.5707963267948966);
            double extraZ = radius * Mth.cos((float)angle);
            Vec3 strafPlus = new Vec3(extraX, extraY, extraZ);
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d0 = vector3d.length();
                double width = this.parentEntity.getBoundingBox().getSize();
                Vec3 shimmy = Vec3.ZERO;
                LivingEntity attackTarget = this.parentEntity.getTarget();
                if (attackTarget != null && this.parentEntity.horizontalCollision) {
                    shimmy = new Vec3(0.0, 0.005, 0.0);
                }
                Vec3 vector3d1 = vector3d.scale(this.speedModifier * 0.05 / d0);
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d1.add(strafPlus.scale(0.003 * Math.min(d0, 100.0)).add(shimmy))));
                if (attackTarget == null) {
                    if (d0 >= width) {
                        Vec3 deltaMovement = this.parentEntity.getDeltaMovement();
                        this.parentEntity.setYRot(-((float)Mth.atan2((double)deltaMovement.x, (double)deltaMovement.z)) * 57.295776f);
                        this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                    }
                } else {
                    double d2 = attackTarget.getX() - this.parentEntity.getX();
                    double d1 = attackTarget.getZ() - this.parentEntity.getZ();
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)d2, (double)d1)) * 57.295776f);
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                }
            } else if (this.operation == MoveControl.Operation.WAIT) {
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(strafPlus.scale(0.003)));
            }
        }
    }

    private class AttackGoal
    extends Goal {
        private int time;
        private int biteCooldown = 0;
        private Vec3 emergeFrom = Vec3.ZERO;
        private float emergeAngle = 0.0f;

        public AttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityMurmurHead.this.getTarget() != null && EntityMurmurHead.this.getTarget().isAlive();
        }

        public void start() {
            this.time = 0;
            this.biteCooldown = 0;
            EntityMurmurHead.this.setPulledIn(false);
        }

        public void stop() {
            this.time = 0;
            EntityMurmurHead.this.setPulledIn(true);
            EntityMurmurHead.this.setAngry(false);
        }

        public void tick() {
            LivingEntity target = EntityMurmurHead.this.getTarget();
            Entity body = EntityMurmurHead.this.getBody();
            if (target != null) {
                double bodyDist;
                double dist = Math.sqrt(EntityMurmurHead.this.distanceToSqr(target.getEyePosition()));
                double d = bodyDist = body != null ? (double)body.distanceTo((Entity)target) : 0.0;
                if (bodyDist > 16.0 && this.time > 30 && body instanceof EntityMurmur) {
                    EntityMurmur murmur = (EntityMurmur)body;
                    murmur.setTarget(target);
                    murmur.getNavigation().moveTo((Entity)target, 1.35);
                }
                if (bodyDist > 64.0) {
                    EntityMurmurHead.this.setPulledIn(true);
                } else if (this.biteCooldown == 0) {
                    EntityMurmurHead.this.setPulledIn(false);
                    Vec3 moveTo = target.getEyePosition();
                    if (this.time > 30) {
                        if (!EntityMurmurHead.this.isAngry()) {
                            EntityMurmurHead.this.playSound((SoundEvent)AMSoundRegistry.MURMUR_ANGER.get(), 1.5f * EntityMurmurHead.this.getSoundVolume(), EntityMurmurHead.this.getVoicePitch());
                            EntityMurmurHead.this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                        }
                        EntityMurmurHead.this.setAngry(true);
                        EntityMurmurHead.this.getNavigation().moveTo(moveTo.x, moveTo.y, moveTo.z, 1.3);
                    } else {
                        if (this.time == 0) {
                            this.emergeFrom = EntityMurmurHead.this.getNeckTop(1.0f).add(0.0, 0.5, 0.0);
                            Vec3 vec3 = moveTo.subtract(this.emergeFrom);
                        }
                        boolean clockwise = false;
                        float circleDistance = 2.5f;
                        float circlingTime = 30 * this.time;
                        float angle = (float)Math.PI / 180 * (clockwise ? -circlingTime : circlingTime);
                        double extraX = circleDistance * Mth.sin((float)((float)Math.PI + angle));
                        double extraZ = circleDistance * Mth.cos((float)angle);
                        double y = Math.max(this.emergeFrom.y + 2.0, target.getEyeY());
                        Vec3 vec3 = new Vec3(this.emergeFrom.x + extraX, y, this.emergeFrom.z + extraZ);
                        EntityMurmurHead.this.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 0.7);
                    }
                    EntityMurmurHead.this.lookAt(EntityAnchorArgument.Anchor.EYES, moveTo);
                    if (dist < 1.5 && EntityMurmurHead.this.hasLineOfSight((Entity)target)) {
                        EntityMurmurHead.this.playSound((SoundEvent)AMSoundRegistry.MURMUR_ATTACK.get(), EntityMurmurHead.this.getSoundVolume(), EntityMurmurHead.this.getVoicePitch());
                        this.biteCooldown = 5 + EntityMurmurHead.this.getRandom().nextInt(15);
                        target.hurt(EntityMurmurHead.this.damageSources().mobAttack((LivingEntity)EntityMurmurHead.this), 5.0f);
                    }
                } else {
                    EntityMurmurHead.this.setPulledIn(true);
                    EntityMurmurHead.this.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
                    EntityMurmurHead.this.setAngry(false);
                }
                ++this.time;
            }
            if (this.biteCooldown > 0) {
                --this.biteCooldown;
            }
        }
    }
}

