/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMobProjectile;
import com.github.alexthe666.alexsmobs.entity.EntityMudskipper;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityMudBall
extends EntityMobProjectile {
    public EntityMudBall(EntityType type, Level level) {
        super(type, level);
    }

    public EntityMudBall(Level worldIn, EntityMudskipper mudskipper) {
        super((EntityType)AMEntityRegistry.MUD_BALL.get(), worldIn, (Mob)mudskipper);
        Vec3 vec3 = mudskipper.position().add(this.calcOffsetVec(new Vec3(0.0, 0.0, (double)(0.2f * mudskipper.getScale())), 0.0f, mudskipper.getYRot()));
        this.setPos(vec3.x, vec3.y, vec3.z);
    }

    @Override
    public void doBehavior() {
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f));
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
        }
    }

    @Override
    protected boolean removeInWater() {
        return false;
    }

    @Override
    protected float getDamage() {
        return 1 + this.random.nextInt(3);
    }

    @Override
    protected void onEntityHit(EntityHitResult result) {
        super.onEntityHit(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity hurt = (LivingEntity)entity;
            hurt.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60));
        }
    }

    public void handleEntityEvent(byte event) {
        if (event == 3) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.MUD.defaultBlockState());
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(event);
        }
    }

    @Override
    protected void onImpact(HitResult result) {
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
        super.onImpact(result);
    }
}

