/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.MooseAIJostle;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

public class EntityMoose
extends Animal
implements IAnimatedEntity {
    public static final Animation ANIMATION_EAT_GRASS = Animation.create((int)30);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)15);
    private static final int DAY = 24000;
    private static final EntityDataAccessor<Boolean> ANTLERED = SynchedEntityData.defineId(EntityMoose.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> JOSTLING = SynchedEntityData.defineId(EntityMoose.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> JOSTLE_ANGLE = SynchedEntityData.defineId(EntityMoose.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> JOSTLER_UUID = SynchedEntityData.defineId(EntityMoose.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> SNOWY = SynchedEntityData.defineId(EntityMoose.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevJostleAngle;
    public float prevJostleProgress;
    public float jostleProgress;
    public boolean jostleDirection;
    public int jostleTimer = 0;
    public boolean instantlyTriggerJostleAI = false;
    public int jostleCooldown = 100 + this.random.nextInt(40);
    public int timeUntilAntlerDrop = 168000 + this.random.nextInt(3) * 24000;
    private int animationTick;
    private Animation currentAnimation;
    private int snowTimer = 0;
    private boolean permSnow = false;

    protected EntityMoose(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canMooseSpawn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        BlockState blockstate = worldIn.getBlockState(pos.below());
        return blockstate.is(Blocks.GRASS_BLOCK) || blockstate.is(Blocks.SNOW) || blockstate.is(Blocks.SNOW_BLOCK) && worldIn.getRawBrightness(pos, 0) > 8;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 55.0).add(Attributes.ATTACK_DAMAGE, 7.5).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mooseSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MooseAIJostle(this));
        this.goalSelector.addGoal(3, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.MOOSE_BREEDABLES), false));
        this.goalSelector.addGoal(7, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 120, 1.0, 14, 7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 6) {
            for (int lvt_3_1_ = 0; lvt_3_1_ < 7; ++lvt_3_1_) {
                double lvt_4_1_ = this.random.nextGaussian() * 0.02;
                double lvt_6_1_ = this.random.nextGaussian() * 0.02;
                double lvt_8_1_ = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), lvt_4_1_, lvt_6_1_, lvt_8_1_);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isFood(ItemStack stack) {
        if (stack.is(AMTagRegistry.MOOSE_BREEDABLES) && !this.isInLove() && this.getAge() == 0) {
            if (this.getRandom().nextInt(5) == 0) {
                return true;
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
            return false;
        }
        return false;
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.isBaby()) {
            super.setTarget(entitylivingbaseIn);
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANTLERED, (Object)true);
        builder.define(JOSTLING, (Object)false);
        builder.define(SNOWY, (Object)false);
        builder.define(JOSTLE_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(JOSTLER_UUID, Optional.empty());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSnowy(compound.getBoolean("Snowy"));
        if (compound.contains("AntlerTime")) {
            this.timeUntilAntlerDrop = compound.getInt("AntlerTime");
        }
        this.setAntlered(compound.getBoolean("Antlered"));
        this.jostleCooldown = compound.getInt("JostlingCooldown");
        this.permSnow = compound.getBoolean("SnowPerm");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Snowy", this.isSnowy());
        compound.putBoolean("SnowPerm", this.permSnow);
        compound.putInt("AntlerTime", this.timeUntilAntlerDrop);
        compound.putBoolean("Antlered", this.isAntlered());
        compound.putInt("JostlingCooldown", this.jostleCooldown);
    }

    public void tick() {
        super.tick();
        this.prevJostleProgress = this.jostleProgress;
        this.prevJostleAngle = this.getJostleAngle();
        if (this.isJostling()) {
            if (this.jostleProgress < 5.0f) {
                this.jostleProgress += 1.0f;
            }
        } else if (this.jostleProgress > 0.0f) {
            this.jostleProgress -= 1.0f;
        }
        if (this.jostleCooldown > 0) {
            --this.jostleCooldown;
        }
        if (!(this.level().isClientSide || this.getAnimation() != NO_ANIMATION || this.getRandom().nextInt(120) != 0 || this.getTarget() != null && this.getTarget().isAlive() || this.isJostling() || this.getJostlingPartnerUUID() != null || !this.level().getBlockState(this.blockPosition().below()).is(Blocks.GRASS_BLOCK) || this.getRandom().nextInt(3) != 0)) {
            this.setAnimation(ANIMATION_EAT_GRASS);
        }
        if (this.timeUntilAntlerDrop > 0) {
            --this.timeUntilAntlerDrop;
        }
        if (this.timeUntilAntlerDrop == 0) {
            if (this.isAntlered()) {
                this.setAntlered(false);
                this.spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.MOOSE_ANTLER.get()));
                this.timeUntilAntlerDrop = 48000 + this.random.nextInt(3) * 24000;
            } else {
                this.setAntlered(true);
                this.timeUntilAntlerDrop = 168000 + this.random.nextInt(3) * 24000;
            }
        }
        if (this.getTarget() != null && this.getTarget().isAlive()) {
            if (this.isJostling()) {
                this.setJostling(false);
            }
            if (!this.level().isClientSide && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 8) {
                float dmg = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue();
                if (!this.isAntlered()) {
                    dmg = 3.0f;
                }
                if (this.getTarget() instanceof Wolf || this.getTarget() instanceof EntityOrca) {
                    dmg = 2.0f;
                }
                this.getTarget().knockback(1.0, this.getTarget().getX() - this.getX(), this.getTarget().getZ() - this.getZ());
                this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), dmg);
            }
        }
        if (this.snowTimer > 0) {
            --this.snowTimer;
        }
        if (this.snowTimer == 0 && !this.level().isClientSide) {
            this.snowTimer = 200 + this.random.nextInt(400);
            if (this.isSnowy()) {
                if (!(this.permSnow || this.level().isClientSide && this.getRemainingFireTicks() <= 0 && !this.isInWaterOrBubble() && EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition().above()))) {
                    this.setSnowy(false);
                }
            } else if (!this.level().isClientSide && EntityGrizzlyBear.isSnowingAt(this.level(), this.blockPosition())) {
                this.setSnowy(true);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof EntityOrca || entity instanceof Wolf) {
            amount = (amount + 1.0f) * 3.0f;
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.MOOSE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.MOOSE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.MOOSE_HURT.get();
    }

    public boolean isAntlered() {
        return (Boolean)this.entityData.get(ANTLERED);
    }

    public void setAntlered(boolean anters) {
        this.entityData.set(ANTLERED, (Object)anters);
    }

    public boolean isJostling() {
        return (Boolean)this.entityData.get(JOSTLING);
    }

    public void setJostling(boolean jostle) {
        this.entityData.set(JOSTLING, (Object)jostle);
    }

    public float getJostleAngle() {
        return ((Float)this.entityData.get(JOSTLE_ANGLE)).floatValue();
    }

    public void setJostleAngle(float scale) {
        this.entityData.set(JOSTLE_ANGLE, (Object)Float.valueOf(scale));
    }

    @Nullable
    public UUID getJostlingPartnerUUID() {
        return ((Optional)this.entityData.get(JOSTLER_UUID)).orElse(null);
    }

    public void setJostlingPartnerUUID(@Nullable UUID uniqueId) {
        this.entityData.set(JOSTLER_UUID, Optional.ofNullable(uniqueId));
    }

    public boolean isSnowy() {
        return (Boolean)this.entityData.get(SNOWY);
    }

    public void setSnowy(boolean honeyed) {
        this.entityData.set(SNOWY, (Object)honeyed);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (item == Items.SNOW && !this.isSnowy() && !this.level().isClientSide) {
            this.usePlayerItem(player, hand, itemstack);
            this.permSnow = true;
            this.setSnowy(true);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SNOW_PLACE, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        if (item instanceof ShovelItem && this.isSnowy() && !this.level().isClientSide) {
            this.permSnow = false;
            if (!player.isCreative() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                itemstack.hurtAndBreak(1, (LivingEntity)sp, EquipmentSlot.MAINHAND);
            }
            this.setSnowy(false);
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.SNOW_BREAK, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Nullable
    public Entity getJostlingPartner() {
        UUID id = this.getJostlingPartnerUUID();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setJostlingPartner(@Nullable Entity jostlingPartner) {
        if (jostlingPartner == null) {
            this.setJostlingPartnerUUID(null);
        } else {
            this.setJostlingPartnerUUID(jostlingPartner.getUUID());
        }
    }

    public void pushBackJostling(EntityMoose entityMoose, float strength) {
        this.applyKnockbackFromMoose(strength, entityMoose.getX() - this.getX(), entityMoose.getZ() - this.getZ());
    }

    private void applyKnockbackFromMoose(float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)this, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!(strength <= 0.0f)) {
            this.hasImpulse = true;
            Vec3 vector3d = this.getDeltaMovement();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).normalize().scale((double)strength);
            this.setDeltaMovement(vector3d.x / 2.0 - vector3d1.x, 0.3f, vector3d.z / 2.0 - vector3d1.z);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK, ANIMATION_EAT_GRASS};
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.MOOSE.get()).create((Level)serverWorld);
    }

    public boolean canJostleWith(EntityMoose moose) {
        return !moose.isJostling() && moose.isAntlered() && moose.getAnimation() == NO_ANIMATION && !moose.isBaby() && moose.getJostlingPartnerUUID() == null && moose.jostleCooldown == 0;
    }

    public void playJostleSound() {
        this.playSound((SoundEvent)AMSoundRegistry.MOOSE_JOSTLE.get(), this.getVoicePitch(), this.getSoundVolume());
    }
}

