/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class EntityMobProjectile
extends Entity {
    private UUID ownerUUID;
    private int ownerNetworkId;
    private boolean leftOwner;

    public EntityMobProjectile(EntityType type, Level level) {
        super(type, level);
    }

    public EntityMobProjectile(EntityType type, Level worldIn, Mob shooter) {
        this(type, worldIn);
        this.setShooter((Entity)shooter);
    }

    protected Vec3 calcOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.xRot(xRot * ((float)Math.PI / 180)).yRot(-yRot * ((float)Math.PI / 180));
    }

    protected static float lerpRotation(float f, float f1) {
        while (f1 - f < -180.0f) {
            f -= 360.0f;
        }
        while (f1 - f >= 180.0f) {
            f += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)f, (float)f1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        this.doBehavior();
        super.tick();
        Vec3 vector3d = this.getDeltaMovement();
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
            this.onImpact(raytraceresult);
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        this.updateRotation();
        if (this.isInWall() && (!this.isInWater() || this.removeInWater())) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else if (this.isInWaterOrBubble() && this.removeInWater()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.setDeltaMovement(vector3d.scale((double)0.99f));
            this.setPos(d0, d1, d2);
        }
    }

    protected boolean removeInWater() {
        return true;
    }

    public abstract void doBehavior();

    protected void onEntityHit(EntityHitResult result) {
        Entity entity = this.getShooter();
        if (entity instanceof LivingEntity) {
            boolean bl = result.getEntity().hurt(this.damageSources().mobProjectile((Entity)this, (LivingEntity)entity), this.getDamage());
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected abstract float getDamage();

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.level().getBlockState(p_230299_1_.getBlockPos());
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    public Entity getShooter() {
        if (this.ownerUUID != null && this.level() instanceof ServerLevel) {
            return ((ServerLevel)this.level()).getEntity(this.ownerUUID);
        }
        return this.ownerNetworkId != 0 ? this.level().getEntity(this.ownerNetworkId) : null;
    }

    public void setShooter(@Nullable Entity entityIn) {
        if (entityIn != null) {
            this.ownerUUID = entityIn.getUUID();
            this.ownerNetworkId = entityIn.getId();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compound.putBoolean("LeftOwner", true);
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        this.leftOwner = compound.getBoolean("LeftOwner");
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getShooter();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_234613_0_ -> !p_234613_0_.isSpectator() && p_234613_0_.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        float f = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        float f = -Mth.sin((float)(p_234612_3_ * ((float)Math.PI / 180))) * Mth.cos((float)(p_234612_2_ * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((p_234612_2_ + p_234612_4_) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(p_234612_3_ * ((float)Math.PI / 180))) * Mth.cos((float)(p_234612_2_ * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, p_234612_5_, p_234612_6_);
        Vec3 vector3d = p_234612_1_.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vector3d.x, p_234612_1_.onGround() ? 0.0 : vector3d.y, vector3d.z));
    }

    protected void onImpact(HitResult result) {
        HitResult.Type raytraceresult$type = result.getType();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)result);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)(x * x + z * z)));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity inQuestion) {
        if (!inQuestion.isSpectator() && inQuestion.isAlive() && inQuestion.isPickable()) {
            Entity entity = this.getShooter();
            return !(entity != null && !this.leftOwner && entity.isPassengerOfSameVehicle(inQuestion) || entity != null && inQuestion != null && this.isSameTeam(entity, inQuestion));
        }
        return false;
    }

    public boolean isSameTeam(Entity shooter, Entity entity) {
        TamableAnimal tamableAnimal;
        if (shooter instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)shooter).isTame()) {
            TamableAnimal alsoTameable;
            if (entity instanceof TamableAnimal && (alsoTameable = (TamableAnimal)entity).isTame() && alsoTameable.getOwnerUUID() != null && tamableAnimal.getOwnerUUID() != null && tamableAnimal.getOwnerUUID().equals(alsoTameable.getOwnerUUID())) {
                return true;
            }
            return tamableAnimal.getOwnerUUID() != null && tamableAnimal.getOwnerUUID().equals(entity.getUUID()) || shooter.isAlliedTo(entity);
        }
        return shooter.isAlliedTo(entity);
    }

    protected void updateRotation() {
        Vec3 vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)vector3d.horizontalDistance()));
        this.setXRot(EntityMobProjectile.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875)));
        this.setYRot(EntityMobProjectile.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875)));
    }
}

