/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.MimiCubeAIRangedAttack;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;

public class EntityMimicube
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityMimicube.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final MimiCubeAIRangedAttack aiArrowAttack = new MimiCubeAIRangedAttack(this, 1.0, 10, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    public float leftSwapProgress = 0.0f;
    public float prevLeftSwapProgress = 0.0f;
    public float rightSwapProgress = 0.0f;
    public float prevRightSwapProgress = 0.0f;
    public float helmetSwapProgress = 0.0f;
    public float prevHelmetSwapProgress = 0.0f;
    public float prevAttackProgress;
    public float attackProgress;
    private boolean wasOnGround;
    private int eatingTicks;

    protected EntityMimicube(EntityType type, Level world) {
        super(type, world);
        this.moveControl = new MimicubeMoveHelper(this);
        this.navigation = new DirectPathNavigator((Mob)this, world);
        this.setCombatTask();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.45f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mimicubeSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TICK, (Object)0);
    }

    public boolean doHurtTarget(Entity entityIn) {
        this.entityData.set(ATTACK_TICK, (Object)5);
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 60, 1.0, 10, 7));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    public void setCombatTask() {
        if (this.level() != null && !this.level().isClientSide) {
            this.goalSelector.removeGoal((Goal)this.aiAttackOnCollide);
            this.goalSelector.removeGoal((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.getMainHandItem();
            if (itemstack.getItem() instanceof ProjectileWeaponItem || itemstack.getItem() instanceof TridentItem) {
                int i = 10;
                if (this.level().getDifficulty() != Difficulty.HARD) {
                    i = 30;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.goalSelector.addGoal(4, (Goal)this.aiArrowAttack);
            } else {
                this.goalSelector.addGoal(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void attackEntityWithRangedAttackTrident(LivingEntity target, float distanceFactor) {
        ThrownTrident tridententity = new ThrownTrident(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.TRIDENT));
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - tridententity.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        tridententity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        this.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)tridententity);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.getMainHandItem().getItem() instanceof TridentItem) {
            this.attackEntityWithRangedAttackTrident(target, distanceFactor);
            return;
        }
        ItemStack itemstack = this.getProjectile(this.getMainHandItem());
        AbstractArrow abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrowentity, ItemStack.EMPTY, ItemStack.EMPTY);
        }
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - abstractarrowentity.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrowentity);
    }

    protected AbstractArrow fireArrow(ItemStack arrowStack, float distanceFactor) {
        return null;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem p_230280_1_) {
        return p_230280_1_ == Items.BOW;
    }

    public void setSlot(EquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn) {
            case HEAD: {
                if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.getItemBySlot(EquipmentSlot.HEAD))) break;
                this.helmetSwapProgress = 5.0f;
                this.level().broadcastEntityEvent((Entity)this, (byte)45);
                break;
            }
            case MAINHAND: {
                if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.getItemBySlot(EquipmentSlot.MAINHAND))) break;
                this.rightSwapProgress = 5.0f;
                this.level().broadcastEntityEvent((Entity)this, (byte)46);
                break;
            }
            case OFFHAND: {
                if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.getItemBySlot(EquipmentSlot.OFFHAND))) break;
                this.leftSwapProgress = 5.0f;
                this.level().broadcastEntityEvent((Entity)this, (byte)47);
            }
        }
        if (!this.level().isClientSide) {
            this.setCombatTask();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        switch (id) {
            case 45: {
                this.helmetSwapProgress = 5.0f;
                break;
            }
            case 46: {
                this.rightSwapProgress = 5.0f;
                break;
            }
            case 47: {
                this.leftSwapProgress = 5.0f;
                break;
            }
        }
    }

    public boolean isBlocking() {
        return this.getMainHandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK) || this.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)trueSource;
            if (!attacker.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                this.setSlot(EquipmentSlot.HEAD, this.mimicStack(attacker.getItemBySlot(EquipmentSlot.HEAD)));
            }
            if (!attacker.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
                this.setSlot(EquipmentSlot.OFFHAND, this.mimicStack(attacker.getItemBySlot(EquipmentSlot.OFFHAND)));
            }
            if (!attacker.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                this.setSlot(EquipmentSlot.MAINHAND, this.mimicStack(attacker.getItemBySlot(EquipmentSlot.MAINHAND)));
            }
        }
        return super.hurt(source, amount);
    }

    private ItemStack mimicStack(ItemStack stack) {
        ItemStack copy = stack.copy();
        if (copy.isDamageableItem()) {
            copy.setDamageValue(copy.getMaxDamage());
        }
        return copy;
    }

    public void tick() {
        super.tick();
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        this.prevHelmetSwapProgress = this.helmetSwapProgress;
        this.prevRightSwapProgress = this.rightSwapProgress;
        this.prevLeftSwapProgress = this.leftSwapProgress;
        this.prevAttackProgress = this.attackProgress;
        if (this.rightSwapProgress > 0.0f) {
            this.rightSwapProgress -= 0.5f;
        }
        if (this.leftSwapProgress > 0.0f) {
            this.leftSwapProgress -= 0.5f;
        }
        if (this.helmetSwapProgress > 0.0f) {
            this.helmetSwapProgress -= 0.5f;
        }
        if (this.onGround() && !this.wasOnGround) {
            for (int j = 0; j < 8; ++j) {
                float f = this.random.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.random.nextFloat() * 0.5f + 0.5f;
                float f2 = Mth.sin((float)f) * 0.5f * f1;
                float f3 = Mth.cos((float)f) * 0.5f * f1;
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)AMItemRegistry.MIMICREAM.get())), this.getX() + (double)f2, this.getY(), this.getZ() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.playSound(this.getSquishSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.35f;
        } else if (!this.onGround() && this.wasOnGround) {
            this.squishAmount = 2.0f;
        }
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.05, 0.0));
        }
        if (this.getOffhandItem().has(DataComponents.FOOD) && this.getHealth() < this.getMaxHealth()) {
            if (this.eatingTicks < 100) {
                for (i = 0; i < 3; ++i) {
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.OFF_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
                if (this.eatingTicks % 6 == 0) {
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                }
                ++this.eatingTicks;
            }
            if (this.eatingTicks == 100) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.PLAYER_BURP, this.getSoundVolume(), this.getVoicePitch());
                this.getOffhandItem().shrink(1);
                this.heal(5.0f);
                this.eatingTicks = 0;
            }
        } else if (this.getMainHandItem().has(DataComponents.FOOD) && this.getHealth() < this.getMaxHealth()) {
            if (this.eatingTicks < 100) {
                for (i = 0; i < 3; ++i) {
                    double d2 = this.random.nextGaussian() * 0.02;
                    double d0 = this.random.nextGaussian() * 0.02;
                    double d1 = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemInHand(InteractionHand.MAIN_HAND)), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() + (double)(this.getBbHeight() * 0.5f) + (double)(this.random.nextFloat() * this.getBbHeight() * 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, d0, d1, d2);
                }
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.eatingTicks % 6 == 0) {
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                }
                ++this.eatingTicks;
            }
            if (this.eatingTicks == 100) {
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.PLAYER_BURP, this.getSoundVolume(), this.getVoicePitch());
                this.getMainHandItem().shrink(1);
                this.heal(5.0f);
            }
        } else {
            this.eatingTicks = 0;
        }
        this.wasOnGround = this.onGround();
        this.alterSquishAmount();
        LivingEntity livingentity = this.getTarget();
        if (livingentity != null && this.distanceToSqr((Entity)livingentity) < 144.0) {
            this.moveControl.setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), this.moveControl.getSpeedModifier());
            this.wasOnGround = true;
        }
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            if ((Integer)this.entityData.get(ATTACK_TICK) == 2 && this.getTarget() != null && (double)this.distanceTo((Entity)this.getTarget()) < 2.3) {
                super.doHurtTarget((Entity)this.getTarget());
            }
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 3.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
    }

    protected float getEquipmentDropChance(EquipmentSlot slotIn) {
        return 0.0f;
    }

    private SoundEvent getSquishSound() {
        return (SoundEvent)AMSoundRegistry.MIMICUBE_JUMP.get();
    }

    private SoundEvent getJumpSound() {
        return (SoundEvent)AMSoundRegistry.MIMICUBE_JUMP.get();
    }

    public void jumpFromGround() {
        Vec3 vector3d = this.getDeltaMovement();
        this.setDeltaMovement(vector3d.x, this.getJumpPower(), vector3d.z);
        this.hasImpulse = true;
    }

    protected int getJumpDelay() {
        return this.random.nextInt(20) + 10;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public boolean shouldShoot() {
        return this.getMainHandItem().getItem() instanceof ProjectileWeaponItem || this.getMainHandItem().getItem() instanceof TridentItem;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.MIMICUBE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.MIMICUBE_HURT.get();
    }

    private static class MimicubeMoveHelper
    extends MoveControl {
        private final EntityMimicube slime;
        private float yRot;
        private int jumpDelay;
        private boolean isAggressive;

        public MimicubeMoveHelper(EntityMimicube slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.getYRot() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.speedModifier = speedIn;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            if (this.mob.onGround()) {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                if (this.jumpDelay-- <= 0 && this.operation != MoveControl.Operation.WAIT) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.mob.getTarget() != null) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.getJumpControl().jump();
                    this.slime.playSound(this.slime.getJumpSound(), this.slime.getSoundVolume(), this.slime.getVoicePitch());
                } else {
                    this.slime.xxa = 0.0f;
                    this.slime.zza = 0.0f;
                    this.mob.setSpeed(0.0f);
                }
            }
            super.tick();
        }
    }
}

