/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityAnteater;
import com.github.alexthe666.alexsmobs.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.LeafcutterAntAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.LeafcutterAntAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityLeafcutterAnthill;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityLeafcutterAnt
extends Animal
implements NeutralMob,
IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)13);
    protected static final EntityDimensions QUEEN_SIZE = EntityDimensions.fixed((float)1.25f, (float)0.98f);
    public static final ResourceLocation QUEEN_LOOT = ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"entities/leafcutter_ant_queen");
    private static final EntityDataAccessor<Optional<BlockPos>> LEAF_HARVESTED_POS = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Optional<BlockState>> LEAF_HARVESTED_STATE = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    private static final EntityDataAccessor<Boolean> HAS_LEAF = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> ANT_SCALE = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> QUEEN = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(EntityLeafcutterAnt.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final UniformInt ANGRY_TIMER = TimeUtil.rangeOfSeconds((int)10, (int)20);
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private Direction prevAttachDir = Direction.DOWN;
    @Nullable
    private EntityLeafcutterAnt caravanHead;
    @Nullable
    private EntityLeafcutterAnt caravanTail;
    private UUID lastHurtBy;
    @Nullable
    private BlockPos hivePos = null;
    private int stayOutOfHiveCountdown;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isUpsideDownNavigator;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of(AMTagRegistry.LEAFCUTTER_ANT_FOODSTUFFS);
    private int haveBabyCooldown = 0;

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public EntityLeafcutterAnt(EntityType type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.switchNavigator(true);
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (entitylivingbaseIn instanceof Player && ((Player)entitylivingbaseIn).isCreative()) {
            return;
        }
        super.setTarget(entitylivingbaseIn);
    }

    private void switchNavigator(boolean rightsideUp) {
        if (rightsideUp) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new AdvancedPathNavigateNoTeleport((Mob)this, this.level(), AdvancedPathNavigate.MovementType.WALKING, true, false);
            this.isUpsideDownNavigator = false;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 0.6f, false);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isUpsideDownNavigator = true;
        }
    }

    public boolean canCollideWith(Entity entity) {
        return !(entity instanceof EntityAnteater) && super.canCollideWith(entity);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    private static boolean isSideSolid(BlockGetter reader, BlockPos pos, Entity entityIn, Direction direction) {
        return Block.isFaceFull((VoxelShape)reader.getBlockState(pos).getCollisionShape(reader, pos, CollisionContext.of((Entity)entityIn)), (Direction)direction);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ReturnToHiveGoal());
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, (Goal)new TameableAITempt(this, 1.1, TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(4, (Goal)new LeafcutterAntAIFollowCaravan(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LeafcutterAntAIForageLeaves(this));
        this.goalSelector.addGoal(6, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 30, 1.0, 25, 7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AngerGoal(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isQueen() ? (SoundEvent)AMSoundRegistry.LEAFCUTTER_ANT_QUEEN_HURT.get() : (SoundEvent)AMSoundRegistry.LEAFCUTTER_ANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.isQueen() ? (SoundEvent)AMSoundRegistry.LEAFCUTTER_ANT_QUEEN_HURT.get() : (SoundEvent)AMSoundRegistry.LEAFCUTTER_ANT_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public void push(Entity entity) {
        if (!(entity instanceof EntityAnteater)) {
            super.push(entity);
        }
    }

    private void pacifyAllNearby() {
        this.stopBeingAngry();
        List list = this.level().getEntitiesOfClass(EntityLeafcutterAnt.class, this.getBoundingBox().inflate(20.0, 6.0, 20.0));
        for (EntityLeafcutterAnt ant : list) {
            ant.stopBeingAngry();
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (type != InteractionResult.SUCCESS && itemstack.is(AMTagRegistry.LEAFCUTTER_ANT_FOODSTUFFS)) {
            if (this.isQueen() && this.haveBabyCooldown == 0) {
                int babies = 1 + this.random.nextInt(1);
                this.pacifyAllNearby();
                for (int i = 0; i < babies; ++i) {
                    EntityLeafcutterAnt leafcutterAnt = (EntityLeafcutterAnt)((EntityType)AMEntityRegistry.LEAFCUTTER_ANT.get()).create(this.level());
                    leafcutterAnt.copyPosition((Entity)this);
                    leafcutterAnt.setAge(-24000);
                    if (this.level().isClientSide) continue;
                    this.level().broadcastEntityEvent((Entity)this, (byte)18);
                    this.level().addFreshEntity((Entity)leafcutterAnt);
                }
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.haveBabyCooldown = 24000;
                this.setBaby(false);
            } else {
                this.pacifyAllNearby();
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)48);
                this.heal(3.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 48) {
            for (int i = 0; i < 3; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        this.prevAttachChangeProgress = this.attachChangeProgress;
        super.tick();
        if (this.isQueen() && this.getBbWidth() < QUEEN_SIZE.width()) {
            this.refreshDimensions();
        }
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.25f;
        }
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.level().isClientSide && !this.isQueen()) {
            this.setBesideClimbableBlock(this.horizontalCollision || this.verticalCollision && !this.onGround());
            if (this.onGround() || this.isInWaterOrBubble() || this.isInLava()) {
                this.entityData.set(ATTACHED_FACE, (Object)Direction.DOWN);
            } else if (this.verticalCollision) {
                this.entityData.set(ATTACHED_FACE, (Object)Direction.UP);
            } else {
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction dir : HORIZONTALS) {
                    BlockPos antPos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
                    BlockPos offsetPos = antPos.relative(dir);
                    Vec3 offset = Vec3.atCenterOf((Vec3i)offsetPos);
                    if (!(closestDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(offsetPos, (Entity)this, dir.getOpposite())) continue;
                    closestDistance = this.position().distanceTo(offset);
                    closestDirection = dir;
                }
                this.entityData.set(ATTACHED_FACE, (Object)closestDirection);
            }
        }
        boolean flag = false;
        Direction attachmentFacing = this.getAttachmentFacing();
        if (attachmentFacing != Direction.DOWN) {
            if (attachmentFacing == Direction.UP) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 1.0, 0.0));
            } else {
                if (!this.horizontalCollision && attachmentFacing != Direction.UP) {
                    Vec3 vec = Vec3.atLowerCornerOf((Vec3i)attachmentFacing.getNormal());
                    this.setDeltaMovement(this.getDeltaMovement().add(vec.normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.onGround() && vector3d.y < 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.5, 1.0));
                    flag = true;
                }
            }
        }
        if (attachmentFacing == Direction.UP) {
            this.setNoGravity(true);
            this.setDeltaMovement(vector3d.multiply(0.7, 1.0, 0.7));
        } else {
            this.setNoGravity(false);
        }
        if (!flag && this.onClimbable()) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.4, 1.0));
        }
        if (this.prevAttachDir != attachmentFacing) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = attachmentFacing;
        if (!this.level().isClientSide) {
            LivingEntity attackTarget;
            if (attachmentFacing == Direction.UP && !this.isUpsideDownNavigator) {
                this.switchNavigator(false);
            }
            if (attachmentFacing != Direction.UP && this.isUpsideDownNavigator) {
                this.switchNavigator(true);
            }
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.tickCount % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
            if ((attackTarget = this.getTarget()) != null && this.distanceTo((Entity)attackTarget) < attackTarget.getBbWidth() + this.getBbWidth() + 1.0f && this.hasLineOfSight((Entity)attackTarget) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 6) {
                float damage = (int)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
                attackTarget.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private boolean isClimeableFromSide(BlockPos offsetPos, Direction opposite) {
        return false;
    }

    private boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        BlockEntity tileentity = this.level().getBlockEntity(this.hivePos);
        return tileentity instanceof TileEntityLeafcutterAnthill;
    }

    protected void onInsideBlock(BlockState state) {
    }

    public boolean onClimbable() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.entityData.get(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b0);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.lastHurtBy;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGRY_TIMER.sample(this.random));
    }

    protected void customServerAiStep() {
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CLIMBING, (Object)0);
        builder.define(LEAF_HARVESTED_POS, Optional.empty());
        builder.define(LEAF_HARVESTED_STATE, Optional.empty());
        builder.define(HAS_LEAF, (Object)false);
        builder.define(QUEEN, (Object)false);
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(ANT_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(ANGER_TIME, (Object)0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setAntScale(0.75f + this.random.nextFloat() * 0.3f);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public float getAntScale() {
        return ((Float)this.entityData.get(ANT_SCALE)).floatValue();
    }

    public void setAntScale(float scale) {
        this.entityData.set(ANT_SCALE, (Object)Float.valueOf(scale));
    }

    public BlockPos getHarvestedPos() {
        return ((Optional)this.entityData.get(LEAF_HARVESTED_POS)).orElse(null);
    }

    public void setLeafHarvestedPos(BlockPos harvestedPos) {
        this.entityData.set(LEAF_HARVESTED_POS, Optional.ofNullable(harvestedPos));
    }

    public BlockState getHarvestedState() {
        return ((Optional)this.entityData.get(LEAF_HARVESTED_STATE)).orElse(null);
    }

    public void setLeafHarvestedState(BlockState state) {
        this.entityData.set(LEAF_HARVESTED_STATE, Optional.ofNullable(state));
    }

    public boolean hasLeaf() {
        return (Boolean)this.entityData.get(HAS_LEAF);
    }

    public void setLeaf(boolean leaf) {
        this.entityData.set(HAS_LEAF, (Object)leaf);
    }

    public boolean isQueen() {
        return (Boolean)this.entityData.get(QUEEN);
    }

    public void setQueen(boolean queen) {
        boolean prev = this.isQueen();
        if (!prev && queen) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(36.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
            this.setHealth(36.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(6.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.0);
        }
        this.entityData.set(QUEEN, (Object)queen);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(ATTACHED_FACE, (Object)Direction.from3DDataValue((int)compound.getByte("AttachFace")));
        this.setLeaf(compound.getBoolean("Leaf"));
        this.setQueen(compound.getBoolean("Queen"));
        this.setAntScale(compound.getFloat("AntScale"));
        BlockState blockstate = null;
        if (compound.contains("HarvestedLeafState", 10) && (blockstate = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("HarvestedLeafState"))).isAir()) {
            blockstate = null;
        }
        this.stayOutOfHiveCountdown = compound.getInt("CannotEnterHiveTicks");
        this.haveBabyCooldown = compound.getInt("BabyCooldown");
        this.hivePos = null;
        if (compound.contains("HivePos")) {
            this.hivePos = BlockPos.of((long)compound.getLong("HivePos"));
        }
        this.setLeafHarvestedState(blockstate);
        if (compound.contains("HLPX")) {
            int i = compound.getInt("HLPX");
            int j = compound.getInt("HLPY");
            int k = compound.getInt("HLPZ");
            this.entityData.set(LEAF_HARVESTED_POS, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.entityData.set(LEAF_HARVESTED_POS, Optional.empty());
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("AttachFace", (byte)((Direction)this.entityData.get(ATTACHED_FACE)).get3DDataValue());
        compound.putBoolean("Leaf", this.hasLeaf());
        compound.putBoolean("Queen", this.isQueen());
        compound.putFloat("AntScale", this.getAntScale());
        BlockState blockstate = this.getHarvestedState();
        if (blockstate != null) {
            compound.put("HarvestedLeafState", (Tag)NbtUtils.writeBlockState((BlockState)blockstate));
        }
        if (this.hasHive()) {
            compound.put("HivePos", NbtUtils.writeBlockPos((BlockPos)this.getHivePos()));
        }
        compound.putInt("CannotEnterHiveTicks", this.stayOutOfHiveCountdown);
        compound.putInt("BabyCooldown", this.haveBabyCooldown);
        BlockPos blockpos = this.getHarvestedPos();
        if (blockpos != null) {
            compound.putInt("HLPX", blockpos.getX());
            compound.putInt("HLPY", blockpos.getY());
            compound.putInt("HLPZ", blockpos.getZ());
        }
    }

    public void setStayOutOfHiveCountdown(int p_226450_1_) {
        this.stayOutOfHiveCountdown = p_226450_1_;
    }

    private boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        BlockEntity tileentity = this.level().getBlockEntity(this.hivePos);
        return tileentity instanceof TileEntityLeafcutterAnthill && ((TileEntityLeafcutterAnthill)tileentity).isNearFire();
    }

    private boolean doesHiveHaveSpace(BlockPos pos) {
        BlockEntity tileentity = this.level().getBlockEntity(pos);
        if (tileentity instanceof TileEntityLeafcutterAnthill) {
            return !((TileEntityLeafcutterAnthill)tileentity).isFullOfAnts();
        }
        return false;
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    @Nullable
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityLeafcutterAnt caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityLeafcutterAnt getCaravanHead() {
        return this.caravanHead;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public boolean shouldLeadCaravan() {
        return !this.hasLeaf();
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)(2.0 * (this.getY() - this.yo)), (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * 4.0f, 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean doHurtTarget(Entity entityIn) {
        this.setAnimation(ANIMATION_BITE);
        return true;
    }

    private class ReturnToHiveGoal
    extends Goal {
        private int searchCooldown = 1;
        private BlockPos hivePos;
        private int approachTime = 0;
        private int moveToCooldown = 0;

        public boolean canUse() {
            if (EntityLeafcutterAnt.this.stayOutOfHiveCountdown > 0) {
                return false;
            }
            if (EntityLeafcutterAnt.this.hasLeaf() || EntityLeafcutterAnt.this.isQueen()) {
                --this.searchCooldown;
                BlockPos hive = EntityLeafcutterAnt.this.hivePos;
                if (hive != null && EntityLeafcutterAnt.this.level().getBlockEntity(hive) instanceof TileEntityLeafcutterAnthill) {
                    this.hivePos = hive;
                    return true;
                }
                if (this.searchCooldown <= 0) {
                    this.searchCooldown = 400;
                    PoiManager pointofinterestmanager = ((ServerLevel)EntityLeafcutterAnt.this.level()).getPoiManager();
                    Stream stream = pointofinterestmanager.findAll(poiTypeHolder -> poiTypeHolder.is(AMPointOfInterestRegistry.LEAFCUTTER_ANT_HILL.getKey()), (Predicate)Predicates.alwaysTrue(), EntityLeafcutterAnt.this.blockPosition(), 100, PoiManager.Occupancy.ANY);
                    List listOfHives = stream.collect(Collectors.toList());
                    BlockPos ret = null;
                    for (BlockPos pos : listOfHives) {
                        if (ret != null && !(pos.distSqr((Vec3i)EntityLeafcutterAnt.this.blockPosition()) < ret.distSqr((Vec3i)EntityLeafcutterAnt.this.blockPosition()))) continue;
                        ret = pos;
                    }
                    this.hivePos = ret;
                    EntityLeafcutterAnt.this.hivePos = ret;
                    return this.hivePos != null;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.hivePos != null && EntityLeafcutterAnt.this.distanceToSqr(Vec3.upFromBottomCenterOf((Vec3i)this.hivePos, (double)1.0)) > 1.0;
        }

        public void stop() {
            this.hivePos = null;
            this.searchCooldown = 20;
            this.approachTime = 0;
        }

        public void start() {
            this.searchCooldown = 20;
            this.approachTime = 0;
            this.moveToCooldown = 10 + EntityLeafcutterAnt.this.random.nextInt(10);
        }

        public void tick() {
            if (this.moveToCooldown > 0) {
                --this.moveToCooldown;
            }
            if (this.hivePos != null) {
                BlockEntity tileentity;
                double dist = EntityLeafcutterAnt.this.distanceToSqr(Vec3.upFromBottomCenterOf((Vec3i)this.hivePos, (double)1.0));
                if (dist < (double)1.2f && EntityLeafcutterAnt.this.getBlockPosBelowThatAffectsMyMovement().equals((Object)this.hivePos) && (tileentity = EntityLeafcutterAnt.this.level().getBlockEntity(this.hivePos)) instanceof TileEntityLeafcutterAnthill) {
                    TileEntityLeafcutterAnthill beehivetileentity = (TileEntityLeafcutterAnthill)tileentity;
                    beehivetileentity.tryEnterHive(EntityLeafcutterAnt.this, EntityLeafcutterAnt.this.hasLeaf());
                }
                if (dist < 16.0) {
                    ++this.approachTime;
                    if (dist < 4.0) {
                        Vec3 center = Vec3.upFromBottomCenterOf((Vec3i)this.hivePos, (double)1.1f);
                        Vec3 add = center.subtract(EntityLeafcutterAnt.this.position());
                        if (add.length() > 1.0) {
                            add = add.normalize();
                        }
                        add = add.scale((double)0.2f);
                        EntityLeafcutterAnt.this.setDeltaMovement(EntityLeafcutterAnt.this.getDeltaMovement().add(add));
                    }
                    int n = this.approachTime < 200 ? 2 : 10;
                    if (dist < (double)n && EntityLeafcutterAnt.this.getY() >= (double)this.hivePos.getY()) {
                        if (EntityLeafcutterAnt.this.getAttachmentFacing() != Direction.DOWN) {
                            EntityLeafcutterAnt.this.setDeltaMovement(EntityLeafcutterAnt.this.getDeltaMovement().add(0.0, 0.1, 0.0));
                        }
                        EntityLeafcutterAnt.this.getMoveControl().setWantedPosition((double)this.hivePos.getX() + 0.5, (double)this.hivePos.getY() + 1.5, (double)this.hivePos.getZ() + 0.5, 1.0);
                    }
                    if (this.moveToCooldown <= 0) {
                        this.moveToCooldown = 50 + EntityLeafcutterAnt.this.random.nextInt(30);
                        EntityLeafcutterAnt.this.navigation.resetMaxVisitedNodesMultiplier();
                        EntityLeafcutterAnt.this.navigation.moveTo((double)this.hivePos.getX() + 0.5, (double)this.hivePos.getY() + (double)1.6f, (double)this.hivePos.getZ() + 0.5, 1.0);
                    }
                } else {
                    this.startMovingToFar(this.hivePos);
                }
            }
        }

        private boolean startMovingToFar(BlockPos pos) {
            if (this.moveToCooldown <= 0) {
                this.moveToCooldown = 50 + EntityLeafcutterAnt.this.random.nextInt(30);
                EntityLeafcutterAnt.this.navigation.setMaxVisitedNodesMultiplier(10.0f);
                EntityLeafcutterAnt.this.navigation.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
            }
            return EntityLeafcutterAnt.this.navigation.getPath() != null && EntityLeafcutterAnt.this.navigation.getPath().canReach();
        }
    }

    class AngerGoal
    extends HurtByTargetGoal {
        AngerGoal(EntityLeafcutterAnt beeIn) {
            super((PathfinderMob)beeIn, new Class[0]);
            this.setAlertOthers(new Class[]{EntityLeafcutterAnt.class});
        }

        public boolean canContinueToUse() {
            return EntityLeafcutterAnt.this.isAngry() && super.canContinueToUse();
        }

        protected void alertOther(Mob mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityLeafcutterAnt && this.mob.hasLineOfSight((Entity)targetIn)) {
                mobIn.setTarget(targetIn);
            }
        }
    }
}

