/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFleeAdult;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.KomodoDragonAIBreed;
import com.github.alexthe666.alexsmobs.entity.ai.KomodoDragonAIJostle;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

public class EntityKomodoDragon
extends TamableAnimal
implements ITargetsDroppedItems,
IFollower {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of(AMTagRegistry.KOMODO_DRAGON_TAMEABLES);
    public int slaughterCooldown = 0;
    public int timeUntilSpit = this.random.nextInt(12000) + 24000;
    public float nextJostleAngleFromServer;
    private int riderAttackCooldown = 0;
    public static final Predicate<EntityKomodoDragon> TARGETABLE_KOMODO = komodo -> {
        if (komodo.isBaby()) {
            return false;
        }
        return komodo.getHealth() <= 0.7f * komodo.getMaxHealth();
    };
    protected static final EntityDimensions JOSTLING_SIZE = EntityDimensions.scalable((float)1.35f, (float)1.85f);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityKomodoDragon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> JOSTLING = SynchedEntityData.defineId(EntityKomodoDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> JOSTLE_ANGLE = SynchedEntityData.defineId(EntityKomodoDragon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> JOSTLER_UUID = SynchedEntityData.defineId(EntityKomodoDragon.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(EntityKomodoDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float prevJostleAngle;
    public float prevJostleProgress;
    public float jostleProgress;
    public float prevSitProgress;
    public float sitProgress;
    public boolean jostleDirection;
    public int jostleTimer = 0;
    public boolean instantlyTriggerJostleAI = false;
    public int jostleCooldown = 100 + this.random.nextInt(40);
    private boolean hasJostlingSize;

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COMMAND, (Object)0);
        builder.define(JOSTLING, (Object)false);
        builder.define(SADDLED, (Object)false);
        builder.define(JOSTLE_ANGLE, (Object)Float.valueOf(0.0f));
        builder.define(JOSTLER_UUID, Optional.empty());
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public static <T extends Mob> boolean canKomodoDragonSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.KOMODO_DRAGON_SPAWNS);
        return spawnBlock && worldIn.getRawBrightness(pos, 0) > 8;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.komodoDragonSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.goalSelector.addGoal(3, (Goal)new TameableAIFollowOwner(this, 1.2, 6.0f, 3.0f, false));
        this.goalSelector.addGoal(4, (Goal)new KomodoDragonAIJostle(this));
        this.goalSelector.addGoal(5, (Goal)new TameableAITempt((Animal)this, 1.1, TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new AnimalAIFleeAdult((Animal)this, 1.25, 32.0));
        this.goalSelector.addGoal(6, (Goal)new KomodoDragonAIBreed(this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 50));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, new CreatureAITargetItems((PathfinderMob)this, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityKomodoDragon.class, 50, true, false, TARGETABLE_KOMODO));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 150, true, true, null));
        this.targetSelector.addGoal(8, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 180, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.KOMODO_DRAGON_TARGETS)));
    }

    protected Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        if (player.zza != 0.0f) {
            float f = player.zza < 0.0f ? 0.5f : 1.0f;
            return new Vec3((double)(player.xxa * 0.25f), 0.0, (double)(player.zza * 0.5f * f));
        }
        this.setSprinting(false);
        return Vec3.ZERO;
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        if (player.zza != 0.0f || player.xxa != 0.0f) {
            this.setRot(player.getYRot(), player.getXRot() * 0.25f);
            this.yBodyRot = this.yHeadRot = this.getYRot();
            this.yRotO = this.yHeadRot;
            this.getNavigation().stop();
            this.setTarget(null);
            this.setSprinting(true);
        }
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 2.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.KOMODO_DRAGON_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.KOMODO_DRAGON_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.KOMODO_DRAGON_HURT.get();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SpitTime")) {
            this.timeUntilSpit = compound.getInt("SpitTime");
        }
        this.setCommand(compound.getInt("KomodoCommand"));
        this.jostleCooldown = compound.getInt("JostlingCooldown");
        this.setSaddled(compound.getBoolean("Saddle"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SpitTime", this.timeUntilSpit);
        compound.putInt("KomodoCommand", this.getCommand());
        compound.putBoolean("Saddle", this.isSaddled());
        compound.putInt("JostlingCooldown", this.jostleCooldown);
    }

    public boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        return this.isTame() && stack.is(AMTagRegistry.KOMODO_DRAGON_BREEDABLES);
    }

    public void tick() {
        Player rider;
        this.prevJostleAngle = this.getJostleAngle();
        super.tick();
        this.prevJostleProgress = this.jostleProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.slaughterCooldown > 0) {
            --this.slaughterCooldown;
        }
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && --this.timeUntilSpit <= 0) {
            this.spawnAtLocation((ItemLike)AMItemRegistry.KOMODO_SPIT.get());
            this.timeUntilSpit = this.random.nextInt(12000) + 24000;
        }
        if (this.riderAttackCooldown > 0) {
            --this.riderAttackCooldown;
        }
        if (this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player && (rider = (Player)this.getControllingPassenger()).getLastHurtMob() != null && this.distanceTo((Entity)rider.getLastHurtMob()) < this.getBbWidth() + 3.0f && !this.isAlliedTo((Entity)rider.getLastHurtMob())) {
            UUID preyUUID = rider.getLastHurtMob().getUUID();
            if (!this.getUUID().equals(preyUUID) && this.riderAttackCooldown == 0) {
                this.doHurtTarget((Entity)rider.getLastHurtMob());
                this.riderAttackCooldown = 20;
            }
        }
        if (!this.hasJostlingSize && this.isJostling()) {
            this.refreshDimensions();
            this.hasJostlingSize = true;
        }
        if (this.hasJostlingSize && !this.isJostling()) {
            this.refreshDimensions();
            this.hasJostlingSize = false;
        }
        if (this.isJostling()) {
            if (this.jostleProgress < 5.0f) {
                this.jostleProgress += 1.0f;
            }
        } else if (this.jostleProgress > 0.0f) {
            this.jostleProgress -= 1.0f;
        }
        if (this.isOrderedToSit()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.getCommand() == 2 && !this.isVehicle()) {
            this.setOrderedToSit(true);
        } else {
            this.setOrderedToSit(false);
        }
        if (this.jostleCooldown > 0) {
            --this.jostleCooldown;
        }
        if (!this.level().isClientSide) {
            if (this.getJostleAngle() < this.nextJostleAngleFromServer) {
                this.setJostleAngle(this.getJostleAngle() + 1.0f);
            }
            if (this.getJostleAngle() > this.nextJostleAngleFromServer) {
                this.setJostleAngle(this.getJostleAngle() - 1.0f);
            }
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 5;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    i = 20;
                }
                ((LivingEntity)entityIn).addEffect(new MobEffectInstance(MobEffects.POISON, i * 20, 0));
            }
            return true;
        }
        return false;
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(potioneffectIn);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            return player;
        }
        return null;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            float radius = 0.0f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)this.getBbHeight() * 0.75 + 0.0, this.getZ() + extraZ);
        }
    }

    public double getPassengersRidingOffset() {
        float f = Math.min(0.25f, this.walkAnimation.speed());
        float f1 = this.walkAnimation.position();
        return (double)this.getBbHeight() - 0.2 + (double)(0.12f * Mth.cos((float)(f1 * 0.7f)) * 0.7f * f);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult interactionresult;
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (itemstack.is(AMTagRegistry.KOMODO_DRAGON_TAMEABLES)) {
            if (!this.isTame()) {
                int tameAmount;
                int size = itemstack.getCount();
                if (size > (tameAmount = 58 + this.random.nextInt(16))) {
                    this.tame(player);
                }
                itemstack.shrink(size);
                return InteractionResult.SUCCESS;
            }
            if (this.getHealth() <= this.getMaxHealth()) {
                this.usePlayerItem(player, hand, itemstack);
                this.heal(10.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if ((interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand)) != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            boolean sit;
            if (this.isFood(itemstack)) {
                this.setInLoveTime(600);
                this.usePlayerItem(player, hand, itemstack);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() == Items.SADDLE && !this.isSaddled()) {
                this.usePlayerItem(player, hand, itemstack);
                this.setSaddled(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() instanceof ShearsItem && this.isSaddled()) {
                this.setSaddled(false);
                this.spawnAtLocation((ItemLike)Items.SADDLE);
                return InteractionResult.SUCCESS;
            }
            if (!player.isShiftKeyDown() && !this.isBaby() && this.isSaddled()) {
                player.startRiding((Entity)this);
                return InteractionResult.SUCCESS;
            }
            this.setCommand((this.getCommand() + 1) % 3);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    protected EntityKomodoDragon(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.isBaby() || this.slaughterCooldown > 0) {
            super.setTarget(entitylivingbaseIn);
        }
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.KOMODO_DRAGON.get()).create((Level)p_241840_1_);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.KOMODO_DRAGON_TAMEABLES) || stack.getFoodProperties((LivingEntity)this) != null;
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(SADDLED, (Object)saddled);
    }

    public boolean isJostling() {
        return (Boolean)this.entityData.get(JOSTLING);
    }

    public void setJostling(boolean jostle) {
        this.entityData.set(JOSTLING, (Object)jostle);
    }

    public float getJostleAngle() {
        return ((Float)this.entityData.get(JOSTLE_ANGLE)).floatValue();
    }

    public void setJostleAngle(float scale) {
        this.entityData.set(JOSTLE_ANGLE, (Object)Float.valueOf(scale));
    }

    @Nullable
    public UUID getJostlingPartnerUUID() {
        return ((Optional)this.entityData.get(JOSTLER_UUID)).orElse(null);
    }

    public void setJostlingPartnerUUID(@Nullable UUID uniqueId) {
        this.entityData.set(JOSTLER_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public Entity getJostlingPartner() {
        UUID id = this.getJostlingPartnerUUID();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setJostlingPartner(@Nullable Entity jostlingPartner) {
        if (jostlingPartner == null) {
            this.setJostlingPartnerUUID(null);
        } else {
            this.setJostlingPartnerUUID(jostlingPartner.getUUID());
        }
    }

    public void pushBackJostling(EntityKomodoDragon entityMoose, float strength) {
        this.applyKnockbackFromMoose(strength, entityMoose.getX() - this.getX(), entityMoose.getZ() - this.getZ());
    }

    private void applyKnockbackFromMoose(float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = CommonHooks.onLivingKnockBack((LivingEntity)this, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!(strength <= 0.0f)) {
            this.hasImpulse = true;
            Vec3 vector3d = this.getDeltaMovement();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).normalize().scale((double)strength);
            this.setDeltaMovement(vector3d.x / 2.0 - vector3d1.x, 0.3f, vector3d.z / 2.0 - vector3d1.z);
        }
    }

    public boolean canJostleWith(EntityKomodoDragon moose) {
        return !moose.isOrderedToSit() && !moose.isVehicle() && !moose.isBaby() && moose.getJostlingPartnerUUID() == null && moose.jostleCooldown == 0;
    }

    public void playJostleSound() {
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled() && !this.level().isClientSide) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
        this.setSaddled(false);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.heal(10.0f);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public boolean isMaid() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && (s.toLowerCase().contains("maid") || s.toLowerCase().contains("coda"));
    }
}

