/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHammerheadShark
extends WaterAnimal {
    private static final Predicate<LivingEntity> INJURED_PREDICATE = mob -> (double)mob.getHealth() <= (double)mob.getMaxHealth() / 2.0;

    protected EntityHammerheadShark(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.hammerheadSharkSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new SemiAquaticPathNavigator((Mob)this, worldIn);
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COD_HURT;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new CirclePreyGoal(this, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, (double)0.6f, 7));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 8.0f, 1.0, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<LivingEntity>((Mob)this, LivingEntity.class, 50, false, true, INJURED_PREDICATE));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Squid>((Mob)this, Squid.class, 50, false, true, null));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<EntityMimicOctopus>((Mob)this, EntityMimicOctopus.class, 80, false, true, null));
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<AbstractSchoolingFish>((Mob)this, AbstractSchoolingFish.class, 70, false, true, null));
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.BLOCK;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    public static <T extends Mob> boolean canHammerheadSharkSpawn(EntityType<EntityHammerheadShark> p_223364_0_, LevelAccessor p_223364_1_, MobSpawnType reason, BlockPos p_223364_3_, RandomSource p_223364_4_) {
        if (p_223364_3_.getY() > 45 && p_223364_3_.getY() < p_223364_1_.getSeaLevel()) {
            return p_223364_1_.getFluidState(p_223364_3_).is(FluidTags.WATER);
        }
        return false;
    }

    private static class CirclePreyGoal
    extends Goal {
        EntityHammerheadShark shark;
        float speed;
        float circlingTime = 0.0f;
        float circleDistance = 5.0f;
        float maxCirclingTime = 80.0f;
        boolean clockwise = false;

        public CirclePreyGoal(EntityHammerheadShark shark, float speed) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.shark = shark;
            this.speed = speed;
        }

        public boolean canUse() {
            return this.shark.getTarget() != null;
        }

        public boolean canContinueToUse() {
            return this.shark.getTarget() != null;
        }

        public void start() {
            this.circlingTime = 0.0f;
            this.maxCirclingTime = 360 + this.shark.random.nextInt(80);
            this.circleDistance = 5.0f + this.shark.random.nextFloat() * 5.0f;
            this.clockwise = this.shark.random.nextBoolean();
        }

        public void stop() {
            this.circlingTime = 0.0f;
            this.maxCirclingTime = 360 + this.shark.random.nextInt(80);
            this.circleDistance = 5.0f + this.shark.random.nextFloat() * 5.0f;
            this.clockwise = this.shark.random.nextBoolean();
        }

        public void tick() {
            LivingEntity prey = this.shark.getTarget();
            if (prey != null) {
                double dist = this.shark.distanceTo((Entity)prey);
                if (this.circlingTime >= this.maxCirclingTime) {
                    this.shark.lookAt((Entity)prey, 30.0f, 30.0f);
                    this.shark.getNavigation().moveTo((Entity)prey, 1.5);
                    if (dist < 2.0) {
                        this.shark.doHurtTarget((Entity)prey);
                        if (this.shark.random.nextFloat() < 0.3f) {
                            this.shark.spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.SHARK_TOOTH.get()));
                        }
                        this.stop();
                    }
                } else if (dist <= 25.0) {
                    this.circlingTime += 1.0f;
                    BlockPos circlePos = this.getSharkCirclePos(prey);
                    if (circlePos != null) {
                        this.shark.getNavigation().moveTo((double)circlePos.getX() + 0.5, (double)circlePos.getY() + 0.5, (double)circlePos.getZ() + 0.5, 0.6);
                    }
                } else {
                    this.shark.lookAt((Entity)prey, 30.0f, 30.0f);
                    this.shark.getNavigation().moveTo((Entity)prey, 0.8);
                }
            }
        }

        public BlockPos getSharkCirclePos(LivingEntity target) {
            float angle = (float)Math.PI / 180 * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * Mth.sin((float)angle);
            double extraZ = this.circleDistance * Mth.cos((float)angle);
            BlockPos ground = AMBlockPos.fromCoords(target.getX() + 0.5 + extraX, this.shark.getY(), target.getZ() + 0.5 + extraZ);
            if (this.shark.level().getFluidState(ground).is(FluidTags.WATER)) {
                return ground;
            }
            return null;
        }
    }
}

