/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityPollenBall;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityFlutter
extends TamableAnimal
implements IFollower,
FlyingAnimal {
    private static final EntityDataAccessor<Float> FLUTTER_PITCH = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> POTTED = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TENTACLING = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SHAKING_HEAD_TICKS = SynchedEntityData.defineId(EntityFlutter.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevShootProgress;
    public float shootProgress;
    public float prevSitProgress;
    public float sitProgress;
    public float prevFlutterPitch;
    public float tentacleProgress;
    public float prevTentacleProgress;
    public float FlutterRotation;
    private float rotationVelocity;
    private int squishCooldown = 0;
    private float randomMotionSpeed;
    private boolean isLandNavigator;
    private int timeFlying;
    private List<String> flowersEaten = new ArrayList<String>();
    private boolean hasPotStats = false;

    protected EntityFlutter(EntityType type, Level level) {
        super(type, level);
        this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.5f;
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FLYING_SPEED, (double)0.8f).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.21f);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.requiresCustomPersistence() && !this.hasCustomName();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.isTame() || this.isPotted();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.flutterSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canFlutterSpawnInLight(EntityType<? extends EntityFlutter> p_223325_0_, ServerLevelAccessor p_223325_1_, MobSpawnType p_223325_2_, BlockPos p_223325_3_, RandomSource p_223325_4_) {
        return EntityFlutter.checkMobSpawnRules(p_223325_0_, (LevelAccessor)p_223325_1_, (MobSpawnType)p_223325_2_, (BlockPos)p_223325_3_, (RandomSource)p_223325_4_);
    }

    public static <T extends Mob> boolean canFlutterSpawn(EntityType<EntityFlutter> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockState blockstate = iServerWorld.getBlockState(pos.below());
        return reason == MobSpawnType.SPAWNER || !iServerWorld.canSeeSky(pos) && blockstate.is(AMTagRegistry.FLUTTER_SPAWNS) && pos.getY() <= 64 && EntityFlutter.canFlutterSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FlyAwayFromTarget(this));
        this.goalSelector.addGoal(2, (Goal)new TameableAITempt((Animal)this, 1.1, Ingredient.of(AMTagRegistry.FLUTTER_BREEDABLES), false){

            @Override
            public boolean shouldFollowAM(LivingEntity le) {
                return EntityFlutter.this.canEatFlower(le.getMainHandItem()) || EntityFlutter.this.canEatFlower(le.getOffhandItem()) || super.shouldFollowAM(le);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FlyingAIFollowOwner(this, 1.3, 7.0f, 2.0f, false));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AIWalkIdle());
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 1.0f, false, true);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLUTTER_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(FLYING, (Object)false);
        builder.define(POTTED, (Object)false);
        builder.define(COMMAND, (Object)0);
        builder.define(SITTING, (Object)false);
        builder.define(TENTACLING, (Object)false);
        builder.define(SHOOTING, (Object)false);
        builder.define(SHAKING_HEAD_TICKS, (Object)0);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean isPotted() {
        return (Boolean)this.entityData.get(POTTED);
    }

    public void setPotted(boolean potted) {
        this.entityData.set(POTTED, (Object)potted);
    }

    public float getFlutterPitch() {
        return Mth.clamp((float)((Float)this.entityData.get(FLUTTER_PITCH)).floatValue(), (float)-90.0f, (float)90.0f);
    }

    public void setFlutterPitch(float pitch) {
        this.entityData.set(FLUTTER_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementFlutterPitch(float pitch) {
        this.entityData.set(FLUTTER_PITCH, (Object)Float.valueOf(this.getFlutterPitch() + pitch));
    }

    public void decrementFlutterPitch(float pitch) {
        this.entityData.set(FLUTTER_PITCH, (Object)Float.valueOf(this.getFlutterPitch() - pitch));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.FLUTTER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.FLUTTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.FLUTTER_HURT.get();
    }

    public void tick() {
        boolean shooting;
        float decrease;
        super.tick();
        this.prevShootProgress = this.shootProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevFlutterPitch = this.getFlutterPitch();
        this.prevSitProgress = this.sitProgress;
        float extraMotionSlow = 1.0f;
        float extraMotionSlowY = 1.0f;
        this.yBodyRot = this.getYRot();
        this.yHeadRot = this.getYRot();
        this.prevFlutterPitch = this.getFlutterPitch();
        this.prevTentacleProgress = this.tentacleProgress;
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isSitting()) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.tentacleProgress < 5.0f && ((Boolean)this.entityData.get(TENTACLING)).booleanValue()) {
            this.tentacleProgress += 1.0f;
        }
        if (this.tentacleProgress == 5.0f && !((Boolean)this.entityData.get(TENTACLING)).booleanValue() && this.squishCooldown == 0 && this.isFlying()) {
            this.squishCooldown = 10;
            this.playSound((SoundEvent)AMSoundRegistry.FLUTTER_FLAP.get(), this.getSoundVolume(), 1.5f * this.getVoicePitch());
        }
        if (this.tentacleProgress > 0.0f && !((Boolean)this.entityData.get(TENTACLING)).booleanValue()) {
            this.tentacleProgress -= 1.0f;
        }
        this.FlutterRotation += this.rotationVelocity;
        if ((double)this.FlutterRotation > 6.2831854820251465) {
            if (this.level().isClientSide) {
                this.FlutterRotation = (float)Math.PI * 2;
            } else {
                this.FlutterRotation = (float)((double)this.FlutterRotation - 6.2831854820251465);
                if (this.random.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.5f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.FlutterRotation < (float)Math.PI) {
            float f = this.FlutterRotation / (float)Math.PI;
            if ((double)f >= (double)0.95f) {
                this.entityData.set(TENTACLING, (Object)true);
                if (this.squishCooldown == 0 && this.isFlying()) {
                    this.squishCooldown = 10;
                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                    this.playSound((SoundEvent)AMSoundRegistry.FLUTTER_FLAP.get(), 3.0f, 1.5f * this.getVoicePitch());
                }
                this.randomMotionSpeed = 0.8f;
            } else {
                this.entityData.set(TENTACLING, (Object)false);
                this.randomMotionSpeed = 0.01f;
            }
        }
        if (!this.level().isClientSide) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                this.setDeltaMovement(this.getDeltaMovement().x * (double)this.randomMotionSpeed * (double)extraMotionSlow, this.getDeltaMovement().y * (double)this.randomMotionSpeed * (double)extraMotionSlowY, this.getDeltaMovement().z * (double)this.randomMotionSpeed * (double)extraMotionSlow);
                ++this.timeFlying;
                if (this.onGround() && this.timeFlying > 20 || this.isSitting()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
            }
        }
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.8, 1.0));
        }
        if (this.isFlying()) {
            float dist = (float)((Math.abs(this.getDeltaMovement().x()) + Math.abs(this.getDeltaMovement().z())) * 30.0);
            this.incrementFlutterPitch(-dist);
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.2f, 0.0));
            }
        }
        if (this.getFlutterPitch() > 0.0f) {
            decrease = Math.min(2.5f, this.getFlutterPitch());
            this.decrementFlutterPitch(decrease);
        }
        if (this.getFlutterPitch() < 0.0f) {
            decrease = Math.min(2.5f, -this.getFlutterPitch());
            this.incrementFlutterPitch(decrease);
        }
        if ((shooting = ((Boolean)this.entityData.get(SHOOTING)).booleanValue()) && this.shootProgress < 5.0f) {
            this.shootProgress += 1.0f;
        }
        if (!shooting && this.shootProgress > 0.0f) {
            this.shootProgress -= 1.0f;
        }
        if (shooting) {
            this.incrementFlutterPitch(-30.0f);
        }
        if (!this.level().isClientSide && shooting && this.shootProgress == 5.0f) {
            if (this.getTarget() != null) {
                this.spit(this.getTarget());
            }
            this.entityData.set(SHOOTING, (Object)false);
        }
        if (this.hasPotStats && !this.isPotted()) {
            this.hasPotStats = false;
            this.getAttribute(Attributes.ARMOR).setBaseValue(0.21);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.21);
        }
        if (!this.hasPotStats && this.isPotted()) {
            this.hasPotStats = true;
            this.getAttribute(Attributes.ARMOR).setBaseValue(16.0);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.18);
        }
        if ((Integer)this.entityData.get(SHAKING_HEAD_TICKS) > 0) {
            this.entityData.set(SHAKING_HEAD_TICKS, (Object)((Integer)this.entityData.get(SHAKING_HEAD_TICKS) - 1));
        }
        if (this.squishCooldown > 0) {
            --this.squishCooldown;
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.FLUTTER_BREEDABLES) && this.isTame();
    }

    private void spit(LivingEntity target) {
        EntityPollenBall llamaspitentity = new EntityPollenBall(this.level(), this);
        double d0 = target.getX() - this.getX();
        double d1 = target.getY(0.3333333333333333) - llamaspitentity.getY();
        double d2 = target.getZ() - this.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
        llamaspitentity.shoot(d0, d1 + (double)f, d2, 0.5f, 13.0f);
        if (!this.isSilent()) {
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)llamaspitentity);
    }

    public boolean isShakingHead() {
        return (Integer)this.entityData.get(SHAKING_HEAD_TICKS) > 0;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (!this.isTame() && this.canEatFlower(itemstack)) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, itemstack);
                this.flowersEaten.add(BuiltInRegistries.ITEM.getKey((Object)itemstack.getItem()).toString());
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                this.playSound((SoundEvent)AMSoundRegistry.FLUTTER_YES.get(), this.getSoundVolume(), this.getVoicePitch());
                if (this.flowersEaten.size() > 3 && this.getRandom().nextInt(3) == 0 || this.flowersEaten.size() > 6) {
                    this.tame(player);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!this.isTame() && itemstack.is(ItemTags.FLOWERS)) {
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            this.playSound((SoundEvent)AMSoundRegistry.FLUTTER_NO.get(), this.getSoundVolume(), this.getVoicePitch());
            this.entityData.set(SHAKING_HEAD_TICKS, (Object)20);
        }
        InteractionResult type = super.mobInteract(player, hand);
        if (this.isTame() && itemstack.is(ItemTags.FLOWERS) && this.getHealth() < this.getMaxHealth()) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, itemstack);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.CAT_EAT, this.getSoundVolume(), this.getVoicePitch());
                this.heal(5.0f);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack) && !itemstack.is(ItemTags.FLOWERS)) {
            boolean sit;
            if (item == Items.FLOWER_POT && !this.isPotted()) {
                this.setPotted(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.getItem() instanceof ShearsItem && this.isPotted()) {
                this.setPotted(false);
                this.spawnAtLocation((ItemLike)Items.FLOWER_POT);
                return InteractionResult.SUCCESS;
            }
            if (this.isPotted() && player.isShiftKeyDown()) {
                ItemStack fish = this.getFishBucket();
                if (!player.addItem(fish)) {
                    player.drop(fish, false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    @Override
    public void followEntity(TamableAnimal tameable, LivingEntity owner, double followSpeed) {
        if (this.distanceTo((Entity)owner) > 8.0f) {
            this.setFlying(true);
            this.getNavigation().moveTo(owner.getX(), owner.getY() + (double)owner.getBbHeight(), owner.getZ(), followSpeed);
        } else if (this.isFlying() && !this.isOverWaterOrVoid()) {
            BlockPos vec = this.getFlutterGround(this.blockPosition());
            if (vec != null) {
                this.getMoveControl().setWantedPosition((double)vec.getX(), (double)vec.getY(), (double)vec.getZ(), followSpeed);
            }
            if (this.onGround()) {
                this.setFlying(false);
            }
        } else {
            this.getNavigation().moveTo((Entity)owner, followSpeed);
        }
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isPotted() && !this.level().isClientSide) {
            this.spawnAtLocation((ItemLike)Items.FLOWER_POT);
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("Potted", this.isPotted());
        compound.putInt("FlowersEaten", this.flowersEaten.size());
        for (int i = 0; i < this.flowersEaten.size(); ++i) {
            compound.putString("FlowerEaten" + i, this.flowersEaten.get(i));
        }
        compound.putInt("FlutterCommand", this.getCommand());
        compound.putBoolean("FlutterSitting", this.isSitting());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setPotted(compound.getBoolean("Potted"));
        int flowerCount = compound.getInt("FlowersEaten");
        this.flowersEaten = new ArrayList<String>();
        for (int i = 0; i < flowerCount; ++i) {
            String s = compound.getString("FlowerEaten" + i);
            if (s == null) continue;
            this.flowersEaten.add(s);
        }
        this.setCommand(compound.getInt("FlutterCommand"));
        this.setOrderedToSit(compound.getBoolean("FlutterSitting"));
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -63 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || position.getY() < -63;
    }

    private BlockPos getFlutterGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() > -63 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        if (position.getY() < -62) {
            return position.above(120 + this.random.nextInt(5));
        }
        return position;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = (float)(1 + this.getRandom().nextInt(3)) + radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + this.getRandom().nextFloat() * neg * 0.2f;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getFlutterGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 3 + this.getRandom().nextInt(2);
        BlockPos newPos = ground.above(distFromGround > 4 ? flightHeight : distFromGround - 2 + this.getRandom().nextInt(4));
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getFlutterGround(radialPos);
        if (ground.getY() <= -63) {
            return Vec3.upFromBottomCenterOf((Vec3i)ground, (double)(110 + this.random.nextInt(20)));
        }
        ground = this.blockPosition();
        while (ground.getY() > -63 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground.below());
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((ItemLike)AMItemRegistry.POTTED_FLUTTER.get());
        CompoundTag platTag = new CompoundTag();
        this.addAdditionalSaveData(platTag);
        ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().put("FlutterData", (Tag)platTag);
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return stack;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mobo) {
        EntityFlutter baby = (EntityFlutter)((EntityType)AMEntityRegistry.FLUTTER.get()).create(this.level());
        baby.setPersistenceRequired();
        return baby;
    }

    public boolean hasEatenFlower(ItemStack stack) {
        return this.flowersEaten != null && this.flowersEaten.contains(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
    }

    public boolean canEatFlower(ItemStack stack) {
        return !this.hasEatenFlower(stack) && stack.is(ItemTags.FLOWERS);
    }

    private void setupShooting() {
        this.entityData.set(SHOOTING, (Object)true);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal partner) {
        super.spawnChildFromBreeding(world, partner);
        for (int i = 0; i < 15 + this.random.nextInt(10); ++i) {
            BlockPos nearby = this.blockPosition().offset(this.random.nextInt(16) - 8, this.random.nextInt(2), this.random.nextInt(16) - 8);
            if (world.getBlockState(nearby).getBlock() == Blocks.AZALEA) {
                world.setBlockAndUpdate(nearby, Blocks.FLOWERING_AZALEA.defaultBlockState());
                world.levelEvent(1505, nearby, 0);
            }
            if (world.getBlockState(nearby).getBlock() != Blocks.AZALEA_LEAVES) continue;
            world.setBlockAndUpdate(nearby, Blocks.FLOWERING_AZALEA_LEAVES.defaultBlockState());
            world.levelEvent(1505, nearby, 0);
        }
    }

    private class FlyAwayFromTarget
    extends Goal {
        private final EntityFlutter parentEntity;
        private int spitCooldown = 0;
        private BlockPos shootPos = null;

        public FlyAwayFromTarget(EntityFlutter entityFlutter2) {
            this.parentEntity = entityFlutter2;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return !this.parentEntity.isSitting() && this.parentEntity.getTarget() != null && this.parentEntity.getTarget().isAlive() && !this.parentEntity.isBaby();
        }

        public void tick() {
            if (this.spitCooldown > 0) {
                --this.spitCooldown;
            }
            if (this.parentEntity.getTarget() != null) {
                this.parentEntity.setFlying(true);
                if (this.shootPos == null || this.parentEntity.distanceTo((Entity)this.parentEntity.getTarget()) >= 10.0f || this.parentEntity.getTarget().distanceToSqr((double)((float)this.shootPos.getX() + 0.5f), (double)this.shootPos.getY(), (double)((float)this.shootPos.getZ() + 0.5f)) < 4.0) {
                    this.shootPos = this.getShootFromPos(this.parentEntity.getTarget());
                }
                if (this.shootPos != null) {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.shootPos.getX() + 0.5, (double)this.shootPos.getY() + 0.5, (double)this.shootPos.getZ() + 0.5, 1.5);
                }
                if (this.parentEntity.distanceTo((Entity)this.parentEntity.getTarget()) < 25.0f) {
                    this.parentEntity.lookAt((Entity)this.parentEntity.getTarget(), 30.0f, 30.0f);
                    if (this.spitCooldown == 0) {
                        this.parentEntity.setupShooting();
                        this.spitCooldown = 10 + EntityFlutter.this.random.nextInt(10);
                    }
                    this.shootPos = null;
                }
            }
        }

        public BlockPos getShootFromPos(LivingEntity target) {
            float radius = 3 + this.parentEntity.getRandom().nextInt(5);
            float angle = (float)Math.PI / 180 * (target.yHeadRot + 90.0f + (float)this.parentEntity.getRandom().nextInt(180));
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = AMBlockPos.fromCoords(target.getX() + extraX, target.getY() + 2.0, target.getZ() + extraZ);
            if (!this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)radialPos))) {
                return radialPos;
            }
            return this.parentEntity.blockPosition().above((int)Math.ceil(target.getBbHeight() + 1.0f));
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityFlutter phage;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.phage = EntityFlutter.this;
        }

        public boolean canUse() {
            if (this.phage.isVehicle() || this.phage.isSitting() || this.phage.shouldFollow() || this.phage.getTarget() != null && this.phage.getTarget().isAlive() || this.phage.isPassenger()) {
                return false;
            }
            if (this.phage.getRandom().nextInt(30) != 0 && !this.phage.isFlying() && !this.phage.isInWaterOrBubble()) {
                return false;
            }
            this.flightTarget = this.phage.onGround() && !this.phage.isInWaterOrBubble() ? EntityFlutter.this.random.nextInt(4) == 0 && !this.phage.isBaby() : EntityFlutter.this.random.nextInt(5) > 0 && this.phage.timeFlying < 100 && !this.phage.isBaby();
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.phage.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.phage.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityFlutter.this.isFlying() && this.phage.onGround()) {
                this.phage.setFlying(false);
            }
            if (EntityFlutter.this.isFlying() && this.phage.onGround() && this.phage.timeFlying > 40) {
                this.phage.setFlying(false);
            }
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.phage.position();
            if (this.phage.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.phage.timeFlying < 180 || this.phage.isOverWaterOrVoid()) {
                    return this.phage.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.phage.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.phage, (int)5, (int)5);
        }

        public boolean canContinueToUse() {
            if (this.phage.isSitting()) {
                return false;
            }
            if (this.flightTarget) {
                return this.phage.isFlying() && this.phage.distanceToSqr(this.x, this.y, this.z) > 2.0 && !this.phage.isBaby();
            }
            return !this.phage.getNavigation().isDone() && !this.phage.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.phage.setFlying(true);
                this.phage.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.phage.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.phage.getNavigation().stop();
            super.stop();
        }
    }
}

