/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.misc.AMDamageTypes;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.network.MessageSendVisualFlagFromServer;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityFarseer
extends Monster
implements IAnimatedEntity {
    public static final Animation ANIMATION_EMERGE = Animation.create((int)50);
    private static final int HANDS = 4;
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EMERGED = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MELEEING = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> LASER_ENTITY_ID = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LASER_ATTACK_LVL = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> LASER_DISTANCE = SynchedEntityData.defineId(EntityFarseer.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final int LASER_ATTACK_DURATION = 10;
    public final double[][] positions = new double[64][4];
    public final float[] claspProgress = new float[4];
    public final float[] prevClaspProgress = new float[4];
    public final float[] strikeProgress = new float[4];
    public final float[] prevStrikeProgress = new float[4];
    public final boolean[] isStriking = new boolean[4];
    public int posPointer = -1;
    public float angryProgress;
    public float prevAngryProgress;
    public Vec3 angryShakeVec = Vec3.ZERO;
    public float prevLaserLvl;
    private float faceCameraProgress;
    private float prevFaceCameraProgress;
    private LivingEntity laserTargetEntity;
    private int claspingHand = -1;
    private int animationTick;
    private Animation currentAnimation;
    private int meleeCooldown = 0;

    protected EntityFarseer(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.moveControl = new MoveController();
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 70.0).add(Attributes.ARMOR, 6.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.MOVEMENT_SPEED, (double)0.35f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.farseerSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return dimensions.height() * 0.7f;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, this.level());
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AttackGoal());
        this.goalSelector.addGoal(3, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new EntityAINearestTarget3D<Player>((Mob)this, Player.class, 3, false, true, null));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Emerged", this.hasEmerged());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHasEmerged(compound.getBoolean("Emerged"));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.FARSEER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.FARSEER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.FARSEER_HURT.get();
    }

    public static boolean checkFarseerSpawnRules(EntityType<? extends Monster> animal, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && EntityFarseer.isDarkEnoughToSpawn((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)random) && EntityFarseer.isFarseerArea(worldIn, pos);
    }

    private static boolean isFarseerArea(ServerLevelAccessor iServerWorld, BlockPos pos) {
        return !AMConfig.restrictFarseerSpawns || iServerWorld.getWorldBorder().getDistanceToBorder((double)pos.getX(), (double)pos.getZ()) < (double)AMConfig.farseerBorderSpawnDistance;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_EMERGED, (Object)false);
        builder.define(MELEEING, (Object)false);
        builder.define(ANGRY, (Object)false);
        builder.define(LASER_ENTITY_ID, (Object)-1);
        builder.define(LASER_ATTACK_LVL, (Object)0);
        builder.define(LASER_DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
    }

    public boolean hasLaser() {
        return (Integer)this.entityData.get(LASER_ENTITY_ID) != -1 && this.getAnimation() != ANIMATION_EMERGE;
    }

    public int getLaserAttackLvl() {
        return (Integer)this.entityData.get(LASER_ATTACK_LVL);
    }

    public float getLaserDistance() {
        return ((Float)this.entityData.get(LASER_DISTANCE)).floatValue();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_32834_) {
        super.onSyncedDataUpdated(p_32834_);
        if (LASER_ENTITY_ID.equals(p_32834_)) {
            this.laserTargetEntity = null;
        }
    }

    @Nullable
    public LivingEntity getLaserTarget() {
        if (!this.hasLaser()) {
            return null;
        }
        if (this.level().isClientSide) {
            if (this.laserTargetEntity != null) {
                return this.laserTargetEntity;
            }
            Entity fromID = this.level().getEntity(((Integer)this.entityData.get(LASER_ENTITY_ID)).intValue());
            if (fromID instanceof LivingEntity) {
                this.laserTargetEntity = (LivingEntity)fromID;
                return this.laserTargetEntity;
            }
            return null;
        }
        return this.getTarget();
    }

    public boolean hasEmerged() {
        return (Boolean)this.entityData.get(HAS_EMERGED);
    }

    public void setHasEmerged(boolean emerged) {
        this.entityData.set(HAS_EMERGED, (Object)emerged);
    }

    public void tick() {
        int i;
        super.tick();
        this.prevFaceCameraProgress = this.faceCameraProgress;
        this.prevLaserLvl = this.getLaserAttackLvl();
        if (this.getAnimation() == ANIMATION_EMERGE) {
            this.setHasEmerged(true);
            this.faceCameraProgress = 1.0f;
        } else if (this.faceCameraProgress > 0.0f) {
            this.faceCameraProgress = Math.max(0.0f, this.faceCameraProgress - 0.2f);
        }
        this.prevAngryProgress = this.angryProgress;
        for (i = 0; i < 4; ++i) {
            this.prevClaspProgress[i] = this.claspProgress[i];
            this.prevStrikeProgress[i] = this.strikeProgress[i];
        }
        if (this.posPointer < 0) {
            for (i = 0; i < this.positions.length; ++i) {
                this.positions[i][0] = this.getX();
                this.positions[i][1] = this.getY();
                this.positions[i][2] = this.getZ();
                this.positions[i][3] = this.yBodyRot;
            }
        }
        if (++this.posPointer == this.positions.length) {
            this.posPointer = 0;
        }
        this.positions[this.posPointer][0] = this.getX();
        this.positions[this.posPointer][1] = this.getY();
        this.positions[this.posPointer][2] = this.getZ();
        this.positions[this.posPointer][3] = this.yBodyRot;
        if (this.isAngry() && this.angryProgress < 5.0f) {
            this.angryProgress += 1.0f;
        }
        if (!this.isAngry() && this.angryProgress > 0.0f) {
            this.angryProgress -= 1.0f;
        }
        if (this.isAlive()) {
            LivingEntity livingentity;
            int i2;
            LivingEntity target;
            if (this.random.nextInt(this.isAngry() ? 12 : 40) == 0 && this.claspingHand == -1 && this.claspProgress[i = Mth.clamp((int)this.random.nextInt(4), (int)0, (int)3)] == 0.0f) {
                this.claspingHand = i;
            }
            if (this.claspingHand >= 0) {
                if (this.claspProgress[this.claspingHand] < 5.0f) {
                    int n = this.claspingHand;
                    this.claspProgress[n] = this.claspProgress[n] + 1.0f;
                } else {
                    this.claspingHand = -1;
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    if (!(this.claspProgress[i] > 0.0f)) continue;
                    int n = i;
                    this.claspProgress[n] = this.claspProgress[n] - 1.0f;
                }
            }
            if (!this.hasEmerged()) {
                this.setInvisible(true);
                if (this.level().hasNearbyAlivePlayer(this.getX(), this.getY(), this.getZ(), 9.0)) {
                    this.setAnimation(ANIMATION_EMERGE);
                }
            } else {
                this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
            }
            if (this.getAnimation() == ANIMATION_EMERGE) {
                if (this.level().isClientSide) {
                    this.level().addParticle((ParticleOptions)AMParticleRegistry.STATIC_SPARK.get(), this.getRandomX(0.75), this.getRandomY(), this.getRandomZ(0.75), (double)((this.getRandom().nextFloat() - 0.5f) * 0.2f), (double)(this.getRandom().nextFloat() * 0.2f), (double)((this.getRandom().nextFloat() - 0.5f) * 0.2f));
                }
                if (this.getAnimationTick() == 1) {
                    this.playSound((SoundEvent)AMSoundRegistry.FARSEER_EMERGE.get(), this.getSoundVolume(), this.getVoicePitch());
                }
            }
            if ((target = this.getTarget()) != null && ((Boolean)this.entityData.get(MELEEING)).booleanValue() && this.meleeCooldown == 0) {
                this.meleeCooldown = 5;
                i2 = this.random.nextInt(4);
                this.isStriking[i2] = true;
                this.level().broadcastEntityEvent((Entity)this, (byte)(40 + i2));
            }
            if (this.meleeCooldown > 0) {
                --this.meleeCooldown;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (!this.isStriking[i2] || !((Boolean)this.entityData.get(MELEEING)).booleanValue()) {
                    if (!(this.strikeProgress[i2] > 0.0f)) continue;
                    int n = i2;
                    this.strikeProgress[n] = this.strikeProgress[n] - 1.0f;
                    continue;
                }
                if (!this.isStriking[i2]) continue;
                if (this.strikeProgress[i2] < 5.0f) {
                    int n = i2;
                    this.strikeProgress[n] = this.strikeProgress[n] + 1.0f;
                }
                if (this.strikeProgress[i2] != 5.0f) continue;
                this.isStriking[i2] = false;
                this.level().broadcastEntityEvent((Entity)this, (byte)(44 + i2));
                if (target == null || !(this.distanceTo((Entity)target) <= 4.0f)) continue;
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)(5 + this.random.nextInt(5)));
            }
            if (this.hasLaser() && (livingentity = this.getLaserTarget()) != null) {
                Vec3 hit = this.calculateLaserHit(livingentity.getEyePosition());
                this.entityData.set(LASER_DISTANCE, (Object)Float.valueOf((float)hit.distanceTo(this.getEyePosition())));
                this.getLookControl().setLookAt((Entity)livingentity, 90.0f, 90.0f);
                this.getLookControl().tick();
                double d0 = hit.x - this.getX();
                double d1 = hit.y - this.getEyeY();
                double d2 = hit.z - this.getZ();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                float progress = (float)this.getLaserAttackLvl() / 10.0f;
                double d4 = this.random.nextDouble();
                while (d4 < d3 * (double)progress) {
                    double width = (d4 += 0.5 + 2.0 * this.random.nextDouble()) / (d3 * (double)progress);
                    double d5 = (this.random.nextDouble() - 0.5) * width;
                    double d6 = (this.random.nextDouble() - 0.5) * width;
                    this.level().addParticle((ParticleOptions)AMParticleRegistry.STATIC_SPARK.get(), this.getX() + d0 * d4 + d5, this.getEyeY() + d1 * d4, this.getZ() + d2 * d4 + d6, (double)((this.getRandom().nextFloat() - 0.5f) * 0.2f), (double)(this.getRandom().nextFloat() * 0.2f), (double)((this.getRandom().nextFloat() - 0.5f) * 0.2f));
                }
            }
        }
        this.angryShakeVec = this.isAngry() ? new Vec3((double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() - 0.5f), (double)(this.random.nextFloat() - 0.5f)) : Vec3.ZERO;
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id >= 40 && id <= 43) {
            int i = id - 40;
            this.isStriking[i] = true;
        } else if (id >= 44 && id <= 48) {
            int i = id - 44;
            this.isStriking[i] = false;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public double getLatencyVar(int pointer, int index, float partialTick) {
        if (this.isDeadOrDying()) {
            partialTick = 1.0f;
        }
        int i = this.posPointer - pointer & 0x3F;
        int j = this.posPointer - pointer - 1 & 0x3F;
        double d0 = this.positions[j][index];
        double d1 = Mth.wrapDegrees((double)(this.positions[i][index] - d0));
        return d0 + d1 * (double)partialTick;
    }

    public Vec3 getLatencyOffsetVec(int offset, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)this.xOld, (double)this.getX());
        double d1 = Mth.lerp((double)partialTick, (double)this.yOld, (double)this.getY());
        double d2 = Mth.lerp((double)partialTick, (double)this.zOld, (double)this.getZ());
        float renderYaw = (float)this.getLatencyVar(offset, 3, partialTick);
        return new Vec3(this.getLatencyVar(offset, 0, partialTick) - d0, this.getLatencyVar(offset, 1, partialTick) - d1, this.getLatencyVar(offset, 2, partialTick) - d2).yRot(renderYaw * ((float)Math.PI / 180));
    }

    public Vec3 calculateAfterimagePos(float partialTick, boolean flip, float speed) {
        float f = (partialTick + (float)this.tickCount) * speed;
        float f1 = 0.1f;
        Vec3 v = new Vec3((double)((float)Math.sin(f) * f1), (double)((float)Math.cos((double)f - 1.5707963267948966) * f1), (double)(-((float)Math.cos(f)) * f1));
        if (flip) {
            return new Vec3(v.z, -v.y, v.x);
        }
        return v;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EMERGE};
    }

    public int getPortalFrame() {
        if (this.getAnimation() == ANIMATION_EMERGE) {
            if (this.getAnimationTick() < 10) {
                return 0;
            }
            if (this.getAnimationTick() < 20) {
                return 1;
            }
            if (this.getAnimationTick() < 30) {
                return 2;
            }
            if (this.getAnimationTick() > 40) {
                int i = 50 - this.getAnimationTick();
                return i < 6 ? (i < 3 ? 0 : 1) : 2;
            }
            return 3;
        }
        return 0;
    }

    public float getPortalOpacity(float partialTicks) {
        if (this.getAnimation() == ANIMATION_EMERGE) {
            float tick = (float)(this.getAnimationTick() - 1) + partialTicks;
            if (tick < 5.0f) {
                return tick / 5.0f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public float getFarseerOpacity(float partialTicks) {
        if (this.getAnimation() == ANIMATION_EMERGE) {
            float tick = (float)(this.getAnimationTick() - 1) + partialTicks;
            float prog = tick / (float)ANIMATION_EMERGE.getDuration();
            return prog > 0.5f ? (prog - 0.5f) / 0.5f : 0.0f;
        }
        return 1.0f;
    }

    public float getFacingCameraAmount(float partialTicks) {
        return this.prevFaceCameraProgress + (this.faceCameraProgress - this.prevFaceCameraProgress) * partialTicks;
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.getAnimation() != ANIMATION_EMERGE && this.hasEmerged();
    }

    private Vec3 calculateLaserHit(Vec3 target) {
        Vec3 eyes = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        BlockHitResult hitResult = this.level().clip(new ClipContext(eyes, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return hitResult.getLocation();
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public void travel(Vec3 vec3) {
        if (this.isEffectiveAi() || this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public boolean isInvulnerableTo(DamageSource dmg) {
        return super.isInvulnerableTo(dmg) || this.getAnimation() == ANIMATION_EMERGE;
    }

    private boolean canUseLaser() {
        return !this.hasEffect(MobEffects.BLINDNESS);
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)EntityFarseer.this);
            this.parentEntity = EntityFarseer.this;
        }

        public void tick() {
            float angle = (float)Math.PI / 180 * (this.parentEntity.yBodyRot + 90.0f);
            float radius = (float)Math.sin((float)this.parentEntity.tickCount * 0.2f) * 2.0f;
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraY = (double)radius * -Math.cos((double)angle - 1.5707963267948966);
            double extraZ = radius * Mth.cos((float)angle);
            Vec3 strafPlus = new Vec3(extraX, extraY, extraZ);
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d0 = vector3d.length();
                double width = this.parentEntity.getBoundingBox().getSize();
                Vec3 shimmy = Vec3.ZERO;
                LivingEntity attackTarget = this.parentEntity.getTarget();
                if (attackTarget != null && this.parentEntity.horizontalCollision) {
                    shimmy = new Vec3(0.0, 0.005, 0.0);
                }
                Vec3 vector3d1 = vector3d.scale(this.speedModifier * 0.05 / d0);
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d1.add(strafPlus.scale(0.003 * Math.min(d0, 100.0)).add(shimmy))));
                if (d0 >= width) {
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                    if (EntityFarseer.this.hasLaser()) {
                        this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                    }
                }
            } else if (this.operation == MoveControl.Operation.WAIT) {
                this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(strafPlus.scale(0.003)));
            }
        }
    }

    private class AttackGoal
    extends Goal {
        private boolean attackDecision = true;
        private int timeSinceLastSuccessfulAttack = 0;
        private int laserCooldown = 0;
        private int laserUseTime = 0;
        private int lasersShot = 0;

        public AttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityFarseer.this.getTarget() != null && EntityFarseer.this.getTarget().isAlive();
        }

        public void stop() {
            this.lasersShot = 0;
            this.laserCooldown = 0;
            this.laserUseTime = 0;
            this.attackDecision = EntityFarseer.this.getRandom().nextBoolean();
            EntityFarseer.this.entityData.set(LASER_ENTITY_ID, (Object)-1);
            this.timeSinceLastSuccessfulAttack = 0;
            EntityFarseer.this.setAngry(false);
        }

        public void tick() {
            super.tick();
            LivingEntity target = EntityFarseer.this.getTarget();
            if (this.laserCooldown > 0) {
                --this.laserCooldown;
            }
            ++this.timeSinceLastSuccessfulAttack;
            if (this.timeSinceLastSuccessfulAttack > 100) {
                this.timeSinceLastSuccessfulAttack = 0;
                boolean bl = this.attackDecision = !this.attackDecision;
            }
            if (target != null) {
                double dist = EntityFarseer.this.distanceTo((Entity)target);
                boolean canLaserHit = this.willLaserHit(target);
                if (this.laserCooldown == 0 && this.attackDecision && canLaserHit && dist > 2.0) {
                    EntityFarseer.this.setAngry(true);
                    EntityFarseer.this.entityData.set(LASER_ENTITY_ID, (Object)target.getId());
                    if (this.laserUseTime == 0) {
                        EntityFarseer.this.playSound((SoundEvent)AMSoundRegistry.FARSEER_BEAM.get(), EntityFarseer.this.getSoundVolume(), EntityFarseer.this.getVoicePitch());
                    }
                    ++this.laserUseTime;
                    if (this.laserUseTime > 10) {
                        this.laserUseTime = 0;
                        if (canLaserHit) {
                            float healthTenth = target.getMaxHealth() * 0.1f;
                            if (target.hurt(AMDamageTypes.causeFarseerDamage((LivingEntity)EntityFarseer.this), (float)EntityFarseer.this.random.nextInt(2) + Math.max(6.0f, healthTenth)) && !target.isAlive()) {
                                AlexsMobs.sendMSGToAll(new MessageSendVisualFlagFromServer(target.getId(), 87));
                            }
                            this.timeSinceLastSuccessfulAttack = 0;
                        }
                        if (this.lasersShot++ > 5) {
                            this.lasersShot = 0;
                            this.laserCooldown = 80 + EntityFarseer.this.random.nextInt(40);
                            EntityFarseer.this.entityData.set(LASER_ENTITY_ID, (Object)-1);
                            this.attackDecision = EntityFarseer.this.getRandom().nextBoolean();
                        }
                    }
                    EntityFarseer.this.entityData.set(LASER_ATTACK_LVL, (Object)this.laserUseTime);
                    EntityFarseer.this.lookAt((Entity)target, 180.0f, 180.0f);
                    if (dist < 17.0 && canLaserHit) {
                        EntityFarseer.this.getNavigation().stop();
                    } else {
                        EntityFarseer.this.getNavigation().moveTo((Entity)target, 1.0);
                    }
                    EntityFarseer.this.entityData.set(MELEEING, (Object)false);
                } else {
                    if (!canLaserHit && dist > 10.0) {
                        EntityFarseer.this.setAngry(false);
                    }
                    if (EntityFarseer.this.hasLaser()) {
                        EntityFarseer.this.entityData.set(LASER_ENTITY_ID, (Object)-1);
                    }
                    EntityFarseer.this.entityData.set(MELEEING, (Object)(dist < 4.0 ? 1 : 0));
                    if (dist < 4.0) {
                        this.timeSinceLastSuccessfulAttack = 0;
                    } else {
                        EntityFarseer.this.getNavigation().moveTo((Entity)target, 1.0);
                        EntityFarseer.this.moveControl.setWantedPosition(target.getX(), target.getEyeY(), target.getZ(), 1.0);
                    }
                }
            }
        }

        private boolean willLaserHit(LivingEntity target) {
            Vec3 vec = EntityFarseer.this.calculateLaserHit(target.getEyePosition());
            return vec.distanceTo(target.getEyePosition()) < 1.0 && EntityFarseer.this.canUseLaser();
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final EntityFarseer parentEntity;
        private BlockPos target = null;
        private final float speed = 0.6f;

        public RandomFlyGoal(EntityFarseer mosquito) {
            this.parentEntity = mosquito;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.parentEntity.getNavigation().isDone() && this.parentEntity.getTarget() == null && this.parentEntity.getRandom().nextInt(4) == 0) {
                this.target = this.getBlockInViewFarseer();
                if (this.target != null) {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, (double)0.6f);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.parentEntity.getTarget() == null;
        }

        public void stop() {
            this.target = null;
        }

        public void tick() {
            if (this.target != null) {
                this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, (double)0.6f);
                if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) < 4.0 || this.parentEntity.horizontalCollision) {
                    this.target = null;
                }
            }
        }

        private BlockPos getFarseerGround(BlockPos in) {
            BlockPos position = new BlockPos(in.getX(), (int)this.parentEntity.getY(), in.getZ());
            while (position.getY() < 256 && !this.parentEntity.level().getFluidState(position).isEmpty()) {
                position = position.above();
            }
            while (position.getY() > 1 && this.parentEntity.level().isEmptyBlock(position)) {
                position = position.below();
            }
            return position;
        }

        public BlockPos getBlockInViewFarseer() {
            float radius = 5 + this.parentEntity.getRandom().nextInt(10);
            float neg = this.parentEntity.getRandom().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.getYRot();
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f * (this.parentEntity.getRandom().nextFloat() * neg);
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = new BlockPos((int)(this.parentEntity.getX() + extraX), (int)this.parentEntity.getY(), (int)(this.parentEntity.getZ() + extraZ));
            BlockPos ground = this.getFarseerGround(radialPos).above(2 + this.parentEntity.random.nextInt(2));
            if (!this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
                return ground;
            }
            return null;
        }
    }
}

