/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityEnderiophageRocket
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<OptionalInt> DATA_ATTACHED_TO_TARGET = SynchedEntityData.defineId(EntityEnderiophageRocket.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private int life;
    private int lifetime;

    public EntityEnderiophageRocket(EntityType<? extends EntityEnderiophageRocket> type, Level level) {
        super(type, level);
        this.lifetime = 18 + this.random.nextInt(14);
    }

    public EntityEnderiophageRocket(Level worldIn, double x, double y, double z, ItemStack givenItem) {
        this((EntityType<? extends EntityEnderiophageRocket>)((EntityType)AMEntityRegistry.ENDERIOPHAGE_ROCKET.get()), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(this.random.nextGaussian() * 0.001, 0.05, this.random.nextGaussian() * 0.001);
        this.lifetime = 18 + this.random.nextInt(14);
    }

    public EntityEnderiophageRocket(Level level, @Nullable Entity owner, double x, double y, double z, ItemStack stack) {
        this(level, x, y, z, stack);
        this.setOwner(owner);
    }

    public EntityEnderiophageRocket(Level level, ItemStack stack, LivingEntity shooter) {
        this(level, (Entity)shooter, shooter.getX(), shooter.getY(), shooter.getZ(), stack);
        this.entityData.set(DATA_ATTACHED_TO_TARGET, (Object)OptionalInt.of(shooter.getId()));
        this.lifetime = 18 + this.random.nextInt(14);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ATTACHED_TO_TARGET, (Object)OptionalInt.empty());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    public boolean shouldRender(double x, double y, double z) {
        return super.shouldRender(x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.isAttachedToEntity()) {
            Entity attached = this.getAttachedEntity();
            if (attached != null) {
                LivingEntity living;
                if (attached instanceof LivingEntity && (living = (LivingEntity)attached).isFallFlying()) {
                    Vec3 lookVec = attached.getLookAngle();
                    Vec3 deltaMovement = attached.getDeltaMovement();
                    attached.setDeltaMovement(deltaMovement.add(lookVec.x * 0.1 + (lookVec.x * 1.5 - deltaMovement.x) * 0.5, lookVec.y * 0.1 + (lookVec.y * 1.5 - deltaMovement.y) * 0.5, lookVec.z * 0.1 + (lookVec.z * 1.5 - deltaMovement.z) * 0.5));
                }
                this.setPos(attached.getX(), attached.getY(), attached.getZ());
                this.setDeltaMovement(attached.getDeltaMovement());
            }
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.15, 1.0, 1.15).add(0.0, 0.04, 0.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (!this.noPhysics) {
            this.onHit(hitresult);
            this.hasImpulse = true;
        }
        if (this.level().isClientSide) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() - 0.3, this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
        ++this.life;
        if (!this.level().isClientSide && this.life > this.lifetime) {
            this.explode();
        }
    }

    private boolean isAttachedToEntity() {
        return ((OptionalInt)this.entityData.get(DATA_ATTACHED_TO_TARGET)).isPresent();
    }

    @Nullable
    private Entity getAttachedEntity() {
        return ((OptionalInt)this.entityData.get(DATA_ATTACHED_TO_TARGET)).isPresent() ? this.level().getEntity(((OptionalInt)this.entityData.get(DATA_ATTACHED_TO_TARGET)).getAsInt()) : null;
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            this.explode();
        }
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)result);
        } else if (result.getType() == HitResult.Type.BLOCK && !this.level().isClientSide) {
            this.explode();
        }
    }

    private void explode() {
        this.level().broadcastEntityEvent((Entity)this, (byte)17);
        this.discard();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 17) {
            int i;
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, 0.005, this.random.nextGaussian() * 0.05);
            for (i = 0; i < this.random.nextInt(15) + 30; ++i) {
                this.level().addParticle((ParticleOptions)AMParticleRegistry.DNA.get(), this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.25, this.random.nextGaussian() * 0.25, this.random.nextGaussian() * 0.25);
            }
            for (i = 0; i < this.random.nextInt(15) + 15; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.15, this.random.nextGaussian() * 0.15, this.random.nextGaussian() * 0.15);
            }
            SoundEvent soundEvent = AlexsMobs.PROXY.isFarFromCamera(this.getX(), this.getY(), this.getZ()) ? SoundEvents.FIREWORK_ROCKET_BLAST : SoundEvents.FIREWORK_ROCKET_BLAST_FAR;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), soundEvent, SoundSource.AMBIENT, 20.0f, 0.95f + this.random.nextFloat() * 0.1f, true);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Life", this.life);
        tag.putInt("LifeTime", this.lifetime);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.life = tag.getInt("Life");
        this.lifetime = tag.getInt("LifeTime");
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)AMItemRegistry.ENDERIOPHAGE_ROCKET.get());
    }

    public boolean isAttackable() {
        return false;
    }
}

