/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityEmu
extends Animal
implements IAnimatedEntity,
IHerdPanic {
    public static final Animation ANIMATION_DODGE_LEFT = Animation.create((int)10);
    public static final Animation ANIMATION_DODGE_RIGHT = Animation.create((int)10);
    public static final Animation ANIMATION_PECK_GROUND = Animation.create((int)25);
    public static final Animation ANIMATION_SCRATCH = Animation.create((int)20);
    public static final Animation ANIMATION_PUZZLED = Animation.create((int)30);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityEmu.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int animationTick;
    private Animation currentAnimation;
    private int revengeCooldown = 0;
    private boolean emuAttackedDirectly = false;
    public int timeUntilNextEgg = this.random.nextInt(6000) + 6000;

    protected EntityEmu(EntityType type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.35f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public static <T extends Mob> boolean canEmuSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.EMU_SPAWNS);
        return spawnBlock && worldIn.getRawBrightness(pos, 0) > 8;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.emuSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.EMU_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.EMU_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.EMU_HURT.get();
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, true){

            protected double getAttackReachSqr(LivingEntity attackTarget) {
                return (double)(EntityEmu.this.getBbWidth() * 2.0f * EntityEmu.this.getBbWidth() * 2.0f + attackTarget.getBbWidth()) + 2.5;
            }

            public boolean canUse() {
                return super.canUse() && EntityEmu.this.revengeCooldown <= 0;
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && EntityEmu.this.revengeCooldown <= 0;
            }
        });
        this.goalSelector.addGoal(2, (Goal)new AnimalAIHerdPanic((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of(AMTagRegistry.EMU_BREEDABLES), false));
        this.goalSelector.addGoal(5, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 110, 1.0, 10, 7));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal());
        if (AMConfig.emuTargetSkeletons) {
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, false));
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.EMU_BREEDABLES);
    }

    public boolean canAttack(LivingEntity target) {
        return !this.isBaby() && super.canAttack(target);
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev = super.hurt(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.getRandom().nextInt(5);
            List list = this.level().getEntitiesOfClass(this.getClass(), this.getBoundingBox().inflate(range, range / 2.0, range));
            for (EntityEmu emu : list) {
                emu.revengeCooldown = fleeTime;
                if (!emu.isBaby() || this.random.nextInt(2) != 0) continue;
                emu.emuAttackedDirectly = this.getLastHurtByMob() != null;
                emu.revengeCooldown = emu.emuAttackedDirectly ? 10 + this.getRandom().nextInt(30) : fleeTime;
            }
            this.emuAttackedDirectly = this.getLastHurtByMob() != null;
            this.revengeCooldown = this.emuAttackedDirectly ? 10 + this.getRandom().nextInt(30) : this.revengeCooldown;
        }
        return prev;
    }

    public void travel(Vec3 travelVector) {
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.getAnimation() == ANIMATION_PECK_GROUND || this.getAnimation() == ANIMATION_PUZZLED ? 0.15f : 1.0f) * (this.isInLava() ? 0.2f : 1.0f));
        super.travel(travelVector);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getLastHurtByMob() == null && this.getTarget() == null && this.getDeltaMovement().lengthSqr() < 0.03 && this.getRandom().nextInt(190) == 0 && this.getAnimation() == NO_ANIMATION) {
                if (this.getRandom().nextInt(3) == 0) {
                    this.setAnimation(ANIMATION_PUZZLED);
                } else if (this.onGround()) {
                    this.setAnimation(ANIMATION_PECK_GROUND);
                }
            }
            if (this.revengeCooldown > 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown <= 0 && this.getLastHurtByMob() != null && !this.emuAttackedDirectly) {
                this.setLastHurtByMob(null);
                this.revengeCooldown = 0;
            }
            LivingEntity target = this.getTarget();
            if (this.isAlive() && target != null && this.getAnimation() == ANIMATION_SCRATCH && this.distanceTo((Entity)target) < 4.0f && (this.getAnimationTick() == 8 || this.getAnimationTick() == 15)) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.02f), 0.0, (double)(Mth.cos((float)f1) * 0.02f)));
                target.knockback((double)0.4f, target.getX() - this.getX(), target.getZ() - this.getZ());
                target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
            }
        }
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && --this.timeUntilNextEgg <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)AMItemRegistry.EMU_EGG.get());
            this.timeUntilNextEgg = this.random.nextInt(6000) + 6000;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_DODGE_LEFT, ANIMATION_DODGE_RIGHT, ANIMATION_PECK_GROUND, ANIMATION_SCRATCH, ANIMATION_PUZZLED};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityEmu emu = (EntityEmu)((EntityType)AMEntityRegistry.EMU.get()).create((Level)serverWorld);
        emu.setVariant(this.getVariant());
        return emu;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SCRATCH);
        }
        return true;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getInt("Variant"));
        if (compound.contains("EggLayTime")) {
            this.timeUntilNextEgg = compound.getInt("EggLayTime");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
        compound.putInt("EggLayTime", this.timeUntilNextEgg);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (this.random.nextInt(200) == 0) {
            this.setVariant(2);
        } else if (this.random.nextInt(3) == 0) {
            this.setVariant(1);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return true;
    }

    class HurtByTargetGoal
    extends net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((PathfinderMob)EntityEmu.this, new Class[0]);
        }

        public void start() {
            if (EntityEmu.this.isBaby() || !EntityEmu.this.emuAttackedDirectly) {
                this.alertOthers();
                this.stop();
            } else {
                super.start();
            }
        }

        protected void alertOther(Mob mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityEmu && !mobIn.isBaby() && !EntityEmu.this.emuAttackedDirectly && ((EntityEmu)mobIn).revengeCooldown <= 0) {
                super.alertOther(mobIn, targetIn);
            }
        }
    }
}

