/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAICircleCrops;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageCrowDismount;
import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class EntityCrow
extends TamableAnimal
implements ITargetsDroppedItems {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityCrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityCrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityCrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityCrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> PERCH_POS = SynchedEntityData.defineId(EntityCrow.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevAttackProgress;
    public float attackProgress;
    public int fleePumpkinFlag = 0;
    public boolean aiItemFlag = false;
    public boolean aiItemFrameFlag = false;
    public float prevSitProgress;
    public float sitProgress;
    private boolean isLandNavigator;
    private int timeFlying = 0;
    @Nullable
    private UUID seedThrowerID;
    private int heldItemTime = 0;
    private int checkPerchCooldown = 0;
    private final boolean gatheringClockwise = false;

    protected EntityCrow(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new CrowAIMelee(this));
        this.goalSelector.addGoal(3, (Goal)new CrowAIFollowOwner(this, 1.0, 4.0f, 2.0f, true));
        this.goalSelector.addGoal(4, (Goal)new AIDepositChests());
        this.goalSelector.addGoal(4, (Goal)new AIScatter());
        this.goalSelector.addGoal(5, (Goal)new AIAvoidPumpkins());
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new CrowAICircleCrops(this));
        this.goalSelector.addGoal(7, (Goal)new AIWalkIdle());
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, PathfinderMob.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AITargetItems((PathfinderMob)this, false, false, 40, 16));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}).setAlertOthers(new Class[0]));
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crowSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static <T extends Mob> boolean canCrowSpawn(EntityType<EntityCrow> crow, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return EntityCrow.isBrightEnoughToSpawn((BlockAndTintGetter)worldIn, (BlockPos)pos);
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 0.7f, false);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean prev;
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 4.0f;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((prev = super.hurt(source, amount)) && !this.getMainHandItem().isEmpty()) {
            this.spawnAtLocation(this.getMainHandItem().copy());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        return prev;
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (this.isPassenger() && !entity.isAlive()) {
            this.stopRiding();
        } else if (this.isTame() && entity instanceof LivingEntity && this.isOwnedBy((LivingEntity)entity)) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            Entity riding = this.getVehicle();
            if (this.isPassenger()) {
                int i = riding.getPassengers().indexOf(this);
                float radius = 0.43f;
                float angle = (float)Math.PI / 180 * (((Player)riding).yBodyRot + (float)(i == 0 ? -90 : 90));
                double extraX = 0.43f * Mth.sin((float)((float)Math.PI + angle));
                double extraZ = 0.43f * Mth.cos((float)angle);
                double extraY = riding.isShiftKeyDown() ? 1.25 : 1.45;
                this.yHeadRot = ((Player)riding).yHeadRot;
                this.yRotO = ((Player)riding).yHeadRot;
                this.setPos(riding.getX() + extraX, riding.getY() + extraY, riding.getZ() + extraZ);
                if (!riding.isAlive() || this.boardingCooldown == 0 && riding.isShiftKeyDown() || ((Player)riding).isFallFlying() || this.getTarget() != null && this.getTarget().isAlive()) {
                    this.removeVehicle();
                    if (!this.level().isClientSide) {
                        AlexsMobs.sendMSGToAll(new MessageCrowDismount(this.getId(), riding.getId()));
                    }
                }
            }
        } else {
            super.rideTick();
        }
    }

    public int getRidingCrows(LivingEntity player) {
        int crowCount = 0;
        for (Entity e : player.getPassengers()) {
            if (!(e instanceof EntityCrow)) continue;
            ++crowCount;
        }
        return crowCount;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.CROW_BREEDABLES) && this.isTame();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (!this.getMainHandItem().isEmpty() && type != InteractionResult.SUCCESS) {
            this.spawnAtLocation(this.getMainHandItem().copy());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack)) {
            if (this.isCrowEdible(itemstack) && this.getMainHandItem().isEmpty()) {
                ItemStack cop = itemstack.copy();
                cop.setCount(1);
                this.setItemInHand(InteractionHand.MAIN_HAND, cop);
                itemstack.shrink(1);
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 4) {
                this.setCommand(0);
            }
            if (this.getCommand() == 3) {
                player.displayClientMessage((Component)Component.translatable((String)"entity.alexsmobs.crow.command_3", (Object[])new Object[]{this.getName()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            }
            boolean sit = this.getCommand() == 2;
            this.setOrderedToSit(sit);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        boolean isSittingOrPassenger;
        super.tick();
        this.prevAttackProgress = this.attackProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevSitProgress = this.sitProgress;
        boolean bl = isSittingOrPassenger = this.isSitting() || this.isPassenger();
        if (isSittingOrPassenger) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.fleePumpkinFlag > 0) {
            --this.fleePumpkinFlag;
        }
        if (!this.level().isClientSide) {
            boolean isFlying = this.isFlying();
            if (isFlying && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!isFlying && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (isFlying) {
                ++this.timeFlying;
                this.setNoGravity(true);
                if (this.isSitting() || this.isPassenger() || this.isInLove()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
        }
        if (!this.getMainHandItem().isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 60 && this.isCrowEdible(this.getMainHandItem()) && (!this.isTame() || this.getHealth() < this.getMaxHealth())) {
                this.heldItemTime = 0;
                this.heal(4.0f);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.PARROT_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.seedThrowerID != null && this.getMainHandItem().is(AMTagRegistry.CROW_TAMEABLES) && !this.isTame()) {
                    if (this.getRandom().nextFloat() < 0.3f) {
                        this.setTame(true, true);
                        this.setCommand(1);
                        this.setOwnerUUID(this.seedThrowerID);
                        Player player = this.level().getPlayerByUUID(this.seedThrowerID);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.TAME_ANIMAL.trigger(serverPlayer, (Animal)this);
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                this.getMainHandItem().shrink(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.checkPerchCooldown > 0) {
            --this.checkPerchCooldown;
        }
        if (this.isTame()) {
            if (this.checkPerchCooldown == 0) {
                this.checkPerchCooldown = 50;
                BlockState below = this.getBlockStateOn();
                if (below.is(AMTagRegistry.CROW_HOME_BLOCKS)) {
                    this.heal(1.0f);
                    this.level().broadcastEntityEvent((Entity)this, (byte)67);
                    this.setPerchPos(this.getBlockPosBelowThatAffectsMyMovement());
                }
            }
            if (this.getCommand() == 3 && this.getPerchPos() != null && this.checkPerchCooldown == 0) {
                this.checkPerchCooldown = 120;
                BlockState below = this.level().getBlockState(this.getPerchPos());
                if (below.is(AMTagRegistry.CROW_HOME_BLOCKS)) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)68);
                    this.setPerchPos(null);
                    this.setCommand(2);
                    this.setOrderedToSit(true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else if (id == 68) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putBoolean("MonkeySitting", this.isSitting());
        compound.putInt("Command", this.getCommand());
        if (this.getPerchPos() != null) {
            compound.putInt("PerchX", this.getPerchPos().getX());
            compound.putInt("PerchY", this.getPerchPos().getY());
            compound.putInt("PerchZ", this.getPerchPos().getZ());
        }
    }

    public void travel(Vec3 vec3d) {
        if (this.isSitting()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            vec3d = Vec3.ZERO;
        }
        if (this.isInWater() && this.getDeltaMovement().y > 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.5, 1.0));
        }
        super.travel(vec3d);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.setOrderedToSit(compound.getBoolean("MonkeySitting"));
        this.setCommand(compound.getInt("Command"));
        if (compound.contains("PerchX") && compound.contains("PerchY") && compound.contains("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.getInt("PerchX"), compound.getInt("PerchY"), compound.getInt("PerchZ")));
        }
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            return;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(COMMAND, (Object)0);
        builder.define(SITTING, (Object)false);
        builder.define(PERCH_POS, Optional.empty());
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FALL) || source.is(DamageTypes.CACTUS) || super.isInvulnerableTo(source);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)AMEntityRegistry.CROW.get()).create((Level)serverWorld);
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public int getAmbientSoundInterval() {
        return 60;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.CROW_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.CROW_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.CROW_HURT.get();
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        BlockPos newPos;
        float radius = -9.450001f - (float)this.getRandom().nextInt(24) - radiusAdd;
        float angle = this.getAngle1();
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        if (distFromGround > 8) {
            int flightHeight = 4 + this.getRandom().nextInt(10);
            newPos = ground.above(flightHeight);
        } else {
            newPos = ground.above(this.getRandom().nextInt(6) + 1);
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.450001f - (float)this.getRandom().nextInt(24);
        float angle = this.getAngle1();
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), (int)this.getY(), (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.getY() == -64) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -64 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    private float getAngle1() {
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        return (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
    }

    private boolean isOverWater() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -64 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty();
    }

    @Override
    public void peck() {
        this.entityData.set(ATTACK_TICK, (Object)7);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack != null && this.isCrowEdible(stack) || this.isTame();
    }

    private boolean isCrowEdible(ItemStack stack) {
        return stack.has(DataComponents.FOOD) || stack.is(AMTagRegistry.CROW_FOODSTUFFS);
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        Entity itemThrower = e.getOwner();
        this.seedThrowerID = e.getItem().is(AMTagRegistry.CROW_TAMEABLES) && !this.isTame() && itemThrower != null ? itemThrower.getUUID() : null;
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.entityData.get(PERCH_POS)).orElse(null);
    }

    public void setPerchPos(BlockPos pos) {
        this.entityData.set(PERCH_POS, Optional.ofNullable(pos));
    }

    private Vec3 getGatheringVec(Vec3 vector3d, float gatheringCircleDist) {
        if (this.getPerchPos() != null) {
            float angle = 0.13962634f * (float)this.tickCount;
            double extraX = gatheringCircleDist * Mth.sin((float)angle);
            double extraZ = gatheringCircleDist * Mth.cos((float)angle);
            Vec3 pos = new Vec3((double)this.getPerchPos().getX() + extraX, (double)(this.getPerchPos().getY() + 2), (double)this.getPerchPos().getZ() + extraZ);
            if (this.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
                return pos;
            }
        }
        return null;
    }

    private class AIDepositChests
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<ItemFrame> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private ItemFrame targetEntity;
        private Vec3 flightTarget = null;
        private int cooldown = 0;

        AIDepositChests() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityCrow.this);
            this.targetEntitySelector = new Predicate<ItemFrame>(){

                public boolean apply(@Nullable ItemFrame e) {
                    IItemHandler handler;
                    BlockPos hangingPosition = e.getPos().relative(e.getDirection().getOpposite());
                    BlockEntity entity = e.level().getBlockEntity(hangingPosition);
                    if (entity != null && (handler = (IItemHandler)e.level().getCapability(Capabilities.ItemHandler.BLOCK, hangingPosition, (Object)e.getDirection())) != null) {
                        return ItemStack.isSameItem((ItemStack)e.getItem(), (ItemStack)EntityCrow.this.getMainHandItem());
                    }
                    return false;
                }
            };
        }

        public boolean canUse() {
            List list;
            long worldTime;
            if (EntityCrow.this.isPassenger() || EntityCrow.this.aiItemFlag || EntityCrow.this.isVehicle() || EntityCrow.this.isSitting() || EntityCrow.this.getCommand() != 3) {
                return false;
            }
            if (EntityCrow.this.getMainHandItem().isEmpty()) {
                return false;
            }
            if (!this.mustUpdate && (worldTime = EntityCrow.this.level().getGameTime() % 10L) != 0L) {
                if (EntityCrow.this.getNoActionTime() >= 100) {
                    return false;
                }
                if (EntityCrow.this.getRandom().nextInt(this.executionChance) != 0) {
                    return false;
                }
            }
            if ((list = EntityCrow.this.level().getEntitiesOfClass(ItemFrame.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            list.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = (ItemFrame)list.get(0);
            this.mustUpdate = false;
            EntityCrow.this.aiItemFrameFlag = true;
            return true;
        }

        public boolean canContinueToUse() {
            return this.targetEntity != null && EntityCrow.this.getCommand() == 3 && !EntityCrow.this.getMainHandItem().isEmpty();
        }

        public void stop() {
            this.flightTarget = null;
            this.targetEntity = null;
            EntityCrow.this.aiItemFrameFlag = false;
        }

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntityCrow.this.setFlying(true);
                if (EntityCrow.this.horizontalCollision) {
                    EntityCrow.this.getMoveControl().setWantedPosition(this.flightTarget.x, EntityCrow.this.getY() + 1.0, this.flightTarget.z, 1.0);
                } else {
                    EntityCrow.this.getMoveControl().setWantedPosition(this.flightTarget.x, this.flightTarget.y, this.flightTarget.z, 1.0);
                }
            }
            if (this.targetEntity != null) {
                this.flightTarget = this.targetEntity.position();
                if (EntityCrow.this.distanceTo((Entity)this.targetEntity) < 2.0f) {
                    try {
                        BlockPos hangingPosition = this.targetEntity.getPos().relative(this.targetEntity.getDirection().getOpposite());
                        BlockEntity entity = this.targetEntity.level().getBlockEntity(hangingPosition);
                        Direction deposit = this.targetEntity.getDirection();
                        IItemHandler handler = (IItemHandler)this.targetEntity.level().getCapability(Capabilities.ItemHandler.BLOCK, hangingPosition, (Object)deposit);
                        if (handler != null && this.cooldown == 0) {
                            ItemStack duplicate = EntityCrow.this.getItemInHand(InteractionHand.MAIN_HAND).copy();
                            ItemStack insertSimulate = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)true);
                            if (!insertSimulate.equals(duplicate)) {
                                ItemStack shrunkenStack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                                if (shrunkenStack.isEmpty()) {
                                    EntityCrow.this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                                } else {
                                    EntityCrow.this.setItemInHand(InteractionHand.MAIN_HAND, shrunkenStack);
                                }
                                EntityCrow.this.peck();
                            } else {
                                this.cooldown = 20;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stop();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(EntityCrow.this.getX(), EntityCrow.this.getY(), EntityCrow.this.getZ());
            AABB aabb = new AABB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0);
            return aabb.move(renderCenter);
        }

        public record Sorter(Entity theEntity) implements Comparator<Entity>
        {
            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.distanceToSqr(p_compare_1_);
                double d1 = this.theEntity.distanceToSqr(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    private class AIScatter
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vec3 flightTarget = null;
        private int cooldown = 0;

        AIScatter() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityCrow.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.isAlive() && e.getType().is(AMTagRegistry.SCATTERS_CROWS) || e instanceof Player && !((Player)e).isCreative();
                }
            };
        }

        public boolean canUse() {
            List list;
            long worldTime;
            if (EntityCrow.this.isPassenger() || EntityCrow.this.aiItemFlag || EntityCrow.this.isVehicle() || EntityCrow.this.isTame()) {
                return false;
            }
            if (!this.mustUpdate && (worldTime = EntityCrow.this.level().getGameTime() % 10L) != 0L) {
                if (EntityCrow.this.getNoActionTime() >= 100) {
                    return false;
                }
                if (EntityCrow.this.getRandom().nextInt(this.executionChance) != 0) {
                    return false;
                }
            }
            if ((list = EntityCrow.this.level().getEntitiesOfClass(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            list.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean canContinueToUse() {
            return this.targetEntity != null && !EntityCrow.this.isTame();
        }

        public void stop() {
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntityCrow.this.setFlying(true);
                EntityCrow.this.getMoveControl().setWantedPosition(this.flightTarget.x, this.flightTarget.y, this.flightTarget.z, 1.0);
                if (this.cooldown == 0 && EntityCrow.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vec3 vec;
                if ((EntityCrow.this.onGround() || this.flightTarget == null || EntityCrow.this.distanceToSqr(this.flightTarget) < 3.0) && (vec = EntityCrow.this.getBlockInViewAway(this.targetEntity.position(), 0.0f)) != null && vec.y() > EntityCrow.this.getY()) {
                    this.flightTarget = vec;
                }
                if (EntityCrow.this.distanceTo(this.targetEntity) > 20.0f) {
                    this.stop();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(EntityCrow.this.getX(), EntityCrow.this.getY() + 0.5, EntityCrow.this.getZ());
            AABB aabb = new AABB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
            return aabb.move(renderCenter);
        }

        public record Sorter(Entity theEntity) implements Comparator<Entity>
        {
            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.distanceToSqr(p_compare_1_);
                double d1 = this.theEntity.distanceToSqr(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    private class AIAvoidPumpkins
    extends Goal {
        private final int searchLength;
        private final int verticalSearchRange;
        protected BlockPos destinationBlock;
        protected int runDelay = 70;
        private Vec3 flightTarget;

        private AIAvoidPumpkins() {
            this.searchLength = 20;
            this.verticalSearchRange = 1;
        }

        public boolean canContinueToUse() {
            return this.destinationBlock != null && this.isPumpkin(EntityCrow.this.level(), this.destinationBlock.mutable()) && this.isCloseToPumpkin(16.0);
        }

        public boolean isCloseToPumpkin(double dist) {
            return this.destinationBlock == null || EntityCrow.this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.destinationBlock)) < dist * dist;
        }

        public boolean canUse() {
            if (EntityCrow.this.isTame()) {
                return false;
            }
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 70 + EntityCrow.this.random.nextInt(150);
            return this.searchForDestination();
        }

        public void start() {
            EntityCrow.this.fleePumpkinFlag = 200;
            Vec3 vec = EntityCrow.this.getBlockInViewAway(Vec3.atCenterOf((Vec3i)this.destinationBlock), 10.0f);
            if (vec != null) {
                this.flightTarget = vec;
                EntityCrow.this.setFlying(true);
                EntityCrow.this.getMoveControl().setWantedPosition(vec.x, vec.y, vec.z, 1.0);
            }
        }

        public void tick() {
            if (this.isCloseToPumpkin(16.0)) {
                Vec3 vec;
                EntityCrow.this.fleePumpkinFlag = 200;
                if ((this.flightTarget == null || EntityCrow.this.distanceToSqr(this.flightTarget) < 2.0) && (vec = EntityCrow.this.getBlockInViewAway(Vec3.atCenterOf((Vec3i)this.destinationBlock), 10.0f)) != null) {
                    this.flightTarget = vec;
                    EntityCrow.this.setFlying(true);
                }
                if (this.flightTarget != null) {
                    EntityCrow.this.getMoveControl().setWantedPosition(this.flightTarget.x, this.flightTarget.y, this.flightTarget.z, 1.0);
                }
            }
        }

        public void stop() {
            this.flightTarget = null;
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            BlockPos lvt_3_1_ = EntityCrow.this.blockPosition();
            BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos();
            for (int lvt_5_1_ = -8; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.setWithOffset((Vec3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isPumpkin(EntityCrow.this.level(), lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isPumpkin(Level world, BlockPos.MutableBlockPos lvt_4_1_) {
            return world.getBlockState((BlockPos)lvt_4_1_).is(AMTagRegistry.CROW_FEARS);
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityCrow crow;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.crow = EntityCrow.this;
        }

        public boolean canUse() {
            Vec3 lvt_1_1_;
            if (this.crow.isVehicle() || EntityCrow.this.getCommand() == 1 || EntityCrow.this.aiItemFlag || this.crow.getTarget() != null && this.crow.getTarget().isAlive() || this.crow.isPassenger() || this.crow.isSitting()) {
                return false;
            }
            if (this.crow.getRandom().nextInt(30) != 0 && !this.crow.isFlying()) {
                return false;
            }
            if (this.crow.onGround()) {
                this.flightTarget = EntityCrow.this.random.nextBoolean();
            } else {
                boolean bl = this.flightTarget = EntityCrow.this.random.nextInt(5) > 0 && this.crow.timeFlying < 200;
            }
            if (this.crow.getCommand() == 3) {
                if (this.crow.aiItemFrameFlag) {
                    return false;
                }
                this.flightTarget = true;
            }
            if ((lvt_1_1_ = this.getPosition()) == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                this.crow.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.crow.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
                if (EntityCrow.this.isFlying() && this.crow.onGround()) {
                    this.crow.setFlying(false);
                }
            }
            if (EntityCrow.this.isFlying() && this.crow.onGround() && this.crow.timeFlying > 10) {
                this.crow.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.crow.position();
            if (this.crow.getCommand() == 3 && this.crow.getPerchPos() != null) {
                return this.crow.getGatheringVec(vector3d, 4 + EntityCrow.this.random.nextInt(2));
            }
            if (this.crow.isOverWater()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.crow.timeFlying < 50 || this.crow.isOverWater()) {
                    return this.crow.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.crow.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.crow, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.crow.aiItemFlag || this.crow.isSitting() || EntityCrow.this.getCommand() == 1) {
                return false;
            }
            if (this.flightTarget) {
                return this.crow.isFlying() && this.crow.distanceToSqr(this.x, this.y, this.z) > 2.0;
            }
            return !this.crow.getNavigation().isDone() && !this.crow.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.crow.setFlying(true);
                this.crow.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.crow.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.crow.getNavigation().stop();
            super.stop();
        }
    }

    private static class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void stop() {
            super.stop();
            ((EntityCrow)this.mob).aiItemFlag = false;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !((EntityCrow)this.mob).isSitting() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && !((EntityCrow)this.mob).isSitting() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        protected void moveTo() {
            EntityCrow crow = (EntityCrow)this.mob;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if (this.mob.distanceTo((Entity)this.targetEntity) < 2.0f) {
                    crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                    crow.peck();
                }
                if (this.mob.distanceTo((Entity)this.targetEntity) > 8.0f || crow.isFlying()) {
                    crow.setFlying(true);
                    if (!crow.hasLineOfSight((Entity)this.targetEntity)) {
                        crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), 1.0 + crow.getY(), this.targetEntity.getZ(), 1.0);
                    } else {
                        float f2;
                        float f = (float)(crow.getX() - this.targetEntity.getX());
                        float xzDist = Mth.sqrt((float)(f * f + (f2 = (float)(crow.getZ() - this.targetEntity.getZ())) * f2));
                        float f1 = xzDist < 5.0f ? 0.0f : 1.8f;
                        crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), (double)f1 + this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                    }
                } else {
                    this.mob.getNavigation().moveTo(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                }
            }
        }

        @Override
        public void tick() {
            super.tick();
            this.moveTo();
        }
    }
}

