/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockReptileEgg;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CrocodileAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.CrocodileAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;

public class EntityCrocodile
extends TamableAnimal
implements IAnimatedEntity,
ISemiAquatic {
    public static final Animation ANIMATION_LUNGE = Animation.create((int)23);
    public static final Animation ANIMATION_DEATHROLL = Animation.create((int)40);
    public static final Predicate<Entity> NOT_CREEPER = entity -> entity.isAlive() && !(entity instanceof Creeper);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DESERT = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> STUN_TICKS = SynchedEntityData.defineId(EntityCrocodile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float groundProgress = 0.0f;
    public float prevGroundProgress = 0.0f;
    public float swimProgress = 0.0f;
    public float prevSwimProgress = 0.0f;
    public float baskingProgress = 0.0f;
    public float prevBaskingProgress = 0.0f;
    public float grabProgress = 0.0f;
    public float prevGrabProgress = 0.0f;
    public int baskingType = 0;
    public boolean forcedSit = false;
    private int baskingTimer = 0;
    private int swimTimer = -1000;
    private int ticksSinceInWater = 0;
    private int passengerTimer = 0;
    private boolean isLandNavigator;
    private boolean hasSpedUp = false;
    private int animationTick;
    private Animation currentAnimation;

    protected EntityCrocodile(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.baskingType = this.random.nextInt(1);
    }

    public static boolean canCrocodileSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        boolean spawnBlock = worldIn.getBlockState(pos.below()).is(AMTagRegistry.CROCODILE_SPAWNS);
        return spawnBlock && pos.getY() < worldIn.getSeaLevel() + 4;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 15.0).add(Attributes.ARMOR, 8.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.4f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crocSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public boolean isMaxGroupSizeReached(int sizeIn) {
        return false;
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(new ItemStack((ItemLike)AMItemRegistry.CROCODILE_SCUTE.get(), this.random.nextInt(1) + 1), 1.0f);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.setDesert(this.isBiomeDesert((LevelAccessor)worldIn, this.blockPosition()));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    private boolean isBiomeDesert(LevelAccessor worldIn, BlockPos position) {
        return worldIn.getBiome(position).is(AMTagRegistry.SPAWNS_DESERT_CROCODILES);
    }

    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? (SoundEvent)AMSoundRegistry.CROCODILE_BABY.get() : (SoundEvent)AMSoundRegistry.CROCODILE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.CROCODILE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.CROCODILE_HURT.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("CrocodileSitting", this.isSitting());
        compound.putBoolean("Desert", this.isDesert());
        compound.putBoolean("ForcedToSit", this.forcedSit);
        compound.putInt("BaskingStyle", this.baskingType);
        compound.putInt("BaskingTimer", this.baskingTimer);
        compound.putInt("SwimTimer", this.swimTimer);
        compound.putInt("StunTimer", this.getStunTicks());
        compound.putBoolean("HasEgg", this.hasEgg());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("CrocodileSitting"));
        this.setDesert(compound.getBoolean("Desert"));
        this.forcedSit = compound.getBoolean("ForcedToSit");
        this.baskingType = compound.getInt("BaskingStyle");
        this.baskingTimer = compound.getInt("BaskingTimer");
        this.swimTimer = compound.getInt("SwimTimer");
        this.setHasEgg(compound.getBoolean("HasEgg"));
        this.setStunTicks(compound.getInt("StunTimer"));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            PathNavigation prevNav = this.navigation;
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new AquaticMoveController((PathfinderMob)this, 1.0f);
            PathNavigation prevNav = this.navigation;
            this.navigation = new SemiAquaticPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
        builder.define(DESERT, (Object)false);
        builder.define(HAS_EGG, (Object)false);
        builder.define(IS_DIGGING, (Object)false);
        builder.define(CLIMBING, (Object)0);
        builder.define(STUN_TICKS, (Object)0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.entityData.get(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b0);
    }

    public void tick() {
        boolean grabbing;
        super.tick();
        this.prevGroundProgress = this.groundProgress;
        this.prevSwimProgress = this.swimProgress;
        this.prevBaskingProgress = this.baskingProgress;
        this.prevGrabProgress = this.grabProgress;
        boolean ground = !this.isInWater();
        boolean groundAnimate = !this.isInWater();
        boolean basking = groundAnimate && this.isSitting();
        boolean bl = grabbing = !this.getPassengers().isEmpty();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (groundAnimate) {
            if (this.groundProgress < 10.0f) {
                this.groundProgress += 1.0f;
            }
            if (this.swimProgress > 0.0f) {
                this.swimProgress -= 1.0f;
            }
        } else {
            if (this.groundProgress > 0.0f) {
                this.groundProgress -= 1.0f;
            }
            if (this.swimProgress < 10.0f) {
                this.swimProgress += 1.0f;
            }
        }
        if (basking) {
            if (this.baskingProgress < 10.0f) {
                this.baskingProgress += 1.0f;
            }
        } else if (this.baskingProgress > 0.0f) {
            this.baskingProgress -= 1.0f;
        }
        if (grabbing) {
            if (this.grabProgress < 10.0f) {
                this.grabProgress += 1.0f;
            }
        } else if (this.grabProgress > 0.0f) {
            this.grabProgress -= 1.0f;
        }
        if (this.getTarget() == null) {
            if (this.hasSpedUp) {
                this.hasSpedUp = false;
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
            }
        } else if (!this.hasSpedUp) {
            this.hasSpedUp = true;
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.28f);
        }
        if (!this.level().isClientSide) {
            this.setBesideClimbableBlock(this.horizontalCollision);
        }
        if (this.baskingTimer < 0) {
            ++this.baskingTimer;
        }
        if (this.passengerTimer > 0 && this.getPassengers().isEmpty()) {
            this.passengerTimer = 0;
        }
        if (!this.level().isClientSide) {
            if (this.isInWater()) {
                ++this.swimTimer;
                this.ticksSinceInWater = 0;
            } else {
                ++this.ticksSinceInWater;
                --this.swimTimer;
            }
            if (!this.isInWater() && this.onGround() && !this.isTame()) {
                if (!this.isSitting() && this.baskingTimer == 0 && this.getTarget() == null && this.getNavigation().isDone()) {
                    this.setOrderedToSit(true);
                    this.baskingTimer = 1000 + this.random.nextInt(750);
                }
                if (this.isSitting() && (this.baskingTimer <= 0 || this.getTarget() != null || this.swimTimer < -1000)) {
                    this.setOrderedToSit(false);
                    this.baskingTimer = -2000 - this.random.nextInt(750);
                }
                if (this.isSitting() && this.baskingTimer > 0) {
                    --this.baskingTimer;
                }
            }
            if (this.getStunTicks() == 0 && this.isAlive() && this.getTarget() != null && this.getAnimation() == ANIMATION_LUNGE && (this.level().getDifficulty() != Difficulty.PEACEFUL || !(this.getTarget() instanceof Player)) && this.getAnimationTick() > 5 && this.getAnimationTick() < 9) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.setDeltaMovement(this.getDeltaMovement().add((double)(-Mth.sin((float)f1) * 0.02f), 0.0, (double)(Mth.cos((float)f1) * 0.02f)));
                if (this.distanceTo((Entity)this.getTarget()) < 3.5f && this.hasLineOfSight((Entity)this.getTarget())) {
                    boolean flag = this.getTarget().isBlocking();
                    if (!flag && this.getTarget().getBbWidth() < this.getBbWidth() && this.getPassengers().isEmpty() && !this.getTarget().isShiftKeyDown()) {
                        this.getTarget().startRiding((Entity)this, true);
                    }
                    if (flag) {
                        LivingEntity livingEntity = this.getTarget();
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            this.damageShieldFor(player, (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                        }
                        if (this.getStunTicks() == 0) {
                            this.setStunTicks(25 + this.random.nextInt(20));
                        }
                    } else {
                        this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                    }
                    this.playSound((SoundEvent)AMSoundRegistry.CROCODILE_BITE.get(), this.getSoundVolume(), this.getVoicePitch());
                }
            }
            if (this.isAlive() && this.getTarget() != null && this.isInWater() && (this.level().getDifficulty() != Difficulty.PEACEFUL || !(this.getTarget() instanceof Player)) && this.getTarget().getVehicle() != null && this.getTarget().getVehicle() == this) {
                if (this.getAnimation() == NO_ANIMATION) {
                    this.setAnimation(ANIMATION_DEATHROLL);
                }
                if (this.getAnimation() == ANIMATION_DEATHROLL && this.getAnimationTick() % 10 == 0 && (double)this.distanceTo((Entity)this.getTarget()) < 5.0) {
                    this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), 5.0f);
                }
            }
        }
        if (this.getAnimation() == ANIMATION_DEATHROLL) {
            this.getNavigation().stop();
        }
        if (this.isInLove() && this.getTarget() != null) {
            this.setTarget(null);
        }
        if (this.getStunTicks() > 0) {
            this.setStunTicks(this.getStunTicks() - 1);
            if (this.level().isClientSide) {
                float angle = (float)Math.PI / 180 * this.yBodyRot;
                double headX = 1.5f * this.getScale() * Mth.sin((float)((float)Math.PI + angle));
                double headZ = 1.5f * this.getScale() * Mth.cos((float)angle);
                for (int i = 0; i < 5; ++i) {
                    float innerAngle = (float)Math.PI / 180 * (this.yBodyRot + (float)(this.tickCount * 5)) * (float)(i + 1);
                    double extraX = 0.5f * Mth.sin((float)((float)(Math.PI + (double)innerAngle)));
                    double extraZ = 0.5f * Mth.cos((float)innerAngle);
                    this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, true, this.getX() + headX + extraX, this.getEyeY() + 0.5, this.getZ() + headZ + extraZ, 0.0, 0.0, 0.0);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void damageShieldFor(Player holder, float damage) {
        if (holder.getUseItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            if (!this.level().isClientSide) {
                holder.awardStat(Stats.ITEM_USED.get((Object)holder.getUseItem().getItem()));
            }
            if (damage >= 3.0f) {
                int i = 1 + Mth.floor((float)damage);
                InteractionHand hand = holder.getUsedItemHand();
                holder.getUseItem().hurtAndBreak(i, (LivingEntity)holder, EquipmentSlot.MAINHAND);
                if (holder.getUseItem().isEmpty()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        // empty if block
                    }
                    holder.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    protected boolean isImmobile() {
        return super.isImmobile() || this.getStunTicks() > 0;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (!this.getPassengers().isEmpty()) {
            this.yBodyRot = Mth.wrapDegrees((float)(this.getYRot() - 180.0f));
        }
        if (this.hasPassenger(passenger)) {
            float radius = 2.0f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = 2.0f * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = 2.0f * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)0.1f, this.getZ() + extraZ);
            ++this.passengerTimer;
            if (this.isAlive() && this.passengerTimer > 0 && this.passengerTimer % 40 == 0) {
                passenger.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f);
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public boolean onClimbable() {
        return this.isInWater() && this.isBesideClimbableBlock();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION && this.getPassengers().isEmpty() && this.getStunTicks() == 0) {
            this.setAnimation(ANIMATION_LUNGE);
        }
        return true;
    }

    public void travel(Vec3 travelVector) {
        if (this.isSitting()) {
            super.travel(Vec3.ZERO);
        } else if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.DROWN) || source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public boolean canBreatheUnderwaterAM() {
        return true;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return super.getWalkTargetValue(pos, worldIn);
    }

    @Override
    public boolean shouldLeaveWater() {
        if (!this.getPassengers().isEmpty()) {
            return false;
        }
        if (this.getTarget() != null && !this.getTarget().isInWater()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.getAnimation() == ANIMATION_DEATHROLL || this.isSitting();
    }

    @Override
    public int getWaterSearchRange() {
        return this.getPassengers().isEmpty() ? 15 : 45;
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public boolean isDesert() {
        return (Boolean)this.entityData.get(DESERT);
    }

    public void setDesert(boolean desert) {
        this.entityData.set(DESERT, (Object)desert);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.entityData.get(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.entityData.set(IS_DIGGING, (Object)isDigging);
    }

    public int getStunTicks() {
        return (Integer)this.entityData.get(STUN_TICKS);
    }

    private void setStunTicks(int stun) {
        this.entityData.set(STUN_TICKS, (Object)stun);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(1, (Goal)new MateGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new LayEggGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AnimalAIFindWater((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new AnimalAILeaveWater((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new CrocodileAIMelee(this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new CrocodileAIRandomSwimming((PathfinderMob)this, 1.0, 7));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new AnimalAIHurtByTargetNotBaby((Animal)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new EntityAINearestTarget3D((Mob)this, Player.class, 80, false, true, null){

            public boolean canUse() {
                return !EntityCrocodile.this.isBaby() && !EntityCrocodile.this.isTame() && EntityCrocodile.this.level().getDifficulty() != Difficulty.PEACEFUL && super.canUse();
            }
        });
        this.targetSelector.addGoal(5, (Goal)new EntityAINearestTarget3D((Mob)this, LivingEntity.class, 180, false, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.CROCODILE_TARGETS)){

            public boolean canUse() {
                return !EntityCrocodile.this.isBaby() && !EntityCrocodile.this.isTame() && super.canUse();
            }
        });
        this.targetSelector.addGoal(6, (Goal)new EntityAINearestTarget3D((Mob)this, Monster.class, 180, false, true, NOT_CREEPER){

            public boolean canUse() {
                return !EntityCrocodile.this.isBaby() && EntityCrocodile.this.isTame() && super.canUse();
            }
        });
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        this.setOrderedToSit(false);
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.hurt(source, amount);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.CROCODILE.get()).create((Level)p_241840_1_);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (item == Items.NAME_TAG) {
            return super.mobInteract(player, hand);
        }
        if (this.isTame() && itemstack.getFoodProperties((LivingEntity)this) != null && itemstack.getFoodProperties((LivingEntity)this).nutrition() > 0 && this.getHealth() < this.getMaxHealth()) {
            this.usePlayerItem(player, hand, itemstack);
            this.heal(10.0f);
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            return InteractionResult.SUCCESS;
        }
        InteractionResult type = super.mobInteract(player, hand);
        InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isFood(itemstack)) {
            if (this.isSitting()) {
                this.forcedSit = false;
                this.setOrderedToSit(false);
            } else {
                this.forcedSit = true;
                this.setOrderedToSit(true);
            }
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.isBaby()) {
            super.setTarget(entitylivingbaseIn);
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.CROCODILE_BREEDABLES);
    }

    @Override
    public boolean shouldEnterWater() {
        if (!this.getPassengers().isEmpty()) {
            return true;
        }
        return this.getTarget() == null && !this.isSitting() && this.baskingTimer <= 0 && !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_LUNGE, ANIMATION_DEATHROLL};
    }

    public boolean isCrowned() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return s != null && (s.toLowerCase().contains("crown") || s.toLowerCase().contains("king") || s.toLowerCase().contains("rool"));
    }

    static class MateGoal
    extends BreedGoal {
        private final EntityCrocodile crocodile;

        MateGoal(EntityCrocodile crocodile, double speedIn) {
            super((Animal)crocodile, speedIn);
            this.crocodile = crocodile;
        }

        public boolean canUse() {
            return super.canUse() && !this.crocodile.hasEgg();
        }

        protected void breed() {
            ServerPlayer serverplayerentity = this.animal.getLoveCause();
            if (serverplayerentity == null && this.partner.getLoveCause() != null) {
                serverplayerentity = this.partner.getLoveCause();
            }
            if (serverplayerentity != null) {
                serverplayerentity.awardStat(Stats.ANIMALS_BRED);
                CriteriaTriggers.BRED_ANIMALS.trigger(serverplayerentity, this.animal, this.partner, (AgeableMob)this.animal);
            }
            this.crocodile.setHasEgg(true);
            this.animal.resetLove();
            this.partner.resetLove();
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                RandomSource random = this.animal.getRandom();
                this.level.addFreshEntity((Entity)new ExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), random.nextInt(7) + 1));
            }
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final EntityCrocodile turtle;
        private int digTime;

        LayEggGoal(EntityCrocodile turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public void stop() {
            this.digTime = 0;
        }

        public boolean canUse() {
            return this.turtle.hasEgg() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.hasEgg();
        }

        public double acceptedDistance() {
            return (double)this.turtle.getBbWidth() + 0.5;
        }

        public void tick() {
            super.tick();
            this.turtle.setOrderedToSit(false);
            this.turtle.baskingTimer = -100;
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                BlockPos blockpos = this.turtle.blockPosition();
                Level world = this.turtle.level();
                this.turtle.gameEvent((Holder)GameEvent.BLOCK_PLACE);
                world.playSound(null, blockpos, SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
                world.setBlock(this.blockPos.above(), (BlockState)((Block)AMBlockRegistry.CROCODILE_EGG.get()).defaultBlockState().setValue((Property)BlockReptileEgg.EGGS, (Comparable)Integer.valueOf(this.turtle.random.nextInt(1) + 1)), 3);
                this.turtle.setHasEgg(false);
                this.turtle.setDigging(false);
                this.turtle.setInLoveTime(600);
            }
        }

        protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
            return worldIn.isEmptyBlock(pos.above()) && BlockReptileEgg.isProperHabitat((BlockGetter)worldIn, pos);
        }
    }
}

