/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCosmicCod;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAITemptDistance;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCosmaw
extends TamableAnimal
implements ITargetsDroppedItems,
FlyingAnimal,
IFollower {
    private static final EntityDataAccessor<Float> COSMAW_PITCH = SynchedEntityData.defineId(EntityCosmaw.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityCosmaw.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityCosmaw.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityCosmaw.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float clutchProgress;
    public float prevClutchProgress;
    public float openProgress;
    public float prevOpenProgress;
    public float prevCosmawPitch;
    public float biteProgress;
    public float prevBiteProgress;
    private float stuckRot;
    private UUID fishThrowerID;
    private int heldItemTime;
    private BlockPos lastSafeTpPosition;

    protected EntityCosmaw(EntityType<? extends TamableAnimal> type, Level lvl) {
        super(type, lvl);
        this.stuckRot = this.random.nextInt(3) * 90;
        this.moveControl = new FlightMoveController((Mob)this, 1.0f, false, true);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.cosmawSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public static boolean canCosmawSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return !worldIn.getBlockState(pos.below()).isAir();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COSMAW_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(COMMAND, (Object)0);
        builder.define(SITTING, (Object)false);
    }

    protected void onBelowWorld() {
    }

    public boolean doHurtTarget(Entity entityIn) {
        if ((Integer)this.entityData.get(ATTACK_TICK) == 0 && this.biteProgress == 0.0f) {
            this.entityData.set(ATTACK_TICK, (Object)5);
        }
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AIAttack());
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new FlyingAIFollowOwner(this, 1.3, 8.0f, 4.0f, false));
        this.goalSelector.addGoal(4, (Goal)new AIPickupOwner());
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.2));
        this.goalSelector.addGoal(6, (Goal)new AnimalAITemptDistance((PathfinderMob)this, 1.1, Ingredient.of(AMTagRegistry.COSMAW_FOODSTUFFS), false, 25.0){

            @Override
            public boolean canUse() {
                return super.canUse() && EntityCosmaw.this.getMainHandItem().isEmpty();
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && EntityCosmaw.this.getMainHandItem().isEmpty();
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomFlyGoal(this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                LivingEntity livingentity = this.mob.getLastHurtByMob();
                if (livingentity != null && EntityCosmaw.this.isOwnedBy(livingentity)) {
                    return false;
                }
                return super.canUse();
            }
        });
        this.targetSelector.addGoal(3, new EntityAINearestTarget3D<EntityCosmicCod>((Mob)this, EntityCosmicCod.class, 80, true, false, (Predicate<LivingEntity>)Predicates.alwaysTrue()));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.COSMAW_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.COSMAW_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.COSMAW_HURT.get();
    }

    public boolean isFood(ItemStack stack) {
        return this.isTame() && stack.is(AMTagRegistry.COSMAW_BREEDABLES);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isLeftHanded() {
        return false;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public float getClampedCosmawPitch(float partialTick) {
        float f = this.prevCosmawPitch + (this.getCosmawPitch() - this.prevCosmawPitch) * partialTick;
        return Mth.clamp((float)f, (float)-90.0f, (float)90.0f);
    }

    public float getCosmawPitch() {
        return ((Float)this.entityData.get(COSMAW_PITCH)).floatValue();
    }

    public void setCosmawPitch(float pitch) {
        this.entityData.set(COSMAW_PITCH, (Object)Float.valueOf(pitch));
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            float f = this.walkAnimation.position();
            float f1 = this.walkAnimation.speed();
            float bob = (float)(Math.sin(f * 0.7f) * (double)f1 * 0.0625 * (double)1.6f - (double)(f1 * 0.0625f * 1.6f));
            passenger.setPos(this.getX(), this.getY() - (double)bob + (double)0.3f - (double)this.getBbHeight() * 0.75, this.getZ());
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("CosmawSitting", this.isSitting());
        compound.putInt("Command", this.getCommand());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("CosmawSitting"));
        this.setCommand(compound.getInt("Command"));
    }

    public void tick() {
        super.tick();
        this.prevOpenProgress = this.openProgress;
        this.prevClutchProgress = this.clutchProgress;
        this.prevBiteProgress = this.biteProgress;
        this.prevCosmawPitch = this.getCosmawPitch();
        if (!this.level().isClientSide) {
            float f2 = -((float)this.getDeltaMovement().y * 57.295776f);
            this.setCosmawPitch(this.getCosmawPitch() + 0.6f * (this.getCosmawPitch() + f2) - this.getCosmawPitch());
        }
        if (this.isMouthOpen()) {
            if (this.openProgress < 5.0f) {
                this.openProgress += 1.0f;
            }
        } else if (this.openProgress > 0.0f) {
            this.openProgress -= 1.0f;
        }
        if (this.isVehicle()) {
            if (this.clutchProgress < 5.0f) {
                this.clutchProgress += 1.0f;
            }
        } else if (this.clutchProgress > 0.0f) {
            this.clutchProgress -= 1.0f;
        }
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            if (this.biteProgress < 5.0f) {
                this.biteProgress = Math.min(5.0f, this.biteProgress + 2.0f);
            } else {
                if (this.getTarget() != null && (double)this.distanceTo((Entity)this.getTarget()) < 3.3) {
                    if (this.getTarget() instanceof EntityCosmicCod && !this.isTame()) {
                        EntityCosmicCod fish = (EntityCosmicCod)this.getTarget();
                        CompoundTag fishNbt = new CompoundTag();
                        fish.addAdditionalSaveData(fishNbt);
                        fishNbt.putString("DeathLootTable", BuiltInLootTables.EMPTY.location().toString());
                        fish.readAdditionalSaveData(fishNbt);
                    }
                    this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
                }
                this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            }
        } else if (this.biteProgress > 0.0f) {
            this.biteProgress -= 1.0f;
        }
        if (!this.getMainHandItem().isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 30 && this.canTargetItem(this.getMainHandItem())) {
                this.heldItemTime = 0;
                this.heal(4.0f);
                this.gameEvent((Holder)GameEvent.EAT);
                this.playSound(SoundEvents.DOLPHIN_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (this.getMainHandItem().is(AMTagRegistry.COSMAW_TAMEABLES) && this.fishThrowerID != null && !this.isTame()) {
                    if (this.getRandom().nextFloat() < 0.3f) {
                        this.setTame(true, true);
                        this.setCommand(1);
                        this.setOwnerUUID(this.fishThrowerID);
                        Player player = this.level().getPlayerByUUID(this.fishThrowerID);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                this.getMainHandItem().shrink(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (!this.level().isClientSide) {
            BlockPos pos;
            if ((this.tickCount % 100 == 0 || this.lastSafeTpPosition == null) && (pos = this.getCosmawGround(this.blockPosition())).getY() > 1) {
                this.lastSafeTpPosition = pos;
            }
            if (this.isVehicle()) {
                if (this.lastSafeTpPosition != null) {
                    double dist = this.distanceToSqr(Vec3.atCenterOf((Vec3i)this.lastSafeTpPosition));
                    float speed = 0.8f;
                    if (this.getY() < -40.0) {
                        speed = 3.0f;
                    }
                    if (this.verticalCollision && dist > 14.0) {
                        this.setYRot(this.stuckRot);
                        if (this.random.nextInt(50) == 0) {
                            this.stuckRot = Mth.wrapDegrees((float)(this.stuckRot + 90.0f));
                        }
                        float angle = (float)Math.PI / 180 * this.stuckRot;
                        double extraX = -2.0f * Mth.sin((float)((float)Math.PI + angle));
                        double extraZ = -2.0f * Mth.cos((float)angle);
                        this.getMoveControl().setWantedPosition(this.getX() + extraX, this.getY() + 2.0, this.getZ() + extraZ, (double)speed);
                    } else if ((double)this.lastSafeTpPosition.getY() > this.getY() + (double)2.3f) {
                        this.getMoveControl().setWantedPosition(this.getX(), this.getY() + 2.0, this.getZ(), (double)speed);
                    } else {
                        this.getMoveControl().setWantedPosition((double)this.lastSafeTpPosition.getX(), (double)(this.lastSafeTpPosition.getY() + 2), (double)this.lastSafeTpPosition.getZ(), (double)speed);
                    }
                    if (dist < 7.0 && this.getCosmawGround(this.blockPosition()).getY() > 1) {
                        this.ejectPassengers();
                    }
                } else if (this.getY() < 0.0) {
                    this.getDeltaMovement().add(0.0, 0.75, 0.0);
                } else if (this.getY() < 80.0) {
                    this.getDeltaMovement().add(0.0, (double)0.1f, 0.0);
                }
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        InteractionResult interactionresult = stack.interactLivingEntity(player, (LivingEntity)this, hand);
        if (this.canTargetItem(stack) && this.getMainHandItem().isEmpty()) {
            ItemStack rippedStack = stack.copy();
            rippedStack.setCount(1);
            stack.shrink(1);
            this.setItemInHand(InteractionHand.MAIN_HAND, rippedStack);
            if (rippedStack.is(AMTagRegistry.COSMAW_TAMEABLES)) {
                this.fishThrowerID = player.getUUID();
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isBaby() && interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setOrderedToSit(true);
                return InteractionResult.SUCCESS;
            }
            this.setOrderedToSit(false);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public boolean isMouthOpen() {
        return !this.getMainHandItem().isEmpty();
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected PathNavigation createNavigation(Level level) {
        return new DirectPathNavigator((Mob)this, level, 0.5f);
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)AMEntityRegistry.COSMAW.get()).create(this.level());
    }

    private BlockPos getCosmawGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() < 256 && !this.level().getFluidState(position).isEmpty()) {
            position = position.above();
        }
        while (position.getY() > 1 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return position;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.is(AMTagRegistry.COSMAW_FOODSTUFFS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
        Entity itemThrower = e.getOwner();
        this.fishThrowerID = e.getItem().is(AMTagRegistry.COSMAW_TAMEABLES) && !this.isTame() && itemThrower != null ? itemThrower.getUUID() : null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1 && !this.isVehicle();
    }

    private boolean shouldWander() {
        if (this.isVehicle()) {
            return false;
        }
        if (this.isTame()) {
            int command = this.getCommand();
            if (command == 2 || this.isSitting()) {
                return false;
            }
            if (command == 1 && this.getOwner() != null && this.distanceTo((Entity)this.getOwner()) < 10.0f) {
                return true;
            }
            return command == 0;
        }
        return true;
    }

    public void push(Entity entity) {
        if (!(this.isTame() && entity instanceof LivingEntity && this.isOwnedBy((LivingEntity)entity))) {
            super.push(entity);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    private class AIAttack
    extends Goal {
        public AIAttack() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityCosmaw.this.getTarget() != null && EntityCosmaw.this.getTarget().isAlive();
        }

        public void tick() {
            double d = EntityCosmaw.this.distanceTo((Entity)EntityCosmaw.this.getTarget());
            float f = EntityCosmaw.this.isBaby() ? 0.5f : 1.0f;
            if (d < 3.0 * (double)f) {
                EntityCosmaw.this.doHurtTarget((Entity)EntityCosmaw.this.getTarget());
            } else {
                EntityCosmaw.this.getNavigation().moveTo((Entity)EntityCosmaw.this.getTarget(), 1.0);
            }
        }
    }

    private class AIPickupOwner
    extends Goal {
        private LivingEntity owner;

        private AIPickupOwner() {
        }

        public boolean canUse() {
            if (EntityCosmaw.this.isTame() && EntityCosmaw.this.getOwner() != null && !EntityCosmaw.this.isSitting() && !EntityCosmaw.this.getOwner().isPassenger() && !EntityCosmaw.this.getOwner().onGround() && EntityCosmaw.this.getOwner().fallDistance > 4.0f) {
                this.owner = EntityCosmaw.this.getOwner();
                return true;
            }
            return false;
        }

        public void tick() {
            if (this.owner != null && (!this.owner.isFallFlying() || this.owner.getY() < -30.0)) {
                double dist = EntityCosmaw.this.distanceTo((Entity)this.owner);
                if (dist < 3.0 || this.owner.getY() <= -50.0) {
                    this.owner.fallDistance = 0.0f;
                    this.owner.startRiding((Entity)EntityCosmaw.this);
                } else if (dist > 100.0 || this.owner.getY() <= -20.0) {
                    EntityCosmaw.this.teleportTo(this.owner.getX(), this.owner.getY() - 1.0, this.owner.getZ());
                } else {
                    EntityCosmaw.this.getNavigation().moveTo((Entity)this.owner, 1.0 + Math.min(dist * (double)0.3f, 3.0));
                }
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityCosmaw parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntityCosmaw mosquito) {
            this.parentEntity = mosquito;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.parentEntity.getNavigation().isDone() && this.parentEntity.shouldWander() && this.parentEntity.getTarget() == null && this.parentEntity.getRandom().nextInt(4) == 0) {
                this.target = this.getBlockInViewCosmaw();
                if (this.target != null) {
                    this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 1.0);
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.parentEntity.shouldWander() && this.parentEntity.getTarget() == null;
        }

        public void stop() {
            this.target = null;
        }

        public void tick() {
            if (this.target != null) {
                this.parentEntity.getMoveControl().setWantedPosition((double)this.target.getX() + 0.5, (double)this.target.getY() + 0.5, (double)this.target.getZ() + 0.5, 1.0);
                if (this.parentEntity.distanceToSqr(Vec3.atCenterOf((Vec3i)this.target)) < 4.0 || this.parentEntity.horizontalCollision) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockInViewCosmaw() {
            float radius = 5 + this.parentEntity.getRandom().nextInt(10);
            float neg = this.parentEntity.getRandom().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.getYRot();
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f * (this.parentEntity.getRandom().nextFloat() * neg);
            double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = radius * Mth.cos((float)angle);
            BlockPos radialPos = AMBlockPos.fromCoords(this.parentEntity.getX() + extraX, this.parentEntity.getY(), this.parentEntity.getZ() + extraZ);
            BlockPos ground = this.parentEntity.getCosmawGround(radialPos);
            if (!this.parentEntity.isTargetBlocked(Vec3.atCenterOf((Vec3i)(ground = ground.getY() <= 1 ? ground.above(70 + this.parentEntity.random.nextInt(4)) : ground.above(2 + this.parentEntity.random.nextInt(2))).above()))) {
                return ground;
            }
            return null;
        }
    }
}

