/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.network.MessageHurtMultipart;
import com.github.alexthe666.alexsmobs.network.MessageInteractMultipart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.entity.PartEntity;

public class EntityCachalotPart
extends PartEntity<EntityCachalotWhale> {
    private final EntityDimensions size;
    public float scale = 1.0f;

    public EntityCachalotPart(EntityCachalotWhale parent, float sizeX, float sizeY) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)sizeX, (float)sizeY);
        this.refreshDimensions();
    }

    public EntityCachalotPart(EntityCachalotWhale entityCachalotWhale, float sizeX, float sizeY, EntityDimensions size) {
        super((Entity)entityCachalotWhale);
        this.size = size;
    }

    protected void collideWithNearbyEntities() {
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(0.2, 0.0, 0.2));
        Entity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(entity -> entity != parent && (!(entity instanceof EntityCachalotPart) || ((EntityCachalotPart)((Object)entity)).getParent() != parent) && entity.isPushable()).forEach(entity -> entity.push(parent));
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide && this.getParent() != null) {
            AlexsMobs.sendMSGToServer(new MessageInteractMultipart(((EntityCachalotWhale)this.getParent()).getId(), hand == InteractionHand.OFF_HAND));
        }
        return this.getParent() == null ? InteractionResult.PASS : ((EntityCachalotWhale)this.getParent()).mobInteract(player, hand);
    }

    protected void collideWithEntity(Entity entityIn) {
        entityIn.push((Entity)this);
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        Entity parent = this.getParent();
        return parent != null ? parent.getPickResult() : ItemStack.EMPTY;
    }

    public boolean hurt(DamageSource source, float amount) {
        ResourceLocation key;
        if (this.level().isClientSide && this.getParent() != null && !((EntityCachalotWhale)this.getParent()).isInvulnerableTo(source) && (key = ((Registry)this.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getKey((Object)source.type())) != null) {
            AlexsMobs.sendMSGToServer(new MessageHurtMultipart(this.getId(), ((EntityCachalotWhale)this.getParent()).getId(), amount, key.toString()));
        }
        return !this.isInvulnerableTo(source) && ((EntityCachalotWhale)this.getParent()).attackEntityPartFrom(this, source, amount);
    }

    public boolean is(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        throw new UnsupportedOperationException();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

