/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotPart;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityCachalotEcho
extends Entity {
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.defineId(EntityCachalotEcho.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FASTER_ANIM = SynchedEntityData.defineId(EntityCachalotEcho.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GREEN = SynchedEntityData.defineId(EntityCachalotEcho.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private UUID ownerUUID;
    private int ownerNetworkId;
    private boolean leftOwner;
    private boolean playerLaunched = false;

    public EntityCachalotEcho(EntityType p_i50162_1_, Level p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public EntityCachalotEcho(Level worldIn, EntityCachalotWhale p_i47273_2_) {
        this((EntityType)AMEntityRegistry.CACHALOT_ECHO.get(), worldIn);
        this.setShooter((Entity)p_i47273_2_);
    }

    public EntityCachalotEcho(Level worldIn, LivingEntity p_i47273_2_, boolean right, boolean green) {
        this((EntityType)AMEntityRegistry.CACHALOT_ECHO.get(), worldIn);
        this.setShooter((Entity)p_i47273_2_);
        float rot = p_i47273_2_.yHeadRot + (float)(right ? 90 : -90);
        this.playerLaunched = true;
        this.setGreen(green);
        this.setFasterAnimation(true);
        this.setPos(p_i47273_2_.getX() - (double)p_i47273_2_.getBbWidth() * 0.5 * (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), p_i47273_2_.getY() + 1.0, p_i47273_2_.getZ() + (double)p_i47273_2_.getBbWidth() * 0.5 * (double)Mth.cos((float)(rot * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntityCachalotEcho(Level worldIn, double x, double y, double z, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        this((EntityType)AMEntityRegistry.CACHALOT_ECHO.get(), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(p_i47274_8_, p_i47274_10_, p_i47274_12_);
    }

    protected static float lerpRotation(float p_234614_0_, float p_234614_1_) {
        while (p_234614_1_ - p_234614_0_ < -180.0f) {
            p_234614_0_ -= 360.0f;
        }
        while (p_234614_1_ - p_234614_0_ >= 180.0f) {
            p_234614_0_ += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)p_234614_0_, (float)p_234614_1_);
    }

    public boolean isReturning() {
        return (Boolean)this.entityData.get(RETURNING);
    }

    public void setReturning(boolean returning) {
        this.entityData.set(RETURNING, (Object)returning);
    }

    public boolean isFasterAnimation() {
        return (Boolean)this.entityData.get(FASTER_ANIM);
    }

    public void setFasterAnimation(boolean anim) {
        this.entityData.set(FASTER_ANIM, (Object)anim);
    }

    public void tick() {
        double yMot = Mth.sqrt((float)((float)(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z)));
        this.setXRot((float)(Mth.atan2((double)this.getDeltaMovement().y, (double)yMot) * 57.2957763671875));
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
        Vec3 vector3d = this.getDeltaMovement();
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            this.onImpact(raytraceresult);
        }
        Entity shooter = this.getOwner();
        if (this.isReturning() && shooter instanceof EntityCachalotWhale) {
            EntityCachalotWhale whale = (EntityCachalotWhale)shooter;
            if (whale.headPart.distanceTo(this) < whale.headPart.getBbWidth()) {
                this.remove(Entity.RemovalReason.DISCARDED);
                whale.recieveEcho();
            }
        }
        if (!(this.playerLaunched || this.level().isClientSide || this.isInWaterOrBubble())) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.tickCount > 100) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        this.updateRotation();
        if (this.playerLaunched) {
            this.noPhysics = true;
        }
        this.setDeltaMovement(vector3d.scale((double)0.99f));
        this.setNoGravity(true);
        this.setPos(d0, d1, d2);
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875) - 90.0f);
    }

    protected void onEntityHit(EntityHitResult result) {
        Entity entity = this.getOwner();
        if (this.isReturning()) {
            EntityCachalotWhale whale = null;
            if (entity instanceof EntityCachalotWhale) {
                whale = (EntityCachalotWhale)entity;
                if (result.getEntity() instanceof EntityCachalotWhale || result.getEntity() instanceof EntityCachalotPart) {
                    whale.recieveEcho();
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        } else if (result.getEntity() != entity && !result.getEntity().is(entity)) {
            this.setReturning(true);
            if (entity instanceof EntityCachalotWhale) {
                Vec3 vec = ((EntityCachalotWhale)entity).getReturnEchoVector();
                double d0 = vec.x() - this.getX();
                double d1 = vec.y() - this.getY();
                double d2 = vec.z() - this.getZ();
                this.setDeltaMovement(Vec3.ZERO);
                EntityCachalotEcho echo = new EntityCachalotEcho(this.level(), (EntityCachalotWhale)entity);
                echo.copyPosition(this);
                this.remove(Entity.RemovalReason.DISCARDED);
                echo.setReturning(true);
                echo.shoot(d0, d1, d2, 1.0f, 0.0f);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)echo);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        if (!this.level().isClientSide && !this.playerLaunched) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(RETURNING, (Object)false);
        builder.define(FASTER_ANIM, (Object)false);
        builder.define(GREEN, (Object)false);
    }

    public void setShooter(@Nullable Entity entityIn) {
        if (entityIn != null) {
            this.ownerUUID = entityIn.getUUID();
            this.ownerNetworkId = entityIn.getId();
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.ownerUUID != null && this.level() instanceof ServerLevel) {
            return ((ServerLevel)this.level()).getEntity(this.ownerUUID);
        }
        return this.ownerNetworkId != 0 ? this.level().getEntity(this.ownerNetworkId) : null;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compound.putBoolean("LeftOwner", true);
        }
        compound.putBoolean("Green", this.isGreen());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        this.setGreen(compound.getBoolean("Green"));
        this.leftOwner = compound.getBoolean("LeftOwner");
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_234613_0_ -> !p_234613_0_.isSpectator() && p_234613_0_.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * 0.0075 * (double)inaccuracy, this.random.nextGaussian() * 0.0075 * (double)inaccuracy, this.random.nextGaussian() * 0.0075 * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vector3d);
        float f = Mth.sqrt((float)((float)this.horizontalMag(vector3d)));
        this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private double horizontalMag(Vec3 vector3d) {
        return vector3d.x * vector3d.x + vector3d.z * vector3d.z;
    }

    public void shootFromRotation(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        float f3 = p_234612_3_ * ((float)Math.PI / 180);
        float f0 = Mth.cos((float)(p_234612_2_ * ((float)Math.PI / 180)));
        float f = -Mth.sin((float)f3) * f0;
        float f1 = -Mth.sin((float)((p_234612_2_ + p_234612_4_) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)f3) * f0;
        this.shoot(f, f1, f2, p_234612_5_, p_234612_6_);
        Vec3 vector3d = p_234612_1_.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vector3d.x, p_234612_1_.onGround() ? 0.0 : vector3d.y, vector3d.z));
    }

    protected void onImpact(HitResult result) {
        HitResult.Type raytraceresult$type = result.getType();
        if (this.playerLaunched) {
            return;
        }
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.onEntityHit((EntityHitResult)result);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)result);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)(x * x + z * z)));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    protected boolean canHitEntity(Entity p_230298_1_) {
        if (this.playerLaunched) {
            return false;
        }
        if (this.isReturning()) {
            return p_230298_1_ instanceof EntityCachalotPart || p_230298_1_ instanceof EntityCachalotWhale;
        }
        if (p_230298_1_ instanceof EntityCachalotPart) {
            return false;
        }
        if (!p_230298_1_.isSpectator() && p_230298_1_.isAlive() && p_230298_1_.isPickable()) {
            Entity entity = this.getOwner();
            return entity == null || this.leftOwner || !entity.isPassengerOfSameVehicle(p_230298_1_);
        }
        return false;
    }

    protected void updateRotation() {
        Vec3 vector3d = this.getDeltaMovement();
        float f = Mth.sqrt((float)((float)this.horizontalMag(vector3d)));
        this.setXRot(EntityCachalotEcho.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875)));
        this.setYRot(EntityCachalotEcho.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875)));
    }

    public boolean isGreen() {
        return (Boolean)this.entityData.get(GREEN);
    }

    public void setGreen(boolean bool) {
        this.entityData.set(GREEN, (Object)bool);
    }
}

