/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.BlueJayAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAITempt;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityBlueJay
extends Animal
implements ITargetsDroppedItems {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> CREST_TARGET = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> LAST_FEEDER_UUID = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> RACCOON_UUID = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> FEED_TIME = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SING_TIME = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> BLUE_VISUAL_FLAG = SynchedEntityData.defineId(EntityBlueJay.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Predicate<Entity> HIGHLIGHTS_WITH_SONG = entity -> entity instanceof Enemy;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevFlapAmount;
    public float flapAmount;
    public float attackProgress;
    public float prevAttackProgress;
    public float prevCrestAmount;
    public float crestAmount;
    private boolean isLandNavigator;
    private int timeFlying;
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    public boolean aiItemFlag = false;
    private int prevSingTime = 0;
    private int blueTime = 0;
    private int raiseCrestOverrideTicks;

    protected EntityBlueJay(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new BlueJayAIMelee(this));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FlyingAITempt((PathfinderMob)this, 1.0, Ingredient.of(AMTagRegistry.BLUE_JAY_FOODSTUFFS), false));
        this.goalSelector.addGoal(5, (Goal)new AIFollowFeederOrRaccoon());
        this.goalSelector.addGoal(6, (Goal)new AIFlyIdle());
        this.goalSelector.addGoal(7, (Goal)new AIScatter());
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, PathfinderMob.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AITargetItems((PathfinderMob)this, false, false, 40, 16));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}).setAlertOthers(new Class[0]));
    }

    public static boolean checkBlueJaySpawnRules(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return EntityBlueJay.isBrightEnoughToSpawn((BlockAndTintGetter)worldIn, (BlockPos)pos);
    }

    public boolean checkSpawnObstruction(LevelReader reader) {
        if (reader.isUnobstructed((Entity)this) && !reader.containsAnyLiquid(this.getBoundingBox())) {
            BlockPos blockpos = this.blockPosition();
            BlockState blockstate2 = reader.getBlockState(blockpos.below());
            return blockstate2.is(BlockTags.LEAVES) || blockstate2.is(BlockTags.LOGS) || blockstate2.is(Blocks.GRASS_BLOCK);
        }
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.blueJaySpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.BLUE_JAY_BREEDABLES);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(FEED_TIME, (Object)0);
        builder.define(SING_TIME, (Object)0);
        builder.define(CREST_TARGET, (Object)Float.valueOf(0.0f));
        builder.define(BLUE_VISUAL_FLAG, (Object)false);
        builder.define(RACCOON_UUID, Optional.empty());
        builder.define(LAST_FEEDER_UUID, Optional.empty());
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new FlightMoveController((Mob)this, 1.0f, false);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public void tick() {
        Entity owner;
        Entity entity;
        super.tick();
        this.prevCrestAmount = this.crestAmount;
        this.prevAttackProgress = this.attackProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevFlyProgress = this.flyProgress;
        this.prevBirdPitch = this.birdPitch;
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if ((Integer)this.entityData.get(ATTACK_TICK) > 0) {
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        float yMov = (float)this.getDeltaMovement().y;
        this.birdPitch = yMov * 2.0f * -57.295776f;
        if (yMov >= 0.0f) {
            if (this.flapAmount < 1.0f) {
                this.flapAmount += 0.25f;
            }
        } else if (yMov < -0.07f && this.flapAmount > 0.0f) {
            this.flapAmount -= 0.25f;
        }
        if (this.raiseCrestOverrideTicks > 0) {
            --this.raiseCrestOverrideTicks;
            this.crestAmount = 0.75f;
        } else {
            this.crestAmount = Mth.approach((float)this.crestAmount, (float)this.getTargetCrest(), (float)0.3f);
        }
        if (!this.level().isClientSide) {
            if (this.isFlying()) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                ++this.timeFlying;
                this.setNoGravity(true);
                if (this.isPassenger() || this.isInLove()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
            if (this.getTarget() != null) {
                this.setCrestTarget(1.0f);
            } else if (this.getRaccoonUUID() != null) {
                this.setCrestTarget(0.5f);
            } else {
                this.setCrestTarget(0.0f);
            }
        }
        if (this.getFeedTime() > 0) {
            this.setFeedTime(this.getFeedTime() - 1);
            if (this.getFeedTime() == 0) {
                this.setLastFeeder(null);
            }
        }
        if ((entity = this.getVehicle()) instanceof EntityRaccoon) {
            EntityRaccoon riddenRaccoon = (EntityRaccoon)entity;
            this.yBodyRot = riddenRaccoon.yBodyRot;
        }
        if ((owner = this.getRaccoon()) instanceof EntityRaccoon) {
            EntityRaccoon raccoon = (EntityRaccoon)owner;
            LivingEntity jayTarget = this.getTarget();
            LivingEntity raccoonTarget = raccoon.getTarget();
            if (jayTarget != null && jayTarget.isAlive()) {
                if (this.isPassenger()) {
                    this.stopRiding();
                }
            } else if (raccoonTarget != null && raccoonTarget.isAlive() && this.canAttack(raccoonTarget)) {
                this.setTarget(raccoonTarget);
            }
        }
        if (this.getSingTime() > 0) {
            this.setSingTime(this.getSingTime() - 1);
            if (this.prevSingTime % 15 == 0) {
                this.playSound((SoundEvent)AMSoundRegistry.BLUE_JAY_SONG.get(), this.getSoundVolume(), this.getVoicePitch());
            }
            if (this.level().isClientSide && this.getSingTime() % 5 == 0 && this.level().isClientSide) {
                Vec3 modelFront = new Vec3(0.0, (double)0.2f, (double)0.3f).scale((double)this.getScale()).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
                Vec3 particleFrom = this.position().add(modelFront);
                this.level().addParticle((ParticleOptions)AMParticleRegistry.BIRD_SONG.get(), particleFrom.x, particleFrom.y, particleFrom.z, modelFront.x, modelFront.y, modelFront.z);
            }
        }
        if (this.prevSingTime < this.getSingTime() && !this.level().isClientSide) {
            this.blueTime = 1200;
            this.entityData.set(BLUE_VISUAL_FLAG, (Object)true);
            this.highlightMonsters();
        }
        if (this.blueTime > 0) {
            --this.blueTime;
            if (this.blueTime == 0) {
                this.entityData.set(BLUE_VISUAL_FLAG, (Object)false);
                this.level().broadcastEntityEvent((Entity)this, (byte)68);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)67);
            }
        }
        this.prevSingTime = this.getSingTime();
    }

    public void playAmbientSound() {
        super.playAmbientSound();
        this.raiseCrestOverrideTicks = 15;
    }

    private boolean highlightMonsters() {
        AABB allyBox = this.getBoundingBox().inflate(64.0);
        allyBox = allyBox.setMinY(-64.0);
        allyBox = allyBox.setMaxY(320.0);
        boolean any = false;
        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, allyBox, HIGHLIGHTS_WITH_SONG)) {
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, this.blueTime, 0, true, false));
        }
        return any;
    }

    public boolean isMakingMonstersBlue() {
        return (Boolean)this.entityData.get(BLUE_VISUAL_FLAG);
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (this.getSingTime() > 0 && !this.level().isClientSide) {
            this.entityData.set(BLUE_VISUAL_FLAG, (Object)false);
            this.level().broadcastEntityEvent((Entity)this, (byte)68);
        }
        super.remove(removalReason);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public void travel(Vec3 vec3d) {
        if (this.isInWater() && this.getDeltaMovement().y > 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.5, 1.0));
        }
        super.travel(vec3d);
    }

    public BlockPos getBlueJayGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() < 320 && !this.level().getFluidState(position).isEmpty()) {
            position = position.above();
        }
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid() && this.level().getFluidState(position).isEmpty()) {
            position = position.below();
        }
        return position;
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.getRaccoonUUID() != null) {
            if (entityIn instanceof EntityRaccoon && this.getRaccoonUUID().equals(entityIn.getUUID())) {
                return true;
            }
            Entity raccoon = this.getRaccoon();
            if (raccoon != null && (raccoon.isAlliedTo(entityIn) || entityIn.isAlliedTo(raccoon))) {
                return true;
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = 10 + this.getRandom().nextInt(15);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), (int)this.getY(), (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getBlueJayGround(radialPos);
        if (ground.getY() < -64) {
            return null;
        }
        ground = this.blockPosition();
        while (ground.getY() > -64 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground.below());
        }
        return null;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.getRandom().nextInt(5);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getBlueJayGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 5 + this.getRandom().nextInt(5);
        int j = this.getRandom().nextInt(5) + 5;
        BlockPos newPos = ground.above(distFromGround > 5 ? flightHeight : j);
        if (this.level().getBlockState(ground).is(BlockTags.LEAVES)) {
            newPos = ground.above(1 + this.getRandom().nextInt(3));
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.BLUE_JAY_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.BLUE_JAY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.BLUE_JAY_HURT.get();
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            flying = false;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlying(compound.getBoolean("Flying"));
        this.blueTime = compound.getInt("BlueTime");
        if (compound.hasUUID("FeederUUID")) {
            this.setLastFeederUUID(compound.getUUID("FeederUUID"));
        }
        if (compound.hasUUID("RaccoonUUID")) {
            this.setRaccoonUUID(compound.getUUID("RaccoonUUID"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Flying", this.isFlying());
        compound.putInt("BlueTime", this.blueTime);
        if (this.getLastFeederUUID() != null) {
            compound.putUUID("FeederUUID", this.getLastFeederUUID());
        }
        if (this.getRaccoonUUID() != null) {
            compound.putUUID("RaccoonUUID", this.getRaccoonUUID());
        }
    }

    public int getFeedTime() {
        return (Integer)this.entityData.get(FEED_TIME);
    }

    public void setFeedTime(int feedTime) {
        this.entityData.set(FEED_TIME, (Object)feedTime);
    }

    public int getSingTime() {
        return (Integer)this.entityData.get(SING_TIME);
    }

    public void setSingTime(int singTime) {
        this.entityData.set(SING_TIME, (Object)singTime);
    }

    public float getTargetCrest() {
        return ((Float)this.entityData.get(CREST_TARGET)).floatValue();
    }

    public void setCrestTarget(float crestTarget) {
        this.entityData.set(CREST_TARGET, (Object)Float.valueOf(crestTarget));
    }

    @Nullable
    public UUID getLastFeederUUID() {
        return ((Optional)this.entityData.get(LAST_FEEDER_UUID)).orElse(null);
    }

    public void setLastFeederUUID(@Nullable UUID uniqueId) {
        this.entityData.set(LAST_FEEDER_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public Entity getLastFeeder() {
        UUID id = this.getLastFeederUUID();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setLastFeeder(@Nullable Entity feeder) {
        if (feeder == null) {
            this.setLastFeederUUID(null);
        } else {
            this.setLastFeederUUID(feeder.getUUID());
        }
    }

    @Nullable
    public UUID getRaccoonUUID() {
        return ((Optional)this.entityData.get(RACCOON_UUID)).orElse(null);
    }

    public void setRaccoonUUID(@Nullable UUID uniqueId) {
        this.entityData.set(RACCOON_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public Entity getRaccoon() {
        UUID id = this.getRaccoonUUID();
        if (id != null && !this.level().isClientSide) {
            return ((ServerLevel)this.level()).getEntity(id);
        }
        return null;
    }

    public void setRaccoon(@Nullable Entity feeder) {
        if (feeder == null) {
            this.setRaccoonUUID(null);
        } else {
            this.setRaccoonUUID(feeder.getUUID());
        }
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -65 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || this.level().getBlockState(position).is(Blocks.VINE) || position.getY() <= -65;
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)AMEntityRegistry.BLUE_JAY.get()).create(this.level());
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.has(DataComponents.FOOD) || stack.is(AMTagRegistry.BLUE_JAY_FOODSTUFFS);
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.heal(3.0f);
        Entity itemThrower = e.getOwner();
        if (itemThrower != null && e.getItem().is(AMTagRegistry.BLUE_JAY_TEAMING_FOODS)) {
            this.setLastFeederUUID(itemThrower.getUUID());
            this.setFeedTime(1200);
            this.stopRiding();
        }
        if (e.getOwner() != null && e.getItem().is(AMTagRegistry.BLUE_JAY_ALERT_FOODS)) {
            this.setSingTime(40);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        if (!type.consumesAction()) {
            if (itemstack.is(AMTagRegistry.BLUE_JAY_TEAMING_FOODS) && this.getFeedTime() <= 0) {
                this.heal(3.0f);
                this.usePlayerItem(player, hand, itemstack);
                this.setRaccoonUUID(null);
                this.stopRiding();
                this.setLastFeeder((Entity)player);
                this.setFeedTime(1200);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.is(AMTagRegistry.BLUE_JAY_ALERT_FOODS) && this.getSingTime() <= 0) {
                this.heal(3.0f);
                this.setSingTime(40);
                this.usePlayerItem(player, hand, itemstack);
                return InteractionResult.SUCCESS;
            }
        }
        return type;
    }

    @Override
    public void peck() {
        this.entityData.set(ATTACK_TICK, (Object)7);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 67 || id == 68) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.handleEntityEvent(id);
        }
    }

    private boolean isTrusting() {
        return this.getFeedTime() > 0 || this.getSingTime() > 0 || this.getRaccoonUUID() != null || this.aiItemFlag;
    }

    private class AIFollowFeederOrRaccoon
    extends Goal {
        private Entity following;

        AIFollowFeederOrRaccoon() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Entity feeder;
            Entity raccoon;
            if (EntityBlueJay.this.isPassenger() || EntityBlueJay.this.getTarget() != null && EntityBlueJay.this.getTarget().isAlive()) {
                return false;
            }
            if (EntityBlueJay.this.getRaccoonUUID() != null && (raccoon = EntityBlueJay.this.getRaccoon()) != null) {
                this.following = raccoon;
                return true;
            }
            if (EntityBlueJay.this.getFeedTime() > 0 && (feeder = EntityBlueJay.this.getLastFeeder()) != null) {
                this.following = feeder;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity target = EntityBlueJay.this.getTarget();
            return !(this.following == null || !this.following.isAlive() || target != null && target.isAlive() || !(this.following instanceof EntityRaccoon) && EntityBlueJay.this.getFeedTime() <= 0 || EntityBlueJay.this.isPassenger());
        }

        public void tick() {
            Entity entity;
            double dist = EntityBlueJay.this.distanceTo(this.following);
            if (dist > 6.0 || EntityBlueJay.this.isFlying()) {
                EntityBlueJay.this.setFlying(true);
                EntityBlueJay.this.getMoveControl().setWantedPosition(this.following.getX(), this.following.getY(), this.following.getZ(), 1.0);
            } else {
                EntityBlueJay.this.getNavigation().moveTo(this.following.getX(), this.following.getY(), this.following.getZ(), 1.0);
            }
            if (EntityBlueJay.this.isFlying() && EntityBlueJay.this.onGround() && dist < 3.0) {
                EntityBlueJay.this.setFlying(false);
            }
            if ((entity = this.following) instanceof EntityRaccoon) {
                EntityRaccoon raccoon = (EntityRaccoon)entity;
                if (dist > 40.0) {
                    EntityBlueJay.this.teleportTo(this.following.getX(), this.following.getY(), this.following.getZ());
                }
                if (dist < 2.5) {
                    EntityBlueJay.this.getMoveControl().setWantedPosition(this.following.getX(), this.following.getY(), this.following.getZ(), 1.0);
                }
                if (dist < 1.0 && raccoon.getPassengers().isEmpty()) {
                    EntityBlueJay.this.startRiding((Entity)raccoon, false);
                }
            }
        }
    }

    private class AIFlyIdle
    extends Goal {
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget;

        public AIFlyIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (EntityBlueJay.this.isVehicle() || EntityBlueJay.this.getTarget() != null && EntityBlueJay.this.getTarget().isAlive() || EntityBlueJay.this.isPassenger() || EntityBlueJay.this.aiItemFlag || EntityBlueJay.this.getSingTime() > 0) {
                return false;
            }
            if (EntityBlueJay.this.getRandom().nextInt(45) != 0 && !EntityBlueJay.this.isFlying()) {
                return false;
            }
            this.flightTarget = EntityBlueJay.this.onGround() ? EntityBlueJay.this.random.nextBoolean() : EntityBlueJay.this.random.nextInt(5) > 0 && EntityBlueJay.this.timeFlying < 200;
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.flightTarget) {
                EntityBlueJay.this.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                EntityBlueJay.this.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityBlueJay.this.isFlying() && EntityBlueJay.this.onGround()) {
                EntityBlueJay.this.setFlying(false);
            }
            if (EntityBlueJay.this.isFlying() && EntityBlueJay.this.onGround() && EntityBlueJay.this.timeFlying > 10) {
                EntityBlueJay.this.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = EntityBlueJay.this.position();
            if (EntityBlueJay.this.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (EntityBlueJay.this.timeFlying < 200 || EntityBlueJay.this.isOverWaterOrVoid()) {
                    return EntityBlueJay.this.getBlockInViewAway(vector3d, 0.0f);
                }
                return EntityBlueJay.this.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)EntityBlueJay.this, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.flightTarget) {
                return EntityBlueJay.this.isFlying() && EntityBlueJay.this.distanceToSqr(this.x, this.y, this.z) > 5.0;
            }
            return !EntityBlueJay.this.getNavigation().isDone() && !EntityBlueJay.this.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                EntityBlueJay.this.setFlying(true);
                EntityBlueJay.this.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                EntityBlueJay.this.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            EntityBlueJay.this.getNavigation().stop();
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.stop();
        }
    }

    private class AIScatter
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final com.google.common.base.Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vec3 flightTarget = null;
        private int cooldown = 0;

        AIScatter() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityBlueJay.this);
            this.targetEntitySelector = new com.google.common.base.Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.isAlive() && e.getType().is(AMTagRegistry.SCATTERS_CROWS) || e instanceof Player && !((Player)e).isCreative();
                }
            };
        }

        public boolean canUse() {
            List list;
            LivingEntity entity = EntityBlueJay.this.getTarget();
            if (EntityBlueJay.this.isPassenger() || EntityBlueJay.this.isVehicle() || entity != null && entity.isAlive() || EntityBlueJay.this.isTrusting()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityBlueJay.this.level().getGameTime() % 10L;
                if (EntityBlueJay.this.getNoActionTime() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityBlueJay.this.getRandom().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityBlueJay.this.level().getEntitiesOfClass(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean canContinueToUse() {
            return this.targetEntity != null;
        }

        public void stop() {
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntityBlueJay.this.setFlying(true);
                EntityBlueJay.this.getMoveControl().setWantedPosition(this.flightTarget.x, this.flightTarget.y, this.flightTarget.z, 1.0);
                if (this.cooldown == 0 && EntityBlueJay.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vec3 vec;
                if ((EntityBlueJay.this.onGround() || this.flightTarget == null || this.flightTarget != null && EntityBlueJay.this.distanceToSqr(this.flightTarget) < 3.0) && (vec = EntityBlueJay.this.getBlockInViewAway(this.targetEntity.position(), 0.0f)) != null && vec.y() > EntityBlueJay.this.getY()) {
                    this.flightTarget = vec;
                }
                if (EntityBlueJay.this.distanceTo(this.targetEntity) > 20.0f) {
                    this.stop();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(EntityBlueJay.this.getX(), EntityBlueJay.this.getY() + 0.5, EntityBlueJay.this.getZ());
            AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.move(renderCenter);
        }

        public record Sorter(Entity theEntity) implements Comparator<Entity>
        {
            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.distanceToSqr(p_compare_1_);
                double d1 = this.theEntity.distanceToSqr(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    private static class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void stop() {
            super.stop();
            ((EntityBlueJay)this.mob).aiItemFlag = false;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        @Override
        protected void moveTo() {
            EntityBlueJay jay = (EntityBlueJay)this.mob;
            if (this.targetEntity != null) {
                jay.aiItemFlag = true;
                if (this.mob.distanceTo((Entity)this.targetEntity) < 2.0f) {
                    jay.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                    jay.peck();
                }
                if (this.mob.distanceTo((Entity)this.targetEntity) > 8.0f || jay.isFlying()) {
                    jay.setFlying(true);
                    float f = (float)(jay.getX() - this.targetEntity.getX());
                    float f1 = 1.8f;
                    float f2 = (float)(jay.getZ() - this.targetEntity.getZ());
                    float xzDist = Mth.sqrt((float)(f * f + f2 * f2));
                    if (!jay.hasLineOfSight((Entity)this.targetEntity)) {
                        jay.getMoveControl().setWantedPosition(this.targetEntity.getX(), 1.0 + jay.getY(), this.targetEntity.getZ(), 1.0);
                    } else {
                        if (xzDist < 5.0f) {
                            f1 = 0.0f;
                        }
                        jay.getMoveControl().setWantedPosition(this.targetEntity.getX(), (double)f1 + this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                    }
                } else {
                    this.mob.getNavigation().moveTo(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
                }
            }
        }

        @Override
        public void tick() {
            super.tick();
            this.moveTo();
        }
    }
}

