/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EntityBananaSlug
extends Animal {
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.defineId(EntityBananaSlug.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(EntityBananaSlug.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityBananaSlug.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Direction[] POSSIBLE_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public float trailYaw;
    public float prevTrailYaw;
    public float trailVisability;
    public float prevTrailVisability;
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    public Direction prevAttachDir = Direction.DOWN;
    public int timeUntilSlime = this.random.nextInt(12000) + 24000;

    protected EntityBananaSlug(EntityType<? extends Animal> animal, Level level) {
        super(animal, level);
        this.prevTrailYaw = this.yBodyRot;
        this.trailYaw = this.yBodyRot;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.BANANA_SLUG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.BANANA_SLUG_HURT.get();
    }

    public static boolean checkBananaSlugSpawnRules(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return !worldIn.getBlockState(pos.below()).isAir();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.bananaSlugSpawnRolls, this.getRandom(), spawnReasonIn) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CLIMBING, (Object)0);
        builder.define(ATTACHED_FACE, (Object)Direction.DOWN);
        builder.define(VARIANT, (Object)0);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void onInsideBlock(BlockState state) {
    }

    public boolean canBreatheUnderwaterAM() {
        return true;
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        this.setVariant(this.random.nextInt(4));
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public boolean onClimbable() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0 && this.getAttachmentFacing() != Direction.DOWN;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.BANANA_SLUG_BREEDABLES);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.entityData.get(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b0);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.entityData.get(ATTACHED_FACE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(AMTagRegistry.BANANA_SLUG_BREEDABLES), false));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 40, 1.0, 10, 7));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f);
    }

    public void tick() {
        boolean flag;
        boolean showTrail;
        super.tick();
        this.prevTrailYaw = this.trailYaw;
        this.yBodyRot = Mth.approachDegrees((float)this.yBodyRotO, (float)this.yBodyRot, (float)this.getMaxHeadYRot());
        this.trailYaw = Mth.approachDegrees((float)this.trailYaw, (float)this.yBodyRot, (float)2.0f);
        this.prevTrailVisability = this.trailVisability;
        this.prevAttachChangeProgress = this.attachChangeProgress;
        boolean bl = showTrail = this.isTrailVisible() && this.getDeltaMovement().length() > (double)0.03f;
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            if (this.attachChangeProgress < 5.0f) {
                this.attachChangeProgress += 1.0f;
                this.trailYaw = this.yBodyRot;
            } else if (this.attachChangeProgress >= 5.0f) {
                this.prevAttachDir = this.getAttachmentFacing();
            }
        } else {
            this.attachChangeProgress = 5.0f;
        }
        if (this.trailVisability < 1.0f && showTrail) {
            this.trailVisability = Math.min(1.0f, this.trailVisability + 0.1f);
        }
        if (this.trailVisability > 0.0f && !showTrail) {
            float dec = this.getDeltaMovement().length() > (double)0.03f ? 1.0f : 0.1f;
            this.trailVisability = Math.max(0.0f, this.trailVisability - dec);
        }
        Vec3 vector3d = this.getDeltaMovement();
        if (!this.level().isClientSide) {
            this.setBesideClimbableBlock(this.horizontalCollision);
            this.setBesideClimbableBlock(this.horizontalCollision || this.verticalCollision && !this.onGround());
            if (this.onGround() || this.isInWaterOrBubble() || this.isInLava()) {
                this.entityData.set(ATTACHED_FACE, (Object)Direction.DOWN);
            } else if (this.verticalCollision) {
                this.entityData.set(ATTACHED_FACE, (Object)Direction.UP);
            } else {
                flag = false;
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction dir : POSSIBLE_DIRECTIONS) {
                    BlockPos antPos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
                    BlockPos offsetPos = antPos.relative(dir);
                    Vec3 offset = Vec3.atCenterOf((Vec3i)offsetPos);
                    if (!(closestDistance > this.position().distanceTo(offset)) || !this.level().loadedAndEntityCanStandOnFace(offsetPos, (Entity)this, dir.getOpposite())) continue;
                    closestDistance = this.position().distanceTo(offset);
                    closestDirection = dir;
                }
                this.entityData.set(ATTACHED_FACE, (Object)closestDirection);
            }
        }
        flag = false;
        if (this.getAttachmentFacing() != Direction.DOWN) {
            if (this.getAttachmentFacing() == Direction.UP) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 1.0, 0.0));
            } else {
                if (!this.horizontalCollision && this.getAttachmentFacing() != Direction.UP) {
                    Vec3 vec = Vec3.atLowerCornerOf((Vec3i)this.getAttachmentFacing().getNormal());
                    this.setDeltaMovement(this.getDeltaMovement().add(vec.normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.onGround() && vector3d.y < 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.5, 1.0));
                    flag = true;
                }
            }
        }
        if (this.getAttachmentFacing() == Direction.UP) {
            this.setNoGravity(true);
            this.setDeltaMovement(vector3d.multiply(0.7, 1.0, 0.7));
        } else {
            this.setNoGravity(false);
        }
        if (!flag && this.onClimbable()) {
            this.setDeltaMovement(vector3d.multiply(1.0, 0.4, 1.0));
        }
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby() && --this.timeUntilSlime <= 0) {
            this.spawnAtLocation((ItemLike)AMItemRegistry.BANANA_SLUG_SLIME.get());
            this.timeUntilSlime = this.random.nextInt(12000) + 24000;
        }
    }

    protected float getJumpPower() {
        return super.getJumpPower();
    }

    public int getMaxHeadXRot() {
        return 1;
    }

    public int getMaxHeadYRot() {
        return 4;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    private boolean isTrailVisible() {
        if (this.isInWaterOrBubble()) {
            return false;
        }
        if (this.onGround()) {
            Vec3 modelBack = new Vec3(0.0, (double)-0.1f, this.isBaby() ? (double)-0.35f : (double)-0.7f).yRot(-this.trailYaw * ((float)Math.PI / 180));
            Vec3 slugBack = this.position().add(modelBack);
            BlockPos backPos = AMBlockPos.fromVec3(slugBack);
            BlockState state = this.level().getBlockState(backPos);
            VoxelShape shape = state.getCollisionShape((BlockGetter)this.level(), backPos);
            if (shape.isEmpty()) {
                return false;
            }
            Optional closest = shape.closestPointTo(modelBack.add(0.0, 1.0, 0.0));
            return closest.isPresent() && Math.min((float)((Vec3)closest.get()).y, 1.0f) >= 0.8f;
        }
        if (this.getAttachmentFacing().getAxis() != Direction.Axis.Y) {
            BlockPos pos = this.blockPosition().relative(this.getAttachmentFacing()).above(this.getDeltaMovement().y <= (double)-0.001f ? 1 : -1);
            BlockState state = this.level().getBlockState(pos);
            VoxelShape shape = state.getCollisionShape((BlockGetter)this.level(), pos);
            return !shape.isEmpty();
        }
        return this.getAttachmentFacing() != Direction.DOWN;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        super.onSyncedDataUpdated(entityDataAccessor);
        if (ATTACHED_FACE.equals(entityDataAccessor)) {
            this.prevAttachChangeProgress = 0.0f;
            this.attachChangeProgress = 0.0f;
        }
    }

    public void calculateEntityAnimation(boolean flying) {
        float f1 = (float)Mth.length((double)(this.getX() - this.xo), (double)(0.5 * (this.getY() - this.yo)), (double)(this.getZ() - this.zo));
        float f2 = Math.min(f1 * 16.0f, 1.0f);
        this.walkAnimation.update(f2, 0.4f);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        EntityBananaSlug slug = (EntityBananaSlug)((EntityType)AMEntityRegistry.BANANA_SLUG.get()).create(this.level());
        slug.setVariant(this.getVariant());
        return slug;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
        compound.putInt("SlimeTime", this.timeUntilSlime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SlimeTime")) {
            this.timeUntilSlime = compound.getInt("SlimeTime");
        }
        this.setVariant(compound.getInt("Variant"));
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int i) {
        this.entityData.set(VARIANT, (Object)i);
    }
}

