/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFalconry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTrigger;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMBlockPos;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoDismount;
import com.github.alexthe666.alexsmobs.network.MessageMosquitoMountPlayer;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBaldEagle
extends TamableAnimal
implements IFollower,
IFalconry {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TACKLING = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_CAP = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LAUNCHED = SynchedEntityData.defineId(EntityBaldEagle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Ingredient TEMPT_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH, (ItemLike)AMItemRegistry.FISH_OIL.get()});
    public float prevAttackProgress;
    public float attackProgress;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevTackleProgress;
    public float tackleProgress;
    public float prevSwoopProgress;
    public float swoopProgress;
    public float prevFlapAmount;
    public float flapAmount;
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    public float prevSitProgress;
    public float sitProgress;
    private boolean isLandNavigator;
    private int timeFlying;
    private BlockPos orbitPos = null;
    private double orbitDist = 5.0;
    private boolean orbitClockwise = false;
    private int passengerTimer = 0;
    private int launchTime = 0;
    private int lastPlayerControlTime = 0;
    private int returnControlTime = 0;
    private int tackleCapCooldown = 0;
    private boolean controlledFlag = false;
    private int chunkLoadCooldown;
    private int stillTicksCounter = 0;

    protected EntityBaldEagle(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.switchNavigator(true);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public static boolean canEagleSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getRawBrightness(pos, 0) > 8;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && (EntityBaldEagle.this.getAirSupply() < 30 || EntityBaldEagle.this.getTarget() == null || !EntityBaldEagle.this.getTarget().isInWaterOrBubble() && EntityBaldEagle.this.getY() > EntityBaldEagle.this.getTarget().getY());
            }
        });
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FlyingAIFollowOwner(this, 1.0, 25.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new AITackle());
        this.goalSelector.addGoal(4, (Goal)new AILandOnGlove(this));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.fromValues(Stream.of(new Ingredient.TagValue(AMTagRegistry.BALD_EAGLE_TAMEABLES), new Ingredient.TagValue(AMTagRegistry.BALD_EAGLE_FOODSTUFFS))), false));
        this.goalSelector.addGoal(7, (Goal)new AIWanderIdle());
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                return EntityBaldEagle.this.returnControlTime == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return EntityBaldEagle.this.returnControlTime == 0 && super.canUse();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new AnimalAIHurtByTargetNotBaby((Animal)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new EntityAINearestTarget3D((Mob)this, LivingEntity.class, 55, true, true, AMEntityRegistry.buildPredicateFromTag(AMTagRegistry.BALD_EAGLE_TARGETS)){

            public boolean canUse() {
                return super.canUse() && !EntityBaldEagle.this.isLaunched() && EntityBaldEagle.this.getCommand() == 0;
            }
        });
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)AMSoundRegistry.BALD_EAGLE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.BALD_EAGLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.BALD_EAGLE_HURT.get();
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.baldEagleSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.BALD_EAGLE_BREEDABLES);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new GroundPathNavigatorWide((Mob)this, this.level());
            this.isLandNavigator = true;
        } else {
            this.moveControl = new MoveHelper(this);
            this.navigation = new DirectPathNavigator((Mob)this, this.level());
            this.isLandNavigator = false;
        }
    }

    public boolean save(CompoundTag compound) {
        String s = this.getEncodeId();
        compound.putString("id", s);
        super.save(compound);
        return true;
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        if (!this.isTame()) {
            return super.saveAsPassenger(compound);
        }
        String s = this.getEncodeId();
        compound.putString("id", s);
        this.saveWithoutId(compound);
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("BirdSitting", this.isSitting());
        compound.putBoolean("Launched", this.isLaunched());
        compound.putBoolean("HasCap", this.hasCap());
        compound.putInt("EagleCommand", this.getCommand());
        compound.putInt("LaunchTime", this.launchTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setOrderedToSit(compound.getBoolean("BirdSitting"));
        this.setLaunched(compound.getBoolean("Launched"));
        this.setCap(compound.getBoolean("HasCap"));
        this.setCommand(compound.getInt("EagleCommand"));
        this.launchTime = compound.getInt("LaunchTime");
    }

    public void travel(Vec3 vec3d) {
        if (!this.shouldHoodedReturn() && this.hasCap() && this.isTame() && !this.isPassenger() || this.isSitting()) {
            super.travel(Vec3.ZERO);
            return;
        }
        super.travel(vec3d);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.attackProgress == 0.0f && (Integer)this.entityData.get(ATTACK_TICK) == 0 && entityIn.isAlive()) {
            double dist;
            double d = dist = this.isSitting() ? (double)(entityIn.getBbWidth() + 1.0f) : (double)(entityIn.getBbWidth() + 5.0f);
            if ((double)this.distanceTo(entityIn) < dist) {
                this.entityData.set(ATTACK_TICK, (Object)5);
            }
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
        builder.define(HAS_CAP, (Object)false);
        builder.define(TACKLING, (Object)false);
        builder.define(LAUNCHED, (Object)false);
        builder.define(ATTACK_TICK, (Object)0);
        builder.define(COMMAND, (Object)0);
        builder.define(SITTING, (Object)false);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setOrderedToSit(boolean sit) {
        this.entityData.set(SITTING, (Object)sit);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
    }

    public boolean isLaunched() {
        return (Boolean)this.entityData.get(LAUNCHED);
    }

    public void setLaunched(boolean flying) {
        this.entityData.set(LAUNCHED, (Object)flying);
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.isBaby()) {
            flying = false;
        }
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean hasCap() {
        return (Boolean)this.entityData.get(HAS_CAP);
    }

    public void setCap(boolean cap) {
        this.entityData.set(HAS_CAP, (Object)cap);
    }

    public boolean isTackling() {
        return (Boolean)this.entityData.get(TACKLING);
    }

    public void setTackling(boolean tackling) {
        this.entityData.set(TACKLING, (Object)tackling);
    }

    @Override
    public void followEntity(TamableAnimal tameable, LivingEntity owner, double followSpeed) {
        if (this.distanceTo((Entity)owner) > 15.0f) {
            this.setFlying(true);
            this.getMoveControl().setWantedPosition(owner.getX(), owner.getY() + (double)owner.getBbHeight(), owner.getZ(), followSpeed);
        } else if (this.isFlying() && !this.isOverWaterOrVoid()) {
            BlockPos vec = this.getCrowGround(this.blockPosition());
            if (vec != null) {
                this.getMoveControl().setWantedPosition((double)vec.getX(), (double)vec.getY(), (double)vec.getZ(), followSpeed);
            }
            if (this.onGround()) {
                this.setFlying(false);
            }
        } else {
            this.getNavigation().moveTo((Entity)owner, followSpeed);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypes.IN_WALL) || super.isInvulnerableTo(source);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        InteractionResult type = super.mobInteract(player, hand);
        if (itemstack.is(AMTagRegistry.BALD_EAGLE_FOODSTUFFS) && this.getHealth() < this.getMaxHealth()) {
            if (!this.level().isClientSide) {
                this.heal(10.0f);
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (itemstack.is(AMTagRegistry.BALD_EAGLE_TAMEABLES)) {
            if (!this.level().isClientSide) {
                if (itemstack.hasCraftingRemainingItem() && !player.getAbilities().instabuild) {
                    this.spawnAtLocation(itemstack.getCraftingRemainingItem());
                }
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                if (this.random.nextBoolean()) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    this.tame(player);
                    this.setCommand(1);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTame() && !this.isFood(itemstack)) {
            if (!this.isBaby() && item == AMItemRegistry.FALCONRY_HOOD.get()) {
                if (!this.hasCap()) {
                    this.setCap(true);
                    if (!player.isCreative()) {
                        itemstack.shrink(1);
                    }
                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                    this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), this.getSoundVolume(), this.getVoicePitch());
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (itemstack.getItem() instanceof ShearsItem && this.hasCap()) {
                    this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
                    this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    if (!this.level().isClientSide && player instanceof ServerPlayer) {
                        itemstack.hurtAndBreak(1, (LivingEntity)((ServerPlayer)player), EquipmentSlot.MAINHAND);
                    }
                    this.spawnAtLocation((ItemLike)AMItemRegistry.FALCONRY_HOOD.get());
                    this.setCap(false);
                    return InteractionResult.SUCCESS;
                }
                if (!(this.isBaby() || this.getRidingFalcons((LivingEntity)player) > 0 || player.getItemInHand(InteractionHand.MAIN_HAND).getItem() != AMItemRegistry.FALCONRY_GLOVE.get() && player.getItemInHand(InteractionHand.OFF_HAND).getItem() != AMItemRegistry.FALCONRY_GLOVE.get())) {
                    this.boardingCooldown = 30;
                    this.setLaunched(false);
                    this.ejectPassengers();
                    this.startRiding((Entity)player, true);
                    if (!this.level().isClientSide) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.getId(), player.getId()));
                    }
                    return InteractionResult.SUCCESS;
                }
                InteractionResult interactionresult = itemstack.interactLivingEntity(player, (LivingEntity)this, hand);
                if (interactionresult != InteractionResult.SUCCESS && type != InteractionResult.SUCCESS) {
                    boolean sit;
                    this.setCommand((this.getCommand() + 1) % 3);
                    if (this.getCommand() == 3) {
                        this.setCommand(0);
                    }
                    player.displayClientMessage((Component)Component.translatable((String)("entity.alexsmobs.all.command_" + this.getCommand()), (Object[])new Object[]{this.getName()}), true);
                    boolean bl = sit = this.getCommand() == 2;
                    if (sit) {
                        this.setOrderedToSit(true);
                        return InteractionResult.SUCCESS;
                    }
                    this.setOrderedToSit(false);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return type;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1 && !this.isLaunched();
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (!(!this.isPassenger() || entity.isAlive() && this.isAlive())) {
            this.stopRiding();
        } else if (this.isTame() && entity instanceof LivingEntity && this.isOwnedBy((LivingEntity)entity)) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (this.isPassenger()) {
                Entity mount = this.getVehicle();
                if (mount instanceof Player) {
                    float yawAdd = 0.0f;
                    if (((Player)mount).getItemInHand(InteractionHand.MAIN_HAND).getItem() == AMItemRegistry.FALCONRY_GLOVE.get()) {
                        yawAdd = ((Player)mount).getMainArm() == HumanoidArm.LEFT ? 135.0f : -135.0f;
                    } else if (((Player)mount).getItemInHand(InteractionHand.OFF_HAND).getItem() == AMItemRegistry.FALCONRY_GLOVE.get()) {
                        yawAdd = ((Player)mount).getMainArm() == HumanoidArm.LEFT ? -135.0f : 135.0f;
                    } else {
                        this.setCommand(2);
                        this.setOrderedToSit(true);
                        this.removeVehicle();
                        this.copyPosition(mount);
                    }
                    float birdYaw = yawAdd * 0.5f;
                    this.yBodyRot = Mth.wrapDegrees((float)(((LivingEntity)mount).yBodyRot + birdYaw));
                    this.setYRot(Mth.wrapDegrees((float)(mount.getYRot() + birdYaw)));
                    this.yHeadRot = Mth.wrapDegrees((float)(((LivingEntity)mount).yHeadRot + birdYaw));
                    float radius = 0.6f;
                    float angle = (float)Math.PI / 180 * (((LivingEntity)mount).yBodyRot - 180.0f + yawAdd);
                    double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
                    double extraZ = radius * Mth.cos((float)angle);
                    this.setPos(mount.getX() + extraX, Math.max(mount.getY() + (double)(mount.getBbHeight() * 0.45f), mount.getY()), mount.getZ() + extraZ);
                }
                if (!mount.isAlive()) {
                    this.removeVehicle();
                }
            }
        } else {
            super.rideTick();
        }
    }

    public void tick() {
        int attackTick;
        boolean sit;
        float yMot;
        super.tick();
        this.prevAttackProgress = this.attackProgress;
        this.prevBirdPitch = this.birdPitch;
        this.prevTackleProgress = this.tackleProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevSwoopProgress = this.swoopProgress;
        this.prevSitProgress = this.sitProgress;
        this.birdPitch = yMot = -((float)this.getDeltaMovement().y * 57.295776f);
        if (this.isFlying()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isTackling()) {
            if (this.tackleProgress < 5.0f) {
                this.tackleProgress += 1.0f;
            }
        } else if (this.tackleProgress > 0.0f) {
            this.tackleProgress -= 1.0f;
        }
        boolean bl = sit = this.isSitting() || this.isPassenger();
        if (sit) {
            if (this.sitProgress < 5.0f) {
                this.sitProgress += 1.0f;
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        this.launchTime = this.isLaunched() ? ++this.launchTime : 0;
        if (this.lastPlayerControlTime > 0) {
            --this.lastPlayerControlTime;
        }
        if (this.lastPlayerControlTime <= 0) {
            this.controlledFlag = false;
        }
        if (yMot < 0.1f) {
            this.flapAmount = Math.min(-yMot * 0.2f, 1.0f);
            if (this.swoopProgress > 0.0f) {
                this.swoopProgress -= 1.0f;
            }
        } else {
            this.flapAmount = this.flapAmount > 0.0f ? (this.flapAmount -= Math.min(this.flapAmount, 0.1f)) : 0.0f;
            if (this.swoopProgress < yMot * 0.2f) {
                this.swoopProgress = Math.min(yMot * 0.2f, this.swoopProgress + 1.0f);
            }
        }
        if (this.isTackling()) {
            this.flapAmount = Math.min(2.0f, this.flapAmount + 0.2f);
        }
        if (!this.level().isClientSide) {
            if (this.isFlying()) {
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
            } else if (!this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (!(this.tackleCapCooldown != 0 || !this.isTackling() || this.isVehicle() || this.getTarget() != null && this.getTarget().isAlive())) {
                this.setTackling(false);
            }
            if (this.isFlying()) {
                ++this.timeFlying;
                this.setNoGravity(true);
                if ((this.isSitting() || this.isPassenger() || this.isInLove()) && !this.isLaunched()) {
                    this.setFlying(false);
                }
                if (this.getTarget() != null && this.getTarget().getY() < this.getX() && !this.isVehicle()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.9, 1.0));
                }
            } else {
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
            if (this.isInWaterOrBubble() && this.isVehicle()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.1f, 0.0));
            }
            if (this.isSitting() && !this.isLaunched()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.1f, 0.0));
            }
            if (this.getTarget() != null && this.isInWaterOrBubble()) {
                this.timeFlying = 0;
                this.setFlying(true);
            }
            if (this.onGround() && this.timeFlying > 30 && this.isFlying() && !this.isInWaterOrBubble()) {
                this.setFlying(false);
            }
        }
        if ((attackTick = ((Integer)this.entityData.get(ATTACK_TICK)).intValue()) > 0) {
            if (attackTick == 2 && this.getTarget() != null && (double)this.distanceTo((Entity)this.getTarget()) < (double)this.getTarget().getBbWidth() + 2.0) {
                this.getTarget().hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f);
            }
            this.entityData.set(ATTACK_TICK, (Object)((Integer)this.entityData.get(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.isPassenger()) {
            this.setFlying(false);
            this.setTackling(false);
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        if (this.returnControlTime > 0) {
            --this.returnControlTime;
        }
        if (this.tackleCapCooldown > 0) {
            --this.tackleCapCooldown;
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)AMEntityRegistry.BALD_EAGLE.get()).create((Level)p_241840_1_);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24) - radiusAdd;
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.x() + extraX), 0, (int)(fleePos.z() + extraZ));
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.getY() - ground.getY();
        int flightHeight = 7 + this.getRandom().nextInt(10);
        BlockPos newPos = ground.above(distFromGround > 8 ? flightHeight : this.getRandom().nextInt(7) + 4);
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)newPos)) && this.distanceToSqr(Vec3.atCenterOf((Vec3i)newPos)) > 1.0) {
            return Vec3.atCenterOf((Vec3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos(in.getX(), (int)this.getY(), in.getZ());
        while (position.getY() < 320 && !this.level().getFluidState(position).isEmpty()) {
            position = position.above();
        }
        while (position.getY() > -64 && !this.level().getBlockState(position).isSolid()) {
            position = position.below();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = -9.45f - (float)this.getRandom().nextInt(24);
        float neg = this.getRandom().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.yBodyRot;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.getRandom().nextFloat() * neg;
        double extraX = radius * Mth.sin((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.cos((float)angle);
        BlockPos radialPos = AMBlockPos.fromCoords(fleePos.x() + extraX, this.getY(), fleePos.z() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.getY() == -64) {
            return this.position();
        }
        ground = this.blockPosition();
        while (ground.getY() > -64 && !this.level().getBlockState(ground).isSolid()) {
            ground = ground.below();
        }
        if (!this.isTargetBlocked(Vec3.atCenterOf((Vec3i)ground.above()))) {
            return Vec3.atCenterOf((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    private Vec3 getOrbitVec(Vec3 vector3d, float gatheringCircleDist) {
        float angle = (float)Math.PI / 180 * (float)this.orbitDist * (float)(this.orbitClockwise ? -this.tickCount : this.tickCount);
        double extraX = gatheringCircleDist * Mth.sin((float)angle);
        double extraZ = gatheringCircleDist * Mth.cos((float)angle);
        if (this.orbitPos != null) {
            Vec3 pos = new Vec3((double)this.orbitPos.getX() + extraX, (double)(this.orbitPos.getY() + this.random.nextInt(2) - 2), (double)this.orbitPos.getZ() + extraZ);
            if (this.level().isEmptyBlock(AMBlockPos.fromVec3(pos))) {
                return pos;
            }
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.blockPosition();
        while (position.getY() > -64 && this.level().isEmptyBlock(position)) {
            position = position.below();
        }
        return !this.level().getFluidState(position).isEmpty() || position.getY() <= -64;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunc) {
        if (this.hasPassenger(passenger)) {
            float radius = 0.3f;
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = 0.3f * Mth.sin((float)((float)Math.PI + angle));
            double extraZ = 0.3f * Mth.cos((float)angle);
            passenger.setYRot(this.yBodyRot + 90.0f);
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.yBodyRot = this.yBodyRot + 90.0f;
            }
            float extraY = 0.0f;
            if (passenger instanceof AbstractFish && !passenger.isInWaterOrBubble()) {
                extraY = 0.1f;
            }
            moveFunc.accept(passenger, this.getX() + extraX, this.getY() - (double)0.3f + (double)extraY + (double)(passenger.getBbHeight() * 0.3f), this.getZ() + extraZ);
            ++this.passengerTimer;
            if (this.isAlive() && this.passengerTimer > 0 && this.passengerTimer % 40 == 0) {
                passenger.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
            }
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        return new Vec3(this.getX(), this.getBoundingBox().minY, this.getZ());
    }

    public boolean shouldHoodedReturn() {
        if (this.getOwner() != null && (!this.getOwner().isAlive() || this.getOwner().isShiftKeyDown())) {
            return true;
        }
        return !this.isAlive() || this.portalProcess != null || this.launchTime > 12000 || this.portalProcess != null || this.isRemoved();
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.lastPlayerControlTime == 0 && !this.isPassenger()) {
            super.remove(reason);
        }
    }

    public void directFromPlayer(float rotationYaw, float rotationPitch, boolean loadChunk, Entity over) {
        LivingEntity owner = this.getOwner();
        if (owner != null && this.distanceTo((Entity)owner) > 150.0f) {
            this.returnControlTime = 100;
        }
        this.stillTicksCounter = Math.abs(this.xo - this.getX()) > (double)0.1f || Math.abs(this.yo - this.getY()) > (double)0.1f || Math.abs(this.zo - this.getZ()) > (double)0.1f ? 0 : ++this.stillTicksCounter;
        int stillTPthreshold = AMConfig.falconryTeleportsBack ? 200 : 6000;
        this.setOrderedToSit(false);
        this.setLaunched(true);
        if (owner != null && (this.returnControlTime > 0 && AMConfig.falconryTeleportsBack || this.stillTicksCounter > stillTPthreshold && this.distanceTo((Entity)owner) > 30.0f)) {
            this.copyPosition((Entity)owner);
            this.returnControlTime = 0;
            this.stillTicksCounter = 0;
            this.launchTime = Math.max(this.launchTime, 12000);
        }
        if (!this.level().isClientSide) {
            if (this.returnControlTime > 0 && owner != null) {
                this.getLookControl().setLookAt((Entity)owner, 30.0f, 30.0f);
            } else {
                this.yBodyRot = rotationYaw;
                this.setYRot(rotationYaw);
                this.yHeadRot = rotationYaw;
                this.setXRot(rotationPitch);
            }
            if (rotationPitch < 10.0f && this.onGround()) {
                this.setFlying(true);
            }
            float yawOffset = rotationYaw + 90.0f;
            float rad = 3.0f;
            float speed = 1.2f;
            if (this.returnControlTime > 0) {
                this.getMoveControl().setWantedPosition(owner.getX(), owner.getY() + 10.0, owner.getZ(), (double)1.2f);
            } else {
                this.getMoveControl().setWantedPosition(this.getX() + 4.5 * Math.cos(yawOffset * ((float)Math.PI / 180)), this.getY() - 3.0 * Math.sin(rotationPitch * ((float)Math.PI / 180)), this.getZ() + 3.0 * Math.sin(yawOffset * ((float)Math.PI / 180)), (double)1.2f);
            }
            if (loadChunk) {
                this.loadChunkOnServer(this.blockPosition());
            }
            this.setLastHurtByMob(null);
            this.setTarget(null);
            if (over == null) {
                List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(3.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
                Entity closest = null;
                for (Entity e : list) {
                    if (closest != null && !(this.distanceTo(e) < this.distanceTo(closest))) continue;
                    closest = e;
                }
                over = closest;
            }
        }
        if (over != null && over != owner && !this.isAlliedTo(over) && this.canFalconryAttack(over) && this.tackleCapCooldown == 0 && (double)this.distanceTo(over) <= (double)over.getBbWidth() + 4.0) {
            this.setTackling(true);
            if ((double)this.distanceTo(over) <= (double)over.getBbWidth() + 2.0) {
                float speedDamage = (float)Math.ceil(Mth.clamp((double)(this.getDeltaMovement().length() + 0.2), (double)0.0, (double)1.2) * 3.333);
                over.hurt(this.damageSources().mobAttack((LivingEntity)this), 5.0f + speedDamage + (float)this.random.nextInt(2));
                this.tackleCapCooldown = 22;
            }
        }
        this.lastPlayerControlTime = 10;
        this.controlledFlag = true;
    }

    @Override
    public float getHandOffset() {
        return 0.8f;
    }

    private boolean canFalconryAttack(Entity over) {
        return !(over instanceof ItemEntity) && (!(over instanceof LivingEntity) || !this.isOwnedBy((LivingEntity)over));
    }

    public void awardKillScore(LivingEntity entity, int score, DamageSource src) {
        if (this.isLaunched() && this.hasCap() && this.isTame() && this.getOwner() != null && this.getOwner() instanceof ServerPlayer && this.distanceTo((Entity)this.getOwner()) >= 100.0f) {
            ((AMAdvancementTrigger)((Object)AMAdvancementTriggerRegistry.BALD_EAGLE_CHALLENGE.get())).trigger((ServerPlayer)this.getOwner());
        }
        super.awardKillScore((Entity)entity, score, src);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity != null && this.isTame() && !(entity instanceof Player) && !(entity instanceof AbstractArrow) && this.isLaunched()) {
            amount = (amount + 1.0f) / 4.0f;
        }
        return super.hurt(source, amount);
    }

    public void loadChunkOnServer(BlockPos center) {
        if (!this.level().isClientSide) {
            ServerLevel serverWorld = (ServerLevel)this.level();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    ChunkPos pos = new ChunkPos(this.blockPosition().offset(i * 16, 0, j * 16));
                    serverWorld.setChunkForced(pos.x, pos.z, true);
                }
            }
        }
    }

    @Override
    public void onLaunch(Player player, Entity pointedEntity) {
        this.setLaunched(true);
        this.setOrderedToSit(false);
        this.setCommand(0);
        if (this.hasCap()) {
            this.setFlying(true);
            this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), (double)0.1f);
            if (this.level().isClientSide) {
                AlexsMobs.sendMSGToServer(new MessageMosquitoDismount(this.getId(), player.getId()));
            }
            AlexsMobs.PROXY.setRenderViewEntity((Entity)this);
        } else {
            this.getNavigation().stop();
            this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), (double)0.1f);
            if (pointedEntity != null && pointedEntity.isAlive() && !this.isAlliedTo(pointedEntity)) {
                this.setFlying(true);
                if (pointedEntity instanceof LivingEntity) {
                    LivingEntity pointedLivingEntity = (LivingEntity)pointedEntity;
                    this.setTarget(pointedLivingEntity);
                }
            } else {
                this.setFlying(false);
                this.setCommand(2);
                this.setOrderedToSit(true);
            }
        }
    }

    private class AITackle
    extends Goal {
        protected EntityBaldEagle eagle;
        private int circleTime;
        private int maxCircleTime = 10;

        public AITackle() {
            this.eagle = EntityBaldEagle.this;
        }

        public boolean canUse() {
            return this.eagle.getTarget() != null && !this.eagle.controlledFlag && !this.eagle.isVehicle();
        }

        public void start() {
            this.eagle.orbitPos = null;
        }

        public void stop() {
            this.circleTime = 0;
            this.maxCircleTime = 60 + EntityBaldEagle.this.random.nextInt(60);
        }

        public void tick() {
            boolean smallPrey;
            LivingEntity target = this.eagle.getTarget();
            boolean bl = smallPrey = target != null && target.getBbHeight() < 1.0f && target.getBbWidth() < 0.7f && !(target instanceof EntityBaldEagle) || target instanceof AbstractFish;
            if (this.eagle.orbitPos != null && this.circleTime < this.maxCircleTime) {
                Vec3 vec;
                ++this.circleTime;
                this.eagle.setTackling(false);
                this.eagle.setFlying(true);
                if (target != null) {
                    int i = 0;
                    int up = 2 + this.eagle.getRandom().nextInt(4);
                    this.eagle.orbitPos = target.blockPosition().above((int)target.getBbHeight());
                    while (this.eagle.level().isEmptyBlock(this.eagle.orbitPos) && i < up) {
                        ++i;
                        this.eagle.orbitPos = this.eagle.orbitPos.above();
                    }
                }
                if ((vec = this.eagle.getOrbitVec(Vec3.ZERO, 4 + EntityBaldEagle.this.random.nextInt(2))) != null) {
                    this.eagle.getMoveControl().setWantedPosition(vec.x, vec.y, vec.z, (double)1.2f);
                }
            } else if (target != null) {
                if (this.eagle.isFlying() || this.eagle.isInWaterOrBubble()) {
                    double d0 = this.eagle.getX() - target.getX();
                    double d2 = this.eagle.getZ() - target.getZ();
                    double xzDist = Math.sqrt(d0 * d0 + d2 * d2);
                    double yAddition = target.getBbHeight();
                    if (xzDist > 15.0) {
                        yAddition = 3.0;
                    }
                    this.eagle.setTackling(true);
                    this.eagle.getMoveControl().setWantedPosition(target.getX(), target.getY() + yAddition, target.getZ(), this.eagle.isInWaterOrBubble() ? (double)1.3f : 1.0);
                } else {
                    this.eagle.getNavigation().moveTo((Entity)target, 1.0);
                }
                if (this.eagle.distanceTo((Entity)target) < target.getBbWidth() + 2.5f) {
                    if (this.eagle.isTackling()) {
                        if (smallPrey) {
                            this.eagle.setFlying(true);
                            this.eagle.timeFlying = 0;
                            float radius = 0.3f;
                            float angle = (float)Math.PI / 180 * this.eagle.yBodyRot;
                            double extraX = 0.3f * Mth.sin((float)((float)Math.PI + angle));
                            double extraZ = 0.3f * Mth.cos((float)angle);
                            target.setYRot(this.eagle.yBodyRot + 90.0f);
                            if (target instanceof LivingEntity) {
                                LivingEntity living = target;
                                living.yBodyRot = this.eagle.yBodyRot + 90.0f;
                            }
                            target.setPos(this.eagle.getX() + extraX, this.eagle.getY() - (double)0.4f + (double)(target.getBbHeight() * 0.45f), this.eagle.getZ() + extraZ);
                            target.startRiding((Entity)this.eagle, true);
                        } else {
                            target.hurt(this.eagle.damageSources().mobAttack((LivingEntity)this.eagle), 5.0f);
                            this.eagle.setFlying(false);
                            this.eagle.orbitPos = target.blockPosition().above(2);
                            this.circleTime = 0;
                            this.maxCircleTime = 60 + EntityBaldEagle.this.random.nextInt(60);
                        }
                    } else {
                        this.eagle.doHurtTarget((Entity)target);
                    }
                } else if (this.eagle.distanceTo((Entity)target) > 12.0f || target.isInWaterOrBubble()) {
                    this.eagle.setFlying(true);
                }
            }
            if (this.eagle.isLaunched()) {
                this.eagle.setFlying(true);
            }
        }
    }

    private class AILandOnGlove
    extends Goal {
        protected EntityBaldEagle eagle;
        private int seperateTime = 0;

        public AILandOnGlove(EntityBaldEagle entityBaldEagle) {
            this.eagle = entityBaldEagle;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.eagle.isLaunched() && !this.eagle.controlledFlag && this.eagle.isTame() && !this.eagle.isPassenger() && !this.eagle.isVehicle() && (this.eagle.getTarget() == null || !this.eagle.getTarget().isAlive());
        }

        public void tick() {
            LivingEntity owner;
            if (this.eagle.getDeltaMovement().lengthSqr() < 0.03) {
                ++this.seperateTime;
            }
            if ((owner = this.eagle.getOwner()) != null) {
                if (this.seperateTime > 200) {
                    this.seperateTime = 0;
                    this.eagle.copyPosition((Entity)owner);
                }
                this.eagle.setFlying(true);
                double d0 = this.eagle.getX() - owner.getX();
                double d2 = this.eagle.getZ() - owner.getZ();
                double xzDist = Math.sqrt(d0 * d0 + d2 * d2);
                double yAdd = xzDist > 14.0 ? 5.0 : 0.0;
                this.eagle.getMoveControl().setWantedPosition(owner.getX(), owner.getY() + yAdd + (double)owner.getEyeHeight(), owner.getZ(), 1.0);
                if ((double)this.eagle.distanceTo((Entity)owner) < (double)owner.getBbWidth() + 1.4) {
                    this.eagle.setLaunched(false);
                    if (this.eagle.getRidingFalcons(owner) <= 0) {
                        this.eagle.startRiding((Entity)owner);
                        if (!this.eagle.level().isClientSide) {
                            AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.eagle.getId(), owner.getId()));
                        }
                    } else {
                        this.eagle.setCommand(2);
                        this.eagle.setOrderedToSit(true);
                    }
                }
            }
        }

        public void stop() {
            this.seperateTime = 0;
        }
    }

    private class AIWanderIdle
    extends Goal {
        protected final EntityBaldEagle eagle;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;
        private int orbitResetCooldown = 0;
        private int maxOrbitTime = 360;
        private int orbitTime = 0;

        public AIWanderIdle() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.eagle = EntityBaldEagle.this;
        }

        public boolean canUse() {
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.eagle.getTarget() != null && this.eagle.getTarget().isAlive() && !this.eagle.isVehicle() || this.eagle.isPassenger() || this.eagle.isSitting() || this.eagle.controlledFlag) {
                return false;
            }
            if (this.eagle.getRandom().nextInt(15) != 0 && !this.eagle.isFlying()) {
                return false;
            }
            if (this.eagle.isBaby()) {
                this.flightTarget = false;
            } else if (this.eagle.isInWaterOrBubble()) {
                this.flightTarget = true;
            } else if (this.eagle.hasCap()) {
                this.flightTarget = false;
            } else if (this.eagle.onGround()) {
                this.flightTarget = EntityBaldEagle.this.random.nextBoolean();
            } else {
                if (this.orbitResetCooldown == 0 && EntityBaldEagle.this.random.nextInt(6) == 0) {
                    this.orbitResetCooldown = 400;
                    this.eagle.orbitPos = this.eagle.blockPosition();
                    this.eagle.orbitDist = 4 + EntityBaldEagle.this.random.nextInt(5);
                    this.eagle.orbitClockwise = EntityBaldEagle.this.random.nextBoolean();
                    this.orbitTime = 0;
                    this.maxOrbitTime = (int)(360.0f + 360.0f * EntityBaldEagle.this.random.nextFloat());
                }
                this.flightTarget = this.eagle.isVehicle() || EntityBaldEagle.this.random.nextInt(7) > 0 && this.eagle.timeFlying < 700;
            }
            Vec3 lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.x;
            this.y = lvt_1_1_.y;
            this.z = lvt_1_1_.z;
            return true;
        }

        public void tick() {
            if (this.orbitResetCooldown > 0) {
                --this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                if (this.orbitTime < this.maxOrbitTime && !this.eagle.isInWaterOrBubble()) {
                    ++this.orbitTime;
                } else {
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntityBaldEagle.this.random.nextInt(400);
                }
            }
            if (this.eagle.horizontalCollision && !this.eagle.onGround()) {
                this.stop();
            }
            if (this.flightTarget) {
                this.eagle.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else if (!this.eagle.onGround() && this.eagle.isFlying()) {
                if (!this.eagle.isInWaterOrBubble()) {
                    this.eagle.setDeltaMovement(this.eagle.getDeltaMovement().multiply((double)1.2f, (double)0.6f, (double)1.2f));
                }
            } else {
                this.eagle.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && this.eagle.onGround() && EntityBaldEagle.this.isFlying()) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntityBaldEagle.this.random.nextInt(400);
            }
            if (this.eagle.timeFlying > 30 && EntityBaldEagle.this.isFlying() && (!EntityBaldEagle.this.level().isEmptyBlock(this.eagle.getBlockPosBelowThatAffectsMyMovement()) || this.eagle.onGround()) && !this.eagle.isInWaterOrBubble()) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntityBaldEagle.this.random.nextInt(400);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.eagle.position();
            if (this.eagle.isTame() && this.eagle.getCommand() == 1 && this.eagle.getOwner() != null) {
                vector3d = this.eagle.getOwner().position();
                this.eagle.orbitPos = this.eagle.getOwner().blockPosition();
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                return this.eagle.getOrbitVec(vector3d, 4 + EntityBaldEagle.this.random.nextInt(2));
            }
            if (this.eagle.isVehicle() || this.eagle.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.eagle.timeFlying < 500 || this.eagle.isVehicle() || this.eagle.isOverWaterOrVoid()) {
                    return this.eagle.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.eagle.getBlockGrounding(vector3d);
            }
            return LandRandomPos.getPos((PathfinderMob)this.eagle, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            if (this.eagle.isSitting()) {
                return false;
            }
            if (this.flightTarget) {
                return this.eagle.isFlying() && this.eagle.distanceToSqr(this.x, this.y, this.z) > 2.0;
            }
            return !this.eagle.getNavigation().isDone() && !this.eagle.isVehicle();
        }

        public void start() {
            if (this.flightTarget) {
                this.eagle.setFlying(true);
                this.eagle.getMoveControl().setWantedPosition(this.x, this.y, this.z, 1.0);
            } else {
                this.eagle.getNavigation().moveTo(this.x, this.y, this.z, 1.0);
            }
        }

        public void stop() {
            this.eagle.getNavigation().stop();
            super.stop();
        }
    }

    static class MoveHelper
    extends MoveControl {
        private final EntityBaldEagle parentEntity;

        public MoveHelper(EntityBaldEagle bird) {
            super((Mob)bird);
            this.parentEntity = bird;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.wantedX - this.parentEntity.getX(), this.wantedY - this.parentEntity.getY(), this.wantedZ - this.parentEntity.getZ());
                double d5 = vector3d.length();
                if (d5 < 0.3) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().scale(0.5));
                } else {
                    this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add(vector3d.scale(this.speedModifier * 0.05 / d5)));
                    Vec3 vector3d1 = this.parentEntity.getDeltaMovement();
                    this.parentEntity.setYRot(-((float)Mth.atan2((double)vector3d1.x, (double)vector3d1.z)) * 57.295776f);
                    this.parentEntity.yBodyRot = this.parentEntity.getYRot();
                }
            }
        }

        private boolean canReach(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.getBoundingBox();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.move(p_220673_1_);
                if (this.parentEntity.level().noCollision((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }
}

