/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityLeafcutterAnt;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRideParent;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.AnteaterAIRaidNest;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;

public class EntityAnteater
extends Animal
implements NeutralMob,
IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_SLASH_R = Animation.create((int)20);
    public static final Animation ANIMATION_TOUNGE_IDLE = Animation.create((int)10);
    public static final Animation ANIMATION_SLASH_L = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.defineId(EntityAnteater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEANING_DOWN = SynchedEntityData.defineId(EntityAnteater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANT_ON_TONGUE = SynchedEntityData.defineId(EntityAnteater.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(EntityAnteater.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float prevStandProgress;
    public float standProgress;
    public float prevTongueProgress;
    public float tongueProgress;
    public float prevLeaningProgress;
    public float leaningProgress;
    public int eatAntCooldown = 0;
    public int ticksAntOnTongue = 0;
    private int animationTick;
    private Animation currentAnimation;
    private int maxStandTime = 75;
    private int standingTime = 0;
    private int antsEatenRecently = 0;
    private int heldItemTime;
    private UUID lastHurtBy;
    private static final UniformInt ANGRY_TIMER = TimeUtil.rangeOfSeconds((int)30, (int)60);

    protected EntityAnteater(EntityType type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public static boolean canAnteaterSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.getRawBrightness(pos, 0) > 8;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.anteaterSpawnRolls, this.getRandom(), spawnReasonIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AIMelee());
        this.goalSelector.addGoal(3, (Goal)new AnteaterAIRaidNest(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AnimalAIRideParent(this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of(AMTagRegistry.ANTEATER_FOODSTUFFS), false));
        this.goalSelector.addGoal(7, (Goal)new AnimalAIWanderRanged((PathfinderMob)this, 110, 1.0, 10, 7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, new CreatureAITargetItems((PathfinderMob)this, false, false, 25, 16));
        this.targetSelector.addGoal(2, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new AITargetAnts());
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source.getDirectEntity() != null && source.getDirectEntity() instanceof EntityLeafcutterAnt;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)AMSoundRegistry.ANTEATER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AMSoundRegistry.ANTEATER_HURT.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Standing", this.isStanding());
        compound.putInt("AntCooldown", this.eatAntCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setStanding(compound.getBoolean("Standing"));
        this.eatAntCooldown = compound.getInt("AntCooldown");
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(AMTagRegistry.ANTEATER_BREEDABLES);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STANDING, (Object)Boolean.FALSE);
        builder.define(ANT_ON_TONGUE, (Object)Boolean.FALSE);
        builder.define(LEANING_DOWN, (Object)Boolean.FALSE);
        builder.define(ANGER_TIME, (Object)0);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.lastHurtBy;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGRY_TIMER.sample(this.random));
    }

    public boolean isStanding() {
        return (Boolean)this.entityData.get(STANDING);
    }

    public void setStanding(boolean standing) {
        this.entityData.set(STANDING, (Object)standing);
    }

    public boolean hasAntOnTongue() {
        return (Boolean)this.entityData.get(ANT_ON_TONGUE);
    }

    public void setAntOnTongue(boolean standing) {
        this.entityData.set(ANT_ON_TONGUE, (Object)standing);
    }

    public boolean canCollideWith(Entity entity) {
        return !(entity instanceof EntityLeafcutterAnt) && super.canCollideWith(entity);
    }

    public void push(Entity entity) {
        if (!(entity instanceof EntityLeafcutterAnt)) {
            super.push(entity);
        }
    }

    public boolean isLeaning() {
        return (Boolean)this.entityData.get(LEANING_DOWN);
    }

    public void setLeaning(boolean leaning) {
        this.entityData.set(LEANING_DOWN, (Object)leaning);
    }

    protected boolean isImmobile() {
        return super.isImmobile();
    }

    protected void customServerAiStep() {
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResult type = super.mobInteract(player, hand);
        boolean isFoodstuff = itemstack.is(AMTagRegistry.ANTEATER_FOODSTUFFS);
        if (isFoodstuff) {
            ItemStack rippedStack = itemstack.copy();
            rippedStack.setCount(1);
            this.stopBeingAngry();
            this.heal(4.0f);
            this.setItemInHand(InteractionHand.MAIN_HAND, rippedStack);
            if (itemstack.is(AMTagRegistry.ANTEATER_BREEDABLES)) {
                return type;
            }
            this.usePlayerItem(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void tick() {
        Object object;
        boolean isTongueOut;
        super.tick();
        this.prevStandProgress = this.standProgress;
        this.prevTongueProgress = this.tongueProgress;
        this.prevLeaningProgress = this.leaningProgress;
        if (this.isStanding()) {
            if (this.standProgress < 5.0f) {
                this.standProgress += 1.0f;
            }
        } else if (this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        boolean bl = isTongueOut = this.getAnimation() == ANIMATION_TOUNGE_IDLE;
        if (isTongueOut) {
            if (this.tongueProgress < 5.0f) {
                this.tongueProgress += 1.0f;
            }
        } else if (this.tongueProgress > 0.0f) {
            this.tongueProgress -= 1.0f;
        }
        if (this.isLeaning()) {
            if (this.leaningProgress < 5.0f) {
                this.leaningProgress += 1.0f;
            }
        } else if (this.leaningProgress > 0.0f) {
            this.leaningProgress -= 1.0f;
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.random.nextInt(50);
        }
        if (this.isPassenger() && (object = this.getVehicle()) instanceof EntityAnteater) {
            EntityAnteater mount = (EntityAnteater)object;
            if (this.isBaby()) {
                this.setYRot(mount.yBodyRot);
                this.yHeadRot = mount.yBodyRot;
                this.yBodyRot = mount.yBodyRot;
            } else {
                this.removeVehicle();
            }
        }
        if (this.eatAntCooldown > 0) {
            --this.eatAntCooldown;
        }
        if (this.antsEatenRecently >= 3 && this.eatAntCooldown <= 0) {
            this.resetAntCooldown();
        }
        if (this.ticksAntOnTongue > 10 && this.hasAntOnTongue()) {
            this.heal(6.0f);
            this.gameEvent((Holder)GameEvent.EAT);
            this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
            this.setAntOnTongue(false);
        }
        this.ticksAntOnTongue = this.hasAntOnTongue() ? ++this.ticksAntOnTongue : 0;
        if (!this.level().isClientSide && this.getTongueStickOut() > 0.6f && !this.hasAntOnTongue() && this.antsEatenRecently < 3) {
            EntityLeafcutterAnt closestAnt = null;
            for (EntityLeafcutterAnt entity : this.level().getEntitiesOfClass(EntityLeafcutterAnt.class, this.getBoundingBox().inflate((double)2.6f))) {
                if (closestAnt != null && (!(entity.distanceTo((Entity)this) < closestAnt.distanceTo((Entity)this)) || !this.hasLineOfSight((Entity)entity))) continue;
                closestAnt = entity;
            }
            if (closestAnt != null) {
                closestAnt.remove(Entity.RemovalReason.KILLED);
                this.ticksAntOnTongue = 0;
                this.setAntOnTongue(true);
                ++this.antsEatenRecently;
            }
        }
        if (!this.getMainHandItem().isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 10 && this.getTongueStickOut() < 0.3f && this.canTargetItem(this.getMainHandItem())) {
                this.heldItemTime = 0;
                this.heal(4.0f);
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                this.gameEvent((Holder)GameEvent.EAT);
                if (this.getMainHandItem().hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.getMainHandItem().getCraftingRemainingItem());
                }
                this.stopBeingAngry();
                this.getMainHandItem().shrink(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (!this.level().isClientSide) {
            LivingEntity attackTarget;
            if (this.getRandom().nextInt(300) == 0) {
                this.setAnimation(ANIMATION_TOUNGE_IDLE);
            }
            if ((attackTarget = this.getTarget()) != null && this.distanceTo((Entity)attackTarget) < attackTarget.getBbWidth() + this.getBbWidth() + 2.0f && this.getAnimationTick() == 7) {
                if (this.getAnimation() == ANIMATION_SLASH_L) {
                    this.doHurtTarget((Entity)attackTarget);
                    float rot = this.getYRot() + 90.0f;
                    attackTarget.knockback(0.5, (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(rot * ((float)Math.PI / 180)))));
                } else if (this.getAnimation() == ANIMATION_SLASH_R) {
                    this.doHurtTarget((Entity)attackTarget);
                    float rot = this.getYRot() - 90.0f;
                    attackTarget.knockback(0.5, (double)Mth.sin((float)(rot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(rot * ((float)Math.PI / 180)))));
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void resetAntCooldown() {
        this.eatAntCooldown = 600 + this.random.nextInt(1000);
        this.antsEatenRecently = 0;
    }

    public void standFor(int time) {
        this.setStanding(true);
        this.maxStandTime = time;
    }

    public float getTongueStickOut() {
        if (this.tongueProgress > 0.0f) {
            double tongueM = Math.min(Math.sin((float)this.tickCount * 0.15f), 0.0);
            return (float)(-tongueM) * (this.tongueProgress * 0.2f);
        }
        return 0.0f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)AMEntityRegistry.ANTEATER.get()).create(this.level());
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return !this.hasAntOnTongue() && stack.is(AMTagRegistry.INSECT_ITEMS);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.getItemInHand(InteractionHand.MAIN_HAND), 0.0f);
        }
        this.setAnimation(ANIMATION_TOUNGE_IDLE);
        this.setItemInHand(InteractionHand.MAIN_HAND, duplicate);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SLASH_L, ANIMATION_SLASH_R, ANIMATION_TOUNGE_IDLE};
    }

    private boolean shouldTargetAnts() {
        return !this.isAngry();
    }

    public boolean isPeter() {
        String name = ChatFormatting.stripFormatting((String)this.getName().getString());
        if (name == null) {
            return false;
        }
        String lowercaseName = name.toLowerCase(Locale.ROOT);
        return lowercaseName.contains("peter") || lowercaseName.contains("petr") || lowercaseName.contains("zot");
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.5f);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    private class AIMelee
    extends Goal {
        public AIMelee() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EntityAnteater.this.getTarget() != null && EntityAnteater.this.getTarget().isAlive() && !EntityAnteater.this.isBaby();
        }

        public void tick() {
            LivingEntity enemy = EntityAnteater.this.getTarget();
            if (enemy != null) {
                double attackReachSqr = this.getAttackReachSqr(enemy);
                double distToEnemySqr = EntityAnteater.this.distanceTo((Entity)enemy);
                EntityAnteater.this.lookAt((Entity)enemy, 100.0f, 5.0f);
                if (enemy instanceof EntityLeafcutterAnt) {
                    if (distToEnemySqr <= attackReachSqr + 1.5) {
                        EntityAnteater.this.setAnimation(ANIMATION_TOUNGE_IDLE);
                    } else {
                        EntityAnteater.this.lookAt((Entity)enemy, 5.0f, 5.0f);
                    }
                    EntityAnteater.this.getNavigation().moveTo((Entity)enemy, 1.0);
                } else {
                    if (distToEnemySqr <= attackReachSqr) {
                        EntityAnteater.this.getNavigation().moveTo((Entity)enemy, 1.0);
                        EntityAnteater.this.setAnimation(EntityAnteater.this.getRandom().nextBoolean() ? ANIMATION_SLASH_L : ANIMATION_SLASH_R);
                    }
                    double x = enemy.getX() - EntityAnteater.this.getX();
                    double z = enemy.getZ() - EntityAnteater.this.getZ();
                    float f = (float)(Mth.atan2((double)z, (double)x) * 57.2957763671875) - 90.0f;
                    EntityAnteater.this.setYRot(f);
                    EntityAnteater.this.yBodyRot = f;
                    EntityAnteater.this.setStanding(true);
                }
            }
        }

        public void stop() {
            EntityAnteater.this.setStanding(false);
            super.stop();
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return 2.0f + attackTarget.getBbWidth();
        }
    }

    private class AITargetAnts
    extends NearestAttackableTargetGoal {
        private static final Predicate<EntityLeafcutterAnt> QUEEN_ANT = entity -> !entity.isQueen();

        public AITargetAnts() {
            super((Mob)EntityAnteater.this, EntityLeafcutterAnt.class, 30, true, false, QUEEN_ANT);
        }

        public boolean canUse() {
            return EntityAnteater.this.shouldTargetAnts() && !EntityAnteater.this.isBaby() && !EntityAnteater.this.hasAntOnTongue() && !EntityAnteater.this.isStanding() && super.canUse();
        }

        public boolean canContinueToUse() {
            return EntityAnteater.this.shouldTargetAnts() && !EntityAnteater.this.hasAntOnTongue() && !EntityAnteater.this.isStanding() && super.canContinueToUse();
        }
    }
}

