/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.effect;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class EffectFleetFooted
extends MobEffect {
    private static final AttributeModifier SPRINT_JUMP_SPEED_BONUS = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"fleetfooted_speed_bonus"), (double)0.2f, AttributeModifier.Operation.ADD_VALUE);
    private int removeEffectAfter = 0;

    public EffectFleetFooted() {
        super(MobEffectCategory.BENEFICIAL, 6837313);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        boolean applyEffect;
        MobEffectInstance effectInstance = entity.getEffect(AMEffectRegistry.FLEET_FOOTED);
        int currentDuration = effectInstance != null ? effectInstance.getDuration() : 0;
        AttributeInstance modifiableattributeinstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        boolean bl = applyEffect = entity.isSprinting() && !entity.onGround() && currentDuration > 2;
        if (this.removeEffectAfter > 0) {
            --this.removeEffectAfter;
        }
        if (applyEffect) {
            if (!modifiableattributeinstance.hasModifier(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"fleetfooted_speed_bonus"))) {
                modifiableattributeinstance.addPermanentModifier(SPRINT_JUMP_SPEED_BONUS);
            }
            this.removeEffectAfter = 5;
        }
        if (this.removeEffectAfter <= 0 || currentDuration < 2) {
            modifiableattributeinstance.removeModifier(SPRINT_JUMP_SPEED_BONUS);
        }
        return true;
    }

    public void removeAttributeModifiers(LivingEntity livingEntity, AttributeMap attributeMap, int level) {
        AttributeInstance modifiableattributeinstance = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (modifiableattributeinstance != null && modifiableattributeinstance.hasModifier(ResourceLocation.fromNamespaceAndPath((String)"alexsmobs", (String)"fleetfooted_speed_bonus"))) {
            modifiableattributeinstance.removeModifier(SPRINT_JUMP_SPEED_BONUS);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public String getDescriptionId() {
        return "alexsmobs.potion.fleet_footed";
    }
}

