/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.tile;

import com.github.alexthe666.alexsmobs.block.BlockTransmutationTable;
import com.github.alexthe666.alexsmobs.client.model.ModelTransmutationTable;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.tileentity.TileEntityTransmutationTable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderTransmutationTable<T extends TileEntityTransmutationTable>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table.png");
    private static final ResourceLocation OVERLAY = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table_overlay.png");
    private static final ResourceLocation GLOW_TEXTURE = ResourceLocation.parse((String)"alexsmobs:textures/entity/farseer/transmutation_table_glow.png");
    private static final ModelTransmutationTable MODEL = new ModelTransmutationTable(0.0f);
    private static final ModelTransmutationTable OVERLAY_MODEL = new ModelTransmutationTable(0.01f);

    public RenderTransmutationTable(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        Direction dir = (Direction)tileEntityIn.getBlockState().getValue((Property)BlockTransmutationTable.FACING);
        switch (dir) {
            case NORTH: {
                matrixStackIn.translate(0.5, 1.5, 0.5);
                break;
            }
            case EAST: {
                matrixStackIn.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case SOUTH: {
                matrixStackIn.translate(0.5, 1.5, 0.5);
                break;
            }
            case WEST: {
                matrixStackIn.translate(0.5f, 1.5f, 0.5f);
            }
        }
        float ageInTicks = partialTicks + (float)((TileEntityTransmutationTable)((Object)tileEntityIn)).ticksExisted;
        matrixStackIn.mulPose(dir.getOpposite().getRotation());
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.pushPose();
        MODEL.animate((TileEntityTransmutationTable)((Object)tileEntityIn), partialTicks);
        MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn);
        MODEL.renderToBuffer(matrixStackIn, bufferIn.getBuffer(AMRenderTypes.getEyesAlphaEnabled(GLOW_TEXTURE)), 240, combinedOverlayIn);
        VertexConsumer staticyOverlay = bufferIn.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)OVERLAY));
        OVERLAY_MODEL.animate((TileEntityTransmutationTable)((Object)tileEntityIn), partialTicks);
        OVERLAY_MODEL.renderToBuffer(matrixStackIn, staticyOverlay, combinedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, Matrix3f p_114092_, int p_114093_, float p_114094_, float p_114095_, int p_114096_, int p_114097_) {
        p_114090_.addVertex(0.0f, 0.0f, 0.0f).setColor(65025, 65025, 65025, 25500).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(p_114093_ & 0xFFFF, p_114093_ >> 16).setNormal(0.0f, 1.0f, 0.0f);
    }
}

